/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.meta;

import java.util.ListIterator;
import org.eclipse.persistence.internal.codegen.NonreflectiveMethodDefinition;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassCodeGenPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWMethod;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWMethodParameter;
import org.eclipse.persistence.tools.workbench.utility.NameTools;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public abstract class MWMethodCodeGenPolicy {
    private volatile MWClassCodeGenPolicy classCodeGenPolicy;
    private volatile MWMethod method;
    private static final String ARRAY_SUFFIX = "Array";
    private static final String A_ARTICLE = "a";
    private static final String AN_ARTICLE = "an";

    MWMethodCodeGenPolicy(MWMethod method, MWClassCodeGenPolicy classCodeGenPolicy) {
        this.method = method;
        this.classCodeGenPolicy = classCodeGenPolicy;
    }

    MWClassCodeGenPolicy getClassCodeGenPolicy() {
        return this.classCodeGenPolicy;
    }

    MWMethod getMethod() {
        return this.method;
    }

    void insertArguments(NonreflectiveMethodDefinition methodDef) {
        ListIterator stream = this.getMethod().methodParameters();
        while (stream.hasNext()) {
            this.addArgument(methodDef, (MWMethodParameter)stream.next());
        }
    }

    void insertMethodBody(NonreflectiveMethodDefinition methodDef) {
        methodDef.addLine(this.classCodeGenPolicy.emptyMethodBodyComment());
        if (!this.method.isConstructor() && !this.method.getReturnType().isVoid()) {
            methodDef.addLine("return " + this.method.getReturnTypeDeclaration().defaultReturnValueString() + ";");
        }
    }

    protected void addArgument(NonreflectiveMethodDefinition methodDef, MWMethodParameter argument) {
        methodDef.addArgument(argument.declaration(), this.uniqueParameterName(argument, methodDef));
    }

    protected String uniqueParameterName(MWMethodParameter methodParameter, NonreflectiveMethodDefinition methodDef) {
        String parmName = methodParameter.getType().shortName();
        StringBuffer sb = new StringBuffer(parmName.length() + 10);
        if (StringTools.charIsVowel(parmName.charAt(0))) {
            sb.append(AN_ARTICLE);
        } else {
            sb.append(A_ARTICLE);
        }
        StringTools.capitalizeOn(parmName, sb);
        if (methodParameter.getDimensionality() > 0) {
            sb.append(ARRAY_SUFFIX);
        }
        return NameTools.uniqueNameFor(sb.toString(), methodDef.argumentNames());
    }
}

