/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.project;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.InheritancePolicy;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.converters.ObjectTypeConverter;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeDirectCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWCachingPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWMappingDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.MWNullCachingPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.MWTransactionalProjectCachingPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.relational.MWRelationalProjectDefaultsPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.xml.MWEisProjectDefaultsPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.xml.MWOXProjectDefaultsPolicy;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public abstract class MWProjectDefaultsPolicy
extends MWModel {
    public static final String COPY_POLICY = "Copy Policy";
    public static final String AFTER_LOAD_POLICY = "After Load";
    public static final String INSTANTIATION_POLICY = "Instantiation";
    public static final String INHERITANCE_POLICY = "Inheritance";
    private Collection defaultPolicies;
    public static final String DEFAULT_POLICY_COLLECTION = "defaultPolicyCollection";
    private Map policyBuilderMap;
    private MWCachingPolicy cachingPolicy;
    private volatile boolean methodAccessing;
    public static final String METHOD_ACCESSING_PROPERTY = "methodAccessing";

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWProjectDefaultsPolicy.class);
        InheritancePolicy ip = descriptor.getInheritancePolicy();
        ip.setClassIndicatorFieldName("@type");
        ip.addClassIndicator(MWRelationalProjectDefaultsPolicy.class, (Object)"relational");
        ip.addClassIndicator(MWEisProjectDefaultsPolicy.class, (Object)"eis");
        ip.addClassIndicator(MWOXProjectDefaultsPolicy.class, (Object)"o-x");
        descriptor.addDirectMapping(METHOD_ACCESSING_PROPERTY, "use-method-accessing/text()");
        XMLCompositeDirectCollectionMapping defaultPoliciesMapping = new XMLCompositeDirectCollectionMapping();
        defaultPoliciesMapping.setAttributeName("defaultPolicies");
        defaultPoliciesMapping.setXPath("default-descriptor-policies/policy-type/text()");
        ObjectTypeConverter converter = new ObjectTypeConverter();
        converter.addConversionValue((Object)COPY_POLICY, (Object)COPY_POLICY);
        converter.addConversionValue((Object)AFTER_LOAD_POLICY, (Object)AFTER_LOAD_POLICY);
        converter.addConversionValue((Object)INSTANTIATION_POLICY, (Object)INSTANTIATION_POLICY);
        converter.addConversionValue((Object)INHERITANCE_POLICY, (Object)INHERITANCE_POLICY);
        converter.addConversionValue((Object)"Events", (Object)"Events");
        converter.addConversionValue((Object)"Returning", (Object)"Returning");
        converter.addConversionValue((Object)"Interface Alias", (Object)"Interface Alias");
        converter.addConversionValue((Object)"Multi-Table Info", (Object)"Multi-Table Info");
        defaultPoliciesMapping.setValueConverter((Converter)converter);
        descriptor.addMapping((DatabaseMapping)defaultPoliciesMapping);
        XMLCompositeObjectMapping projectCachingPolicyMapping = new XMLCompositeObjectMapping();
        projectCachingPolicyMapping.setAttributeName("cachingPolicy");
        projectCachingPolicyMapping.setSetMethodName("setProjectCachingPolicyForTopLink");
        projectCachingPolicyMapping.setGetMethodName("getProjectCachingPolicyForTopLink");
        projectCachingPolicyMapping.setReferenceClass(MWTransactionalProjectCachingPolicy.class);
        projectCachingPolicyMapping.setXPath("caching-policy");
        descriptor.addMapping((DatabaseMapping)projectCachingPolicyMapping);
        return descriptor;
    }

    protected MWProjectDefaultsPolicy() {
    }

    public MWProjectDefaultsPolicy(MWModel parent) {
        super(parent);
    }

    protected void initialize() {
        super.initialize();
        this.policyBuilderMap = new HashMap();
        this.initializePolicyDescriptors();
    }

    protected void initialize(Node parent) {
        super.initialize(parent);
        this.defaultPolicies = new Vector();
        this.cachingPolicy = this.buildCachingPolicy();
    }

    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        children.add(this.cachingPolicy);
    }

    protected MWCachingPolicy buildCachingPolicy() {
        return new MWNullCachingPolicy(this);
    }

    protected void initializePolicyDescriptors() {
        this.addPolicyDescriptor(COPY_POLICY, new CopyPolicyDescriptor());
        this.addPolicyDescriptor(AFTER_LOAD_POLICY, new AfterLoadPolicyDescriptor());
        this.addPolicyDescriptor(INHERITANCE_POLICY, new InheritancePolicyDescriptor());
        this.addPolicyDescriptor(INSTANTIATION_POLICY, new InstantiationPolicyDescriptor());
    }

    public Iterator defaultPolicies() {
        return this.defaultPolicies.iterator();
    }

    protected void addPolicyDescriptor(String policyKey, PolicyDescriptor descriptor) {
        this.policyBuilderMap.put(policyKey, descriptor);
    }

    protected PolicyDescriptor getPolicyDescriptor(String policyKey) {
        return (PolicyDescriptor)this.policyBuilderMap.get(policyKey);
    }

    public void applyAdvancedPolicyDefaults(MWMappingDescriptor descriptor) {
        Iterator defaults = this.defaultPolicies.iterator();
        while (defaults.hasNext()) {
            this.getPolicyDescriptor((String)defaults.next()).applyPolicyToDescriptor(descriptor);
        }
    }

    public boolean containsAdvancePolicyDefault(String policyName) {
        return this.defaultPolicies.contains(policyName);
    }

    public void addAdvancedPolicyDefault(String policyName) {
        this.defaultPolicies.add(policyName);
        this.fireItemAdded(DEFAULT_POLICY_COLLECTION, policyName);
    }

    public void removeAdvancedPolicyDefault(String policyName) {
        this.defaultPolicies.remove(policyName);
        this.fireItemRemoved(DEFAULT_POLICY_COLLECTION, policyName);
    }

    public MWCachingPolicy getCachingPolicy() {
        return this.cachingPolicy;
    }

    public boolean isMethodAccessing() {
        return this.methodAccessing;
    }

    public void setMethodAccessing(boolean newMethodAccessing) {
        boolean old = this.methodAccessing;
        this.methodAccessing = newMethodAccessing;
        this.firePropertyChanged(METHOD_ACCESSING_PROPERTY, old, this.methodAccessing);
    }

    private MWTransactionalProjectCachingPolicy getProjectCachingPolicyForTopLink() {
        return (MWTransactionalProjectCachingPolicy)this.cachingPolicy.getPersistedPolicy();
    }

    private void setProjectCachingPolicyForTopLink(MWTransactionalProjectCachingPolicy cachingPolicy) {
        this.cachingPolicy = cachingPolicy == null ? this.buildCachingPolicy() : cachingPolicy;
    }

    protected void adjustRuntimeProject(Project project) {
    }

    private class InheritancePolicyDescriptor
    implements PolicyDescriptor {
        private InheritancePolicyDescriptor() {
        }

        public void applyPolicyToDescriptor(MWMappingDescriptor descriptor) {
            if (!descriptor.getInheritancePolicy().isActive()) {
                descriptor.addInheritancePolicy();
            }
        }
    }

    private class InstantiationPolicyDescriptor
    implements PolicyDescriptor {
        private InstantiationPolicyDescriptor() {
        }

        public void applyPolicyToDescriptor(MWMappingDescriptor descriptor) {
            if (!descriptor.getInstantiationPolicy().isActive()) {
                descriptor.addInstantiationPolicy();
            }
        }
    }

    private class CopyPolicyDescriptor
    implements PolicyDescriptor {
        private CopyPolicyDescriptor() {
        }

        public void applyPolicyToDescriptor(MWMappingDescriptor descriptor) {
            if (!descriptor.getCopyPolicy().isActive()) {
                descriptor.addCopyPolicy();
            }
        }
    }

    private class AfterLoadPolicyDescriptor
    implements PolicyDescriptor {
        private AfterLoadPolicyDescriptor() {
        }

        public void applyPolicyToDescriptor(MWMappingDescriptor descriptor) {
            if (!descriptor.getAfterLoadingPolicy().isActive()) {
                descriptor.addAfterLoadingPolicy();
            }
        }
    }

    protected static interface PolicyDescriptor {
        public void applyPolicyToDescriptor(MWMappingDescriptor var1);
    }
}

