/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWQueryableHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQueryable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWOrderingItem;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWQueryableArgument;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWQueryableArgumentElement
extends MWModel {
    private MWQueryableHandle queryableHandle;
    private volatile MWQueryableArgumentElement joinedQueryableElement;
    private volatile boolean allowsNull;
    public static final String ALLOWS_NULL_PROPERTY = "allowsNull";

    private MWQueryableArgumentElement() {
    }

    MWQueryableArgumentElement(MWQueryableArgument argument, MWQueryable queryable) {
        this(argument);
        this.queryableHandle.setQueryable(queryable);
    }

    MWQueryableArgumentElement(MWQueryableArgumentElement argument, MWQueryable queryable) {
        this(argument);
        this.queryableHandle.setQueryable(queryable);
    }

    MWQueryableArgumentElement(MWQueryableArgument argument) {
        super(argument);
    }

    MWQueryableArgumentElement(MWQueryableArgumentElement argument) {
        super(argument);
    }

    MWQueryableArgumentElement(MWOrderingItem orderingItem, MWQueryable queryable) {
        super(orderingItem);
        this.queryableHandle.setQueryable(queryable);
    }

    protected void initialize(Node parent) {
        super.initialize(parent);
        this.queryableHandle = new MWQueryableHandle(this, this.buildQueryableScrubber());
    }

    public MWQueryable getQueryable() {
        return this.queryableHandle.getQueryable();
    }

    void setQueryableToNull() {
        this.queryableHandle.setQueryable(null);
        this.joinedQueryableElement = null;
    }

    public boolean isAllowsNull() {
        return this.allowsNull;
    }

    public void setAllowsNull(boolean allowsNull) {
        boolean oldAllowsNull = this.isAllowsNull();
        this.allowsNull = allowsNull;
        this.firePropertyChanged(ALLOWS_NULL_PROPERTY, oldAllowsNull, allowsNull);
    }

    public MWQueryableArgumentElement getJoinedQueryableElement() {
        return this.joinedQueryableElement;
    }

    void setJoinedQueryable(Iterator joinedQueryables, Iterator allowsNull) {
        MWQueryable queryable = (MWQueryable)joinedQueryables.next();
        joinedQueryables.remove();
        this.joinedQueryableElement = new MWQueryableArgumentElement(this, queryable);
        if (allowsNull.hasNext()) {
            this.joinedQueryableElement.setAllowsNull((Boolean)allowsNull.next());
            allowsNull.remove();
        }
        if (joinedQueryables.hasNext()) {
            this.joinedQueryableElement.setJoinedQueryable(joinedQueryables, allowsNull);
        }
    }

    public String displayString() {
        StringBuffer displayString = new StringBuffer();
        if (this.getJoinedQueryableElement() != null) {
            displayString.append(this.getJoinedQueryableElement().displayString());
            displayString.append('.');
        }
        if (this.getQueryable() != null) {
            displayString.append(this.getQueryable().getName());
            if (this.allowsNull) {
                if (this.getQueryable().usesAnyOf()) {
                    displayString.append("(Allows None)");
                } else {
                    displayString.append("(Allows Null)");
                }
            }
        } else {
            displayString.append("<null>");
        }
        return displayString.toString();
    }

    public void toString(StringBuffer sb) {
        if (this.getJoinedQueryableElement() != null) {
            sb.append(this.getJoinedQueryableElement().displayString() + ".");
        }
        if (this.getQueryable() != null) {
            sb.append(this.getQueryable().getName());
            if (this.allowsNull) {
                if (this.getQueryable().usesAnyOf()) {
                    sb.append("(Allows None)");
                } else {
                    sb.append("(Allows Null)");
                }
            }
        }
    }

    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        children.add(this.queryableHandle);
        if (this.joinedQueryableElement != null) {
            children.add(this.joinedQueryableElement);
        }
    }

    private MWHandle.NodeReferenceScrubber buildQueryableScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            public void nodeReferenceRemoved(Node node, MWHandle handle) {
                MWQueryableArgumentElement.this.setQueryableToNull();
            }

            public String toString() {
                return "MWQueryableArgumentElement.buildQueryableScrubber()";
            }
        };
    }

    public void descriptorUnmapped(Collection mappings) {
        super.descriptorUnmapped(mappings);
        if (this.getQueryable() != null && mappings.contains(this.getQueryable())) {
            this.setQueryableToNull();
        }
    }

    public void mappingReplaced(MWMapping oldMapping, MWMapping newMapping) {
        super.mappingReplaced(oldMapping, newMapping);
        if (this.getQueryable() == oldMapping) {
            this.queryableHandle.setQueryable(newMapping);
            if (newMapping != null && !newMapping.allowsOuterJoin()) {
                this.setAllowsNull(false);
            }
        }
    }

    Expression convertToRuntime(ExpressionBuilder builder) {
        builder.derivedExpressions = null;
        if (this.getJoinedQueryableElement() != null) {
            Expression joinedExpression = this.getJoinedQueryableElement().convertToRuntime(builder);
            return this.buildExpressionFrom(joinedExpression);
        }
        return this.buildExpressionFrom((Expression)builder);
    }

    private Expression buildExpressionFrom(Expression expression) {
        String name = "";
        if (this.getQueryable() != null) {
            name = this.getQueryable().getName();
        }
        if (this.getQueryable() != null && !this.getQueryable().usesAnyOf()) {
            if (!this.allowsNull) {
                return expression.get(name);
            }
            return expression.getAllowingNull(name);
        }
        if (!this.allowsNull) {
            return expression.anyOf(name);
        }
        return expression.anyOfAllowingNone(name);
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWQueryableArgumentElement.class);
        XMLCompositeObjectMapping queryableHandleMapping = new XMLCompositeObjectMapping();
        queryableHandleMapping.setAttributeName("queryableHandle");
        queryableHandleMapping.setGetMethodName("getQueryableHandleForTopLink");
        queryableHandleMapping.setSetMethodName("setQueryableHandleForTopLink");
        queryableHandleMapping.setReferenceClass(MWQueryableHandle.class);
        queryableHandleMapping.setXPath("queryable-handle");
        descriptor.addMapping((DatabaseMapping)queryableHandleMapping);
        ((XMLDirectMapping)descriptor.addDirectMapping(ALLOWS_NULL_PROPERTY, "allows-null/text()")).setNullValue((Object)Boolean.FALSE);
        XMLCompositeObjectMapping joinedQueryableElementMapping = new XMLCompositeObjectMapping();
        joinedQueryableElementMapping.setAttributeName("joinedQueryableElement");
        joinedQueryableElementMapping.setReferenceClass(MWQueryableArgumentElement.class);
        joinedQueryableElementMapping.setXPath("joined-queryable-element");
        descriptor.addMapping((DatabaseMapping)joinedQueryableElementMapping);
        return descriptor;
    }

    private MWQueryableHandle getQueryableHandleForTopLink() {
        return this.queryableHandle.getQueryable() == null ? null : this.queryableHandle;
    }

    private void setQueryableHandleForTopLink(MWQueryableHandle handle) {
        MWHandle.NodeReferenceScrubber scrubber = this.buildQueryableScrubber();
        this.queryableHandle = handle == null ? new MWQueryableHandle(this, scrubber) : handle.setScrubber(scrubber);
    }
}

