/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.schema;

import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.xerces.impl.xs.XSComplexTypeDecl;
import org.apache.xerces.impl.xs.XSElementDecl;
import org.apache.xerces.impl.xs.XSParticleDecl;
import org.apache.xerces.impl.xs.identity.IdentityConstraint;
import org.apache.xerces.xs.XSObject;
import org.apache.xerces.xs.XSTypeDefinition;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.QName;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.AbstractNamedSchemaComponent;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.AbstractSchemaComponent;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.ExplicitSchemaTypeDefinition;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.IdentityConstraintDefinition;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWAttributeDeclaration;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWElementDeclaration;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWNamedSchemaComponent;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWSchemaTypeDefinition;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.ReferencedAttributeDeclaration;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.ReferencedElementDeclaration;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.ReferencedSchemaTypeDefinition;
import org.eclipse.persistence.tools.workbench.utility.iterators.CompositeIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.NullIterator;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class ExplicitElementDeclaration
extends AbstractNamedSchemaComponent
implements MWElementDeclaration {
    private volatile MWSchemaTypeDefinition type;
    private volatile boolean nillable;
    private volatile transient MWAttributeDeclaration nilAttribute;
    private volatile String defaultValue;
    private volatile String fixedValue;
    private Map identityConstraints;
    private volatile ReferencedElementDeclaration substitutionGroup;
    private volatile boolean abstractFlag;
    private volatile int minOccurs;
    private volatile int maxOccurs;

    private ExplicitElementDeclaration() {
    }

    ExplicitElementDeclaration(MWModel parent, String name) {
        super(parent, name);
    }

    protected void initialize(Node parent) {
        super.initialize(parent);
        this.identityConstraints = new Hashtable();
    }

    protected void initialize() {
        super.initialize();
        this.minOccurs = 1;
        this.maxOccurs = 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        if (this.type != null) {
            children.add(this.type);
        }
        Map map = this.identityConstraints;
        synchronized (map) {
            children.addAll(this.identityConstraints.values());
        }
        if (this.substitutionGroup != null) {
            children.add(this.substitutionGroup);
        }
    }

    private MWAttributeDeclaration buildNilAttribute() {
        return new ReferencedAttributeDeclaration(this, "nil", "http://www.w3.org/2001/XMLSchema");
    }

    public MWSchemaTypeDefinition getType() {
        return this.type;
    }

    public MWElementDeclaration getSubstitutionGroup() {
        return this.substitutionGroup;
    }

    public boolean isAbstract() {
        return this.abstractFlag;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getFixedValue() {
        return this.fixedValue;
    }

    public boolean isNillable() {
        return this.nillable;
    }

    public int getMinOccurs() {
        return this.minOccurs;
    }

    public int getMaxOccurs() {
        return this.maxOccurs;
    }

    public boolean isDescriptorContextComponent() {
        return !this.type.isReference();
    }

    public boolean isEquivalentTo(XSParticleDecl xsParticle) {
        if (xsParticle.getTerm() instanceof XSElementDecl) {
            XSElementDecl elementNode = (XSElementDecl)xsParticle.getTerm();
            return this.getName().equals(elementNode.getName());
        }
        return false;
    }

    public Iterator baseBuiltInTypes() {
        return this.type.baseBuiltInTypes();
    }

    public boolean hasType() {
        return true;
    }

    public String contextTypeQname() {
        return this.type.contextTypeQname();
    }

    public boolean containsText() {
        return this.type.containsText();
    }

    public boolean containsWildcard() {
        return this.type.containsWildcard();
    }

    public int compareSchemaOrder(MWElementDeclaration element1, MWElementDeclaration element2) {
        return this.type.compareSchemaOrder(element1, element2);
    }

    public String componentTypeName() {
        return "element";
    }

    public void addDirectlyOwnedComponentsTo(Collection directlyOwnedComponents) {
        this.type.addDirectlyOwnedComponentsTo(directlyOwnedComponents);
    }

    public Iterator structuralComponents() {
        return this.type.structuralComponents();
    }

    public Iterator descriptorContextComponents() {
        if (!this.type.isReference()) {
            return this.type.descriptorContextComponents();
        }
        return NullIterator.instance();
    }

    public Iterator xpathComponents() {
        Iterator typeXpathComponents = this.type.xpathComponents();
        if (this.nilAttribute == null) {
            return typeXpathComponents;
        }
        return new CompositeIterator(this.nilAttribute, this.type.xpathComponents());
    }

    public MWNamedSchemaComponent nestedNamedComponent(QName qName) {
        return this.type.nestedNamedComponent(qName);
    }

    public MWAttributeDeclaration nestedAttribute(String namespaceUrl, String attributeName) {
        if (this.nilAttribute != null && namespaceUrl.equals(this.nilAttribute.getNamespaceUrl()) && attributeName.equals(this.nilAttribute.getName())) {
            return this.nilAttribute;
        }
        return this.type.nestedAttribute(namespaceUrl, attributeName);
    }

    public MWElementDeclaration nestedElement(String namespaceUrl, String elementName) {
        return this.type.nestedElement(namespaceUrl, elementName);
    }

    public int totalElementCount() {
        return 1;
    }

    protected void reloadInternal(XSObject xsObject) {
        XSElementDecl elemenDecl = null;
        if (xsObject instanceof XSParticleDecl) {
            elemenDecl = (XSElementDecl)((XSParticleDecl)xsObject).getTerm();
            super.reloadInternal((XSObject)elemenDecl);
        } else {
            elemenDecl = (XSElementDecl)xsObject;
            super.reloadInternal(xsObject);
        }
        this.reloadType(elemenDecl);
        this.reloadNillable(elemenDecl);
        if (elemenDecl.getConstraintType() != 0) {
            if (elemenDecl.getConstraintType() == 1) {
                this.defaultValue = elemenDecl.getConstraintValue();
            } else if (elemenDecl.getConstraintType() == 2) {
                this.fixedValue = elemenDecl.getConstraintValue();
            }
        }
        this.abstractFlag = elemenDecl.getAbstract();
        if (xsObject instanceof XSParticleDecl) {
            this.minOccurs = ((XSParticleDecl)xsObject).getMinOccurs();
            this.maxOccurs = ((XSParticleDecl)xsObject).getMaxOccurs();
            if (((XSParticleDecl)xsObject).getMaxOccursUnbounded()) {
                this.maxOccurs = 0x7FFFFFF8;
            }
        }
        this.reloadSubstitutionGroup(elemenDecl);
        this.reloadIdentityConstraints(elemenDecl);
    }

    private void reloadType(XSElementDecl elementDecl) {
        MWSchemaTypeDefinition oldType = this.type;
        XSTypeDefinition typeDef = elementDecl.getTypeDefinition();
        String typeName = typeDef.getName();
        String typeNamespace = typeDef.getNamespace();
        this.type = !"".equals(this.getName()) && this.parentNamedComponent() instanceof ExplicitElementDeclaration && this.getName().equals(this.parentNamedComponent().getName()) && this.parentNamedComponent().parentNamedComponent() instanceof ExplicitElementDeclaration && this.getName().equals(this.parentNamedComponent().parentNamedComponent().getName()) ? ReferencedSchemaTypeDefinition.urType(this) : (typeName == null && (typeDef.getTypeCategory() != 15 || ((XSComplexTypeDecl)typeDef).getBaseType() != null) ? ExplicitSchemaTypeDefinition.reloadedExplicitType(this, this.type, elementDecl) : ReferencedSchemaTypeDefinition.reloadedReferencedType(this, oldType, typeName, typeNamespace, typeDef));
        if (oldType != this.type && oldType != null) {
            this.getProject().nodeRemoved(oldType);
        }
    }

    private void reloadNillable(XSElementDecl elemenDecl) {
        this.nillable = elemenDecl.getNillable();
        this.nilAttribute = this.nillable ? this.buildNilAttribute() : null;
    }

    private void reloadSubstitutionGroup(XSElementDecl elementDecl) {
        if (elementDecl.getSubstitutionGroupAffiliation() != null) {
            String substitutionGroupName = elementDecl.getSubstitutionGroupAffiliation().getName();
            String substitutionGroupNamespace = elementDecl.getSubstitutionGroupAffiliation().getNamespace();
            this.substitutionGroup = new ReferencedElementDeclaration(this, substitutionGroupName, substitutionGroupNamespace);
        } else {
            this.substitutionGroup = null;
        }
    }

    private void reloadIdentityConstraints(XSElementDecl elementDecl) {
        IdentityConstraint[] identityNodes = elementDecl.getIDConstraints();
        for (int i = 0; identityNodes != null && i < identityNodes.length; ++i) {
            IdentityConstraint identityNode = identityNodes[i];
            String identityName = identityNode.getName();
            IdentityConstraintDefinition identityConstraint = (IdentityConstraintDefinition)this.identityConstraints.get(identityName);
            if (identityConstraint == null) {
                identityConstraint = new IdentityConstraintDefinition(this, identityName);
                this.identityConstraints.put(identityName, identityConstraint);
            }
            identityConstraint.reload(identityNode);
        }
    }

    public void resolveReferences() {
        super.resolveReferences();
        this.type.resolveReferences();
        if (this.nilAttribute != null) {
            this.nilAttribute.resolveReferences();
        }
        if (this.substitutionGroup != null) {
            this.substitutionGroup.resolveReferences();
        }
    }

    private Map getIdentityConstraintsForToplink() {
        return new TreeMap(this.identityConstraints);
    }

    private void setIdentityConstraintsForToplink(Map map) {
        Iterator iter = map.values().iterator();
        Hashtable<String, IdentityConstraintDefinition> elementMap = new Hashtable<String, IdentityConstraintDefinition>();
        while (iter.hasNext()) {
            IdentityConstraintDefinition icd = (IdentityConstraintDefinition)iter.next();
            elementMap.put(icd.getName(), icd);
        }
        this.identityConstraints = elementMap;
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(ExplicitElementDeclaration.class);
        descriptor.getInheritancePolicy().setParentClass(AbstractNamedSchemaComponent.class);
        XMLCompositeObjectMapping typeMapping = new XMLCompositeObjectMapping();
        typeMapping.setAttributeName("type");
        typeMapping.setReferenceClass(AbstractSchemaComponent.class);
        typeMapping.setXPath("type");
        descriptor.addMapping((DatabaseMapping)typeMapping);
        XMLDirectMapping nillableMapping = (XMLDirectMapping)descriptor.addDirectMapping("nillable", "nillable/text()");
        nillableMapping.setGetMethodName("getNillableForTopLink");
        nillableMapping.setSetMethodName("setNillableForTopLink");
        nillableMapping.setNullValue((Object)Boolean.FALSE);
        descriptor.addDirectMapping("defaultValue", "default-value/text()");
        descriptor.addDirectMapping("fixedValue", "fixed-value/text()");
        XMLDirectMapping abstractMapping = (XMLDirectMapping)descriptor.addDirectMapping("abstractFlag", "abstract/text()");
        abstractMapping.setNullValue((Object)Boolean.FALSE);
        ((XMLDirectMapping)descriptor.addDirectMapping("minOccurs", "min-occurs/text()")).setNullValue((Object)new Integer(1));
        ((XMLDirectMapping)descriptor.addDirectMapping("maxOccurs", "max-occurs/text()")).setNullValue((Object)new Integer(1));
        XMLCompositeObjectMapping substitutionGroupMapping = new XMLCompositeObjectMapping();
        substitutionGroupMapping.setAttributeName("substitutionGroup");
        substitutionGroupMapping.setReferenceClass(ReferencedElementDeclaration.class);
        substitutionGroupMapping.setXPath("substitution-group");
        descriptor.addMapping((DatabaseMapping)substitutionGroupMapping);
        XMLCompositeCollectionMapping indentityConstraintsMapping = new XMLCompositeCollectionMapping();
        indentityConstraintsMapping.setAttributeName("identityConstraints");
        indentityConstraintsMapping.setGetMethodName("getIdentityConstraintsForToplink");
        indentityConstraintsMapping.setSetMethodName("setIdentityConstraintsForToplink");
        indentityConstraintsMapping.setXPath("identity-constraints/identity-constraint");
        indentityConstraintsMapping.setReferenceClass(IdentityConstraintDefinition.class);
        indentityConstraintsMapping.useMapClass(TreeMap.class, "getName");
        descriptor.addMapping((DatabaseMapping)indentityConstraintsMapping);
        return descriptor;
    }

    private boolean getNillableForTopLink() {
        return this.nillable;
    }

    private void setNillableForTopLink(boolean newValue) {
        this.nillable = newValue;
        if (newValue) {
            this.nilAttribute = this.buildNilAttribute();
        }
    }
}

