/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.xml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.oxm.XMLConstants;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.XMLUnionField;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWDataField;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWSchemaContextComponent;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWSimpleTypeDefinition;
import org.eclipse.persistence.tools.workbench.mappingsmodel.xml.MWXmlNode;
import org.eclipse.persistence.tools.workbench.mappingsmodel.xml.MWXpathContext;
import org.eclipse.persistence.tools.workbench.mappingsmodel.xml.MWXpathSpec;
import org.eclipse.persistence.tools.workbench.mappingsmodel.xml.MWXpathStep;
import org.eclipse.persistence.tools.workbench.mappingsmodel.xml.SchemaChange;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.NullIterator;

public final class MWXmlField
extends MWModel
implements MWDataField,
MWXmlNode {
    private volatile String xpath = "";
    public static final String XPATH_PROPERTY = "xpath";
    private volatile boolean aggregated = false;
    public static final String AGGREGATED_PROPERTY = "aggregated";
    private volatile boolean typed;
    public static final String TYPED_PROPERTY = "typed";
    private volatile boolean useSingleNode = false;
    public static final String USE_SINGLE_NODE_PROPERTY = "useSingleNode";
    private transient Vector xpathSteps;
    private transient boolean resolved;
    public static final String RESOLVED_PROPERTY = "resolved";
    private transient boolean validPosition = true;
    public static final String VALID_POSITION_PROPERTY = "validPosition";
    private transient boolean validText = true;
    public static final String VALID_TEXT_PROPERTY = "validText";
    public static final String TEXT = "text()";
    private static transient Map jdbcTypeMap;

    private MWXmlField() {
    }

    public MWXmlField(MWXpathContext parent) {
        super(parent);
    }

    protected void initialize() {
        super.initialize();
        this.xpathSteps = new Vector();
    }

    protected void addTransientAspectNamesTo(Set transientAspectNames) {
        super.addTransientAspectNamesTo(transientAspectNames);
        transientAspectNames.add(RESOLVED_PROPERTY);
        transientAspectNames.add(VALID_POSITION_PROPERTY);
        transientAspectNames.add(VALID_TEXT_PROPERTY);
    }

    public MWXpathContext getXpathContext() {
        return (MWXpathContext)this.getParent();
    }

    public MWSchemaContextComponent schemaContext() {
        return this.getXpathContext().schemaContext(this);
    }

    public MWXpathSpec xpathSpec() {
        return this.getXpathContext().xpathSpec(this);
    }

    protected Iterator xpathSteps() {
        return this.xpathSteps.iterator();
    }

    public String getXpath() {
        return this.xpath;
    }

    public void setXpath(String newXpath) {
        if (newXpath == null) {
            newXpath = "";
        }
        String oldXpath = this.xpath;
        this.xpath = newXpath;
        if (this.attributeValueHasChanged(oldXpath, newXpath)) {
            this.firePropertyChanged(XPATH_PROPERTY, oldXpath, newXpath);
            this.firePropertyChanged("fieldName", newXpath);
            this.resolve();
            if (!this.xpath.equals("")) {
                this.setAggregated(false);
            }
            if (!this.xpath.endsWith(TEXT)) {
                this.setTyped(false);
            }
        }
    }

    public boolean isTextXpath() {
        return this.getXpath().endsWith(TEXT);
    }

    public boolean isAttributeXpath() {
        return this.getXpath().indexOf(64) != -1;
    }

    public boolean isPositionalXpath() {
        if (this.isResolved()) {
            Iterator stream = this.xpathSteps();
            while (stream.hasNext()) {
                if (!((MWXpathStep)stream.next()).isPositional()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isDirect() {
        if (this.isResolved() && !this.isAggregated()) {
            MWXpathStep lastStep = (MWXpathStep)this.xpathSteps.lastElement();
            return lastStep.isAttribute() || lastStep.isText();
        }
        return false;
    }

    public boolean isSingular() {
        boolean singular = true;
        Iterator stream = this.xpathSteps();
        while (stream.hasNext()) {
            singular &= ((MWXpathStep)stream.next()).isSingular();
        }
        return singular;
    }

    public boolean containsXmlField(MWXmlField otherField) {
        return otherField.getXpath().startsWith(this.getXpath());
    }

    public boolean isAggregated() {
        return this.aggregated;
    }

    public void setAggregated(boolean newValue) {
        boolean oldValue = this.aggregated;
        this.aggregated = newValue;
        this.firePropertyChanged(AGGREGATED_PROPERTY, oldValue, newValue);
        if (newValue) {
            this.setXpath("");
        }
    }

    public boolean isTyped() {
        return this.typed;
    }

    public void setTyped(boolean newValue) {
        boolean oldValue = this.typed;
        this.typed = newValue;
        this.firePropertyChanged(TYPED_PROPERTY, oldValue, newValue);
    }

    public boolean usesSingleNode() {
        return this.useSingleNode;
    }

    public void setUseSingleNode(boolean newValue) {
        boolean oldValue = this.useSingleNode;
        this.useSingleNode = newValue;
        this.firePropertyChanged(USE_SINGLE_NODE_PROPERTY, oldValue, newValue);
    }

    public boolean isSpecified() {
        return !"".equals(this.xpath) || this.isAggregated();
    }

    public boolean isResolved() {
        return this.resolved;
    }

    private void setResolved(boolean newValue) {
        boolean oldValue = this.resolved;
        this.resolved = newValue;
        this.firePropertyChanged(RESOLVED_PROPERTY, oldValue, newValue);
    }

    private void setValidText(boolean newValue) {
        boolean oldValue = this.validText;
        this.validText = newValue;
        this.firePropertyChanged(VALID_TEXT_PROPERTY, oldValue, newValue);
    }

    private void setValidPosition(boolean newValue) {
        boolean oldValue = this.validPosition;
        this.validPosition = newValue;
        this.firePropertyChanged(VALID_POSITION_PROPERTY, oldValue, newValue);
    }

    public boolean isValid() {
        return this.isResolved() && this.validText && this.validPosition;
    }

    private void resolve() {
        boolean resolved;
        MWXpathStep nextStep;
        this.xpathSteps.clear();
        StringTokenizer tokenizer = new StringTokenizer(this.xpath, "/");
        while (tokenizer.hasMoreTokens()) {
            this.xpathSteps.add(new MWXpathStep(this, tokenizer.nextToken()));
        }
        MWSchemaContextComponent schemaContext = this.schemaContext();
        Iterator stream = this.xpathSteps();
        for (resolved = this.isSpecified(); resolved && stream.hasNext(); resolved &= nextStep.isResolved()) {
            nextStep = (MWXpathStep)stream.next();
            schemaContext = nextStep.resolveContext(schemaContext);
        }
        if (!resolved) {
            this.xpathSteps.clear();
        }
        this.setResolved(resolved);
        this.validateXpath();
    }

    private void resynchXpath() {
        if (this.isResolved()) {
            String xpath = "";
            Iterator stream = this.xpathSteps.iterator();
            while (stream.hasNext()) {
                MWXpathStep nextStep = (MWXpathStep)stream.next();
                nextStep.updateStepString();
                xpath = xpath + nextStep.getStepString();
                if (!stream.hasNext()) continue;
                xpath = xpath + "/";
            }
            this.setXpath(xpath);
        } else {
            this.resolve();
        }
    }

    private void validateXpath() {
        if (this.isTextXpath()) {
            if (this.isResolved()) {
                this.validateTextXpath();
            } else {
                this.setValidText(false);
            }
        } else {
            this.setValidText(true);
        }
        if (this.isPositionalXpath()) {
            if (this.isResolved()) {
                this.validatePositionalXpath();
            } else {
                this.setValidPosition(false);
            }
        } else {
            this.setValidPosition(true);
        }
    }

    private void validateTextXpath() {
        boolean valid = true;
        Iterator stream = this.xpathSteps();
        while (stream.hasNext()) {
            MWXpathStep step = (MWXpathStep)stream.next();
            if (!step.isText()) continue;
            valid &= step.isValid();
        }
        this.setValidText(valid);
    }

    private void validatePositionalXpath() {
        boolean valid = true;
        Iterator stream = this.xpathSteps();
        while (stream.hasNext()) {
            MWXpathStep step = (MWXpathStep)stream.next();
            if (!step.isPositional()) continue;
            valid &= step.isValid();
        }
        this.setValidPosition(valid);
    }

    public void resolveXpaths() {
        this.resolve();
    }

    public void schemaChanged(SchemaChange change) {
        if (change.getChangeType() == 0) {
            this.resolve();
        } else if (change.getChangeType() == 1) {
            this.resynchXpath();
        }
    }

    public String fieldName() {
        return this.xpath;
    }

    protected void addProblemsTo(List currentProblems) {
        super.addProblemsTo(currentProblems);
        this.checkXpath(currentProblems);
    }

    private void checkXpath(List currentProblems) {
        if (this.isResolved()) {
            if (!this.validText) {
                currentProblems.add(this.buildProblem("0812", this.getXpath()));
            }
            if (!this.validPosition) {
                currentProblems.add(this.buildProblem("0813", this.getXpath()));
            }
        } else if (!"".equals(this.getXpath())) {
            currentProblems.add(this.buildProblem("0811", this.getXpath()));
        }
    }

    public String runtimeFieldName() {
        return this.xpath;
    }

    public DatabaseField runtimeField() {
        if (!this.isSpecified()) {
            return null;
        }
        XMLField runtimeField = this.buildRuntimeField();
        runtimeField.setXPath(this.runtimeXpath());
        return runtimeField;
    }

    public DatabaseField runtimeField(MWXmlField groupingElement) {
        if (!this.isSpecified()) {
            return null;
        }
        XMLField runtimeField = this.buildRuntimeField();
        if (groupingElement.isSpecified()) {
            runtimeField.setXPath(this.runtimeXpath(groupingElement));
        } else {
            runtimeField.setXPath(this.runtimeXpath());
        }
        return runtimeField;
    }

    private XMLField buildRuntimeField() {
        XMLUnionField runtimeField = null;
        Vector dataTypes = CollectionTools.vector(this.baseBuiltInTypes());
        if (dataTypes.size() > 1) {
            runtimeField = new XMLUnionField();
            this.adjustUnionSchemaTypes(runtimeField, dataTypes);
        } else {
            runtimeField = new XMLField();
            this.adjustNonUnionSchemaTypes((XMLField)runtimeField, dataTypes);
        }
        if (this.isTyped()) {
            runtimeField.setIsTypedTextField(true);
        }
        if (this.usesSingleNode()) {
            runtimeField.setUsesSingleNode(true);
        }
        return runtimeField;
    }

    private String runtimeXpath() {
        if (this.isAggregated()) {
            return ".";
        }
        return this.getXpath();
    }

    private String runtimeXpath(MWXmlField groupingElement) {
        String runtimeXpath = this.runtimeXpath();
        if (groupingElement.containsXmlField(this)) {
            String groupingRuntimeXpath = groupingElement.getXpath();
            if (runtimeXpath.length() > groupingRuntimeXpath.length()) {
                return runtimeXpath.substring(groupingRuntimeXpath.length() + 1);
            }
            return runtimeXpath;
        }
        return runtimeXpath;
    }

    private Iterator baseBuiltInTypes() {
        MWSchemaContextComponent component = this.xpathComponent();
        if (component == null) {
            return NullIterator.instance();
        }
        return component.baseBuiltInTypes();
    }

    private MWSchemaContextComponent xpathComponent() {
        MWSchemaContextComponent xpathComponent = null;
        if (TEXT.equals(this.getXpath())) {
            xpathComponent = this.schemaContext();
        }
        Iterator stream = this.xpathSteps();
        while (stream.hasNext()) {
            MWXpathStep nextStep = (MWXpathStep)stream.next();
            if (nextStep.xpathComponent() == null) continue;
            xpathComponent = nextStep.xpathComponent();
        }
        return xpathComponent;
    }

    private void adjustUnionSchemaTypes(XMLUnionField runtimeField, Vector baseBuiltInTypes) {
        if (!this.isDirect()) {
            return;
        }
        for (MWSimpleTypeDefinition baseBuiltInType : baseBuiltInTypes) {
            if (!"http://www.w3.org/2001/XMLSchema".equals(baseBuiltInType.getNamespaceUrl())) continue;
            QName schemaType = this.runtimeSchemaType(baseBuiltInType);
            ArrayList runtimeSchemaTypes = runtimeField.getSchemaTypes();
            if (runtimeSchemaTypes != null && runtimeSchemaTypes.contains(schemaType)) continue;
            runtimeField.addSchemaType(schemaType);
        }
    }

    private void adjustNonUnionSchemaTypes(XMLField runtimeField, Vector baseBuiltInTypes) {
        if (!this.isDirect()) {
            return;
        }
        for (MWSimpleTypeDefinition baseBuiltInType : baseBuiltInTypes) {
            QName runtimeSchemaType;
            if (!"http://www.w3.org/2001/XMLSchema".equals(baseBuiltInType.getNamespaceUrl()) || !this.shouldSetNonUnionRuntimeSchemaType(runtimeSchemaType = this.runtimeSchemaType(baseBuiltInType))) continue;
            runtimeField.setSchemaType(runtimeSchemaType);
        }
    }

    private boolean shouldSetNonUnionRuntimeSchemaType(QName runtimeSchemaType) {
        return XMLConstants.DATE_QNAME.equals(runtimeSchemaType) || XMLConstants.TIME_QNAME.equals(runtimeSchemaType) || XMLConstants.DATE_TIME_QNAME.equals(runtimeSchemaType) || XMLConstants.BASE_64_BINARY_QNAME.equals(runtimeSchemaType) || XMLConstants.HEX_BINARY_QNAME.equals(runtimeSchemaType);
    }

    private QName runtimeSchemaType(MWSimpleTypeDefinition baseBuiltInType) {
        String baseDataType = (String)this.jdbcTypeMap().get(baseBuiltInType.getName());
        return new QName("http://www.w3.org/2001/XMLSchema", baseDataType);
    }

    private Map jdbcTypeMap() {
        if (jdbcTypeMap == null) {
            MWXmlField.buildJdbcTypeMap();
        }
        return jdbcTypeMap;
    }

    private static void buildJdbcTypeMap() {
        HashMap<String, String> typeMap = new HashMap<String, String>();
        typeMap.put("anySimpleType", "anySimpleType");
        typeMap.put("duration", "anySimpleType");
        typeMap.put("dateTime", "dateTime");
        typeMap.put("time", "time");
        typeMap.put("date", "date");
        typeMap.put("gYear", "anySimpleType");
        typeMap.put("gYearMonth", "anySimpleType");
        typeMap.put("gMonth", "anySimpleType");
        typeMap.put("gMonthDay", "anySimpleType");
        typeMap.put("gDay", "anySimpleType");
        typeMap.put("boolean", "boolean");
        typeMap.put("base64Binary", "base64Binary");
        typeMap.put("hexBinary", "hexBinary");
        typeMap.put("anyURI", "anySimpleType");
        typeMap.put("QName", "anySimpleType");
        typeMap.put("NOTATION", "anySimpleType");
        typeMap.put("string", "anySimpleType");
        typeMap.put("normalizedString", "anySimpleType");
        typeMap.put("token", "anySimpleType");
        typeMap.put("language", "anySimpleType");
        typeMap.put("Name", "anySimpleType");
        typeMap.put("NMTOKEN", "anySimpleType");
        typeMap.put("NCName", "anySimpleType");
        typeMap.put("ID", "anySimpleType");
        typeMap.put("IDREF", "IDREF");
        typeMap.put("IDREFS", "IDREFS");
        typeMap.put("ENTITY", "anySimpleType");
        typeMap.put("float", "float");
        typeMap.put("double", "double");
        typeMap.put("decimal", "decimal");
        typeMap.put("integer", "integer");
        typeMap.put("nonPositiveInteger", "integer");
        typeMap.put("negativeInteger", "integer");
        typeMap.put("nonNegativeInteger", "integer");
        typeMap.put("positiveInteger", "integer");
        typeMap.put("unsignedLong", "integer");
        typeMap.put("unsignedInt", "unsignedInt");
        typeMap.put("unsignedShort", "unsignedShort");
        typeMap.put("unsignedByte", "unsignedByte");
        typeMap.put("long", "long");
        typeMap.put("int", "int");
        typeMap.put("short", "short");
        typeMap.put("byte", "byte");
        jdbcTypeMap = typeMap;
    }

    public static int compareSchemaOrder(MWXmlField xmlField1, MWXmlField xmlField2) {
        if (xmlField1 == xmlField2 || xmlField1 == null || xmlField2 == null || !xmlField1.isResolved() || !xmlField2.isResolved()) {
            return 0;
        }
        if (xmlField1.schemaContext() != xmlField2.schemaContext()) {
            throw new IllegalStateException("XML field \"" + xmlField1.getXpath() + "\" and XML field \"" + xmlField2.getXpath() + "\" are not in the same context.");
        }
        return MWXmlField.compareSchemaOrder(xmlField1.schemaContext(), xmlField1.xpathSteps(), xmlField2.xpathSteps());
    }

    public static int compareSchemaOrder(MWSchemaContextComponent contextComponent, Iterator xpathSteps1, Iterator xpathSteps2) {
        MWXpathStep step2;
        if (!xpathSteps1.hasNext() || !xpathSteps2.hasNext()) {
            return 0;
        }
        MWXpathStep step1 = (MWXpathStep)xpathSteps1.next();
        int comparison = MWXpathStep.compareSchemaOrder(contextComponent, step1, step2 = (MWXpathStep)xpathSteps2.next());
        if (comparison == 0 && step1.xpathComponent() == step2.xpathComponent()) {
            return MWXmlField.compareSchemaOrder(step1.xpathComponent(), xpathSteps1, xpathSteps2);
        }
        return comparison;
    }

    public void toString(StringBuffer sb) {
        super.toString(sb);
        sb.append("\"" + this.xpath + "\"");
    }

    public String displayString() {
        return this.xpath;
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWXmlField.class);
        ((XMLDirectMapping)descriptor.addDirectMapping(XPATH_PROPERTY, TEXT)).setNullValue((Object)"");
        ((XMLDirectMapping)descriptor.addDirectMapping(AGGREGATED_PROPERTY, "@aggregated")).setNullValue((Object)Boolean.FALSE);
        ((XMLDirectMapping)descriptor.addDirectMapping(TYPED_PROPERTY, "@typed")).setNullValue((Object)Boolean.FALSE);
        return descriptor;
    }

    public void postProjectBuild() {
        super.postProjectBuild();
        this.resolve();
    }
}

