/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.persistence.tools.workbench.utility.Bag;
import org.eclipse.persistence.tools.workbench.utility.HashBag;

public class IdentityHashBag
extends AbstractCollection
implements Bag,
Cloneable,
Serializable {
    transient Entry[] table;
    transient int count = 0;
    transient int uniqueCount = 0;
    private int threshold;
    private float loadFactor;
    transient int modCount = 0;
    private static Iterator emptyIterator = new EmptyIterator();
    private static final long serialVersionUID = 1L;

    public IdentityHashBag() {
        this(11, 0.75f);
    }

    public IdentityHashBag(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public IdentityHashBag(int initialCapacity, float loadFactor) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Initial Capacity: " + initialCapacity);
        }
        if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException("Illegal Load factor: " + loadFactor);
        }
        if (initialCapacity == 0) {
            initialCapacity = 1;
        }
        this.loadFactor = loadFactor;
        this.table = new Entry[initialCapacity];
        this.threshold = (int)((float)initialCapacity * loadFactor);
    }

    public IdentityHashBag(Collection c) {
        this(Math.max(2 * c.size(), 11));
        this.addAll(c);
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public boolean contains(Object o) {
        Entry[] tab = this.table;
        int hash = System.identityHashCode(o);
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index];
        while (e != null) {
            if (e.hash == hash && e.object == o) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    public int count(Object o) {
        Entry[] tab = this.table;
        int hash = System.identityHashCode(o);
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index];
        while (e != null) {
            if (e.hash == hash && e.object == o) {
                return e.count;
            }
            e = e.next;
        }
        return 0;
    }

    private void rehash() {
        Entry[] oldMap = this.table;
        int oldCapacity = oldMap.length;
        int newCapacity = oldCapacity * 2 + 1;
        Entry[] newMap = new Entry[newCapacity];
        ++this.modCount;
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.table = newMap;
        int i = oldCapacity;
        while (i-- > 0) {
            Entry old = oldMap[i];
            while (old != null) {
                Entry e = old;
                old = old.next;
                int index = (e.hash & Integer.MAX_VALUE) % newCapacity;
                e.next = newMap[index];
                newMap[index] = e;
            }
        }
    }

    public boolean add(Object o) {
        ++this.modCount;
        Entry[] tab = this.table;
        int hash = 0;
        int index = 0;
        hash = System.identityHashCode(o);
        index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index];
        while (e != null) {
            if (e.hash == hash && e.object == o) {
                ++e.count;
                ++this.count;
                return true;
            }
            e = e.next;
        }
        if (this.uniqueCount >= this.threshold) {
            this.rehash();
            tab = this.table;
            index = (hash & Integer.MAX_VALUE) % tab.length;
        }
        tab[index] = e = new Entry(hash, o, tab[index]);
        ++this.count;
        ++this.uniqueCount;
        return true;
    }

    public boolean remove(Object o) {
        Entry[] tab = this.table;
        int hash = System.identityHashCode(o);
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index];
        Entry prev = null;
        while (e != null) {
            if (e.hash == hash && e.object == o) {
                ++this.modCount;
                --e.count;
                if (e.count == 0) {
                    if (prev == null) {
                        tab[index] = e.next;
                    } else {
                        prev.next = e.next;
                    }
                    --this.uniqueCount;
                }
                --this.count;
                return true;
            }
            prev = e;
            e = e.next;
        }
        return false;
    }

    public boolean removeAll(Collection c) {
        return super.removeAll(new IdentityHashBag(c));
    }

    public boolean retainAll(Collection c) {
        return super.retainAll(new IdentityHashBag(c));
    }

    public void clear() {
        Entry[] tab = this.table;
        ++this.modCount;
        int i = tab.length;
        while (--i >= 0) {
            tab[i] = null;
        }
        this.count = 0;
        this.uniqueCount = 0;
    }

    public Object clone() {
        try {
            IdentityHashBag clone = (IdentityHashBag)super.clone();
            clone.table = new Entry[this.table.length];
            int i = this.table.length;
            while (i-- > 0) {
                clone.table[i] = this.table[i] == null ? null : (Entry)this.table[i].clone();
            }
            clone.modCount = 0;
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public Iterator iterator() {
        if (this.count == 0) {
            return emptyIterator;
        }
        return new HashIterator();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof IdentityHashBag) {
            IdentityHashBag b = (IdentityHashBag)o;
            if (b.size() != this.size()) {
                return false;
            }
            IdentityHashBag clone = (IdentityHashBag)this.clone();
            Iterator stream = b.iterator();
            while (stream.hasNext()) {
                if (clone.remove(stream.next())) continue;
                return false;
            }
            return clone.isEmpty();
        }
        if (o instanceof Bag) {
            return new HashBag(this).equals(o);
        }
        return false;
    }

    public int hashCode() {
        int h = 0;
        Iterator stream = this.iterator();
        while (stream.hasNext()) {
            h += System.identityHashCode(stream.next());
        }
        return h;
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.table.length);
        s.writeInt(this.uniqueCount);
        for (int i = this.table.length - 1; i >= 0; --i) {
            Entry entry = this.table[i];
            while (entry != null) {
                s.writeObject(entry.object);
                s.writeInt(entry.count);
                entry = entry.next;
            }
        }
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int numBuckets = s.readInt();
        this.table = new Entry[numBuckets];
        int unique = s.readInt();
        for (int i = 0; i < unique; ++i) {
            Object element = s.readObject();
            int elementCount = s.readInt();
            for (int j = 0; j < elementCount; ++j) {
                this.add(element);
            }
        }
    }

    private class HashIterator
    implements Iterator {
        Entry[] localTable;
        int index;
        Entry nextEntry;
        int nextEntryCount;
        Entry lastReturnedEntry;
        private int expectedModCount;

        HashIterator() {
            this.localTable = IdentityHashBag.this.table;
            this.index = this.localTable.length;
            this.nextEntry = null;
            this.nextEntryCount = 0;
            this.lastReturnedEntry = null;
            this.expectedModCount = IdentityHashBag.this.modCount;
        }

        public boolean hasNext() {
            Entry e = this.nextEntry;
            int i = this.index;
            Entry[] tab = this.localTable;
            while (e == null && i > 0) {
                e = tab[--i];
            }
            this.nextEntry = e;
            this.index = i;
            return e != null;
        }

        public Object next() {
            if (IdentityHashBag.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Entry et = this.nextEntry;
            int i = this.index;
            Entry[] tab = this.localTable;
            while (et == null && i > 0) {
                et = tab[--i];
            }
            this.nextEntry = et;
            this.index = i;
            if (et == null) {
                throw new NoSuchElementException();
            }
            Entry e = this.lastReturnedEntry = this.nextEntry;
            ++this.nextEntryCount;
            if (this.nextEntryCount == e.count) {
                this.nextEntry = e.next;
                this.nextEntryCount = 0;
            }
            return e.object;
        }

        public void remove() {
            if (this.lastReturnedEntry == null) {
                throw new IllegalStateException();
            }
            if (IdentityHashBag.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Entry[] tab = this.localTable;
            int slot = (this.lastReturnedEntry.hash & Integer.MAX_VALUE) % tab.length;
            Entry e = tab[slot];
            Entry prev = null;
            while (e != null) {
                if (e == this.lastReturnedEntry) {
                    ++IdentityHashBag.this.modCount;
                    ++this.expectedModCount;
                    --e.count;
                    if (e.count == 0) {
                        if (prev == null) {
                            tab[slot] = e.next;
                        } else {
                            prev.next = e.next;
                        }
                        --IdentityHashBag.this.uniqueCount;
                    } else {
                        --this.nextEntryCount;
                    }
                    --IdentityHashBag.this.count;
                    this.lastReturnedEntry = null;
                    return;
                }
                prev = e;
                e = e.next;
            }
            throw new ConcurrentModificationException();
        }
    }

    private static class EmptyIterator
    implements Iterator {
        private EmptyIterator() {
        }

        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new IllegalStateException();
        }
    }

    private static class Entry {
        int hash;
        Object object;
        int count;
        Entry next;

        Entry(int hash, Object object, Entry next) {
            this(hash, object, 1, next);
        }

        private Entry(int hash, Object object, int count, Entry next) {
            this.hash = hash;
            this.object = object;
            this.count = count;
            this.next = next;
        }

        protected Object clone() {
            return new Entry(this.hash, this.object, this.count, this.next == null ? null : (Entry)this.next.clone());
        }

        public String toString() {
            return this.object + "=>" + this.count;
        }
    }
}

