/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.classfile;

import java.io.IOException;
import org.eclipse.persistence.tools.workbench.utility.classfile.Attribute;
import org.eclipse.persistence.tools.workbench.utility.classfile.AttributePool;
import org.eclipse.persistence.tools.workbench.utility.classfile.LineNumber;
import org.eclipse.persistence.tools.workbench.utility.classfile.Visitor;
import org.eclipse.persistence.tools.workbench.utility.classfile.tools.ClassFileDataInputStream;
import org.eclipse.persistence.tools.workbench.utility.io.IndentingPrintWriter;

public class LineNumberTableAttribute
extends Attribute {
    private short count;
    private LineNumber[] lineNumbers;

    LineNumberTableAttribute(ClassFileDataInputStream stream, short nameIndex, AttributePool pool) throws IOException {
        super(stream, nameIndex, pool);
    }

    void initializeInfo(ClassFileDataInputStream stream) throws IOException {
        short cnt = this.count = stream.readU2();
        LineNumber[] numbers = this.lineNumbers = new LineNumber[cnt];
        for (short i = 0; i < cnt; i = (short)(i + 1)) {
            numbers[i] = new LineNumber(stream);
        }
    }

    public void displayNameOn(IndentingPrintWriter writer) {
        super.displayNameOn(writer);
        writer.print(" (count: ");
        writer.print(this.count);
        writer.print(")");
    }

    void displayInfoStringOn(IndentingPrintWriter writer) {
        short cnt = this.count;
        LineNumber[] numbers = this.lineNumbers;
        for (short i = 0; i < cnt; i = (short)(i + 1)) {
            writer.print(i);
            writer.print(": ");
            numbers[i].displayStringOn(writer);
        }
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
        short cnt = this.count;
        LineNumber[] numbers = this.lineNumbers;
        for (short i = 0; i < cnt; i = (short)(i + 1)) {
            numbers[i].accept(visitor);
        }
    }

    public short getCount() {
        return this.count;
    }

    public LineNumber[] getLineNumbers() {
        return this.lineNumbers;
    }

    public LineNumber getLineNumber(short index) {
        return this.lineNumbers[index];
    }

    void toString(StringBuffer sb) {
        sb.append(this.count);
        sb.append(" line number(s)");
    }
}

