/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.classfile.descriptor;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import org.eclipse.persistence.tools.workbench.utility.classfile.Visitor;
import org.eclipse.persistence.tools.workbench.utility.classfile.descriptor.FieldType;

public class ObjectType
extends FieldType {
    private String internalTypeName;
    private String typeName;

    ObjectType(Reader reader) throws IOException {
        this(ObjectType.extractInternalNameFrom(reader));
    }

    ObjectType(String internalName) {
        this.internalTypeName = internalName;
        this.typeName = this.internalTypeName.replace('/', '.');
    }

    private static String extractInternalNameFrom(Reader reader) throws IOException {
        StringBuffer sb = new StringBuffer(256);
        int c = reader.read();
        while (c != 59) {
            sb.append((char)c);
            c = reader.read();
        }
        return sb.toString();
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public int arrayDepth() {
        return 0;
    }

    public String elementTypeName() {
        return this.typeName;
    }

    public String javaName() {
        return this.typeName;
    }

    public Class javaClass() throws ClassNotFoundException {
        return Class.forName(this.typeName);
    }

    public void appendDeclarationTo(StringBuffer sb) {
        sb.append(this.typeName);
    }

    public void printDeclarationOn(PrintWriter writer) {
        writer.print(this.typeName);
    }

    public String internalName() {
        StringBuffer sb = new StringBuffer();
        this.appendInternalNameTo(sb);
        return sb.toString();
    }

    void appendArrayJavaNameTo(StringBuffer sb) {
        sb.append('L');
        sb.append(this.typeName);
        sb.append(';');
    }

    void appendArrayInternalNameTo(StringBuffer sb) {
        this.appendInternalNameTo(sb);
    }

    void appendInternalNameTo(StringBuffer sb) {
        sb.append('L');
        sb.append(this.internalTypeName);
        sb.append(';');
    }
}

