/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.classfile.tools;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.jar.JarFile;
import org.eclipse.persistence.tools.workbench.utility.Classpath;
import org.eclipse.persistence.tools.workbench.utility.classfile.ClassFile;

public class ClassFileIterator
implements Iterator {
    private File file;
    private JarFile jarFile;
    private boolean archive;
    private Iterator classNames;

    public ClassFileIterator(String classpathEntry) {
        this.file = new File(classpathEntry);
        this.archive = Classpath.fileNameIsArchive(classpathEntry);
        if (this.archive) {
            this.jarFile = this.buildJarFile();
        }
        this.classNames = this.buildClassNames(classpathEntry);
    }

    private JarFile buildJarFile() {
        try {
            return new JarFile(this.file);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected Iterator buildClassNames(String classpathEntry) {
        Classpath cp = new Classpath(new String[]{classpathEntry});
        return cp.classNamesStream();
    }

    public boolean hasNext() {
        return this.classNames.hasNext();
    }

    public Object next() {
        String className = (String)this.classNames.next();
        ClassFile classFile = null;
        try {
            classFile = this.archive ? this.buildClassFileFromArchive(className) : this.buildClassFileFromDirectory(className);
        }
        catch (IOException ex) {
            throw new RuntimeException(className, ex);
        }
        if (this.archive && !this.hasNext()) {
            this.closeJarFile();
        }
        return classFile;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    private ClassFile buildClassFileFromArchive(String className) throws IOException {
        return ClassFile.fromArchiveEntry(this.jarFile, className);
    }

    private ClassFile buildClassFileFromDirectory(String className) throws IOException {
        return ClassFile.fromClassFile(this.file, className);
    }

    private void closeJarFile() {
        try {
            this.jarFile.close();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }
}

