/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.iterators;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;

public class ArrayIterator
implements Iterator {
    Object[] array;
    int nextIndex;
    private int maxIndex;

    public ArrayIterator(Object[] array) {
        this(array, 0, array.length);
    }

    public ArrayIterator(Object[] array, int start, int length) {
        if (start < 0 || start > array.length) {
            throw new IllegalArgumentException("start: " + start);
        }
        if (length < 0 || length > array.length - start) {
            throw new IllegalArgumentException("length: " + length);
        }
        this.array = array;
        this.nextIndex = start;
        this.maxIndex = start + length;
    }

    public boolean hasNext() {
        return this.nextIndex < this.maxIndex;
    }

    public Object next() {
        if (this.hasNext()) {
            return this.array[this.nextIndex++];
        }
        throw new NoSuchElementException();
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return ClassTools.shortClassNameForObject(this) + '(' + CollectionTools.list(this.array) + ')';
    }
}

