/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.iterators;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;

public class ChainIterator
implements Iterator {
    private Object nextLink;
    private Linker linker;

    public ChainIterator(Object startLink) {
        this(startLink, Linker.NULL_INSTANCE);
    }

    public ChainIterator(Object startLink, Linker linker) {
        this.nextLink = startLink;
        this.linker = linker;
    }

    public boolean hasNext() {
        return this.nextLink != null;
    }

    public Object next() {
        if (this.nextLink == null) {
            throw new NoSuchElementException();
        }
        Object result = this.nextLink;
        this.nextLink = this.nextLink(this.nextLink);
        return result;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    protected Object nextLink(Object currentLink) {
        return this.linker.nextLink(currentLink);
    }

    public String toString() {
        return ClassTools.shortClassNameForObject(this) + '(' + this.nextLink + ')';
    }

    public static interface Linker {
        public static final Linker NULL_INSTANCE = new Linker(){

            public Object nextLink(Object currentLink) {
                return null;
            }
        };

        public Object nextLink(Object var1);
    }
}

