/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.app;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.prefs.Preferences;
import javax.swing.Icon;
import org.eclipse.persistence.tools.workbench.framework.NodeManager;
import org.eclipse.persistence.tools.workbench.framework.Plugin;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationProblem;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationProblemContainer;
import org.eclipse.persistence.tools.workbench.framework.app.CompositeIconBuilder;
import org.eclipse.persistence.tools.workbench.framework.app.DefaultApplicationProblem;
import org.eclipse.persistence.tools.workbench.framework.app.IconBuilder;
import org.eclipse.persistence.tools.workbench.framework.app.NavigatorSelectionModel;
import org.eclipse.persistence.tools.workbench.framework.app.SimpleIconBuilder;
import org.eclipse.persistence.tools.workbench.framework.context.ApplicationContext;
import org.eclipse.persistence.tools.workbench.framework.context.ApplicationContextWorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.context.ShellWorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.internal.FrameworkIconResourceFileNameMap;
import org.eclipse.persistence.tools.workbench.framework.resources.DefaultIconRepository;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.uitools.app.AbstractTreeNodeValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.NullListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.TreeNodeValueModel;
import org.eclipse.persistence.tools.workbench.uitools.swing.EmptyIcon;
import org.eclipse.persistence.tools.workbench.utility.Model;
import org.eclipse.persistence.tools.workbench.utility.events.ListChangeEvent;
import org.eclipse.persistence.tools.workbench.utility.events.ListChangeListener;
import org.eclipse.persistence.tools.workbench.utility.io.IndentingPrintWriter;
import org.eclipse.persistence.tools.workbench.utility.node.Node;
import org.eclipse.persistence.tools.workbench.utility.node.NodeModel;
import org.eclipse.persistence.tools.workbench.utility.node.Problem;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public abstract class AbstractApplicationNode
extends AbstractTreeNodeValueModel
implements ApplicationNode {
    private NodeModel value;
    private TreeNodeValueModel parent;
    private Plugin plugin;
    private ApplicationContext context;
    private String displayString;
    private PropertyChangeListener valueDisplayStringListener;
    protected static final String[] DEFAULT_DISPLAY_STRING_PROPERTY_NAMES = new String[0];
    private IconBuilder iconBuilder;
    private Icon icon;
    private PropertyChangeListener valueIconListener;
    protected static final String[] DEFAULT_ICON_PROPERTY_NAMES = new String[]{"hasBranchProblems"};
    private boolean dirty;
    private PropertyChangeListener valueDirtyListener;
    protected static final String[] DEFAULT_DIRTY_PROPERTY_NAMES = new String[]{"dirtyBranch"};
    private List applicationProblems;
    private List branchApplicationProblems;
    private ListChangeListener valueBranchProblemsListener;
    protected static final String[] DEFAULT_BRANCH_PROBLEMS_LIST_NAMES = new String[]{"branchProblems"};
    private String propertiesPageTitleText;
    private PropertyChangeListener valuePropertiesPageTitleTextListener;
    private IconBuilder propertiesPageTitleIconBuilder;
    private Icon propertiesPageTitleIcon;
    private PropertyChangeListener valuePropertiesPageTitleIconListener;
    private static final Icon PROBLEM_ICON = new DefaultIconRepository(new FrameworkIconResourceFileNameMap()).getIcon("problem.small");
    protected static final Icon EMPTY_ICON = new EmptyIcon(16);

    protected AbstractApplicationNode(ApplicationContext context) {
        this(null, null, null, context);
    }

    protected AbstractApplicationNode(NodeModel value, TreeNodeValueModel parent, Plugin plugin, ApplicationContext context) {
        this.value = value;
        this.context = this.expandContext(context);
        this.plugin = plugin;
        this.parent = parent;
        this.valueDisplayStringListener = this.buildValueDisplayStringListener();
        this.valueIconListener = this.buildValueIconListener();
        this.valueDirtyListener = this.buildValueDirtyListener();
        this.valueBranchProblemsListener = this.buildValueBranchProblemsListener();
        this.applicationProblems = new ArrayList();
        this.branchApplicationProblems = new ArrayList();
        this.valuePropertiesPageTitleTextListener = this.buildValuePropertiesPageTitleTextListener();
        this.valuePropertiesPageTitleIconListener = this.buildValuePropertiesPageTitleIconListener();
    }

    protected ApplicationContext expandContext(ApplicationContext ctx) {
        return ctx;
    }

    protected WorkbenchContext buildLocalWorkbenchContext(WorkbenchContext workbenchContext) {
        return new ApplicationContextWorkbenchContext(workbenchContext, this.getApplicationContext());
    }

    protected WorkbenchContext buildShellWorkbenchContext() {
        return new ShellWorkbenchContext(this.getApplicationContext());
    }

    private PropertyChangeListener buildValueDisplayStringListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                AbstractApplicationNode.this.displayStringChanged();
            }

            public String toString() {
                return StringTools.buildToStringFor((Object)this, (Object)"display string listener");
            }
        };
    }

    private PropertyChangeListener buildValueIconListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                AbstractApplicationNode.this.iconChanged();
            }

            public String toString() {
                return StringTools.buildToStringFor((Object)this, (Object)"icon listener");
            }
        };
    }

    private PropertyChangeListener buildValueDirtyListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                AbstractApplicationNode.this.dirtyChanged();
            }

            public String toString() {
                return StringTools.buildToStringFor((Object)this, (Object)"dirty listener");
            }
        };
    }

    private ListChangeListener buildValueBranchProblemsListener() {
        return new ListChangeListener(){

            public void itemsAdded(ListChangeEvent e) {
                AbstractApplicationNode.this.branchProblemsChanged();
            }

            public void itemsRemoved(ListChangeEvent e) {
                AbstractApplicationNode.this.branchProblemsChanged();
            }

            public void itemsReplaced(ListChangeEvent e) {
                AbstractApplicationNode.this.branchProblemsChanged();
            }

            public void listChanged(ListChangeEvent e) {
                AbstractApplicationNode.this.branchProblemsChanged();
            }

            public String toString() {
                return StringTools.buildToStringFor((Object)this, (Object)"branch problems listener");
            }
        };
    }

    private PropertyChangeListener buildValuePropertiesPageTitleTextListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                AbstractApplicationNode.this.propertiesPageTitleTextChanged();
            }

            public String toString() {
                return StringTools.buildToStringFor((Object)this, (Object)"properties page title text listener");
            }
        };
    }

    private PropertyChangeListener buildValuePropertiesPageTitleIconListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                AbstractApplicationNode.this.propertiesPageTitleIconChanged();
            }

            public String toString() {
                return StringTools.buildToStringFor((Object)this, (Object)"properties page title icon listener");
            }
        };
    }

    protected void engageValue() {
        this.engageValueProperties();
        this.engageValueLists();
    }

    protected void engageValueProperties() {
        if (this.hasNoPropertyChangeListeners("displayString")) {
            this.engageValueDisplayString();
        }
        if (this.hasNoPropertyChangeListeners("icon")) {
            this.engageValueIcon();
        }
        if (this.hasNoPropertyChangeListeners("dirty")) {
            this.engageValueDirty();
        }
        if (this.hasNoPropertyChangeListeners("propertiesPageTitleText")) {
            this.engageValuePropertiesPageTitleText();
        }
        if (this.hasNoPropertyChangeListeners("propertiesPageTitleIcon")) {
            this.engageValuePropertiesPageTitleIcon();
        }
    }

    protected void engageValueLists() {
        if (this.hasNoListChangeListeners("applicationProblems") && this.hasNoListChangeListeners("branchApplicationProblems")) {
            this.engageValueBranchProblems();
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.hasNoStateChangeListeners()) {
            this.engageValueProperties();
        }
        super.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (this.hasNoStateChangeListeners()) {
            if (this.hasNoPCLs(propertyName, "displayString")) {
                this.engageValueDisplayString();
            }
            if (this.hasNoPCLs(propertyName, "icon")) {
                this.engageValueIcon();
            }
            if (this.hasNoPCLs(propertyName, "dirty")) {
                this.engageValueDirty();
            }
            if (this.hasNoPCLs(propertyName, "propertiesPageTitleText")) {
                this.engageValuePropertiesPageTitleText();
            }
            if (this.hasNoPCLs(propertyName, "propertiesPageTitleIcon")) {
                this.engageValuePropertiesPageTitleIcon();
            }
        }
        super.addPropertyChangeListener(propertyName, listener);
    }

    protected boolean hasNoPCLs(String listenerPropertyName, String propertyName) {
        return listenerPropertyName == propertyName && this.hasNoPropertyChangeListeners(propertyName);
    }

    public void addListChangeListener(ListChangeListener listener) {
        if (this.hasNoStateChangeListeners()) {
            this.engageValueLists();
        }
        super.addListChangeListener(listener);
    }

    public void addListChangeListener(String listName, ListChangeListener listener) {
        if (this.hasNoStateChangeListeners() && this.hasNoProblemListeners(listName)) {
            this.engageValueBranchProblems();
        }
        super.addListChangeListener(listName, listener);
    }

    private boolean hasNoProblemListeners(String propertyName) {
        if (propertyName == "applicationProblems" || propertyName == "branchApplicationProblems") {
            return this.hasNoListChangeListeners("applicationProblems") && this.hasNoListChangeListeners("branchApplicationProblems");
        }
        return false;
    }

    protected void engageValue(String[] propertyNames, PropertyChangeListener listener) {
        this.engage((Model)this.value, propertyNames, listener);
    }

    protected void engage(Model model, String[] propertyNames, PropertyChangeListener listener) {
        int i = propertyNames.length;
        while (i-- > 0) {
            model.addPropertyChangeListener(propertyNames[i], listener);
        }
    }

    protected void engageValueDisplayString() {
        this.engageValue(this.displayStringPropertyNames(), this.valueDisplayStringListener);
        this.rebuildDisplayString();
    }

    protected String[] displayStringPropertyNames() {
        return DEFAULT_DISPLAY_STRING_PROPERTY_NAMES;
    }

    protected void engageValueIcon() {
        this.engageValue(this.iconPropertyNames(), this.valueIconListener);
        this.rebuildIconBuilder();
        this.rebuildIcon();
    }

    protected String[] iconPropertyNames() {
        return DEFAULT_ICON_PROPERTY_NAMES;
    }

    protected void engageValueDirty() {
        this.engageValue(this.dirtyPropertyNames(), this.valueDirtyListener);
        this.rebuildDirtyFlag();
    }

    protected String[] dirtyPropertyNames() {
        return DEFAULT_DIRTY_PROPERTY_NAMES;
    }

    protected void engageValuePropertiesPageTitleText() {
        this.engageValue(this.propertiesPageTitleTextPropertyNames(), this.valuePropertiesPageTitleTextListener);
        this.rebuildPropertiesPageTitleText();
    }

    protected String[] propertiesPageTitleTextPropertyNames() {
        return this.displayStringPropertyNames();
    }

    protected void engageValuePropertiesPageTitleIcon() {
        this.engageValue(this.propertiesPageTitleIconPropertyNames(), this.valuePropertiesPageTitleIconListener);
        this.rebuildPropertiesPageTitleIconBuilder();
        this.rebuildPropertiesPageTitleIcon();
    }

    protected String[] propertiesPageTitleIconPropertyNames() {
        return this.iconPropertyNames();
    }

    protected void engageValue(String[] listNames, ListChangeListener listener) {
        this.engage((Model)this.value, listNames, listener);
    }

    protected void engage(Model model, String[] listNames, ListChangeListener listener) {
        int i = listNames.length;
        while (i-- > 0) {
            model.addListChangeListener(listNames[i], listener);
        }
    }

    protected String[] branchProblemsListNames() {
        return DEFAULT_BRANCH_PROBLEMS_LIST_NAMES;
    }

    protected void engageValueBranchProblems() {
        this.engageValue(this.branchProblemsListNames(), this.valueBranchProblemsListener);
        this.rebuildApplicationProblems();
        this.rebuildBranchApplicationProblems();
    }

    protected void disengageValue() {
        this.disengageValueLists();
        this.disengageValueProperties();
    }

    protected void disengageValueLists() {
        if (this.hasNoListChangeListeners("applicationProblems") && this.hasNoListChangeListeners("branchApplicationProblems")) {
            this.disengageValueBranchProblems();
        }
    }

    protected void disengageValueProperties() {
        if (this.hasNoPropertyChangeListeners("propertiesPageTitleIcon")) {
            this.disengageValuePropertiesPageTitleIcon();
        }
        if (this.hasNoPropertyChangeListeners("propertiesPageTitleText")) {
            this.disengageValuePropertiesPageTitleText();
        }
        if (this.hasNoPropertyChangeListeners("dirty")) {
            this.disengageValueDirty();
        }
        if (this.hasNoPropertyChangeListeners("icon")) {
            this.disengageValueIcon();
        }
        if (this.hasNoPropertyChangeListeners("displayString")) {
            this.disengageValueDisplayString();
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        super.removePropertyChangeListener(listener);
        if (this.hasNoStateChangeListeners()) {
            this.disengageValueProperties();
        }
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        super.removePropertyChangeListener(propertyName, listener);
        if (this.hasNoStateChangeListeners()) {
            if (this.hasNoPCLs(propertyName, "propertiesPageTitleIcon")) {
                this.disengageValuePropertiesPageTitleIcon();
            }
            if (this.hasNoPCLs(propertyName, "propertiesPageTitleText")) {
                this.disengageValuePropertiesPageTitleText();
            }
            if (this.hasNoPCLs(propertyName, "dirty")) {
                this.disengageValueDirty();
            }
            if (this.hasNoPCLs(propertyName, "icon")) {
                this.disengageValueIcon();
            }
            if (this.hasNoPCLs(propertyName, "displayString")) {
                this.disengageValueDisplayString();
            }
        }
    }

    public void removeListChangeListener(ListChangeListener listener) {
        super.removeListChangeListener(listener);
        if (this.hasNoStateChangeListeners()) {
            this.disengageValueLists();
        }
    }

    public void removeListChangeListener(String listName, ListChangeListener listener) {
        super.removeListChangeListener(listName, listener);
        if (this.hasNoStateChangeListeners() && this.hasNoProblemListeners(listName)) {
            this.disengageValueBranchProblems();
        }
    }

    protected void disengageValue(String[] propertyNames, PropertyChangeListener listener) {
        this.disengage((Model)this.value, propertyNames, listener);
    }

    protected void disengage(Model model, String[] propertyNames, PropertyChangeListener listener) {
        int i = propertyNames.length;
        while (i-- > 0) {
            model.removePropertyChangeListener(propertyNames[i], listener);
        }
    }

    protected void disengageValue(String[] listNames, ListChangeListener listener) {
        this.disengage((Model)this.value, listNames, listener);
    }

    protected void disengage(Model model, String[] listNames, ListChangeListener listener) {
        int i = listNames.length;
        while (i-- > 0) {
            model.removeListChangeListener(listNames[i], listener);
        }
    }

    protected void disengageValueBranchProblems() {
        this.disengageValue(this.branchProblemsListNames(), this.valueBranchProblemsListener);
        this.applicationProblems.clear();
        this.branchApplicationProblems.clear();
    }

    protected void disengageValuePropertiesPageTitleIcon() {
        this.disengageValue(this.propertiesPageTitleIconPropertyNames(), this.valuePropertiesPageTitleIconListener);
        this.propertiesPageTitleIconBuilder = null;
        this.propertiesPageTitleIcon = null;
    }

    protected void disengageValuePropertiesPageTitleText() {
        this.disengageValue(this.propertiesPageTitleTextPropertyNames(), this.valuePropertiesPageTitleTextListener);
        this.propertiesPageTitleText = null;
    }

    protected void disengageValueDirty() {
        this.disengageValue(this.dirtyPropertyNames(), this.valueDirtyListener);
        this.dirty = false;
    }

    protected void disengageValueIcon() {
        this.disengageValue(this.iconPropertyNames(), this.valueIconListener);
        this.iconBuilder = null;
        this.icon = null;
    }

    protected void disengageValueDisplayString() {
        this.disengageValue(this.displayStringPropertyNames(), this.valueDisplayStringListener);
        this.displayString = null;
    }

    protected PropertyChangeListener getValueDisplayStringListener() {
        return this.valueDisplayStringListener;
    }

    protected PropertyChangeListener getValueIconListener() {
        return this.valueIconListener;
    }

    protected PropertyChangeListener getValueDirtyListener() {
        return this.valueDirtyListener;
    }

    protected ListChangeListener getValueBranchProblemsListener() {
        return this.valueBranchProblemsListener;
    }

    protected PropertyChangeListener getValuePropertiesPageTitleTextListener() {
        return this.valuePropertiesPageTitleTextListener;
    }

    protected PropertyChangeListener getValuePropertiesPageTitleIconListener() {
        return this.valuePropertiesPageTitleIconListener;
    }

    protected final void rebuildDisplayString() {
        this.displayString = this.buildDisplayString();
    }

    protected String buildDisplayString() {
        return this.value.displayString();
    }

    protected final void rebuildIconBuilder() {
        this.iconBuilder = this.buildIconBuilder();
    }

    protected IconBuilder buildIconBuilder() {
        return new CompositeIconBuilder(this.buildBaseIconBuilder(), this.valueHasBranchProblems(), PROBLEM_ICON, -21, 0, 3, null);
    }

    protected IconBuilder buildBaseIconBuilder() {
        return new SimpleIconBuilder(this.resourceRepository().getIcon(this.buildIconKey()));
    }

    protected String buildIconKey() {
        return null;
    }

    protected final void rebuildIcon() {
        this.icon = this.buildIcon();
    }

    protected final Icon buildIcon() {
        return this.iconBuilder.buildIcon();
    }

    protected final void rebuildDirtyFlag() {
        this.dirty = this.buildDirtyFlag();
    }

    protected boolean buildDirtyFlag() {
        return this.value.isDirtyBranch();
    }

    protected final void rebuildPropertiesPageTitleText() {
        this.propertiesPageTitleText = this.buildPropertiesPageTitleText();
    }

    protected String buildPropertiesPageTitleText() {
        return this.buildDisplayString();
    }

    protected final void rebuildPropertiesPageTitleIconBuilder() {
        this.propertiesPageTitleIconBuilder = this.buildPropertiesPageTitleIconBuilder();
    }

    protected IconBuilder buildPropertiesPageTitleIconBuilder() {
        return this.buildIconBuilder();
    }

    protected final void rebuildPropertiesPageTitleIcon() {
        this.propertiesPageTitleIcon = this.buildPropertiesPageTitleIcon();
    }

    protected final Icon buildPropertiesPageTitleIcon() {
        return this.propertiesPageTitleIconBuilder.buildIcon();
    }

    protected final void rebuildApplicationProblems() {
        this.applicationProblems.clear();
        this.addExclusiveApplicationProblemsTo(this.applicationProblems);
    }

    protected void addExclusiveApplicationProblemsTo(List list) {
        ListIterator stream = this.value.branchProblems();
        while (stream.hasNext()) {
            Problem problem = (Problem)stream.next();
            if (!this.ownsExclusively(problem)) continue;
            list.add(this.buildApplicationProblem(problem));
        }
    }

    private boolean ownsExclusively(Problem problem) {
        return this.value.containsBranchProblem(problem) && !this.childrenContain(problem);
    }

    private boolean childrenContain(Problem problem) {
        Iterator stream = this.children();
        while (stream.hasNext()) {
            if (!((ApplicationProblemContainer)stream.next()).containsBranchApplicationProblemFor(problem)) continue;
            return true;
        }
        return false;
    }

    ApplicationProblem buildApplicationProblem(Problem problem) {
        return new DefaultApplicationProblem(this, problem.getMessageKey(), this.resourceRepository().getString(problem.getMessageKey(), problem.getMessageArguments()));
    }

    protected final void rebuildBranchApplicationProblems() {
        this.branchApplicationProblems.clear();
        this.addBranchApplicationProblemsTo(this.branchApplicationProblems);
    }

    public Iterator children() {
        return (Iterator)this.getChildrenModel().getValue();
    }

    protected boolean valueHasBranchProblems() {
        return this.value.hasBranchProblems();
    }

    public NodeManager nodeManager() {
        return this.getApplicationContext().getNodeManager();
    }

    protected ResourceRepository resourceRepository() {
        return this.getApplicationContext().getResourceRepository();
    }

    protected Preferences preferences() {
        return this.getApplicationContext().getPreferences();
    }

    public void selectDescendantNodeForValue(Node node, NavigatorSelectionModel nsm) {
        nsm.setSelectedNode(this.descendantNodeForValue(node));
    }

    protected void displayStringChanged() {
        String old = this.displayString;
        this.rebuildDisplayString();
        this.firePropertyChanged("displayString", old, this.displayString);
        if (this.attributeValueHasChanged(old, this.displayString)) {
            this.fireStateChanged();
        }
    }

    protected void iconChanged() {
        IconBuilder oldBuilder = this.iconBuilder;
        this.rebuildIconBuilder();
        if (!((Object)this.iconBuilder).equals(oldBuilder)) {
            Icon oldIcon = this.icon;
            this.rebuildIcon();
            this.firePropertyChanged("icon", oldIcon, this.icon);
            this.fireStateChanged();
        }
    }

    protected void dirtyChanged() {
        boolean old = this.dirty;
        this.rebuildDirtyFlag();
        this.firePropertyChanged("dirty", old, this.dirty);
        if (this.dirty != old) {
            this.fireStateChanged();
        }
    }

    protected void propertiesPageTitleTextChanged() {
        String old = this.propertiesPageTitleText;
        this.rebuildPropertiesPageTitleText();
        this.firePropertyChanged("propertiesPageTitleText", old, this.propertiesPageTitleText);
        if (this.attributeValueHasChanged(old, this.propertiesPageTitleText)) {
            this.fireStateChanged();
        }
    }

    protected void propertiesPageTitleIconChanged() {
        IconBuilder oldBuilder = this.propertiesPageTitleIconBuilder;
        this.rebuildPropertiesPageTitleIconBuilder();
        if (!((Object)this.propertiesPageTitleIconBuilder).equals(oldBuilder)) {
            Icon oldIcon = this.propertiesPageTitleIcon;
            this.rebuildPropertiesPageTitleIcon();
            this.firePropertyChanged("propertiesPageTitleIcon", oldIcon, this.propertiesPageTitleIcon);
            this.fireStateChanged();
        }
    }

    protected void branchProblemsChanged() {
        this.rebuildApplicationProblems();
        this.fireListChanged("applicationProblems");
        this.rebuildBranchApplicationProblems();
        this.fireListChanged("branchApplicationProblems");
    }

    public Object getValue() {
        return this.value;
    }

    public TreeNodeValueModel getParent() {
        return this.parent;
    }

    public ListValueModel getChildrenModel() {
        return NullListValueModel.instance();
    }

    public ApplicationContext getApplicationContext() {
        return this.context;
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public ApplicationNode getProjectRoot() {
        if (this.getParent() == this.nodeManager().getRootNode()) {
            return this;
        }
        return ((ApplicationNode)this.getParent()).getProjectRoot();
    }

    public final boolean isDirty() {
        return this.dirty;
    }

    public String helpTopicID() {
        return "default";
    }

    public boolean save(File mostRecentSaveDirectory, WorkbenchContext workbenchContext) {
        return this.getProjectRoot().save(mostRecentSaveDirectory, workbenchContext);
    }

    public boolean saveAs(File mostRecentSaveDirectory, WorkbenchContext workbenchContext) {
        return this.getProjectRoot().saveAs(mostRecentSaveDirectory, workbenchContext);
    }

    public File saveFile() {
        return this.getProjectRoot().saveFile();
    }

    public void addValuePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.value.addPropertyChangeListener(propertyName, listener);
    }

    public void removeValuePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.value.removePropertyChangeListener(propertyName, listener);
    }

    public final ApplicationNode descendantNodeForValue(Node node) {
        if (this.value == node) {
            return this;
        }
        Iterator stream = this.children();
        while (stream.hasNext()) {
            ApplicationNode appNode = ((ApplicationNode)stream.next()).descendantNodeForValue(node);
            if (appNode == null) continue;
            return appNode;
        }
        return null;
    }

    public final ListIterator applicationProblems() {
        return this.applicationProblems.listIterator();
    }

    public final int applicationProblemsSize() {
        return this.applicationProblems.size();
    }

    public final void addApplicationProblemsTo(List list) {
        list.addAll(this.applicationProblems);
    }

    public final ListIterator branchApplicationProblems() {
        return this.branchApplicationProblems.listIterator();
    }

    public final int branchApplicationProblemsSize() {
        return this.branchApplicationProblems.size();
    }

    public void addBranchApplicationProblemsTo(List list) {
        this.addApplicationProblemsTo(list);
        Iterator stream = this.children();
        while (stream.hasNext()) {
            ((ApplicationProblemContainer)stream.next()).addBranchApplicationProblemsTo(list);
        }
    }

    public boolean containsBranchApplicationProblemFor(Problem problem) {
        return this.value.containsBranchProblem(problem);
    }

    public void printBranchApplicationProblemsOn(IndentingPrintWriter writer) {
        if (this.branchApplicationProblems.size() == 0) {
            return;
        }
        this.printBranchApplicationProblemsHeaderOn(writer);
        writer.println();
        writer.indent();
        Iterator stream = this.applicationProblems();
        while (stream.hasNext()) {
            ((ApplicationProblem)stream.next()).printOn(writer);
            writer.println();
        }
        stream = this.children();
        while (stream.hasNext()) {
            ((ApplicationProblemContainer)stream.next()).printBranchApplicationProblemsOn(writer);
        }
        writer.undent();
    }

    protected void printBranchApplicationProblemsHeaderOn(IndentingPrintWriter writer) {
        writer.print(this.displayString());
    }

    public final String propertiesPageTitleText() {
        return this.propertiesPageTitleText;
    }

    public final Icon propertiesPageTitleIcon() {
        return this.propertiesPageTitleIcon;
    }

    public final String displayString() {
        return this.displayString;
    }

    public final Icon icon() {
        return this.icon;
    }

    public int compareTo(Object o) {
        return DEFAULT_COMPARATOR.compare(this, o);
    }

    public String accessibleName() {
        return this.resourceRepository().getString(this.accessibleNameKey(), this.displayString());
    }

    protected String accessibleNameKey() {
        return "ACCESSIBLE_NODE";
    }
}

