/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.app;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.eclipse.persistence.tools.workbench.framework.app.ActionContainer;
import org.eclipse.persistence.tools.workbench.framework.app.ComponentGroupDescription;
import org.eclipse.persistence.tools.workbench.framework.app.GroupContainerDescription;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.CompositeIterator;

public class RootMenuDescription
implements GroupContainerDescription {
    private List buttonGroups = new ArrayList();

    public void add(ComponentGroupDescription menuGroup) {
        this.buttonGroups.add(menuGroup);
    }

    public void remove(ComponentGroupDescription menuGroup) {
        this.buttonGroups.remove(menuGroup);
    }

    public boolean hasComponents() {
        return this.buttonGroups.size() > 0;
    }

    public Component component() {
        JMenu menu = new JMenu();
        ListIterator items = this.components();
        while (items.hasNext()) {
            menu.add((Component)items.next());
        }
        return menu;
    }

    public Iterator actions() {
        ArrayList<Iterator> actionIterators = new ArrayList<Iterator>();
        for (ComponentGroupDescription menuGroup : this.buttonGroups) {
            actionIterators.add(menuGroup.actions());
        }
        return new CompositeIterator(actionIterators);
    }

    public void updateOn(Collection frameworkActions) {
        for (ComponentGroupDescription groupWrapper : this.buttonGroups) {
            groupWrapper.updateOn(frameworkActions);
        }
        this.removeEmptyGroups();
    }

    public void mergeWith(ActionContainer menuDescription) {
        this.updateOn(CollectionTools.collection((Iterator)menuDescription.actions()));
    }

    private void removeEmptyGroups() {
        for (ComponentGroupDescription groupWrapper : new ArrayList(this.buttonGroups)) {
            if (groupWrapper.hasComponents()) continue;
            this.buttonGroups.remove(groupWrapper);
        }
    }

    public ListIterator components() {
        ArrayList<JComponent> listOfItems = new ArrayList<JComponent>();
        Iterator groups = this.buttonGroups.iterator();
        while (groups.hasNext()) {
            ComponentGroupDescription groupWrapper = (ComponentGroupDescription)groups.next();
            ListIterator menuItems = groupWrapper.components();
            while (menuItems.hasNext()) {
                JMenuItem menuItem = (JMenuItem)menuItems.next();
                listOfItems.add(menuItem);
            }
            if (!groups.hasNext()) continue;
            listOfItems.add(new JPopupMenu.Separator());
        }
        return listOfItems.listIterator();
    }
}

