/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.internal;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.text.NumberFormat;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.eclipse.persistence.tools.workbench.framework.action.AbstractFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;

final class JavaHeapInformationAction
extends AbstractFrameworkAction {
    private JLabel totalMemoryLabel;
    private JLabel freeMemoryLabel;
    private JLabel maxMemoryLabel;
    private static final int MB = 0x100000;

    JavaHeapInformationAction(WorkbenchContext context) {
        super(context);
    }

    protected void initialize() {
        super.initialize();
        this.initializeTextAndMnemonic("JAVA_HEAP_INFO");
    }

    protected void execute() {
        this.totalMemoryLabel = new JLabel();
        this.freeMemoryLabel = new JLabel();
        this.maxMemoryLabel = new JLabel();
        this.refreshLabels();
        JOptionPane.showMessageDialog(this.currentWindow(), this.buildPanel(), this.resourceRepository().getString("JAVA_HEAP_INFO"), 1);
    }

    private Object buildPanel() {
        JPanel panel = new JPanel(new GridLayout(0, 1));
        panel.add(this.totalMemoryLabel);
        panel.add(this.freeMemoryLabel);
        panel.add(this.maxMemoryLabel);
        panel.add(this.buildGCButton());
        return panel;
    }

    private void refreshLabels() {
        Runtime rt = Runtime.getRuntime();
        NumberFormat nf = NumberFormat.getInstance();
        this.totalMemoryLabel.setText("Current Heap Size: " + nf.format(rt.totalMemory() / 0x100000L) + " MB");
        this.freeMemoryLabel.setText("Available Heap Space: " + nf.format(rt.freeMemory() / 0x100000L) + " MB");
        this.maxMemoryLabel.setText("Max Heap Size: " + nf.format(rt.maxMemory() / 0x100000L) + " MB");
    }

    private JButton buildGCButton() {
        return new JButton(this.buildGCAction());
    }

    private Action buildGCAction() {
        AbstractAction action = new AbstractAction("Collect Garbage"){

            public void actionPerformed(ActionEvent event) {
                JavaHeapInformationAction.this.gc();
            }
        };
        action.setEnabled(true);
        return action;
    }

    void gc() {
        System.gc();
        this.refreshLabels();
    }
}

