/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.internal;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.eclipse.persistence.tools.workbench.framework.app.AbstractPreferencesNode;
import org.eclipse.persistence.tools.workbench.framework.app.PreferencesNode;
import org.eclipse.persistence.tools.workbench.uitools.cell.SimpleTreeCellRenderer;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;

final class PreferencesNavigatorView {
    private JTree tree;
    private AbstractPreferencesNode rootNode;
    private JPanel panel;

    public PreferencesNavigatorView(AbstractPreferencesNode root) {
        this.initialize(root);
    }

    private void initialize(AbstractPreferencesNode root) {
        this.rootNode = root;
        this.tree = this.buildTree(root);
        this.panel = this.buildPanel();
        this.expandAll(this.rootNode);
    }

    private void expandAll(TreeNode node) {
        this.tree.expandPath(this.buildPath(node));
        Enumeration<? extends TreeNode> enumeration = node.children();
        while (enumeration.hasMoreElements()) {
            TreeNode child = enumeration.nextElement();
            if (child.isLeaf()) continue;
            this.expandAll(child);
        }
    }

    private TreePath buildPath(TreeNode node) {
        Vector<TreeNode> paths = new Vector<TreeNode>();
        do {
            paths.add(0, node);
        } while ((node = node.getParent()) != null);
        return new TreePath(paths.toArray());
    }

    private JTree buildTree(PreferencesNode root) {
        JTree tree = new JTree(root);
        tree.setShowsRootHandles(true);
        tree.setRootVisible(false);
        tree.setCellRenderer(new PreferencesTreeCellRenderer());
        tree.getSelectionModel().setSelectionMode(1);
        tree.addKeyListener(this.buildF1KeyListener());
        tree.addMouseListener(this.buildMouseListener());
        return tree;
    }

    private MouseListener buildMouseListener() {
        return new LocalMouseListener(this.getRootNode().resourceRepository().getString("HELP_POPUP"));
    }

    private KeyListener buildF1KeyListener() {
        return new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                AbstractPreferencesNode node;
                if (e.getKeyCode() == 112 && (node = (AbstractPreferencesNode)PreferencesNavigatorView.this.getTree().getLastSelectedPathComponent()) != null) {
                    node.showHelp();
                }
            }
        };
    }

    private JPanel buildPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEtchedBorder());
        panel.setMinimumSize(new Dimension(0, 0));
        JScrollPane scrollPane = new JScrollPane(this.tree);
        scrollPane.getVerticalScrollBar().setUnitIncrement(10);
        scrollPane.getHorizontalScrollBar().setUnitIncrement(10);
        scrollPane.setBorder(null);
        panel.add((Component)scrollPane, "Center");
        return panel;
    }

    synchronized void addTreeSelectionListener(TreeSelectionListener listener) {
        this.tree.addTreeSelectionListener(listener);
    }

    synchronized void removeTreeSelectionListener(TreeSelectionListener listener) {
        this.tree.removeTreeSelectionListener(listener);
    }

    Component getComponent() {
        return this.panel;
    }

    Component initialFocusComponent() {
        return this.tree;
    }

    JTree getTree() {
        return this.tree;
    }

    AbstractPreferencesNode getRootNode() {
        return this.rootNode;
    }

    void selectFirstChild() {
        this.tree.setSelectionPath(this.buildPath(this.rootNode.getChildAt(0)));
    }

    private class LocalMouseListener
    extends MouseAdapter {
        PopupMenu popupMenu;
        int x;
        int y;

        LocalMouseListener(String menuItemLabel) {
            this.initialize(menuItemLabel);
        }

        private void initialize(String menuItemLabel) {
            MenuItem item = new MenuItem(menuItemLabel);
            item.addActionListener(this.buildMenuItemListener());
            this.popupMenu = new PopupMenu();
            this.popupMenu.add(item);
        }

        private ActionListener buildMenuItemListener() {
            return new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    LocalMouseListener.this.showHelp();
                    LocalMouseListener.this.popupMenu.getParent().remove(LocalMouseListener.this.popupMenu);
                }
            };
        }

        public void mousePressed(MouseEvent e) {
            this.handleMouseEvent(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.handleMouseEvent(e);
        }

        private void handleMouseEvent(MouseEvent e) {
            if (!e.isPopupTrigger()) {
                return;
            }
            PreferencesNavigatorView.this.getTree().add(this.popupMenu);
            this.x = e.getX();
            this.y = e.getY();
            this.popupMenu.show(PreferencesNavigatorView.this.getTree(), e.getX(), e.getY());
        }

        void showHelp() {
            int row = PreferencesNavigatorView.this.getTree().getRowForLocation(this.x, this.y);
            if (row != -1) {
                AbstractPreferencesNode node;
                TreePath path = PreferencesNavigatorView.this.tree.getPathForRow(row);
                Object[] selectedPaths = PreferencesNavigatorView.this.tree.getSelectionPaths();
                if (selectedPaths == null || !CollectionTools.contains((Object[])selectedPaths, (Object)path)) {
                    PreferencesNavigatorView.this.tree.setSelectionPath(path);
                }
                if ((node = (AbstractPreferencesNode)PreferencesNavigatorView.this.getTree().getLastSelectedPathComponent()) != null) {
                    node.showHelp();
                }
            }
        }
    }

    private static class NodeRenderer
    extends SimpleTreeCellRenderer {
        private static final Border BORDER = BorderFactory.createEmptyBorder(0, 2, 0, 0);

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            this.setBorder(BORDER);
            return super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        }

        protected Icon buildIcon(Object value) {
            return null;
        }

        protected String buildText(Object value) {
            return ((PreferencesNode)value).displayString();
        }
    }

    private static class PreferencesTreeCellRenderer
    implements TreeCellRenderer {
        private PreferencesTreeCellRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            NodeRenderer renderer = new NodeRenderer();
            return renderer.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        }
    }
}

