/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.internal;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.border.MatteBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import org.eclipse.persistence.tools.workbench.framework.Plugin;
import org.eclipse.persistence.tools.workbench.framework.action.AbstractFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.action.ActionRepository;
import org.eclipse.persistence.tools.workbench.framework.action.FrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.app.ComponentContainerDescription;
import org.eclipse.persistence.tools.workbench.framework.app.GroupContainerDescription;
import org.eclipse.persistence.tools.workbench.framework.app.NavigatorSelectionModel;
import org.eclipse.persistence.tools.workbench.framework.app.RootMenuDescription;
import org.eclipse.persistence.tools.workbench.framework.context.AbstractWorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.context.ApplicationContext;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.help.HelpFacade;
import org.eclipse.persistence.tools.workbench.framework.internal.AboutAction;
import org.eclipse.persistence.tools.workbench.framework.internal.DevelopmentConsoleAction;
import org.eclipse.persistence.tools.workbench.framework.internal.ExamplesAction;
import org.eclipse.persistence.tools.workbench.framework.internal.FrameworkActionRepository;
import org.eclipse.persistence.tools.workbench.framework.internal.FrameworkApplication;
import org.eclipse.persistence.tools.workbench.framework.internal.FrameworkNodeManager;
import org.eclipse.persistence.tools.workbench.framework.internal.GoToAction;
import org.eclipse.persistence.tools.workbench.framework.internal.HelpAction;
import org.eclipse.persistence.tools.workbench.framework.internal.HomeAction;
import org.eclipse.persistence.tools.workbench.framework.internal.JavaDocAction;
import org.eclipse.persistence.tools.workbench.framework.internal.JavaHeapInformationAction;
import org.eclipse.persistence.tools.workbench.framework.internal.NewWindowAction;
import org.eclipse.persistence.tools.workbench.framework.internal.OpenRecentFileAction;
import org.eclipse.persistence.tools.workbench.framework.internal.PreferencesAction;
import org.eclipse.persistence.tools.workbench.framework.internal.ShowProblemsAction;
import org.eclipse.persistence.tools.workbench.framework.internal.SynchronousProblemsAction;
import org.eclipse.persistence.tools.workbench.framework.internal.ThreadBrowserAction;
import org.eclipse.persistence.tools.workbench.framework.internal.UsersGuideAction;
import org.eclipse.persistence.tools.workbench.framework.internal.WorkbenchCloseAction;
import org.eclipse.persistence.tools.workbench.framework.internal.WorkbenchSaveAction;
import org.eclipse.persistence.tools.workbench.framework.internal.WorkbenchSaveAsAction;
import org.eclipse.persistence.tools.workbench.framework.internal.WorkspaceView;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.framework.uitools.DropDownButton;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.TreeNodeValueModel;
import org.eclipse.persistence.tools.workbench.uitools.swing.EmptyIcon;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.events.StateChangeEvent;
import org.eclipse.persistence.tools.workbench.utility.events.StateChangeListener;

final class WorkbenchWindow
extends JFrame {
    private FrameworkApplication application;
    private WorkbenchContext context;
    private WorkspaceView workspace;
    private JMenu fileMenu;
    private int recentFilesSize;
    private StateChangeListener recentFilesListener;
    private FrameworkActionRepository actionRepository;
    private ButtonModel showProblemsButtonModel;
    private ButtonModel synchronousProblemsButtonModel;
    private PropertyValueModel selectionMenuDescriptionHolder;
    private TreeSelectionListener treeSelectionListener;
    private JMenu workbenchMenu;
    private JMenu selectionMenu;
    private Map pluginToolBarActions;
    private JToolBar selectionToolBar;
    private Set selectionActions;
    private Set workbenchActions;
    private WindowListener windowListener;
    private static final Icon EMPTY_ICON = new EmptyIcon(16);

    WorkbenchWindow(FrameworkApplication application) {
        this.application = application;
        this.initialize();
    }

    WorkbenchWindow(FrameworkApplication application, WorkbenchWindow workbenchWindow) {
        this(application);
        this.copySettingsFrom(workbenchWindow);
    }

    private void initialize() {
        this.recentFilesSize = 0;
        this.recentFilesListener = this.buildRecentFilesListener();
        this.application.recentFilesManager().addStateChangeListener(this.recentFilesListener);
        this.context = new LocalWorkbenchContext();
        this.selectionMenuDescriptionHolder = new SimplePropertyValueModel();
        this.workspace = new WorkspaceView(this.context, this.selectionMenuDescriptionHolder);
        this.actionRepository = new FrameworkActionRepository(this);
        this.selectionActions = new HashSet();
        this.workbenchActions = new HashSet();
        this.setBounds(50, 50, 800, 725);
        this.setDefaultCloseOperation(0);
        this.initializeTitleBar();
        this.windowListener = new LocalWindowListener();
        this.addWindowListener(this.windowListener);
        this.getRootPane().setJMenuBar(this.buildMenuBar());
        this.getContentPane().add((Component)this.buildToolBarPanel(), "North");
        this.getContentPane().add(this.workspace.getComponent(), "Center");
        this.treeSelectionListener = this.buildTreeSelectionListener();
        this.getWorkspace().addNavigatorTreeSelectionListener(this.treeSelectionListener);
    }

    private void initializeTitleBar() {
        this.setTitle(this.application.getFullProductName());
        Icon icon = this.resourceRepository().getIcon("oracle.logo.large");
        if (icon instanceof ImageIcon) {
            this.setIconImage(((ImageIcon)icon).getImage());
        }
    }

    private void copySettingsFrom(WorkbenchWindow workbenchWindow) {
        this.setSize(workbenchWindow.getWidth(), workbenchWindow.getHeight());
        this.setExtendedState(workbenchWindow.getExtendedState());
        int titleBarHeight = workbenchWindow.getLocationOnScreen().y - workbenchWindow.getRootPane().getLocationOnScreen().y;
        int x = workbenchWindow.getLocationOnScreen().x - titleBarHeight;
        int y = workbenchWindow.getLocationOnScreen().y - titleBarHeight;
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension windowSize = this.getSize();
        if (x + windowSize.width > screenSize.width || y + windowSize.height > screenSize.height) {
            this.setLocation(0, 0);
        } else {
            this.setLocation(x, y);
        }
        this.workspace.copySettingsFrom(workbenchWindow.getWorkspace());
    }

    private JMenuBar buildMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        this.fileMenu = this.buildFileMenu();
        this.rebuildRecentFilesMenuItems();
        menuBar.add(this.fileMenu);
        this.workbenchMenu = this.buildWorkbenchMenu();
        menuBar.add(this.workbenchMenu);
        this.selectionMenu = this.buildSelectionMenu();
        menuBar.add(this.selectionMenu);
        menuBar.add(this.buildToolsMenu());
        menuBar.add(this.buildWindowMenu());
        menuBar.add(this.buildHelpMenu());
        return menuBar;
    }

    private JMenu buildFileMenu() {
        JMenu menu = new JMenu();
        menu.setText(this.resourceRepository().getString("FILE_MENU"));
        menu.setMnemonic(this.resourceRepository().getMnemonic("FILE_MENU"));
        menu.add(this.buildNewMenu());
        menu.add(new JMenuItem(this.actionRepository.getOpenAction()));
        menu.addSeparator();
        menu.add(new JMenuItem(new WorkbenchSaveAction(this.getContext(), this.nodeManager())));
        menu.add(new JMenuItem(new WorkbenchSaveAsAction(this.getContext(), this.nodeManager())));
        menu.add(new JMenuItem(this.actionRepository.getSaveAllAction()));
        menu.addSeparator();
        menu.add(new JMenuItem(new WorkbenchCloseAction(this.getContext(), this.nodeManager())));
        menu.add(new JMenuItem(this.actionRepository.getCloseAllAction()));
        menu.addSeparator();
        menu.addSeparator();
        menu.addSeparator();
        menu.add(new JMenuItem(this.actionRepository.getExitAction()));
        return menu;
    }

    private JMenu buildNewMenu() {
        JMenu menu = new JMenu();
        menu.setIcon(this.resourceRepository().getIcon("file"));
        menu.setText(this.resourceRepository().getString("file.new"));
        menu.setMnemonic(this.resourceRepository().getMnemonic("file.new"));
        menu.setToolTipText(this.resourceRepository().getString("file.new.toolTipText"));
        Plugin[] plugins = this.plugins();
        for (int i = 0; i < plugins.length; ++i) {
            JMenuItem[] menuItems = plugins[i].buildNewMenuItems(this.context);
            for (int j = 0; j < menuItems.length; ++j) {
                menu.add(menuItems[j]);
            }
        }
        return menu;
    }

    private JMenu buildMigrateMenu() {
        JMenu menu = new JMenu();
        menu.setIcon(EMPTY_ICON);
        menu.setText(this.resourceRepository().getString("file.migrate"));
        menu.setMnemonic(this.resourceRepository().getMnemonic("file.migrate"));
        menu.setToolTipText(this.resourceRepository().getString("file.migrate.toolTipText"));
        Plugin[] plugins = this.plugins();
        return menu;
    }

    private JMenu buildWorkbenchMenu() {
        JMenu menu = new JMenu();
        menu.setText(this.resourceRepository().getString("WORKBENCH_MENU"));
        menu.setMnemonic(this.resourceRepository().getMnemonic("WORKBENCH_MENU"));
        menu.setEnabled(false);
        return menu;
    }

    private JMenu buildSelectionMenu() {
        JMenu menu = new JMenu();
        menu.setText(this.resourceRepository().getString("SELECTED_MENU"));
        menu.setMnemonic(this.resourceRepository().getMnemonic("SELECTED_MENU"));
        menu.setEnabled(false);
        return menu;
    }

    private JMenu buildToolsMenu() {
        JMenu menu = new JMenu();
        menu.setText(this.resourceRepository().getString("TOOLS_MENU"));
        menu.setMnemonic(this.resourceRepository().getMnemonic("TOOLS_MENU"));
        menu.add(new GoToAction(this.getContext()));
        menu.add(this.workspace.problemReportAction());
        menu.add(new PreferencesAction(this.getContext(), this.application));
        if (this.application.isDevelopmentMode()) {
            menu.add(this.buildDevelopmentMenu());
        }
        return menu;
    }

    private JMenu buildDevelopmentMenu() {
        JMenu menu = new JMenu();
        menu.setIcon(EMPTY_ICON);
        menu.setText(this.resourceRepository().getString("DEV_MENU"));
        menu.setMnemonic(this.resourceRepository().getMnemonic("DEV_MENU"));
        menu.add(new DevelopmentConsoleAction(this.getContext(), this.application));
        menu.add(HelpFacade.buildHelpTopicIDWindowAction(this.getContext()));
        menu.add(new ThreadBrowserAction(this.getContext()));
        menu.add(new JavaHeapInformationAction(this.getContext()));
        menu.add(this.buildSynchronousProblemsMenuItem());
        return menu;
    }

    private JMenuItem buildSynchronousProblemsMenuItem() {
        JCheckBoxMenuItem item = new JCheckBoxMenuItem(new SynchronousProblemsAction(this));
        this.synchronousProblemsButtonModel = item.getModel();
        this.synchronousProblemsButtonModel.setSelected(this.application.getNodeManager().projectNodesAreAddedWithSynchronousValidators());
        return item;
    }

    private JMenu buildWindowMenu() {
        JMenu menu = new JMenu();
        menu.setText(this.resourceRepository().getString("WINDOW_MENU"));
        menu.setMnemonic(this.resourceRepository().getMnemonic("WINDOW_MENU"));
        menu.add(new NewWindowAction(this.getContext(), this.application));
        menu.add(this.buildShowProblemsMenuItem());
        return menu;
    }

    private JMenuItem buildShowProblemsMenuItem() {
        JCheckBoxMenuItem item = new JCheckBoxMenuItem(new ShowProblemsAction(this));
        this.showProblemsButtonModel = item.getModel();
        this.showProblemsButtonModel.setSelected(this.workspace.problemsAreVisible());
        return item;
    }

    private JMenu buildHelpMenu() {
        JMenu menu = new JMenu();
        menu.setText(this.resourceRepository().getString("HELP_MENU"));
        menu.setMnemonic(this.resourceRepository().getMnemonic("HELP_MENU"));
        menu.add(new HomeAction(this.getContext()));
        menu.add(new UsersGuideAction(this.getContext()));
        menu.add(new ExamplesAction(this.getContext()));
        menu.add(new JavaDocAction(this.getContext()));
        menu.addSeparator();
        menu.add(new AboutAction(this.getContext()));
        return menu;
    }

    private JPanel buildToolBarPanel() {
        JPanel panel = new JPanel(new GridLayout(2, 1));
        panel.add(this.buildMainToolBar());
        this.selectionToolBar = this.buildToolBar("SELECTION_TOOL_BAR");
        panel.add(this.selectionToolBar);
        return panel;
    }

    private JToolBar buildMainToolBar() {
        JToolBar toolBar = this.buildToolBar("MAIN_TOOL_BAR");
        toolBar.add(this.buildNewToolBarButton());
        JButton button = toolBar.add(this.actionRepository.getOpenAction());
        button.setMnemonic('\u0000');
        button = toolBar.add(new WorkbenchSaveAction(this.getContext(), this.nodeManager()));
        button.setMnemonic('\u0000');
        button = toolBar.add(new WorkbenchSaveAsAction(this.getContext(), this.nodeManager()));
        button.setMnemonic('\u0000');
        button = toolBar.add(this.actionRepository.getSaveAllAction());
        button.setMnemonic('\u0000');
        button = toolBar.add(new WorkbenchCloseAction(this.getContext(), this.nodeManager()));
        button.setMnemonic('\u0000');
        button = toolBar.add(this.actionRepository.getCloseAllAction());
        button.setMnemonic('\u0000');
        this.pluginToolBarActions = new HashMap();
        Plugin[] plugins = this.plugins();
        for (int i = 0; i < plugins.length; ++i) {
            Plugin plugin = plugins[i];
            ComponentContainerDescription ccd = plugin.buildToolBarDescription(this.getContext());
            if (ccd.hasComponents()) {
                toolBar.addSeparator();
            }
            ListIterator stream = ccd.components();
            while (stream.hasNext()) {
                toolBar.add((Component)stream.next());
            }
            ArrayList<Action> actions = new ArrayList<Action>();
            Iterator stream2 = ccd.actions();
            while (stream2.hasNext()) {
                Action action = (Action)stream2.next();
                action.setEnabled(false);
                actions.add(action);
            }
            this.pluginToolBarActions.put(plugin, actions);
        }
        toolBar.addSeparator();
        button = toolBar.add(new HelpAction(this.getContext()));
        button.setMnemonic('\u0000');
        return toolBar;
    }

    private DropDownButton buildNewToolBarButton() {
        DropDownButton button = new DropDownButton();
        button.putClientProperty("hideActionText", Boolean.TRUE);
        button.setAction(this.buildNewToolBarAction());
        button.setMenu(this.buildNewMenu().getPopupMenu());
        button.setMnemonic('\u0000');
        return button;
    }

    private FrameworkAction buildNewToolBarAction() {
        return new AbstractFrameworkAction(this.getContext()){

            protected void initialize() {
                this.initializeIcon("file");
                this.initializeText("file.new");
                this.initializeToolTipText("file.new.toolTipText");
            }

            protected void execute() {
            }
        };
    }

    private JToolBar buildToolBar(String key) {
        JToolBar toolBar = new JToolBar(this.resourceRepository().getString(key));
        MatteBorder shadow = BorderFactory.createMatteBorder(0, 0, 1, 0, toolBar.getBackground().darker());
        MatteBorder highlight = BorderFactory.createMatteBorder(0, 0, 1, 0, toolBar.getBackground().brighter());
        toolBar.setBorder(BorderFactory.createCompoundBorder(highlight, shadow));
        toolBar.setRollover(true);
        toolBar.setFloatable(false);
        return toolBar;
    }

    private TreeSelectionListener buildTreeSelectionListener() {
        return new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                WorkbenchWindow.this.treeSelectionChanged();
            }
        };
    }

    void treeSelectionChanged() {
        ApplicationNode[] selectedNodes = this.navigatorSelectionModel().getSelectedNodes();
        Plugin selectedPlugin = this.selectedPlugin(selectedNodes);
        this.updateWorkbenchActions(selectedPlugin);
        this.enablePluginToolBarActions(selectedPlugin);
        this.updateSelectionActions(selectedNodes, selectedPlugin);
    }

    private Plugin selectedPlugin(ApplicationNode[] selectedNodes) {
        int len = selectedNodes.length;
        if (len == 0) {
            return null;
        }
        Plugin selectedPlugin = selectedNodes[0].getPlugin();
        for (int i = 1; i < len; ++i) {
            if (selectedNodes[i].getPlugin() == selectedPlugin) continue;
            return null;
        }
        return selectedPlugin;
    }

    private void enablePluginToolBarActions(Plugin selectedPlugin) {
        for (Map.Entry entry : this.pluginToolBarActions.entrySet()) {
            boolean enabled = entry.getKey() == selectedPlugin;
            Iterator stream2 = ((Collection)entry.getValue()).iterator();
            while (stream2.hasNext()) {
                ((Action)stream2.next()).setEnabled(enabled);
            }
        }
    }

    private void updateWorkbenchActions(Plugin selectedPlugin) {
        this.tearDownWorkbenchActions();
        this.workbenchActions.clear();
        this.workbenchMenu.removeAll();
        if (selectedPlugin != null) {
            ComponentContainerDescription workbenchMenuDescription = selectedPlugin.buildMenuDescription(this.getContext());
            ListIterator stream = workbenchMenuDescription.components();
            while (stream.hasNext()) {
                this.workbenchMenu.add((Component)stream.next());
            }
            CollectionTools.addAll((Collection)this.workbenchActions, (Iterator)workbenchMenuDescription.actions());
            this.setUpWorkbenchActions();
        }
        this.workbenchMenu.setEnabled(this.workbenchMenu.getMenuComponentCount() > 0);
    }

    private void setUpWorkbenchActions() {
        Iterator stream = this.workbenchActions.iterator();
        while (stream.hasNext()) {
            ((FrameworkAction)stream.next()).setUp();
        }
    }

    private void tearDownWorkbenchActions() {
        Iterator stream = this.workbenchActions.iterator();
        while (stream.hasNext()) {
            ((FrameworkAction)stream.next()).tearDown();
        }
    }

    private void updateSelectionActions(ApplicationNode[] selectedNodes, Plugin selectedPlugin) {
        this.tearDownSelectionActions();
        this.selectionActions.clear();
        this.updateSelectionMenu(selectedNodes, selectedPlugin);
        this.updateSelectionToolBar(selectedNodes, selectedPlugin);
        this.setUpSelectionActions();
    }

    private void setUpSelectionActions() {
        Iterator stream = this.selectionActions.iterator();
        while (stream.hasNext()) {
            ((FrameworkAction)stream.next()).setUp();
        }
    }

    private void tearDownSelectionActions() {
        Iterator stream = this.selectionActions.iterator();
        while (stream.hasNext()) {
            ((FrameworkAction)stream.next()).tearDown();
        }
    }

    private void updateSelectionMenu(ApplicationNode[] selectedNodes, Plugin selectedPlugin) {
        this.selectionMenu.removeAll();
        if (selectedPlugin == null) {
            this.selectionMenu.setEnabled(false);
            this.selectionMenuDescriptionHolder.setValue(new RootMenuDescription());
            return;
        }
        GroupContainerDescription selectionMenuDescription = selectedNodes[0].buildMenuDescription(this.context);
        for (int i = 1; i < selectedNodes.length; ++i) {
            selectionMenuDescription.mergeWith(selectedNodes[i].buildMenuDescription(this.context));
        }
        ListIterator stream = selectionMenuDescription.components();
        while (stream.hasNext()) {
            this.selectionMenu.add((Component)stream.next());
        }
        this.selectionMenu.setEnabled(this.selectionMenu.getMenuComponentCount() > 0);
        CollectionTools.addAll((Collection)this.selectionActions, (Iterator)selectionMenuDescription.actions());
        this.selectionMenuDescriptionHolder.setValue(selectionMenuDescription);
    }

    private void updateSelectionToolBar(ApplicationNode[] selectedNodes, Plugin selectedPlugin) {
        this.selectionToolBar.removeAll();
        this.selectionToolBar.revalidate();
        this.selectionToolBar.repaint();
        if (selectedPlugin == null) {
            return;
        }
        GroupContainerDescription selectionToolBarDescription = selectedNodes[0].buildToolBarDescription(this.context);
        for (int i = 1; i < selectedNodes.length; ++i) {
            selectionToolBarDescription.mergeWith(selectedNodes[i].buildToolBarDescription(this.context));
        }
        ListIterator stream = selectionToolBarDescription.components();
        while (stream.hasNext()) {
            this.selectionToolBar.add((Component)stream.next());
        }
        CollectionTools.addAll((Collection)this.selectionActions, (Iterator)selectionToolBarDescription.actions());
    }

    private StateChangeListener buildRecentFilesListener() {
        return new StateChangeListener(){

            public void stateChanged(StateChangeEvent e) {
                WorkbenchWindow.this.recentFilesChanged();
            }
        };
    }

    void recentFilesChanged() {
        this.rebuildRecentFilesMenuItems();
    }

    private void rebuildRecentFilesMenuItems() {
        int base = this.fileMenu.getMenuComponentCount();
        base -= 2;
        base -= this.recentFilesSize;
        for (int i = 0; i < this.recentFilesSize; ++i) {
            this.fileMenu.remove(base);
        }
        File[] recentFiles = this.application.recentFilesManager().getRecentFiles();
        this.recentFilesSize = recentFiles.length;
        for (int i = 0; i < this.recentFilesSize; ++i) {
            this.fileMenu.insert(this.buildRecentFileMenuItem(i + 1, recentFiles[i]), base + i);
        }
        this.fileMenu.getMenuComponent(this.fileMenu.getMenuComponentCount() - 2).setVisible(recentFiles.length > 0);
    }

    private JMenuItem buildRecentFileMenuItem(int count, File recentFile) {
        return new JMenuItem(new OpenRecentFileAction(this, count, recentFile));
    }

    void saveState(Preferences windowsPreferences) {
        windowsPreferences.putInt("x-location", this.getLocation().x);
        windowsPreferences.putInt("y-location", this.getLocation().y);
        windowsPreferences.putInt("height", this.getSize().height);
        windowsPreferences.putInt("width", this.getSize().width);
        windowsPreferences.putInt("extended state", this.getExtendedState());
        this.workspace.saveState(windowsPreferences);
        windowsPreferences.putBoolean("problems view visible", this.workspace.problemsAreVisible());
    }

    void restoreState(Preferences windowsPreferences) {
        int x = windowsPreferences.getInt("x-location", this.getLocation().x);
        int y = windowsPreferences.getInt("y-location", this.getLocation().y);
        this.setLocation(x, y);
        int height = windowsPreferences.getInt("height", this.getSize().height);
        int width = windowsPreferences.getInt("width", this.getSize().width);
        this.setSize(width, height);
        this.setExtendedState(windowsPreferences.getInt("extended state", this.getExtendedState()));
        this.workspace.restoreState(windowsPreferences);
        if (!windowsPreferences.getBoolean("problems view visible", true)) {
            this.toggleShowProblems();
        }
    }

    void saveTreeExpansionState(Preferences windowsPreferences) {
        this.workspace.saveTreeExpansionState(windowsPreferences);
    }

    void restoreTreeExpansionState(Preferences windowsPreferences) {
        this.workspace.restoreTreeExpansionState(windowsPreferences);
    }

    void toggleShowProblems() {
        this.showProblemsButtonModel.setSelected(this.workspace.toggleShowProblems());
    }

    void toggleSynchronousProblems() {
        this.synchronousProblemsButtonModel.setSelected(this.application.getNodeManager().toggleAddProjectNodesWithSynchronousValidators());
    }

    void closing() {
        this.application.close(this);
    }

    void closed() {
        this.application.recentFilesManager().removeStateChangeListener(this.recentFilesListener);
        this.getWorkspace().removeNavigatorTreeSelectionListener(this.treeSelectionListener);
        this.tearDownSelectionActions();
        this.workspace.close();
        this.removeWindowListener(this.windowListener);
    }

    FrameworkApplication getApplication() {
        return this.application;
    }

    WorkbenchContext getContext() {
        return this.context;
    }

    WorkspaceView getWorkspace() {
        return this.workspace;
    }

    ActionRepository getActionRepository() {
        return this.actionRepository;
    }

    Plugin[] plugins() {
        return this.application.getPlugins();
    }

    ResourceRepository resourceRepository() {
        return this.application.getResourceRepository();
    }

    ApplicationContext applicationContext() {
        return this.application.getRootApplicationContext();
    }

    FrameworkNodeManager nodeManager() {
        return this.application.getNodeManager();
    }

    TreeNodeValueModel rootNode() {
        return this.nodeManager().getRootNode();
    }

    NavigatorSelectionModel navigatorSelectionModel() {
        return this.workspace.navigatorSelectionModel();
    }

    Component getPropertiesPage() {
        return this.workspace.getPropertiesPage();
    }

    private class LocalWindowListener
    extends WindowAdapter {
        private LocalWindowListener() {
        }

        public void windowClosing(WindowEvent e) {
            WorkbenchWindow.this.closing();
        }

        public void windowClosed(WindowEvent e) {
            WorkbenchWindow.this.closed();
        }
    }

    private class LocalWorkbenchContext
    extends AbstractWorkbenchContext {
        private LocalWorkbenchContext() {
        }

        public ApplicationContext getApplicationContext() {
            return WorkbenchWindow.this.applicationContext();
        }

        public Window getCurrentWindow() {
            return WorkbenchWindow.this;
        }

        public NavigatorSelectionModel getNavigatorSelectionModel() {
            return WorkbenchWindow.this.navigatorSelectionModel();
        }

        public ActionRepository getActionRepository() {
            return WorkbenchWindow.this.getActionRepository();
        }

        public Component getPropertiesPage() {
            return WorkbenchWindow.this.getPropertiesPage();
        }
    }
}

