/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.internal;

import java.awt.Component;
import java.util.prefs.Preferences;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JSplitPane;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.app.NavigatorSelectionModel;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.internal.EditorView;
import org.eclipse.persistence.tools.workbench.framework.internal.EmptySelectionPseudoNode;
import org.eclipse.persistence.tools.workbench.framework.internal.MultiSelectionPseudoNode;
import org.eclipse.persistence.tools.workbench.framework.internal.NavigatorView;
import org.eclipse.persistence.tools.workbench.framework.internal.ProblemsView;
import org.eclipse.persistence.tools.workbench.framework.uitools.OSplitPane;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingTools;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;

final class WorkspaceView {
    private JSplitPane splitPane;
    private JSplitPane topSplitPane;
    private TreeSelectionListener treeSelectionListener;
    private NavigatorView navigatorView;
    private EditorView editorView;
    private ProblemsView problemsView;
    private PropertyValueModel selectedNodeHolder;
    private MultiSelectionPseudoNode multiSelectionNode;
    private ApplicationNode emptySelectionNode;

    WorkspaceView(WorkbenchContext context, ValueModel selectionMenuDescriptionHolder) {
        this.multiSelectionNode = new MultiSelectionPseudoNode(context.getApplicationContext());
        this.emptySelectionNode = new EmptySelectionPseudoNode(context.getApplicationContext());
        this.selectedNodeHolder = new SimplePropertyValueModel(this.emptySelectionNode);
        this.navigatorView = new NavigatorView(context.getApplicationContext(), selectionMenuDescriptionHolder);
        this.treeSelectionListener = this.buildTreeSelectionListener();
        this.navigatorView.addTreeSelectionListener(this.treeSelectionListener);
        this.editorView = new EditorView(this.selectedNodeHolder, context);
        this.problemsView = new ProblemsView(this.selectedNodeHolder, this.navigatorSelectionModel(), context);
        this.topSplitPane = this.buildTopSplitPane();
        this.splitPane = this.buildSplitPane();
    }

    private TreeSelectionListener buildTreeSelectionListener() {
        return new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                ApplicationNode[] selectedNodes = ((NavigatorSelectionModel)e.getSource()).getSelectedNodes();
                WorkspaceView.this.selectedNodesChanged(selectedNodes);
            }
        };
    }

    private JSplitPane buildSplitPane() {
        JSplitPane sPane = new JSplitPane(0);
        sPane.setBorder(BorderFactory.createEmptyBorder(3, 0, 0, 0));
        sPane.setDoubleBuffered(false);
        SwingTools.setSplitPaneDividerBorder(sPane, BorderFactory.createEmptyBorder());
        sPane.setDividerSize(3);
        sPane.setResizeWeight(1.0);
        sPane.setContinuousLayout(false);
        sPane.setTopComponent(this.topSplitPane);
        sPane.setBottomComponent(this.problemsView.getComponent());
        sPane.setDividerLocation(475);
        return sPane;
    }

    private JSplitPane buildTopSplitPane() {
        OSplitPane sPane = new OSplitPane(1);
        sPane.setBorder(BorderFactory.createEmptyBorder());
        sPane.setDoubleBuffered(false);
        SwingTools.setSplitPaneDividerBorder(sPane, BorderFactory.createEmptyBorder());
        sPane.setDividerSize(3);
        sPane.setResizeWeight(0.0);
        sPane.setContinuousLayout(false);
        ((JSplitPane)sPane).setLeftComponent(this.navigatorView.getComponent());
        ((JSplitPane)sPane).setRightComponent(this.editorView.getComponent());
        sPane.setDividerLocation(250);
        return sPane;
    }

    Component getComponent() {
        return this.splitPane;
    }

    NavigatorSelectionModel navigatorSelectionModel() {
        return this.navigatorView.getSelectionModel();
    }

    boolean problemsAreVisible() {
        return this.splitPane.getBottomComponent() != null;
    }

    Action problemReportAction() {
        return this.problemsView.getProblemReportAction();
    }

    Component getPropertiesPage() {
        return this.editorView.getPropertiesPage();
    }

    void selectedNodesChanged(ApplicationNode[] selectedNodes) {
        ApplicationNode selectedNode;
        this.multiSelectionNode.setSelectedNodes(selectedNodes);
        switch (selectedNodes.length) {
            case 0: {
                selectedNode = this.emptySelectionNode;
                break;
            }
            case 1: {
                selectedNode = selectedNodes[0];
                break;
            }
            default: {
                selectedNode = this.multiSelectionNode;
            }
        }
        this.selectedNodeHolder.setValue(selectedNode);
    }

    boolean toggleShowProblems() {
        if (this.problemsAreVisible()) {
            this.splitPane.setBottomComponent(null);
            return false;
        }
        this.splitPane.setBottomComponent(this.problemsView.getComponent());
        this.splitPane.setDividerLocation(0.8);
        return true;
    }

    void addNavigatorTreeSelectionListener(TreeSelectionListener listener) {
        this.navigatorView.addTreeSelectionListener(listener);
    }

    void removeNavigatorTreeSelectionListener(TreeSelectionListener listener) {
        this.navigatorView.removeTreeSelectionListener(listener);
    }

    void copySettingsFrom(WorkspaceView workspace) {
        this.splitPane.setDividerLocation(workspace.splitPane.getDividerLocation());
        this.topSplitPane.setDividerLocation(workspace.topSplitPane.getDividerLocation());
        if (!workspace.problemsAreVisible()) {
            this.toggleShowProblems();
        }
    }

    void saveState(Preferences windowsPreferences) {
        windowsPreferences.putInt("split pane divider location", this.splitPane.getDividerLocation());
        windowsPreferences.putInt("top split pane divider location", this.topSplitPane.getDividerLocation());
    }

    void restoreState(Preferences windowsPreferences) {
        int dividerLocation = windowsPreferences.getInt("split pane divider location", this.splitPane.getDividerLocation());
        this.splitPane.setDividerLocation(dividerLocation);
        int topDividerLocation = windowsPreferences.getInt("top split pane divider location", this.topSplitPane.getDividerLocation());
        this.topSplitPane.setDividerLocation(topDividerLocation);
    }

    void saveTreeExpansionState(Preferences windowsPreferences) {
        this.navigatorView.saveTreeExpansionState(windowsPreferences);
    }

    void restoreTreeExpansionState(Preferences windowsPreferences) {
        this.navigatorView.restoreTreeExpansionState(windowsPreferences);
    }

    void close() {
        this.navigatorView.close();
        this.editorView.close();
        this.problemsView.close();
        this.navigatorView.removeTreeSelectionListener(this.treeSelectionListener);
    }
}

