/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.ui.chooser;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JLabel;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractDialog;
import org.eclipse.persistence.tools.workbench.uitools.FilteringListPanel;
import org.eclipse.persistence.tools.workbench.utility.string.StringConverter;

public class DefaultListChooserDialog
extends AbstractDialog {
    private FilteringListPanel filteringListPanel;
    Builder builder;

    public DefaultListChooserDialog(WorkbenchContext context, Builder builder) {
        super(context);
        this.builder = builder;
        this.initialize2();
    }

    public DefaultListChooserDialog(WorkbenchContext context, Dialog owner, Builder builder) {
        super(context, owner);
        this.builder = builder;
        this.initialize2();
    }

    protected void initialize2() {
        this.setTitle(this.resourceRepository().getString(this.builder.getTitleKey()));
        this.filteringListPanel = this.buildFilteringListPanel();
    }

    protected FilteringListPanel buildFilteringListPanel() {
        FilteringListPanel panel = new FilteringListPanel(this.builder.getCompleteList(), this.builder.getInitialSelection(), this.builder.getStringConverter()){

            protected ListCellRenderer buildDefaultCellRenderer() {
                if (DefaultListChooserDialog.this.builder.getListCellRenderer() != null) {
                    return DefaultListChooserDialog.this.builder.getListCellRenderer();
                }
                return super.buildDefaultCellRenderer();
            }
        };
        this.helpManager().addTopicID(panel.getTextField(), this.builder.getHelpTopicId());
        this.helpManager().addTopicID(panel.getListBox(), this.builder.getHelpTopicId());
        this.configureLabel(panel.getTextFieldLabel(), this.builder.getTextFieldLabelKey());
        this.configureLabel(panel.getListBoxLabel(), this.builder.getListBoxLabelKey());
        panel.getListBox().addListSelectionListener(this.buildListBoxSelectionListener());
        panel.getListBox().addMouseListener(this.buildListBoxMouseListener());
        return panel;
    }

    protected void configureLabel(JLabel label, String key) {
        label.setText(this.resourceRepository().getString(key));
        label.setDisplayedMnemonic(this.resourceRepository().getMnemonic(key));
    }

    protected MouseListener buildListBoxMouseListener() {
        return new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    DefaultListChooserDialog.this.clickOK();
                }
            }
        };
    }

    protected ListSelectionListener buildListBoxSelectionListener() {
        return new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    DefaultListChooserDialog.this.updateOK();
                }
            }
        };
    }

    protected void clickOK() {
        super.clickOK();
    }

    protected void updateOK() {
        this.getOKAction().setEnabled(!this.filteringListPanel.getListBox().isSelectionEmpty());
    }

    protected Component buildMainPanel() {
        return this.filteringListPanel;
    }

    protected String helpTopicId() {
        return this.builder.getHelpTopicId();
    }

    protected Component initialFocusComponent() {
        return this.filteringListPanel.getTextField();
    }

    protected void prepareToShow() {
        this.setSize(300, 485);
        this.setLocationRelativeTo(this.getParent());
        this.updateOK();
    }

    public FilteringListPanel getFilteringListPanel() {
        return this.filteringListPanel;
    }

    public Object selection() {
        if (!this.wasConfirmed()) {
            throw new IllegalStateException();
        }
        return this.filteringListPanel.getSelection();
    }

    public static class Builder
    implements Cloneable {
        private Object[] completeList;
        private Object initialSelection;
        private StringConverter stringConverter;
        private ListCellRenderer listCellRenderer;
        private String titleKey;
        private String textFieldLabelKey;
        private String listBoxLabelKey;
        private String helpTopicId;
        static Builder DEFAULT_INSTANCE = new Builder();

        public Builder() {
            this.initialize();
        }

        protected void initialize() {
            this.completeList = null;
            this.initialSelection = null;
            this.stringConverter = StringConverter.DEFAULT_INSTANCE;
            this.titleKey = "DEFAULT_LONG_LIST_BROWSER_DIALOG.TITLE";
            this.textFieldLabelKey = "DEFAULT_LONG_LIST_BROWSER_DIALOG.TEXT_FIELD_LABEL";
            this.listBoxLabelKey = "DEFAULT_LONG_LIST_BROWSER_DIALOG.LIST_BOX_LABEL";
            this.helpTopicId = "default";
        }

        public DefaultListChooserDialog buildDialog(WorkbenchContext context, Object[] list, Object initSel) {
            return this.buildDialog(context, (Builder)this.clone(), list, initSel);
        }

        protected Object clone() {
            Builder clone;
            try {
                clone = (Builder)super.clone();
            }
            catch (CloneNotSupportedException ex) {
                throw new RuntimeException(ex);
            }
            return clone;
        }

        protected DefaultListChooserDialog buildDialog(WorkbenchContext context, Builder clone, Object[] list, Object initSel) {
            if (clone.getCompleteList() == null) {
                clone.setCompleteList(list);
            }
            if (clone.getInitialSelection() == null) {
                clone.setInitialSelection(initSel);
            }
            if (context.getCurrentWindow() instanceof Dialog) {
                return new DefaultListChooserDialog(context, (Dialog)context.getCurrentWindow(), clone);
            }
            return new DefaultListChooserDialog(context, clone);
        }

        public void setTitleKey(String title) {
            this.titleKey = title;
        }

        public String getTitleKey() {
            return this.titleKey;
        }

        public void setTextFieldLabelKey(String textFieldLabel) {
            this.textFieldLabelKey = textFieldLabel;
        }

        public String getTextFieldLabelKey() {
            return this.textFieldLabelKey;
        }

        public void setListBoxLabelKey(String listBoxLabel) {
            this.listBoxLabelKey = listBoxLabel;
        }

        public String getListBoxLabelKey() {
            return this.listBoxLabelKey;
        }

        public String getHelpTopicId() {
            return this.helpTopicId;
        }

        public void setHelpTopicId(String helpTopidId) {
            this.helpTopicId = helpTopidId;
        }

        public Object[] getCompleteList() {
            return this.completeList;
        }

        public void setCompleteList(Object[] completeList) {
            this.completeList = completeList;
        }

        public Object getInitialSelection() {
            return this.initialSelection;
        }

        public void setInitialSelection(Object initialSelection) {
            this.initialSelection = initialSelection;
        }

        public StringConverter getStringConverter() {
            return this.stringConverter;
        }

        public void setStringConverter(StringConverter stringConverter) {
            this.stringConverter = stringConverter;
        }

        public ListCellRenderer getListCellRenderer() {
            return this.listCellRenderer;
        }

        public void setListCellRenderer(ListCellRenderer listCellRenderer) {
            this.listCellRenderer = listCellRenderer;
        }
    }
}

