/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.uitools;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.eclipse.persistence.tools.workbench.framework.resources.DefaultResourceRepository;
import org.eclipse.persistence.tools.workbench.framework.uitools.AccessibleTitledPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingTools;
import org.eclipse.persistence.tools.workbench.framework.uitools.UIToolsResourceBundle;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ListModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.AdaptableListCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.cell.CellRendererAdapter;
import org.eclipse.persistence.tools.workbench.uitools.swing.CompositeIcon;

public class CheckList
extends AccessibleTitledPanel {
    JLabel accessibleLabel;
    EditableCheckList listBox;
    ListSelectionModel selectionModel;

    private CheckList() {
        super(new BorderLayout());
    }

    public CheckList(CollectionValueModel itemHolder, ListSelectionModel selectionModel) {
        this(itemHolder, selectionModel, CellRendererAdapter.DEFAULT_CELL_RENDERER_ADAPTER);
    }

    public CheckList(CollectionValueModel itemHolder, ListSelectionModel selectionModel, CellRendererAdapter labelDecorator) {
        this(new CollectionListValueModelAdapter(itemHolder), selectionModel, labelDecorator);
    }

    public CheckList(ListValueModel itemHolder, ListSelectionModel selectionModel) {
        this(itemHolder, selectionModel, CellRendererAdapter.DEFAULT_CELL_RENDERER_ADAPTER);
    }

    public CheckList(ListValueModel itemHolder, ListSelectionModel selectionModel, CellRendererAdapter labelDecorator) {
        this();
        this.initialize(itemHolder, selectionModel, labelDecorator);
    }

    private FocusListener buildFocusListener() {
        return new FocusListener(){

            public void focusGained(FocusEvent e) {
                CheckList.this.listBox.repaint();
            }

            public void focusLost(FocusEvent e) {
                CheckList.this.listBox.repaint();
            }
        };
    }

    private ListModel buildListModelAdapter(ListValueModel itemHolder) {
        return new ListModelAdapter(itemHolder);
    }

    private ListSelectionListener buildSelectionModelListener() {
        return new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                for (int index = e.getFirstIndex(); index <= e.getLastIndex(); ++index) {
                    CheckList.this.repaintCell(index);
                }
            }
        };
    }

    protected void initialize(ListValueModel itemHolder, ListSelectionModel listSelectionModel, CellRendererAdapter cellRendererAdapter) {
        if (itemHolder == null || listSelectionModel == null || cellRendererAdapter == null) {
            throw new NullPointerException("ListValueModel, ListSelectionModel, CellRendererAdapter cannot be null");
        }
        this.selectionModel = listSelectionModel;
        listSelectionModel.addListSelectionListener(this.buildSelectionModelListener());
        this.listBox = new EditableCheckList(this.buildListModelAdapter(itemHolder));
        this.listBox.addFocusListener(this.buildFocusListener());
        this.listBox.setCellRenderer(new CheckBoxCellRenderer(cellRendererAdapter));
        this.add((Component)new JScrollPane(this.listBox), "Center");
        this.installEditing();
        this.add((Component)new StatusBarPane(), "First");
    }

    private void installEditing() {
        MouseHandler mouseHandler = new MouseHandler();
        this.listBox.addMouseListener(mouseHandler);
        this.listBox.addMouseMotionListener(mouseHandler);
        InputMap inputMap = (InputMap)UIManager.get("List.focusInputMap");
        inputMap.put(KeyStroke.getKeyStroke("SPACE"), "pressed");
        inputMap.put(KeyStroke.getKeyStroke("released SPACE"), "released");
        ActionMap actionMap = this.listBox.getActionMap();
        actionMap.put("pressed", new PressedAction());
        actionMap.put("released", new ReleasedAction());
    }

    boolean isAccessibleContextInitialized() {
        return this.accessibleContext != null;
    }

    void repaintCell(int index) {
        Rectangle bounds = this.listBox.getCellBounds(index, index);
        this.listBox.repaint(bounds);
    }

    public void requestFocus() {
        this.listBox.requestFocus();
    }

    public boolean requestFocus(boolean temporary) {
        return this.listBox.requestFocus(temporary);
    }

    public boolean requestFocusInWindow() {
        return this.listBox.requestFocusInWindow();
    }

    protected boolean requestFocusInWindow(boolean temporary) {
        return this.listBox.requestFocusInWindow(temporary);
    }

    private void updateActiveDescendant(int index) {
        if (this.accessibleContext != null) {
            AccessibleContext accessible = this.listBox.getAccessibleContext();
            Accessible accessibleChild = accessible.getAccessibleChild(index);
            this.accessibleLabel.setText(accessibleChild.getAccessibleContext().getAccessibleName());
        }
    }

    void updateSelection(int index) {
        this.updateSelection(new int[]{index});
    }

    void updateSelection(int[] indices) {
        int index;
        int selectedCount = 0;
        int index2 = indices.length;
        while (--index2 >= 0) {
            if (!this.selectionModel.isSelectedIndex(indices[index2])) continue;
            ++selectedCount;
        }
        boolean select = indices.length != selectedCount;
        for (index = 0; index < indices.length; ++index) {
            int anIndex = indices[index];
            if (select) {
                this.selectionModel.addSelectionInterval(anIndex, anIndex);
                continue;
            }
            this.selectionModel.removeSelectionInterval(anIndex, anIndex);
        }
        for (index = 0; index < indices.length; ++index) {
            this.updateActiveDescendant(indices[index]);
        }
    }

    private class StatusBarPane
    extends JPanel {
        public StatusBarPane() {
            super(new BorderLayout());
        }

        private void createStatusBar() {
            CheckList.this.accessibleLabel = new AccessibleLabel();
            CheckList.this.accessibleLabel.setVisible(false);
            StatusBar statusBar = new StatusBar();
            statusBar.setVisible(false);
            statusBar.add(CheckList.this.accessibleLabel);
            this.add((Component)statusBar, "Center");
            this.validate();
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleStatusBarPane();
                this.createStatusBar();
            }
            return this.accessibleContext;
        }

        private class StatusBar
        extends JPanel {
            private StatusBar() {
            }

            public AccessibleContext getAccessibleContext() {
                if (this.accessibleContext == null) {
                    this.accessibleContext = new AccessibleStatusBar();
                }
                return this.accessibleContext;
            }

            protected class AccessibleStatusBar
            extends JPanel.AccessibleJPanel {
                protected AccessibleStatusBar() {
                    super(StatusBar.this);
                }

                public AccessibleRole getAccessibleRole() {
                    return AccessibleRole.STATUS_BAR;
                }
            }
        }

        protected class AccessibleStatusBarPane
        extends JPanel.AccessibleJPanel {
            protected AccessibleStatusBarPane() {
                super(StatusBarPane.this);
            }
        }

        private class AccessibleLabel
        extends JLabel {
            private AccessibleLabel() {
            }

            public void setText(String text) {
                String oldText = this.getText();
                super.setText(text);
                if (this.accessibleContext != null) {
                    this.accessibleContext.firePropertyChange("AccessibleName", oldText, text);
                }
            }
        }
    }

    private class ReleasedAction
    extends AbstractAction {
        private ReleasedAction() {
        }

        public void actionPerformed(ActionEvent e) {
            int[] selectedIndices = CheckList.this.listBox.getSelectedIndices();
            if (selectedIndices.length > 0) {
                CheckBoxCellRenderer renderer = (CheckBoxCellRenderer)CheckList.this.listBox.getCellRenderer();
                renderer.armedIndex = -1;
                renderer.pressedIndex = -1;
                CheckList.this.updateSelection(selectedIndices);
            }
        }
    }

    private class PressedAction
    extends AbstractAction {
        private PressedAction() {
        }

        public void actionPerformed(ActionEvent e) {
            int[] indices = CheckList.this.listBox.getSelectedIndices();
            if (indices.length != 1) {
                return;
            }
            CheckBoxCellRenderer renderer = (CheckBoxCellRenderer)CheckList.this.listBox.getCellRenderer();
            renderer.armedIndex = indices[0];
            renderer.pressedIndex = indices[0];
            CheckList.this.repaintCell(indices[0]);
        }
    }

    private class MouseHandler
    extends MouseAdapter
    implements MouseMotionListener {
        private int currentPressedIndex = -1;

        private MouseHandler() {
        }

        private int locationToIndex(Point location) {
            int iconWidth = SwingTools.checkBoxIconWidth();
            int index = CheckList.this.listBox.locationToIndex(location);
            Rectangle bounds = CheckList.this.listBox.getCellBounds(index, index);
            if (!CheckList.this.listBox.getComponentOrientation().isLeftToRight()) {
                bounds.x += bounds.width - iconWidth;
            }
            bounds.width = iconWidth;
            return bounds.contains(location.x, location.y) ? index : -1;
        }

        public void mouseDragged(MouseEvent e) {
            this.mouseMoved(e);
        }

        public void mouseExited(MouseEvent e) {
            CheckBoxCellRenderer renderer = (CheckBoxCellRenderer)CheckList.this.listBox.getCellRenderer();
            int oldRolloverIndex = renderer.rolloverIndex;
            if (oldRolloverIndex != -1) {
                renderer.armedIndex = -1;
                renderer.rolloverIndex = -1;
                CheckList.this.repaintCell(oldRolloverIndex);
            }
        }

        public void mouseMoved(MouseEvent e) {
            if (CheckList.this.listBox.getModel().getSize() == 0) {
                return;
            }
            Point location = e.getPoint();
            int index = CheckList.this.listBox.locationToIndex(location);
            Rectangle bounds = CheckList.this.listBox.getCellBounds(index, index);
            if (!bounds.contains(location)) {
                index = -1;
            }
            CheckBoxCellRenderer renderer = (CheckBoxCellRenderer)CheckList.this.listBox.getCellRenderer();
            int oldRolloverIndex = renderer.rolloverIndex;
            if (oldRolloverIndex == index) {
                return;
            }
            renderer.rolloverIndex = index;
            int n = renderer.armedIndex = index == this.currentPressedIndex ? index : -1;
            if (index != -1) {
                CheckList.this.repaintCell(index);
            }
            if (oldRolloverIndex != -1) {
                CheckList.this.repaintCell(oldRolloverIndex);
            }
        }

        public void mousePressed(MouseEvent e) {
            if (!SwingUtilities.isLeftMouseButton(e)) {
                return;
            }
            int index = this.locationToIndex(e.getPoint());
            if (index != -1) {
                CheckBoxCellRenderer renderer = (CheckBoxCellRenderer)CheckList.this.listBox.getCellRenderer();
                renderer.armedIndex = index;
                renderer.pressedIndex = index;
                this.currentPressedIndex = index;
                CheckList.this.repaintCell(index);
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (!SwingUtilities.isLeftMouseButton(e)) {
                return;
            }
            CheckBoxCellRenderer renderer = (CheckBoxCellRenderer)CheckList.this.listBox.getCellRenderer();
            Point location = e.getPoint();
            int newIndex = CheckList.this.listBox.locationToIndex(location);
            Rectangle bounds = CheckList.this.listBox.getCellBounds(newIndex, newIndex);
            if (!bounds.contains(location)) {
                newIndex = -1;
            }
            if (this.currentPressedIndex != newIndex || this.locationToIndex(e.getPoint()) == -1) {
                this.currentPressedIndex = -1;
            }
            renderer.armedIndex = this.currentPressedIndex;
            renderer.pressedIndex = -1;
            renderer.rolloverIndex = newIndex;
            if (this.currentPressedIndex != -1) {
                CheckList.this.updateSelection(this.currentPressedIndex);
            }
            this.currentPressedIndex = -1;
            if (newIndex != -1) {
                CheckList.this.repaintCell(newIndex);
            }
        }
    }

    private class EditableCheckList
    extends SwingComponentFactory.AccessibleList {
        EditableCheckList(ListModel model) {
            super(model);
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleEditableCheckList();
            }
            return this.accessibleContext;
        }

        public boolean requestFocusInWindow(boolean temporary) {
            return super.requestFocusInWindow(temporary);
        }

        protected class AccessibleEditableCheckList
        extends SwingComponentFactory.AccessibleList.AccessibleAccessibleList
        implements ListSelectionListener {
            String ACCESSIBLE_CHECKBOX_CHECKED;
            String ACCESSIBLE_CHECKBOX_NOT_CHECKED;

            protected AccessibleEditableCheckList() {
                super(EditableCheckList.this);
                this.initialize();
            }

            public Accessible getAccessibleAt(Point location) {
                int index = EditableCheckList.this.locationToIndex(location);
                return this.getAccessibleChild(index);
            }

            public Accessible getAccessibleChild(int index) {
                if (index < 0 || index >= EditableCheckList.this.getModel().getSize()) {
                    return null;
                }
                return new AccessibleEditableCheckListChild((JList)EditableCheckList.this, index);
            }

            protected void initialize() {
                DefaultResourceRepository repository = new DefaultResourceRepository(UIToolsResourceBundle.class);
                this.ACCESSIBLE_CHECKBOX_CHECKED = " " + repository.getString("ACCESSIBLE_CHECKLIST_CHECKBOX_CHECKED");
                this.ACCESSIBLE_CHECKBOX_NOT_CHECKED = " " + repository.getString("ACCESSIBLE_CHECKLIST_CHECKBOX_NOT_CHECKED");
            }

            protected class AccessibleEditableCheckListChild
            extends JList.AccessibleJList.AccessibleJListChild {
                private final int index;

                protected AccessibleEditableCheckListChild(JList list, int index) {
                    super(AccessibleEditableCheckList.this, list, index);
                    this.index = index;
                }

                public String getAccessibleName() {
                    String name = super.getAccessibleName();
                    name = CheckList.this.selectionModel.isSelectedIndex(this.index) ? name + AccessibleEditableCheckList.this.ACCESSIBLE_CHECKBOX_CHECKED : name + AccessibleEditableCheckList.this.ACCESSIBLE_CHECKBOX_NOT_CHECKED;
                    return name;
                }
            }
        }
    }

    private class CheckBoxCellRenderer
    extends AdaptableListCellRenderer {
        int armedIndex;
        int pressedIndex;
        int rolloverIndex;

        CheckBoxCellRenderer(CellRendererAdapter adapter) {
            super(adapter);
            this.pressedIndex = -1;
            this.armedIndex = -1;
            this.rolloverIndex = -1;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean selected, boolean cellHasFocus) {
            if (CheckList.this.isAccessibleContextInitialized()) {
                this.getAccessibleContext();
            }
            super.getListCellRendererComponent(list, value, index, selected, cellHasFocus);
            CheckBox checkBox = new CheckBox();
            this.updateCheckBoxUI(checkBox, selected);
            this.updateCheckBoxVisual(checkBox);
            this.updateCheckBoxButtonModel(checkBox, index);
            return checkBox;
        }

        private void updateCheckBoxButtonModel(CheckBox checkBox, int index) {
            ButtonModel model = checkBox.getModel();
            model.setPressed(this.pressedIndex == index);
            model.setArmed(this.armedIndex == index);
            model.setRollover(this.rolloverIndex == index);
            checkBox.setSelected(CheckList.this.selectionModel.isSelectedIndex(index));
        }

        private void updateCheckBoxUI(CheckBox checkBox, boolean selected) {
            checkBox.setHorizontalAlignment(this.getHorizontalAlignment());
            checkBox.setHorizontalTextPosition(this.getHorizontalTextPosition());
            checkBox.setVerticalAlignment(this.getVerticalAlignment());
            checkBox.setVerticalTextPosition(this.getVerticalTextPosition());
            checkBox.setComponentOrientation(this.getComponentOrientation());
            checkBox.setFont(this.getFont());
            checkBox.setEnabled(this.isEnabled());
            checkBox.setOpaque(this.isOpaque());
            checkBox.setBorder(this.getBorder());
            if (!CheckList.this.listBox.hasFocus() && selected) {
                checkBox.setForeground(CheckList.this.listBox.getForeground());
                checkBox.setBackground(UIManager.getColor("Panel.background"));
            } else {
                checkBox.setForeground(this.getForeground());
                checkBox.setBackground(this.getBackground());
            }
        }

        private void updateCheckBoxVisual(CheckBox checkBox) {
            checkBox.setIcon(this.getIcon());
            checkBox.setText(this.getText());
            if (CheckList.this.isAccessibleContextInitialized()) {
                checkBox.getAccessibleContext().setAccessibleName(this.accessibleContext.getAccessibleName());
            }
        }
    }

    private class CheckBox
    extends JCheckBox {
        private CheckBox() {
            this.initialize();
        }

        private void initialize() {
            this.setRolloverEnabled(true);
            this.setBorderPainted(true);
        }

        public void setIcon(Icon icon) {
            if (UIManager.getLookAndFeel().getID().equals("GTK")) {
                return;
            }
            if (icon != null) {
                super.setIcon(new CompositeIcon(UIManager.getIcon("CheckBox.icon"), 3, icon));
            } else {
                super.setIcon(UIManager.getIcon("CheckBox.icon"));
            }
        }
    }
}

