/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractValidatingDialog;
import org.eclipse.persistence.tools.workbench.framework.uitools.AccessibleTitledPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingTools;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.MWProject;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.relational.MWRelationalProject;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.xml.MWEisLoginSpec;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.xml.MWEisProject;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.xml.MWOXProject;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.DefaultSPIManager;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.SPIManager;
import org.eclipse.persistence.tools.workbench.platformsmodel.DatabasePlatform;
import org.eclipse.persistence.tools.workbench.platformsmodel.DatabasePlatformRepository;
import org.eclipse.persistence.tools.workbench.platformsplugin.ui.PlatformComponentFactory;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.io.FileTools;

public final class ProjectCreationDialog
extends AbstractValidatingDialog {
    public static final String DATABASE_PLATFORM_PREFERENCE = "database platform";
    public static final String DATABASE_PLATFORM_PREFERENCE_DEFAULT = "Oracle11";
    private JTextField nameTextField;
    private JRadioButton relationalRadioButton;
    private JRadioButton xmlRadioButton;
    private JRadioButton eisRadioButton;
    private SimplePropertyValueModel databasePlatformHolder;
    private ComboBoxModel j2cAdapterComboBoxModel;

    ProjectCreationDialog(WorkbenchContext context) {
        super(context);
    }

    protected void initialize() {
        super.initialize();
        this.getOKAction().setEnabled(false);
    }

    protected Component buildMainPanel() {
        JPanel mainPanel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        this.setTitle(this.resourceRepository().getString("PROJECT_CREATION_DIALOG_TITLE"));
        JPanel namePanel = this.buildProjectNamePanel();
        this.helpManager().addTopicID(namePanel, this.helpTopicId() + ".name");
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 0, 0, 0);
        mainPanel.add((Component)namePanel, constraints);
        JPanel dataSourcePanel = this.buildDataSourcePanel();
        this.helpManager().addTopicID(dataSourcePanel, this.helpTopicId() + ".datasource");
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 2;
        constraints.anchor = 19;
        constraints.insets = new Insets(10, 0, 10, 0);
        mainPanel.add((Component)dataSourcePanel, constraints);
        return mainPanel;
    }

    private JPanel buildProjectNamePanel() {
        JPanel namePanel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        JLabel projectNameLabel = SwingComponentFactory.buildLabel("PROJECT_NAME_LABEL", this.resourceRepository());
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 0, 0, 0);
        namePanel.add((Component)projectNameLabel, constraints);
        this.nameTextField = new JTextField(35);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(1, 0, 0, 0);
        namePanel.add((Component)this.nameTextField, constraints);
        projectNameLabel.setLabelFor(this.nameTextField);
        this.nameTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                ProjectCreationDialog.this.updateDialog();
            }

            public void removeUpdate(DocumentEvent e) {
                ProjectCreationDialog.this.updateDialog();
            }

            public void changedUpdate(DocumentEvent e) {
                ProjectCreationDialog.this.updateDialog();
            }
        });
        return namePanel;
    }

    private JPanel buildDataSourcePanel() {
        JPanel datasourcePanel = new JPanel(new GridBagLayout());
        datasourcePanel.setBorder(BorderFactory.createTitledBorder(this.resourceRepository().getString("DATASOURCE_LABEL")));
        GridBagConstraints constraints = new GridBagConstraints();
        ButtonGroup buttonGroup = new ButtonGroup();
        this.relationalRadioButton = new JRadioButton();
        this.relationalRadioButton.setText(this.resourceRepository().getString("RELATIONAL_RADIO_BUTTON"));
        this.relationalRadioButton.setMnemonic(this.resourceRepository().getMnemonic("RELATIONAL_RADIO_BUTTON"));
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 5, 0, 0);
        datasourcePanel.add((Component)this.relationalRadioButton, constraints);
        buttonGroup.add(this.relationalRadioButton);
        this.relationalRadioButton.setSelected(true);
        JPanel relationalPanel = this.buildRelationalPanel();
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 5, 0, 0);
        datasourcePanel.add((Component)relationalPanel, constraints);
        this.eisRadioButton = new JRadioButton();
        this.eisRadioButton.setText(this.resourceRepository().getString("EIS_RADIO_BUTTON"));
        this.eisRadioButton.setMnemonic(this.resourceRepository().getMnemonic("EIS_RADIO_BUTTON"));
        constraints.gridx = 0;
        constraints.gridy = 4;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(5, 5, 0, 0);
        datasourcePanel.add((Component)this.eisRadioButton, constraints);
        buttonGroup.add(this.eisRadioButton);
        JPanel eisPanel = this.buildEisPanel();
        constraints.gridx = 0;
        constraints.gridy = 5;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 19;
        constraints.insets = new Insets(0, 5, 0, 0);
        datasourcePanel.add((Component)eisPanel, constraints);
        this.xmlRadioButton = new JRadioButton();
        this.xmlRadioButton.setText(this.resourceRepository().getString("XML_RADIO_BUTTON"));
        this.xmlRadioButton.setMnemonic(this.resourceRepository().getMnemonic("XML_RADIO_BUTTON"));
        constraints.gridx = 0;
        constraints.gridy = 6;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(5, 5, 0, 0);
        datasourcePanel.add((Component)this.xmlRadioButton, constraints);
        buttonGroup.add(this.xmlRadioButton);
        return datasourcePanel;
    }

    private JPanel buildRelationalPanel() {
        GridBagConstraints constraints = new GridBagConstraints();
        AccessibleTitledPanel relationalPanel = new AccessibleTitledPanel(new GridBagLayout());
        int offset = SwingTools.checkBoxIconWidth();
        final JLabel platformLabel = new JLabel(this.resourceRepository().getString("DATABASE_PLATFORM_LABEL"));
        platformLabel.setDisplayedMnemonic(this.resourceRepository().getMnemonic("DATABASE_PLATFORM_LABEL"));
        platformLabel.setDisplayedMnemonicIndex(this.resourceRepository().getMnemonicIndex("DATABASE_PLATFORM_LABEL"));
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, offset, 0, 0);
        relationalPanel.add((Component)platformLabel, constraints);
        String platformName = this.preferences().get(DATABASE_PLATFORM_PREFERENCE, DATABASE_PLATFORM_PREFERENCE_DEFAULT);
        this.databasePlatformHolder = new SimplePropertyValueModel();
        this.databasePlatformHolder.setValue(DatabasePlatformRepository.getDefault().platformNamed(platformName));
        final JComboBox databasePlatformChooser = PlatformComponentFactory.buildPlatformChooser(this.databasePlatformHolder);
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 5, 0, 5);
        relationalPanel.add((Component)databasePlatformChooser, constraints);
        platformLabel.setLabelFor(databasePlatformChooser);
        this.relationalRadioButton.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                databasePlatformChooser.setEnabled(ProjectCreationDialog.this.relationalRadioButton.isSelected());
                platformLabel.setEnabled(ProjectCreationDialog.this.relationalRadioButton.isSelected());
            }
        });
        return relationalPanel;
    }

    private JPanel buildEisPanel() {
        GridBagConstraints constraints = new GridBagConstraints();
        JPanel eisPanel = new JPanel(new GridBagLayout());
        int offset = SwingTools.checkBoxIconWidth();
        final JLabel adapterLabel = new JLabel(this.resourceRepository().getString("EIS_PLATFORM_LABEL"));
        adapterLabel.setDisplayedMnemonic(this.resourceRepository().getMnemonic("DATABASE_PLATFORM_LABEL"));
        adapterLabel.setDisplayedMnemonicIndex(this.resourceRepository().getMnemonicIndex("DATABASE_PLATFORM_LABEL"));
        adapterLabel.setEnabled(false);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, offset, 0, 0);
        eisPanel.add((Component)adapterLabel, constraints);
        this.j2cAdapterComboBoxModel = this.buildJ2CAdaptersComboBoxModel();
        final JComboBox adapterComboBox = new JComboBox(this.j2cAdapterComboBoxModel);
        String platformName = this.preferences().get("eis platform", MWEisLoginSpec.PLATFORM_PREFERENCE_DEFAULT);
        adapterComboBox.setSelectedItem(platformName);
        adapterComboBox.setEnabled(false);
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 5, 0, 5);
        eisPanel.add(adapterComboBox, constraints);
        adapterLabel.setLabelFor(adapterComboBox);
        this.eisRadioButton.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                adapterComboBox.setEnabled(ProjectCreationDialog.this.eisRadioButton.isSelected());
                adapterLabel.setEnabled(ProjectCreationDialog.this.eisRadioButton.isSelected());
            }
        });
        return eisPanel;
    }

    private void updateDialog() {
        String name = this.nameTextField.getText().trim();
        if (name.length() == 0) {
            this.setErrorMessageKey("PROJECT_CREATION_DIALOG_NO_FILE_NAME");
            this.getOKAction().setEnabled(false);
        } else if (FileTools.fileNameIsInvalid((String)name)) {
            this.setErrorMessageKey("PROJECT_CREATION_DIALOG_INVALID_FILE_NAME");
            this.getOKAction().setEnabled(false);
        } else {
            this.clearErrorMessage();
            this.getOKAction().setEnabled(true);
        }
    }

    private ComboBoxModel buildJ2CAdaptersComboBoxModel() {
        return new DefaultComboBoxModel(CollectionTools.vector((Iterator)this.supportedJ2CAdapters()));
    }

    MWProject getProject() {
        String projectName = this.nameTextField.getText().trim();
        DefaultSPIManager spiManager = new DefaultSPIManager(this.preferences(), projectName);
        if (this.relationalRadioButton.isSelected()) {
            DatabasePlatform platform = (DatabasePlatform)this.databasePlatformHolder.getValue();
            this.preferences().put(DATABASE_PLATFORM_PREFERENCE, platform.getName());
            return new MWRelationalProject(projectName, (SPIManager)spiManager, platform);
        }
        if (this.xmlRadioButton.isSelected()) {
            return new MWOXProject(projectName, (SPIManager)spiManager);
        }
        String platformName = (String)this.j2cAdapterComboBoxModel.getSelectedItem();
        this.preferences().put("eis platform", platformName);
        return new MWEisProject(projectName, platformName, (SPIManager)spiManager);
    }

    private Iterator supportedJ2CAdapters() {
        return MWEisLoginSpec.j2CAdapterNames();
    }

    protected String helpTopicId() {
        return "dialog.projectCreation";
    }

    protected Component initialFocusComponent() {
        return this.nameTextField;
    }
}

