/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.sourcegen;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.persistence.tools.workbench.framework.context.ApplicationContext;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassAttribute;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassCodeGenPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWDefaultMethodCodeGenPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWMethod;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWMethodCodeGenPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWZeroArgumentConstructorCodeGenPolicy;
import org.eclipse.persistence.tools.workbench.mappingsplugin.sourcegen.AbstractClassCodeGenPolicy;

abstract class DescriptorClassCodeGenPolicy
extends AbstractClassCodeGenPolicy {
    private MWDescriptor descriptor;
    private Map accessorCodeGenPolicies;

    protected DescriptorClassCodeGenPolicy(MWDescriptor descriptor, ApplicationContext context) {
        super(context);
        this.descriptor = descriptor;
        this.accessorCodeGenPolicies = new HashMap();
        this.initialize();
    }

    protected MWClass getMWClass() {
        return this.getDescriptor().getMWClass();
    }

    public MWMethodCodeGenPolicy getMethodCodeGenPolicy(MWMethod method) {
        if (method.isZeroArgumentConstructor()) {
            return new MWZeroArgumentConstructorCodeGenPolicy(method, this.getDescriptor(), (MWClassCodeGenPolicy)this);
        }
        if (this.accessorCodeGenPolicies.get(method) != null) {
            return (MWMethodCodeGenPolicy)this.accessorCodeGenPolicies.get(method);
        }
        return new MWDefaultMethodCodeGenPolicy(method, (MWClassCodeGenPolicy)this);
    }

    protected MWDescriptor getDescriptor() {
        return this.descriptor;
    }

    protected void initialize() {
        Iterator it = this.getDescriptor().getMWClass().attributes();
        while (it.hasNext()) {
            ((MWClassAttribute)it.next()).addAccessorCodeGenPoliciesTo((MWClassCodeGenPolicy)this);
        }
        it = this.getDescriptor().mappings();
        while (it.hasNext()) {
            MWMapping mapping = (MWMapping)it.next();
            mapping.getInstanceVariable().addAccessorCodeGenPoliciesTo((MWClassCodeGenPolicy)this, mapping);
        }
    }

    public void addAccessorCodeGenPolicy(MWMethod method, MWMethodCodeGenPolicy methodCodeGenPolicy) {
        this.accessorCodeGenPolicies.put(method, methodCodeGenPolicy);
    }
}

