/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPanel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.ClassAttributeAccessorsPanel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.ClassAttributeModifiersPanel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.ClassAttributeTypesPanel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;

final class ClassAttributePanel
extends AbstractPanel {
    private ValueModel attributeHolder;
    private ValueModel descriptorHolder;

    ClassAttributePanel(ValueModel attributeHolder, ValueModel descriptorHolder, WorkbenchContextHolder contextHolder) {
        super(contextHolder);
        this.attributeHolder = attributeHolder;
        this.descriptorHolder = descriptorHolder;
        this.initializeLayout();
    }

    private void initializeLayout() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        JTabbedPane tabbedPane = new JTabbedPane();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)tabbedPane, constraints);
        JPanel generalPage = new JPanel();
        generalPage.setBorder(BorderFactory.createEmptyBorder());
        generalPage.setLayout(new GridBagLayout());
        ClassAttributeModifiersPanel modifiersPanel = new ClassAttributeModifiersPanel(this.attributeHolder, this.descriptorHolder, this.getWorkbenchContextHolder());
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(5, 5, 0, 5);
        generalPage.add((Component)modifiersPanel, constraints);
        ClassAttributeTypesPanel typesPanel = new ClassAttributeTypesPanel(this.attributeHolder, this.getWorkbenchContextHolder());
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 2;
        constraints.anchor = 19;
        constraints.insets = new Insets(5, 5, 5, 5);
        generalPage.add((Component)typesPanel, constraints);
        this.addHelpTopicId(generalPage, this.helpTopicId() + ".general");
        tabbedPane.addTab(this.resourceRepository().getString("ATTRIBUTE_GENERAL_PAGE"), generalPage);
        JPanel accessorsPage = new JPanel(new GridBagLayout());
        ClassAttributeAccessorsPanel accessorsPanel = new ClassAttributeAccessorsPanel(this.attributeHolder, this.getWorkbenchContextHolder());
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 2;
        constraints.anchor = 19;
        constraints.insets = new Insets(5, 5, 5, 5);
        accessorsPage.add((Component)accessorsPanel, constraints);
        this.addHelpTopicId(accessorsPage, this.helpTopicId() + ".accessors");
        tabbedPane.addTab(this.resourceRepository().getString("ATTRIBUTE_ACCESSORS_PAGE"), accessorsPage);
    }

    private String helpTopicId() {
        return "descriptor.classInfo.attributes";
    }
}

