/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.Document;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.NewNameDialog;
import org.eclipse.persistence.tools.workbench.framework.ui.view.ScrollablePropertiesPage;
import org.eclipse.persistence.tools.workbench.framework.uitools.AddRemoveListPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.AddRemovePanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.RegexpDocument;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWMethod;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.cell.MethodCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.MethodPropertiesPanel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.project.ZeroArgConstructorPreference;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ItemPropertyListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SortedListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ObjectListSelectionModel;
import org.eclipse.persistence.tools.workbench.uitools.cell.AdaptableListCellRenderer;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.NameTools;

final class MethodsPropertiesPage
extends ScrollablePropertiesPage {
    private PropertyValueModel mwClassHolder;
    PropertyValueModel methodSelectionHolder;
    private MethodPropertiesPanel methodPropertiesPanel;
    private AddRemoveListPanel methodListPanel;

    MethodsPropertiesPage(PropertyValueModel descriptorNodeHolder, WorkbenchContextHolder contextHolder) {
        super(descriptorNodeHolder, contextHolder);
    }

    protected void initialize(PropertyValueModel nodeHolder) {
        super.initialize(nodeHolder);
        this.mwClassHolder = this.buildMWClassHolder();
        this.methodSelectionHolder = new SimplePropertyValueModel();
    }

    private PropertyValueModel buildMWClassHolder() {
        return new PropertyAspectAdapter(this.getSelectionHolder()){

            protected Object getValueFromSubject() {
                return ((MWDescriptor)this.subject).getMWClass();
            }
        };
    }

    protected String helpTopicId() {
        return "descriptor.classInfo.methods";
    }

    private CollectionValueModel buildMethodsHolder() {
        return new CollectionAspectAdapter(this.mwClassHolder, "methods"){

            protected Iterator getValueFromSubject() {
                return ((MWClass)this.subject).methods();
            }

            protected int sizeFromSubject() {
                return ((MWClass)this.subject).methodsSize();
            }
        };
    }

    protected Component buildPage() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        panel.setBorder(BorderFactory.createEmptyBorder());
        this.methodListPanel = new AddRemoveListPanel(this.getApplicationContext(), (AddRemovePanel.Adapter)this.buildAddRemoveListPanelAdapter(), this.buildMethodsListModel(), this.resourceRepository().getString("METHODS_LIST"));
        this.methodListPanel.setBorder(this.buildStandardEmptyBorder());
        this.methodListPanel.setCellRenderer(new AdaptableListCellRenderer(new MethodCellRendererAdapter(this.resourceRepository())));
        this.methodListPanel.addListSelectionListener(this.buildListSelectionListener(this.methodListPanel));
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 1.0;
        constraints.fill = 3;
        constraints.anchor = 10;
        constraints.insets = new Insets(5, 5, 5, 0);
        panel.add((Component)this.methodListPanel, constraints);
        this.methodPropertiesPanel = new MethodPropertiesPanel(this.methodSelectionHolder, this.getWorkbenchContextHolder());
        constraints.gridx = 2;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 3;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 10;
        constraints.insets = new Insets(5, 5, 5, 5);
        panel.add((Component)this.methodPropertiesPanel, constraints);
        this.addHelpTopicId(panel, this.helpTopicId());
        return panel;
    }

    private ListSelectionListener buildListSelectionListener(final AddRemoveListPanel methodsListPanel) {
        return new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                if (methodsListPanel.getSelectedValues().length > 1) {
                    MethodsPropertiesPage.this.methodSelectionHolder.setValue(null);
                } else {
                    MethodsPropertiesPage.this.methodSelectionHolder.setValue(methodsListPanel.getSelectedValue());
                }
            }
        };
    }

    private ListValueModel buildMethodsListModel() {
        return new ItemPropertyListValueModelAdapter(this.buildSortedMethodsListValueModelAdapter(), "modifierAccessLevel", "signature");
    }

    private SortedListValueModelAdapter buildSortedMethodsListValueModelAdapter() {
        return new SortedListValueModelAdapter(this.buildMethodNameAdapter());
    }

    private ItemPropertyListValueModelAdapter buildMethodNameAdapter() {
        return new ItemPropertyListValueModelAdapter(this.buildMethodsHolder(), "name");
    }

    private AddRemovePanel.OptionAdapter buildAddRemoveListPanelAdapter() {
        return new AddRemovePanel.OptionAdapter(){

            public void addNewItem(ObjectListSelectionModel listSelectionModel) {
                MethodsPropertiesPage.this.addNewMethod(listSelectionModel);
            }

            public void removeSelectedItems(ObjectListSelectionModel listSelectionModel) {
                MethodsPropertiesPage.this.removeMethods(CollectionTools.iterator((Object[])listSelectionModel.getSelectedValues()));
            }

            public void optionOnSelection(ObjectListSelectionModel listSelectionModel) {
                MethodsPropertiesPage.this.renameMethod(listSelectionModel);
            }

            public boolean enableOptionOnSelectionChange(ObjectListSelectionModel listSelectionModel) {
                return listSelectionModel.getSelectedValuesSize() == 1;
            }

            public String optionalButtonKey() {
                return "RENAME_BUTTON";
            }
        };
    }

    void addNewMethod(ObjectListSelectionModel listSelectionModel) {
        NewNameDialog.Builder builder = new NewNameDialog.Builder();
        builder.setIllegalNames(NameTools.javaReservedWords());
        builder.setTextFieldDescription(this.resourceRepository().getString("enterTheNameOfTheNewMethod.message"));
        builder.setTitle(this.resourceRepository().getString("addNewMethod.title"));
        builder.setHelpTopicId("dialog.newMethod");
        builder.setDocumentFactory(new NewNameDialog.DocumentFactory(){

            public Document buildDocument() {
                return new RegexpDocument(5);
            }
        });
        NewNameDialog dialog = builder.buildDialog(this.getWorkbenchContext());
        dialog.show();
        if (dialog.wasCanceled()) {
            return;
        }
        MWMethod newMethod = this.getMWClass().addMethod(dialog.getNewName());
        listSelectionModel.setSelectedValue(newMethod);
    }

    void removeMethods(Iterator selectedMethods) {
        while (selectedMethods.hasNext()) {
            this.getMWClass().removeMethod((MWMethod)selectedMethods.next());
        }
    }

    void renameMethod(ObjectListSelectionModel listSelectionModel) {
        MWMethod method = (MWMethod)listSelectionModel.getSelectedValue();
        NewNameDialog.Builder builder = new NewNameDialog.Builder();
        builder.setIllegalNames(NameTools.javaReservedWords());
        builder.setTextFieldDescription(this.resourceRepository().getString("EDIT_METHOD_DIALOG_MESSAGE"));
        builder.setTitle(this.resourceRepository().getString("EDIT_METHOD_DIALOG_TITLE"));
        builder.setHelpTopicId("dialog.newMethod");
        builder.setOriginalName(method.getName());
        builder.setDocumentFactory(new NewNameDialog.DocumentFactory(){

            public Document buildDocument() {
                return new RegexpDocument(5);
            }
        });
        NewNameDialog dialog = builder.buildDialog(this.getWorkbenchContext());
        dialog.show();
        if (dialog.wasCanceled()) {
            return;
        }
        String newMethodName = dialog.getNewName();
        if (method.isZeroArgumentConstructor()) {
            method.setName(newMethodName);
            ZeroArgConstructorPreference.optionallyAddZeroArgumentConstructor(this.getMWClass(), this.getWorkbenchContext());
        } else {
            method.setName(newMethodName);
        }
        listSelectionModel.setSelectedValue(method);
    }

    private MWClass getMWClass() {
        return (MWClass)this.mwClassHolder.getValue();
    }

    void selectMethod(MWMethod method) {
        this.methodListPanel.setSelectedValue(method, true);
    }
}

