/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractValidatingDialog;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWFieldTransformerAssociation;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.FieldTransformerAssociationEditingPanel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.TransformerEditingDialog;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.TransformerEditingPanel;

public abstract class FieldTransformerAssociationEditingDialog
extends AbstractValidatingDialog {
    protected FieldTransformerAssociationEditor associationEditor;
    protected PropertyChangeListener validatingListener;
    private boolean noError = true;

    protected FieldTransformerAssociationEditingDialog(FieldTransformerAssociationEditor associationEditor, WorkbenchContext context) {
        super(context);
        this.initialize(associationEditor);
    }

    protected void initialize() {
        super.initialize();
        this.setTitle(this.resourceRepository().getString("FIELD_TRANSFORMER_ASSOCIATION_EDITING_DIALOG.TITLE"));
        this.getOKAction().setEnabled(false);
    }

    protected void initialize(FieldTransformerAssociationEditor associationEditor) {
        this.associationEditor = associationEditor;
        this.validatingListener = this.buildValidatingListener();
        this.transformerSpec().transformationMethodHolder().addPropertyChangeListener("value", this.validatingListener);
        this.transformerSpec().transformerClassHolder().addPropertyChangeListener("value", this.validatingListener);
        this.transformerSpec().transformerTypeHolder().addPropertyChangeListener("value", this.validatingListener);
    }

    private PropertyChangeListener buildValidatingListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                FieldTransformerAssociationEditingDialog.this.updateMessage();
                FieldTransformerAssociationEditingDialog.this.updateOKAction();
            }
        };
    }

    protected void updateMessage() {
        if (this.transformerSpec().transformerType() == "nullTransformer") {
            this.setErrorMessageKey("FIELD_TRANSFORMER_ASSOCIATION_EDITING_DIALOG.NULL_TRANSFORMER_ERROR");
        } else if (this.transformerSpec().transformerType() == "transformerClass" && this.transformerSpec().transformerClass() == null) {
            this.setErrorMessageKey("FIELD_TRANSFORMER_ASSOCIATION_EDITING_DIALOG.NULL_TRANSFORMER_CLASS_ERROR");
        } else if (this.transformerSpec().transformerType() == "transformationMethod" && this.transformerSpec().transformationMethod() == null) {
            this.setErrorMessageKey("FIELD_TRANSFORMER_ASSOCIATION_EDITING_DIALOG.NULL_TRANSFORMATION_METHOD_ERROR");
        } else {
            this.clearErrorMessage();
        }
        if (this.transformerSpec().transformerType() == "transformationMethod" && this.transformerSpec().transformationMethod() != null && !this.transformerSpec().transformationMethodIsValid()) {
            this.setWarningMessageKey("FIELD_TRANSFORMER_ASSOCIATION_EDITING_DIALOG.INVALID_TRANSFORMATION_METHOD_WARNING");
        } else {
            this.clearWarningMessage();
        }
    }

    protected void setErrorMessage(String message) {
        super.setErrorMessage(message);
        this.noError = message == null;
    }

    protected void clearErrorMessage() {
        super.clearErrorMessage();
        this.noError = true;
    }

    private void updateOKAction() {
        this.getOKAction().setEnabled(this.noError);
    }

    protected String helpTopicId() {
        return "dialog.editFieldTransformerAssociation";
    }

    private TransformerEditingPanel.TransformerSpec transformerSpec() {
        return this.associationEditor.transformerSpec();
    }

    public static abstract class AbstractFieldTransformerAssociationEditor
    implements FieldTransformerAssociationEditor {
        protected MWFieldTransformerAssociation association;
        private TransformerEditingDialog.FieldTransformerEditor transformerEditor;

        protected AbstractFieldTransformerAssociationEditor(MWFieldTransformerAssociation association) {
            this.association = association;
            this.transformerEditor = new TransformerEditingDialog.FieldTransformerEditor(association);
        }

        public TransformerEditingPanel.TransformerSpec transformerSpec() {
            return this.transformerEditor;
        }

        public void commit() {
            this.transformerEditor.commit();
        }
    }

    public static interface FieldTransformerAssociationEditor
    extends FieldTransformerAssociationEditingPanel.FieldTransformerAssociationSpec {
        public void commit();
    }
}

