/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.Iterator;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.DefaultListChooser;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.DefaultListChooserDialog;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractSubjectPanel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWTypeConversionConverter;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWTypeDeclaration;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.cell.TypeDeclarationCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ComboBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.AdaptableListCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.chooser.ListChooser;
import org.eclipse.persistence.tools.workbench.utility.string.StringConverter;

final class TypeConversionConverterPanel
extends AbstractSubjectPanel {
    TypeConversionConverterPanel(PropertyValueModel typeConversionConverterHolder, WorkbenchContextHolder context) {
        super((ValueModel)typeConversionConverterHolder, context);
    }

    protected void initializeLayout() {
        GridBagConstraints constraints = new GridBagConstraints();
        JComponent dataTypeWidget = this.buildLabeledComponent("DATA_TYPE_LABEL", this.buildDataTypeChooser());
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)dataTypeWidget, constraints);
        JComponent attributeTypeWidget = this.buildLabeledComponent("ATTRIBUTE_TYPE_LABEL", this.buildAttributeTypeChooser());
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 2;
        constraints.anchor = 19;
        constraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)attributeTypeWidget, constraints);
        this.addHelpTopicId(this, this.helpTopicId());
    }

    private ListChooser buildDataTypeChooser() {
        DefaultListChooser chooser = new DefaultListChooser(this.buildDataTypeComboBoxModel(), this.getWorkbenchContextHolder(), this.buildDataTypeChooserDialogBuilder());
        chooser.setRenderer(this.buildTypeDeclarationListCellRenderer());
        return chooser;
    }

    private DefaultListChooserDialog.Builder buildDataTypeChooserDialogBuilder() {
        DefaultListChooserDialog.Builder builder = new DefaultListChooserDialog.Builder();
        builder.setTitleKey("DATA_TYPE_LIST_BROWSER_DIALOG.title");
        builder.setListBoxLabelKey("DATA_TYPE_LIST_BROWSER_DIALOG.listLabel");
        builder.setStringConverter(this.buildTypeDeclarationStringConverter());
        return builder;
    }

    private ComboBoxModel buildDataTypeComboBoxModel() {
        return new ComboBoxModelAdapter(this.buildTypesCollectionModel(), this.buildDataTypeHolder());
    }

    private PropertyValueModel buildDataTypeHolder() {
        return new PropertyAspectAdapter(this.getSubjectHolder(), "dataType"){

            protected Object getValueFromSubject() {
                return ((MWTypeConversionConverter)this.subject).getDataType();
            }

            protected void setValueOnSubject(Object value) {
                ((MWTypeConversionConverter)this.subject).setDataType((MWTypeDeclaration)value);
            }
        };
    }

    private CollectionValueModel buildTypesCollectionModel() {
        return new CollectionAspectAdapter(this.getSubjectHolder()){

            protected Iterator getValueFromSubject() {
                return ((MWTypeConversionConverter)this.subject).getBasicTypes().iterator();
            }
        };
    }

    private StringConverter buildTypeDeclarationStringConverter() {
        return new StringConverter(){

            public String convertToString(Object o) {
                return o == null ? "" : ((MWTypeDeclaration)o).displayStringWithPackage();
            }
        };
    }

    private ListCellRenderer buildTypeDeclarationListCellRenderer() {
        return new AdaptableListCellRenderer(new TypeDeclarationCellRendererAdapter(this.resourceRepository()));
    }

    private ListChooser buildAttributeTypeChooser() {
        DefaultListChooser chooser = new DefaultListChooser(this.buildAttributeTypeComboBoxModel(), this.getWorkbenchContextHolder(), this.buildAttributeTypeChooserDialogBuilder());
        chooser.setRenderer(this.buildTypeDeclarationListCellRenderer());
        return chooser;
    }

    private DefaultListChooserDialog.Builder buildAttributeTypeChooserDialogBuilder() {
        DefaultListChooserDialog.Builder builder = new DefaultListChooserDialog.Builder();
        builder.setTitleKey("ATTRIBUTE_TYPE_LIST_BROWSER_DIALOG.title");
        builder.setListBoxLabelKey("ATTRIBUTE_TYPE_LIST_BROWSER_DIALOG.listLabel");
        builder.setStringConverter(this.buildTypeDeclarationStringConverter());
        return builder;
    }

    private ComboBoxModel buildAttributeTypeComboBoxModel() {
        return new ComboBoxModelAdapter(this.buildTypesCollectionModel(), this.buildAttributeTypeHolder());
    }

    private PropertyValueModel buildAttributeTypeHolder() {
        return new PropertyAspectAdapter(this.getSubjectHolder(), "attributeType"){

            protected Object getValueFromSubject() {
                return ((MWTypeConversionConverter)this.subject).getAttributeType();
            }

            protected void setValueOnSubject(Object value) {
                ((MWTypeConversionConverter)this.subject).setAttributeType((MWTypeDeclaration)value);
            }
        };
    }

    protected String helpTopicId() {
        return "mapping.converter.typeConverter";
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        for (int i = this.getComponentCount() - 1; i >= 0; --i) {
            this.getComponent(i).setEnabled(enabled);
        }
    }
}

