/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.xml;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractSubjectPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.xml.MWAbstractCompositeMapping;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.xml.ContainerAccessorCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.xml.ContainerAccessorEditingDialog;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyCollectionValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ListModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.AdaptableListCellRenderer;

public final class ContainerAccessorPanel
extends AbstractSubjectPanel {
    JList accessorList;

    public ContainerAccessorPanel(ValueModel compositeMappingHolder, WorkbenchContextHolder contextHolder) {
        super(compositeMappingHolder, contextHolder);
    }

    protected void initializeLayout() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        JLabel label = this.buildContainerAccessorLabel();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)label, constraints);
        this.addAlignLeft(label);
        Component component = this.buildContainerAccessorComponent();
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 1;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 5, 0, 0);
        this.add(component, constraints);
        JButton button = this.buildContainerAccessorEditButton();
        constraints.gridx = 2;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)button, constraints);
        this.addAlignRight(button);
        label.setLabelFor(button);
        SwingComponentFactory.updateButtonAccessibleName(label, button);
        this.addHelpTopicId(this, "mapping.containerAccessor");
    }

    private Component buildContainerAccessorComponent() {
        this.accessorList = SwingComponentFactory.buildList(this.buildAccessorListModel());
        this.accessorList.setCellRenderer(this.buildAccessorListCellRenderer());
        this.accessorList.setDoubleBuffered(true);
        this.accessorList.setVisibleRowCount(1);
        this.accessorList.setPreferredSize(new Dimension(0, 0));
        return new JScrollPane(this.accessorList, 21, 31);
    }

    private ListModel buildAccessorListModel() {
        return new ListModelAdapter(this.buildAccessorCollectionValue());
    }

    private CollectionValueModel buildAccessorCollectionValue() {
        return new PropertyCollectionValueModelAdapter(this.buildAccessorPropertyValue());
    }

    private PropertyValueModel buildAccessorPropertyValue() {
        return new PropertyAspectAdapter(this.getSubjectHolder(), "containerAccessor"){

            protected Object getValueFromSubject() {
                return ((MWAbstractCompositeMapping)this.subject).getContainerAccessor();
            }
        };
    }

    private ListCellRenderer buildAccessorListCellRenderer() {
        return new AdaptableListCellRenderer(new ContainerAccessorCellRendererAdapter(this.resourceRepository()));
    }

    private JLabel buildContainerAccessorLabel() {
        return SwingComponentFactory.buildLabel("CONTAINER_ACCESSOR_LABEL", this.resourceRepository());
    }

    private JButton buildContainerAccessorEditButton() {
        JButton button = new JButton(this.resourceRepository().getString("CONTAINER_ACCESSOR_EDIT_BUTTON"));
        button.addActionListener(this.buildAttributeTransformerEditAction());
        return button;
    }

    private ActionListener buildAttributeTransformerEditAction() {
        return new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                MWAbstractCompositeMapping compositeMapping = (MWAbstractCompositeMapping)ContainerAccessorPanel.this.subject();
                WorkbenchContext context = ContainerAccessorPanel.this.getWorkbenchContext();
                ContainerAccessorEditingDialog.promptToEditContainerAccessor(compositeMapping, context);
            }
        };
    }

    public void setEnabled(boolean enabled) {
        if (this.isEnabled() == enabled) {
            return;
        }
        super.setEnabled(enabled);
        this.updateEnableStateOfChildren(enabled);
    }

    protected void updateEnableStateOfChildren(boolean enabled) {
        int index = this.getComponentCount();
        while (--index >= 0) {
            this.getComponent(index).setEnabled(enabled);
        }
        this.accessorList.setEnabled(enabled);
    }
}

