/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import javax.swing.ButtonModel;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.ListCellRenderer;
import javax.swing.SpinnerNumberModel;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractDialog;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.TopLinkOption;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWLockingPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWAbstractQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWAbstractReadQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWReadQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWRelationalQuery;
import org.eclipse.persistence.tools.workbench.uitools.ComponentEnabler;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.TransformationPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.CheckBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.NumberSpinnerModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.RadioButtonModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.SimpleListCellRenderer;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;

public abstract class QueryAdvancedOptionsDialog
extends AbstractDialog {
    private MWQuery query;
    private ButtonModel cacheQueryResultsButtonModel;
    private ButtonModel exclusiveConnectionButtonModel;
    private ComboBoxModel lockingComboBoxModel;
    private ComboBoxModel distinctStateComboBoxModel;
    private SpinnerNumberModel queryTimeoutSpinnerNumberModel;
    private ButtonModel maximumRowCheckBoxModel;
    private ButtonModel firstResultCheckBoxModel;
    private JSpinner maximumRowsSpinner;
    private SpinnerNumberModel maximumRowsSpinnerNumberModel;
    private JSpinner firstResultSpinner;
    private SpinnerNumberModel firstResultSpinnerNumberModel;
    private ButtonModel prepareCheckBoxModel;
    private ButtonModel maintainCacheCheckBoxModel;
    private ButtonModel useWrapperPolicyCheckBoxModel;
    private ButtonModel refreshRemoteIdentityMapCheckBoxModel;
    private boolean refreshIdentityMapResult;

    public QueryAdvancedOptionsDialog(MWQuery query, WorkbenchContext context) {
        super(context);
        this.query = query;
    }

    protected void initialize() {
        super.initialize();
        this.setTitle(this.resourceRepository().getString("ADVANCED_QUERY_OPTIONS_DIALOG.title"));
    }

    protected String helpTopicId() {
        return "dialog.advancedQueryOptions";
    }

    protected JCheckBox buildCacheQueryResultsCheckBox() {
        this.cacheQueryResultsButtonModel = this.buildCacheQueryResultsButtonModel();
        JCheckBox checkBox = SwingComponentFactory.buildCheckBox("CACHE_QUERY_RESULTS_CHECK_BOX", this.cacheQueryResultsButtonModel, this.resourceRepository());
        this.helpManager().addTopicID(checkBox, this.helpTopicId() + ".cacheQuery");
        checkBox.setSelected(this.query.isCacheQueryResults());
        return checkBox;
    }

    private ButtonModel buildCacheQueryResultsButtonModel() {
        return new CheckBoxModelAdapter(new SimplePropertyValueModel());
    }

    public boolean getCacheQueryResults() {
        return this.cacheQueryResultsButtonModel.isSelected();
    }

    protected JCheckBox buildExclusiveConnectionCheckBox() {
        this.exclusiveConnectionButtonModel = this.buildExclusiveConnectionButtonModel();
        JCheckBox checkBox = SwingComponentFactory.buildCheckBox("EXCLUSIVE_CONNECTION_CHECK_BOX", this.exclusiveConnectionButtonModel, this.resourceRepository());
        this.helpManager().addTopicID(checkBox, this.helpTopicId() + ".exclusiveConnection");
        checkBox.setSelected(this.query.isExclusiveConnection());
        return checkBox;
    }

    private ButtonModel buildExclusiveConnectionButtonModel() {
        return new CheckBoxModelAdapter(new SimplePropertyValueModel());
    }

    public boolean getExclusiveConnection() {
        return this.exclusiveConnectionButtonModel.isSelected();
    }

    protected JComboBox buildLockingOptionsComboBox() {
        this.lockingComboBoxModel = new DefaultComboBoxModel(CollectionTools.vector((Iterator)MWAbstractQuery.lockingOptions().toplinkOptions()));
        JComboBox comboBox = new JComboBox(this.lockingComboBoxModel);
        comboBox.setSelectedItem(this.query.getLocking());
        comboBox.addActionListener(this.buildLockingAction());
        comboBox.setRenderer(this.buildTopLinkModelOptionsCellRenderer());
        this.helpManager().addTopicID(comboBox, this.helpTopicId() + ".pesimisticLock");
        return comboBox;
    }

    private ListCellRenderer buildTopLinkModelOptionsCellRenderer() {
        return new SimpleListCellRenderer(){

            protected String buildText(Object value) {
                return QueryAdvancedOptionsDialog.this.resourceRepository().getString(((TopLinkOption)value).resourceKey());
            }
        };
    }

    private ActionListener buildLockingAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                QueryAdvancedOptionsDialog.this.setLocking();
            }
        };
    }

    protected void setLocking() {
        int input;
        MWLockingPolicy lockingPolicy = this.query.getOwningDescriptor().getLockingPolicy();
        String lockingMode = ((MWAbstractQuery.LockingModel)this.lockingComboBoxModel.getSelectedItem()).getMWModelOption();
        if (!(lockingMode == "Do Not Acquire Locks" || lockingMode != "Use Descriptor Setting" || lockingPolicy.getLockingType() != "Pessimistic Locking" || this.getRefreshIdentityMapResult() && this.getRefreshRemoteIdentityMapResult() || (input = JOptionPane.showConfirmDialog(this.getWorkbenchContext().getCurrentWindow(), this.resourceRepository().getString("SET_LOCKING_DIALOG_MESSAGE"), this.resourceRepository().getString("SET_REFRESH_IDENTITY_MAP_RESULTS.title"), 0, 3)) != 0)) {
            this.refreshRemoteIdentityMapCheckBoxModel.setSelected(true);
            this.refreshIdentityMapResult = true;
        }
    }

    public MWAbstractQuery.LockingModel getLocking() {
        return (MWAbstractQuery.LockingModel)this.lockingComboBoxModel.getSelectedItem();
    }

    protected JComboBox buildDistinctStateComboBox() {
        this.distinctStateComboBoxModel = new DefaultComboBoxModel(CollectionTools.vector((Iterator)MWAbstractQuery.distinctStateOptions().toplinkOptions()));
        JComboBox comboBox = new JComboBox(this.distinctStateComboBoxModel);
        comboBox.setSelectedItem(this.query.getDistinctState());
        comboBox.setRenderer(this.buildTopLinkModelOptionsCellRenderer());
        this.helpManager().addTopicID(comboBox, this.helpTopicId() + ".distinctState");
        return comboBox;
    }

    public MWAbstractQuery.DistinctStateModel getDistinctState() {
        return (MWAbstractQuery.DistinctStateModel)this.distinctStateComboBoxModel.getSelectedItem();
    }

    protected JRadioButton buildUseDescriptorTimeoutRadioButton(PropertyValueModel booleanHolder) {
        return SwingComponentFactory.buildRadioButton("QUERY_TIMEOUT_USE_DESCRIPTOR_SETTING", this.buildUseDescriptorTimeoutRadioButtonModel(booleanHolder), this.resourceRepository());
    }

    protected JRadioButton buildQueryTimeoutRadioButton(PropertyValueModel booleanHolder) {
        return SwingComponentFactory.buildRadioButton("QUERY_TIMEOUT_TIMEOUT", this.buildQueryTimeoutRadioButtonModel(booleanHolder), this.resourceRepository());
    }

    protected JRadioButton buildNoTimeoutRadioButton(PropertyValueModel booleanHolder) {
        return SwingComponentFactory.buildRadioButton("QUERY_TIMEOUT_NO_TIMEOUT", this.buildNoQueryTimeoutRadioButtonModel(booleanHolder), this.resourceRepository());
    }

    private RadioButtonModelAdapter buildUseDescriptorTimeoutRadioButtonModel(PropertyValueModel booleanHolder) {
        return new RadioButtonModelAdapter(booleanHolder, MWAbstractReadQuery.QUERY_TIMEOUT_UNDEFINED);
    }

    private RadioButtonModelAdapter buildQueryTimeoutRadioButtonModel(PropertyValueModel booleanHolder) {
        return new RadioButtonModelAdapter(booleanHolder, Boolean.TRUE);
    }

    private RadioButtonModelAdapter buildNoQueryTimeoutRadioButtonModel(PropertyValueModel booleanHolder) {
        return new RadioButtonModelAdapter(booleanHolder, MWAbstractReadQuery.QUERY_TIMEOUT_NO_TIMEOUT);
    }

    protected JSpinner buildQueryTimeoutSpinner(PropertyValueModel queryTimeoutHolder) {
        this.queryTimeoutSpinnerNumberModel = this.buildQueryTimeoutSpinnerModel(queryTimeoutHolder);
        JSpinner spinner = new JSpinner();
        spinner.setPreferredSize(new Dimension(65, 23));
        spinner.setMinimumSize(new Dimension(65, 23));
        spinner.setMaximumSize(new Dimension(65, 23));
        spinner.setModel(this.queryTimeoutSpinnerNumberModel);
        this.queryTimeoutSpinnerNumberModel.setValue(this.query.getQueryTimeout());
        return spinner;
    }

    private SpinnerNumberModel buildQueryTimeoutSpinnerModel(PropertyValueModel queryTimeoutHolder) {
        NumberSpinnerModelAdapter spinnerNumberModel = new NumberSpinnerModelAdapter(queryTimeoutHolder);
        spinnerNumberModel.setMinimum(new Integer(1));
        spinnerNumberModel.setMaximum(new Integer(99999));
        return spinnerNumberModel;
    }

    protected PropertyValueModel buildQueryTimeoutBooleanHolder(PropertyValueModel queryTimeoutHolder) {
        return new TransformationPropertyValueModel(queryTimeoutHolder){

            protected Object transform(Object value) {
                if (value == null) {
                    return null;
                }
                return (Integer)value > 0;
            }

            protected Object reverseTransform(Object value) {
                if (Boolean.TRUE.equals(value)) {
                    return (Integer)this.valueHolder.getValue() > 0 ? this.valueHolder.getValue() : new Integer(1);
                }
                return MWAbstractReadQuery.QUERY_TIMEOUT_NO_TIMEOUT;
            }
        };
    }

    protected ComponentEnabler buildQueryTimeoutSpinnerEnabler(PropertyValueModel queryTimeoutHolder, Component[] components) {
        TransformationPropertyValueModel booleanHolder = new TransformationPropertyValueModel(queryTimeoutHolder){

            protected Object transform(Object value) {
                return (Integer)value > 0;
            }
        };
        return new ComponentEnabler((ValueModel)booleanHolder, components);
    }

    public Integer getQueryTimeout() {
        return (Integer)this.queryTimeoutSpinnerNumberModel.getValue();
    }

    protected JCheckBox buildMaximumRowsCheckBox() {
        this.maximumRowCheckBoxModel = new CheckBoxModelAdapter(new SimplePropertyValueModel());
        JCheckBox checkBox = SwingComponentFactory.buildCheckBox("NO_MAXIMUM_CHECK_BOX", this.maximumRowCheckBoxModel, this.resourceRepository());
        checkBox.setSelected(this.query.getMaximumRows() == 0);
        checkBox.addActionListener(this.buildMaximumRowsAction(checkBox));
        return checkBox;
    }

    private ActionListener buildMaximumRowsAction(final JCheckBox checkBox) {
        return new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                QueryAdvancedOptionsDialog.this.setMaximumRows(checkBox);
            }
        };
    }

    protected void setMaximumRows(JCheckBox checkBox) {
        if (checkBox.isSelected()) {
            this.maximumRowsSpinner.setEnabled(false);
            this.maximumRowsSpinnerNumberModel.setMinimum(new Integer(0));
            this.maximumRowsSpinnerNumberModel.setValue(new Integer(0));
        } else {
            this.maximumRowsSpinner.setEnabled(true);
            this.maximumRowsSpinnerNumberModel.setValue(this.getMaximumRows() == 0 ? new Integer(1) : this.maximumRowsSpinnerNumberModel.getValue());
            this.maximumRowsSpinnerNumberModel.setMinimum(new Integer(1));
        }
    }

    protected JSpinner buildMaximumRowsSpinner() {
        this.maximumRowsSpinnerNumberModel = this.buildMaximumRowsSpinnerModel();
        this.maximumRowsSpinner = new JSpinner();
        this.maximumRowsSpinner.setEnabled(this.query.getMaximumRows() != 0);
        this.maximumRowsSpinner.setPreferredSize(new Dimension(65, 23));
        this.maximumRowsSpinner.setMinimumSize(new Dimension(65, 23));
        this.maximumRowsSpinner.setMaximumSize(new Dimension(65, 23));
        this.maximumRowsSpinner.setModel(this.maximumRowsSpinnerNumberModel);
        this.maximumRowsSpinner.setValue(new Integer(this.query.getMaximumRows()));
        return this.maximumRowsSpinner;
    }

    private SpinnerNumberModel buildMaximumRowsSpinnerModel() {
        NumberSpinnerModelAdapter spinnerNumberModel = new NumberSpinnerModelAdapter(new SimplePropertyValueModel());
        spinnerNumberModel.setMinimum(new Integer(0));
        spinnerNumberModel.setMaximum(null);
        return spinnerNumberModel;
    }

    public int getMaximumRows() {
        return (Integer)this.maximumRowsSpinner.getValue();
    }

    protected JCheckBox buildFirstResultCheckBox() {
        this.firstResultCheckBoxModel = new CheckBoxModelAdapter(new SimplePropertyValueModel());
        JCheckBox checkBox = SwingComponentFactory.buildCheckBox("SET_FIRST_RESULT_CHECK_BOX", this.firstResultCheckBoxModel, this.resourceRepository());
        checkBox.setSelected(this.query.getFirstResult() != 0);
        checkBox.addActionListener(this.buildFirstResultAction(checkBox));
        return checkBox;
    }

    private ActionListener buildFirstResultAction(final JCheckBox checkBox) {
        return new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                QueryAdvancedOptionsDialog.this.setFirstResult(checkBox);
            }
        };
    }

    protected void setFirstResult(JCheckBox checkBox) {
        if (!checkBox.isSelected()) {
            this.firstResultSpinner.setEnabled(false);
            this.firstResultSpinnerNumberModel.setMinimum(new Integer(0));
            this.firstResultSpinnerNumberModel.setValue(new Integer(0));
        } else {
            this.firstResultSpinner.setEnabled(true);
            this.firstResultSpinnerNumberModel.setValue(this.getFirstResult() == 0 ? new Integer(1) : this.firstResultSpinnerNumberModel.getValue());
            this.firstResultSpinnerNumberModel.setMinimum(new Integer(1));
        }
    }

    protected JSpinner buildFirstResultSpinner() {
        this.firstResultSpinnerNumberModel = this.buildFirstResultSpinnerModel();
        this.firstResultSpinner = new JSpinner();
        this.firstResultSpinner.setEnabled(this.query.getFirstResult() != 0);
        this.firstResultSpinner.setPreferredSize(new Dimension(65, 23));
        this.firstResultSpinner.setMinimumSize(new Dimension(65, 23));
        this.firstResultSpinner.setMaximumSize(new Dimension(65, 23));
        this.firstResultSpinner.setModel(this.firstResultSpinnerNumberModel);
        this.firstResultSpinner.setValue(new Integer(this.query.getFirstResult()));
        return this.firstResultSpinner;
    }

    private SpinnerNumberModel buildFirstResultSpinnerModel() {
        NumberSpinnerModelAdapter spinnerNumberModel = new NumberSpinnerModelAdapter(new SimplePropertyValueModel());
        spinnerNumberModel.setMinimum(new Integer(0));
        spinnerNumberModel.setMaximum(null);
        return spinnerNumberModel;
    }

    public int getFirstResult() {
        return (Integer)this.firstResultSpinner.getValue();
    }

    protected JCheckBox buildPrepareCheckBox() {
        this.prepareCheckBoxModel = new CheckBoxModelAdapter(new SimplePropertyValueModel());
        JCheckBox checkBox = SwingComponentFactory.buildCheckBox("PREPARE_CHECK_BOX", this.prepareCheckBoxModel, this.resourceRepository());
        checkBox.setSelected(((MWRelationalQuery)this.query).isPrepare());
        this.helpManager().addTopicID(checkBox, this.helpTopicId() + ".prepare");
        return checkBox;
    }

    public boolean getPrepare() {
        return this.prepareCheckBoxModel.isSelected();
    }

    protected JCheckBox buildMaintainCacheCheckBox() {
        this.maintainCacheCheckBoxModel = new CheckBoxModelAdapter(new SimplePropertyValueModel());
        JCheckBox checkBox = SwingComponentFactory.buildCheckBox("MAINTAIN_CACHE_CHECK_BOX", this.maintainCacheCheckBoxModel, this.resourceRepository());
        checkBox.addActionListener(this.buildMaintainCacheAction());
        checkBox.setSelected(((MWReadQuery)this.query).isMaintainCache());
        this.helpManager().addTopicID(checkBox, this.helpTopicId() + ".maintainCache");
        return checkBox;
    }

    private ActionListener buildMaintainCacheAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                QueryAdvancedOptionsDialog.this.setMaintainCache();
            }
        };
    }

    private void setMaintainCache() {
        int input;
        if (!this.getMaintainCache() && (this.getRefreshIdentityMapResult() || this.getRefreshRemoteIdentityMapResult()) && (input = JOptionPane.showConfirmDialog(this.getWorkbenchContext().getCurrentWindow(), this.resourceRepository().getString("SET_FALSE_MAINTAIN_CACHE_DIALOG_MESSAGE"), this.resourceRepository().getString("SET_REFRESH_IDENTITY_MAP_RESULTS.title"), 0, 3)) == 0) {
            this.refreshRemoteIdentityMapCheckBoxModel.setSelected(false);
            this.refreshIdentityMapResult = false;
        }
    }

    public boolean getMaintainCache() {
        return this.maintainCacheCheckBoxModel.isSelected();
    }

    protected JCheckBox buildUseWrapperPolicyCheckBox() {
        this.useWrapperPolicyCheckBoxModel = new CheckBoxModelAdapter(new SimplePropertyValueModel());
        JCheckBox checkBox = SwingComponentFactory.buildCheckBox("USE_WRAPPER_POLICY_CHECK_BOX", this.useWrapperPolicyCheckBoxModel, this.resourceRepository());
        checkBox.setSelected(((MWReadQuery)this.query).isUseWrapperPolicy());
        this.helpManager().addTopicID(checkBox, this.helpTopicId() + ".useWrapper");
        return checkBox;
    }

    public boolean getUseWrapperPolicy() {
        return this.useWrapperPolicyCheckBoxModel.isSelected();
    }

    protected JCheckBox buildRefreshRemoteIdentityMapCheckBox() {
        this.refreshRemoteIdentityMapCheckBoxModel = new CheckBoxModelAdapter(new SimplePropertyValueModel());
        JCheckBox checkBox = SwingComponentFactory.buildCheckBox("REFRESH_REMOTE_IDENTITY_MAP_RESULTS_CHECK_BOX", this.refreshRemoteIdentityMapCheckBoxModel, this.resourceRepository());
        checkBox.setSelected(((MWReadQuery)this.query).isRefreshRemoteIdentityMapResult());
        this.refreshIdentityMapResult = ((MWReadQuery)this.query).isRefreshIdentityMapResult();
        this.helpManager().addTopicID(checkBox, this.helpTopicId() + ".refreshRemote");
        return checkBox;
    }

    public boolean getRefreshRemoteIdentityMapResult() {
        return this.refreshRemoteIdentityMapCheckBoxModel.isSelected();
    }

    public boolean getRefreshIdentityMapResult() {
        return this.refreshIdentityMapResult;
    }

    protected MWQuery getQuery() {
        return this.query;
    }
}

