/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.ListCellRenderer;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWAutoGeneratedQueryFormat;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWEJBQLQueryFormat;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWExpressionQueryFormat;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWQueryFormat;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWRelationalQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWSQLQueryFormat;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWStoredProcedureQueryFormat;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWStringQueryFormat;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.ExpressionQueryFormatSubPanel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.StoredProcedureQueryFormatSubPanel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.StringQueryFormatSubPanel;
import org.eclipse.persistence.tools.workbench.uitools.ComponentEnabler;
import org.eclipse.persistence.tools.workbench.uitools.LabelArea;
import org.eclipse.persistence.tools.workbench.uitools.SwitcherPanel;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ReadOnlyCollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.TransformationPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.TransformationValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ComboBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.SimpleListCellRenderer;
import org.eclipse.persistence.tools.workbench.utility.Transformer;
import org.eclipse.persistence.tools.workbench.utility.TriStateBoolean;

public final class QuerySelectionCriteriaPanel
extends AbstractPanel {
    private AutoGeneratedQueryFormatPanel autoGeneratedQueryFormatPanel;
    private NonAutoGeneratedQueryFormatPanel nonAutoGeneratedQueryFormatPanel;
    private Map<Class<? extends MWQueryFormat>, JComponent> queryFormatPanelMap;
    private PropertyValueModel queryHolder;

    public QuerySelectionCriteriaPanel(PropertyValueModel queryHolder, WorkbenchContextHolder workbenchContextHolder) {
        super(workbenchContextHolder);
        this.addHelpTopicId(this, this.helpTopicId());
        this.queryHolder = queryHolder;
        this.initializeLayout();
    }

    private Transformer buildPaneTransformer() {
        return new Transformer(){

            public JComponent transform(Object queryFormat) {
                if (queryFormat == null) {
                    return null;
                }
                return (JComponent)QuerySelectionCriteriaPanel.this.queryFormatPanelMap.get(queryFormat.getClass());
            }
        };
    }

    private PropertyValueModel buildQueryFormatHolder() {
        return new PropertyAspectAdapter(this.buildRelationalOptionsHolder(), "queryFormatType"){

            protected Object getValueFromSubject() {
                return ((MWRelationalQuery)this.subject).getQueryFormat();
            }
        };
    }

    private ValueModel buildRelationalOptionsHolder() {
        return new TransformationValueModel(this.buildRelationalQueryHolder()){

            protected Object transformNonNull(Object value) {
                return ((MWRelationalQuery)value).getRelationalOptions();
            }
        };
    }

    private ValueModel buildRelationalQueryHolder() {
        return new TransformationValueModel(this.queryHolder){

            protected Object transformNonNull(Object value) {
                return value;
            }
        };
    }

    private String helpTopicId() {
        return "descriptor.queries.format";
    }

    protected void initializeLayout() {
        GridBagConstraints constraints = new GridBagConstraints();
        this.initializeMaps();
        SwitcherPanel switcherPane = new SwitcherPanel(this.buildQueryFormatHolder(), this.buildPaneTransformer());
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 19;
        constraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)switcherPane, constraints);
    }

    private PropertyValueModel buildAutoGeneratorQueryFormatHolder() {
        return new TransformationPropertyValueModel(this.buildQueryFormatHolder()){

            protected MWAutoGeneratedQueryFormat transform(Object value) {
                return value instanceof MWAutoGeneratedQueryFormat ? (MWAutoGeneratedQueryFormat)value : null;
            }
        };
    }

    private void initializeMaps() {
        this.autoGeneratedQueryFormatPanel = new AutoGeneratedQueryFormatPanel(this.queryHolder, this.buildAutoGeneratorQueryFormatHolder(), this.getWorkbenchContextHolder());
        this.nonAutoGeneratedQueryFormatPanel = new NonAutoGeneratedQueryFormatPanel(this.queryHolder, this.buildQueryFormatHolder(), this.getWorkbenchContextHolder());
        this.queryFormatPanelMap = new Hashtable<Class<? extends MWQueryFormat>, JComponent>();
        this.queryFormatPanelMap.put(MWAutoGeneratedQueryFormat.class, this.autoGeneratedQueryFormatPanel);
        this.queryFormatPanelMap.put(MWExpressionQueryFormat.class, this.nonAutoGeneratedQueryFormatPanel);
        this.queryFormatPanelMap.put(MWStoredProcedureQueryFormat.class, this.nonAutoGeneratedQueryFormatPanel);
        this.queryFormatPanelMap.put(MWSQLQueryFormat.class, this.nonAutoGeneratedQueryFormatPanel);
        this.queryFormatPanelMap.put(MWEJBQLQueryFormat.class, this.nonAutoGeneratedQueryFormatPanel);
    }

    private boolean promptToChangeSelectionCriteriaType() {
        if (this.preferences().getBoolean("query change query format", false)) {
            return true;
        }
        String title = this.resourceRepository().getString("QUERY_QUERY_FORMAT_TITLE");
        String message = this.resourceRepository().getString("QUERY_QUERY_FORMAT_MESSAGE");
        SimplePropertyValueModel dontAskAgainHolder = new SimplePropertyValueModel(new Boolean(false));
        JComponent dontAskAgainPanel = SwingComponentFactory.buildDoNotAskAgainPanel(message, dontAskAgainHolder, this.resourceRepository());
        int response = JOptionPane.showConfirmDialog(this.getWorkbenchContext().getCurrentWindow(), dontAskAgainPanel, title, 0, 2);
        if (dontAskAgainHolder.getValue().equals(Boolean.TRUE)) {
            if (response == 0) {
                this.preferences().putBoolean("query change query format", true);
            } else if (response == 1) {
                this.preferences().putBoolean("query change query format", false);
            }
        }
        return response == 0;
    }

    private boolean queryFormatCanChange() {
        boolean changeQueryType;
        String promptValue = TriStateBoolean.UNDEFINED.toString();
        String value = this.preferences().get("query change query format", "undefined");
        if (value.equals(promptValue)) {
            changeQueryType = this.promptToChangeSelectionCriteriaType();
        } else {
            changeQueryType = TriStateBoolean.TRUE.toString().equals(value);
            if (!changeQueryType) {
                JOptionPane.showMessageDialog(this.getRootPane(), this.resourceRepository().getString("QUERY_FORMAT_CHANGE_DISSALLOWED"), this.application().getShortProductName(), 1);
            }
        }
        return changeQueryType;
    }

    private final class NonAutoGeneratedQueryFormatPanel
    extends AbstractQueryFormatPanel {
        private ExpressionQueryFormatSubPanel expressionPanel;
        private StoredProcedureQueryFormatSubPanel storedProcedurePanel;
        private StringQueryFormatSubPanel stringQueryFormatPanel;
        private Map<Class<? extends MWQueryFormat>, JComponent> subQueryFormatPanelMap;

        public NonAutoGeneratedQueryFormatPanel(PropertyValueModel queryHolder, PropertyValueModel queryFormatHolder, WorkbenchContextHolder workbenchContextHolder) {
            super(queryHolder, queryFormatHolder, workbenchContextHolder);
        }

        private ValueModel buildExpressionQueryFormatHolder() {
            return new TransformationPropertyValueModel(this.queryFormatHolder){

                protected Object transform(Object value) {
                    return value instanceof MWExpressionQueryFormat ? (MWExpressionQueryFormat)value : null;
                }
            };
        }

        private ValueModel buildStoredProcedureQueryFormatHolder() {
            return new TransformationValueModel(this.queryFormatHolder){

                protected Object transform(Object value) {
                    return value instanceof MWStoredProcedureQueryFormat ? (MWStoredProcedureQueryFormat)value : null;
                }
            };
        }

        private Transformer buildPaneTransformer() {
            return new Transformer(){

                public JComponent transform(Object queryFormat) {
                    if (queryFormat == null) {
                        return null;
                    }
                    return (JComponent)NonAutoGeneratedQueryFormatPanel.this.subQueryFormatPanelMap.get(queryFormat.getClass());
                }
            };
        }

        private ValueModel buildQueryComponentEnableBooleanHolder() {
            return new TransformationValueModel(this.queryFormatHolder){

                protected Object transform(Object value) {
                    return value != null;
                }
            };
        }

        private PropertyValueModel buildQueryFormatTypeHolder() {
            return new PropertyAspectAdapter(QuerySelectionCriteriaPanel.this.buildRelationalOptionsHolder(), "queryFormatType"){

                protected Object getValueFromSubject() {
                    return ((MWRelationalQuery)this.subject).getQueryFormatType();
                }

                protected void setValueOnSubject(Object value) {
                    if (QuerySelectionCriteriaPanel.this.queryFormatCanChange()) {
                        ((MWRelationalQuery)this.subject).setQueryFormatType((String)value);
                    }
                }
            };
        }

        private ListCellRenderer buildSelectionCriteraCellRenderer() {
            return new SimpleListCellRenderer(){

                public String buildText(Object value) {
                    if (value == "expressionFormat") {
                        return NonAutoGeneratedQueryFormatPanel.this.resourceRepository().getString("EXPRESSION_OPTION");
                    }
                    if (value == "storedProcedure") {
                        return NonAutoGeneratedQueryFormatPanel.this.resourceRepository().getString("STORED_PROCEDURE_OPTION");
                    }
                    if (value == "sqlFormat") {
                        return NonAutoGeneratedQueryFormatPanel.this.resourceRepository().getString("SQL_OPTION");
                    }
                    return NonAutoGeneratedQueryFormatPanel.this.resourceRepository().getString("EJBQL_OPTION");
                }
            };
        }

        private ComboBoxModel buildSelectionCriteriaComboModel() {
            return new ComboBoxModelAdapter(this.selectionCriteriaOptionsModel(), this.buildQueryFormatTypeHolder());
        }

        private ValueModel buildStringQueryFormatHolder() {
            return new TransformationValueModel(this.queryFormatHolder){

                protected Object transform(Object value) {
                    return value instanceof MWStringQueryFormat ? (MWStringQueryFormat)value : null;
                }
            };
        }

        protected void initializeLayout() {
            GridBagConstraints constraints = new GridBagConstraints();
            this.initializeMaps();
            JComponent queryFormatTypeWidgets = this.buildLabeledComboBox("SELECTION_CRITERIA_TYPE_LABEL", this.buildSelectionCriteriaComboModel(), this.buildSelectionCriteraCellRenderer());
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.weightx = 1.0;
            constraints.weighty = 0.0;
            constraints.fill = 2;
            constraints.anchor = 19;
            constraints.insets = new Insets(0, 0, 0, 0);
            this.add((Component)queryFormatTypeWidgets, constraints);
            new ComponentEnabler(this.buildQueryComponentEnableBooleanHolder(), queryFormatTypeWidgets);
            SwitcherPanel switcherPane = new SwitcherPanel(this.queryFormatHolder, this.buildPaneTransformer());
            constraints.gridx = 0;
            constraints.gridy = 1;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.weightx = 1.0;
            constraints.weighty = 1.0;
            constraints.fill = 1;
            constraints.anchor = 21;
            constraints.insets = new Insets(5, 0, 0, 0);
            this.add((Component)switcherPane, constraints);
        }

        private void initializeMaps() {
            this.stringQueryFormatPanel = new StringQueryFormatSubPanel(this.buildStringQueryFormatHolder(), this.getWorkbenchContextHolder());
            this.expressionPanel = new ExpressionQueryFormatSubPanel(this.buildExpressionQueryFormatHolder(), this.getWorkbenchContextHolder());
            this.storedProcedurePanel = new StoredProcedureQueryFormatSubPanel(this.buildStoredProcedureQueryFormatHolder(), this.getWorkbenchContextHolder());
            this.subQueryFormatPanelMap = new Hashtable<Class<? extends MWQueryFormat>, JComponent>();
            this.subQueryFormatPanelMap.put(MWExpressionQueryFormat.class, this.expressionPanel);
            this.subQueryFormatPanelMap.put(MWStoredProcedureQueryFormat.class, this.storedProcedurePanel);
            this.subQueryFormatPanelMap.put(MWSQLQueryFormat.class, this.stringQueryFormatPanel);
            this.subQueryFormatPanelMap.put(MWEJBQLQueryFormat.class, this.stringQueryFormatPanel);
        }

        private CollectionValueModel selectionCriteriaOptionsModel() {
            ArrayList<String> options = new ArrayList<String>();
            options.add("expressionFormat");
            options.add("storedProcedure");
            options.add("sqlFormat");
            options.add("ejbqlFormat");
            return new ReadOnlyCollectionValueModel(options);
        }
    }

    private final class AutoGeneratedQueryFormatPanel
    extends AbstractQueryFormatPanel {
        public AutoGeneratedQueryFormatPanel(PropertyValueModel queryHolder, PropertyValueModel queryFormatHolder, WorkbenchContextHolder workbenchContextHolder) {
            super(new BorderLayout(), queryHolder, queryFormatHolder, workbenchContextHolder);
        }

        protected void initializeLayout() {
            LabelArea autoGenCommentArea = new LabelArea();
            SwingComponentFactory.setTextFor(autoGenCommentArea, "AUTO_GENERATED_QUERY_COMMENT", this.resourceRepository());
            autoGenCommentArea.setScrollable(true);
            autoGenCommentArea.setFocusable(true);
            autoGenCommentArea.setRequestFocusEnabled(true);
            this.add((Component)autoGenCommentArea, "First");
        }
    }

    private abstract class AbstractQueryFormatPanel
    extends AbstractPanel {
        protected PropertyValueModel queryHolder;
        protected PropertyValueModel queryFormatHolder;

        protected AbstractQueryFormatPanel(LayoutManager layoutManager, PropertyValueModel queryHolder, PropertyValueModel queryFormatHolder, WorkbenchContextHolder workbenchContextHolder) {
            super(layoutManager, workbenchContextHolder);
            this.queryFormatHolder = queryFormatHolder;
            this.queryHolder = queryHolder;
            this.initializeLayout();
        }

        protected AbstractQueryFormatPanel(PropertyValueModel queryHolder, PropertyValueModel queryFormatHolder, WorkbenchContextHolder workbenchContextHolder) {
            super(workbenchContextHolder);
            this.queryFormatHolder = queryFormatHolder;
            this.queryHolder = queryHolder;
            this.initializeLayout();
        }

        protected abstract void initializeLayout();
    }
}

