/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JTabbedPane;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPanel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWGroupingItem;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWQueryItem;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWReportAttributeItem;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.Ordering;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.QueryGeneralPanel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.QueryQuickViewItem;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.QuickViewPanel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.QuerySelectionCriteriaPanel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.ReportQueryAttributesPanel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.ReportQueryGroupingOrderingPanel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.ReportQueryOptionsPanel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ObjectListSelectionModel;

final class ReportQueryPanel
extends AbstractPanel {
    private PropertyValueModel queryHolder;
    private JTabbedPane queryPropertiesPane;
    private ReportQueryAttributesPanel attributesPanel;
    private QuerySelectionCriteriaPanel queryFormatPanel;
    private QueryGeneralPanel queryGeneralPanel;
    private ReportQueryGroupingOrderingPanel queryGroupingOrderingPanel;
    private ReportQueryOptionsPanel queryOptionsPanel;

    ReportQueryPanel(PropertyValueModel queryHolder, ObjectListSelectionModel querySelectionModel, WorkbenchContextHolder contextHolder) {
        super((LayoutManager)new BorderLayout(), contextHolder);
        this.queryHolder = queryHolder;
        this.initializeLayout(querySelectionModel);
    }

    private void initializeLayout(ObjectListSelectionModel querySelectionModel) {
        this.queryGeneralPanel = new QueryGeneralPanel(this.queryHolder, querySelectionModel, this.getWorkbenchContextHolder());
        this.attributesPanel = new ReportQueryAttributesPanel(this.queryHolder, this.getWorkbenchContextHolder());
        this.queryFormatPanel = new QuerySelectionCriteriaPanel(this.queryHolder, this.getWorkbenchContextHolder());
        this.queryGroupingOrderingPanel = new ReportQueryGroupingOrderingPanel(this.queryHolder, this.getWorkbenchContextHolder());
        this.queryOptionsPanel = new ReportQueryOptionsPanel(this.queryHolder, this.getWorkbenchContextHolder());
        this.queryPropertiesPane = new JTabbedPane();
        this.queryPropertiesPane.addTab(this.resourceRepository().getString("GENERAL_TAB"), this.queryGeneralPanel);
        this.queryPropertiesPane.addTab(this.resourceRepository().getString("ATTRIBUTES_TAB"), this.attributesPanel);
        this.queryPropertiesPane.addTab(this.resourceRepository().getString("FORMAT_TAB"), this.queryFormatPanel);
        this.queryPropertiesPane.addTab(this.resourceRepository().getString("GROUP_ORDER_TAB"), this.queryGroupingOrderingPanel);
        this.queryPropertiesPane.addTab(this.resourceRepository().getString("OPTIONS_TAB"), this.queryOptionsPanel);
        this.add((Component)this.queryPropertiesPane, "Center");
    }

    protected void selectReportQueryAttributesTab() {
        this.queryPropertiesPane.setSelectedComponent(this.attributesPanel);
    }

    protected void selectReportQueryGroupingOrderingTab() {
        this.queryPropertiesPane.setSelectedComponent(this.queryGroupingOrderingPanel);
    }

    protected QueryGeneralPanel getQueryGeneralPanel() {
        return this.queryGeneralPanel;
    }

    protected JTabbedPane getQueryTabbedPane() {
        return this.queryPropertiesPane;
    }

    protected QuickViewPanel.QuickViewItem buildReportAttributeQuickViewItem(MWReportAttributeItem attributeItem) {
        return new QueryQuickViewItem((MWQueryItem)attributeItem){

            public void select() {
                ReportQueryPanel.this.queryPropertiesPane.setSelectedComponent(ReportQueryPanel.this.attributesPanel);
                ReportQueryPanel.this.attributesPanel.select((MWQueryItem)((MWReportAttributeItem)this.getValue()));
            }
        };
    }

    protected QuickViewPanel.QuickViewItem buildGroupingAttributeQuickViewItem(MWGroupingItem groupingItem) {
        return new QueryQuickViewItem((MWQueryItem)groupingItem){

            public void select() {
                ReportQueryPanel.this.queryPropertiesPane.setSelectedComponent(ReportQueryPanel.this.queryGroupingOrderingPanel);
                ReportQueryPanel.this.queryGroupingOrderingPanel.selectGroupingItem((MWGroupingItem)this.getValue());
            }
        };
    }

    protected QuickViewPanel.QuickViewItem buildOrderingAttributeQuickViewItem(Ordering orderingItem) {
        return new QueryQuickViewItem((MWQueryItem)orderingItem){

            public void select() {
                ReportQueryPanel.this.queryPropertiesPane.setSelectedComponent(ReportQueryPanel.this.queryGroupingOrderingPanel);
                ReportQueryPanel.this.queryGroupingOrderingPanel.selectOrderingItem((Ordering)this.getValue());
            }
        };
    }
}

