/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.platformsplugin.ui;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.platformsmodel.DatabasePlatform;
import org.eclipse.persistence.tools.workbench.platformsmodel.DatabasePlatformRepository;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimpleListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ComboBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.SimpleListCellRenderer;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;

public final class PlatformComponentFactory {
    private PlatformComponentFactory() {
    }

    static ListValueModel buildDatabasePlatformCollectionHolder() {
        ArrayList platforms = new ArrayList(DatabasePlatformRepository.getDefault().platformsSize());
        CollectionTools.addAll(platforms, (Iterator)DatabasePlatformRepository.getDefault().platforms());
        CollectionTools.sort(platforms, (Comparator)new PlatformComparator());
        for (int i = 0; i < platforms.size(); ++i) {
            DatabasePlatform platform = (DatabasePlatform)platforms.get(i);
            String platformName = platform.getName().toLowerCase();
            if (platformName.indexOf("oracle") != -1) continue;
            platforms.add(i, null);
            break;
        }
        return new SimpleListValueModel(platforms);
    }

    public static JComboBox buildPlatformChooser(PropertyValueModel selectionHolder) {
        return new PlatformChooser(selectionHolder);
    }

    public static JList buildPlatformList(PropertyValueModel selectionHolder) {
        return new PlatformList(selectionHolder);
    }

    private static class PlatformModelAdapter
    extends ComboBoxModelAdapter {
        PlatformModelAdapter(ListValueModel listHolder, PropertyValueModel selectionHolder) {
            super(listHolder, selectionHolder);
        }

        public int indexOf(Object item) {
            Iterator iter = (Iterator)this.listHolder.getValue();
            int index = 0;
            boolean found = false;
            while (iter.hasNext()) {
                if (item == iter.next()) {
                    found = true;
                    break;
                }
                ++index;
            }
            if (!found) {
                index = -1;
            }
            return index;
        }

        public void setSelectedItem(Object item) {
            if (item == null) {
                int oldIndex;
                int newIndex = this.indexOf(item);
                item = newIndex > (oldIndex = this.indexOf(this.getSelectedItem())) ? this.getElementAt(++newIndex) : this.getElementAt(--newIndex);
            }
            super.setSelectedItem(item);
        }
    }

    private static class PlatformList
    extends SwingComponentFactory.AccessibleList {
        public PlatformList(PropertyValueModel platformSelectionHolder) {
            this.setModel(new PlatformModelAdapter(PlatformComponentFactory.buildDatabasePlatformCollectionHolder(), platformSelectionHolder));
            this.setCellRenderer(new PlatformCellRenderer());
            this.addListSelectionListener(this.buildListSelectionListener(platformSelectionHolder));
        }

        private ListSelectionListener buildListSelectionListener(final PropertyValueModel platformSelectionHolder) {
            return new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting()) {
                        platformSelectionHolder.setValue(PlatformList.this.getSelectedValue());
                    }
                }
            };
        }
    }

    private static class PlatformComparator
    implements Comparator {
        private PlatformComparator() {
        }

        public int compare(Object o1, Object o2) {
            boolean oraclePlatform2;
            DatabasePlatform platform1 = (DatabasePlatform)o1;
            DatabasePlatform platform2 = (DatabasePlatform)o2;
            String platformName1 = platform1.getName().toLowerCase();
            String platformName2 = platform2.getName().toLowerCase();
            boolean oraclePlatform1 = platformName1.indexOf("oracle") != -1;
            boolean bl = oraclePlatform2 = platformName2.indexOf("oracle") != -1;
            if (oraclePlatform1 && !oraclePlatform2) {
                return -1;
            }
            if (!oraclePlatform1 && oraclePlatform2) {
                return 1;
            }
            if (oraclePlatform1) {
                return this.oracleVersionNumber(platformName2) - this.oracleVersionNumber(platformName1);
            }
            return platform1.compareTo((Object)platform2);
        }

        private int oracleVersionNumber(String oraclePlatformName) {
            StringBuffer sb = new StringBuffer();
            int len = oraclePlatformName.length();
            for (int i = 0; i < len; ++i) {
                char c = oraclePlatformName.charAt(i);
                if (!Character.isDigit(c)) continue;
                sb.append(c);
            }
            return sb.length() == 0 ? 0 : Integer.parseInt(sb.toString());
        }
    }

    private static class PlatformCellRenderer
    extends SimpleListCellRenderer {
        private PlatformCellRenderer() {
        }

        private String buildSeparator(JList list) {
            int width = list.getSize().width - list.getInsets().left - list.getInsets().right;
            int length = width / SwingUtilities.computeStringWidth(list.getFontMetrics(list.getFont()), "\u2212") - 2;
            StringBuffer sb = new StringBuffer(" ");
            for (int i = 0; i < length; ++i) {
                sb.append("\u2212");
            }
            return sb.toString();
        }

        protected String buildText(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            return value == null ? this.buildSeparator(list) : ((DatabasePlatform)value).getName();
        }
    }

    private static class PlatformChooser
    extends JComboBox {
        public PlatformChooser(PropertyValueModel platformSelectionHolder) {
            this.setModel(new PlatformModelAdapter(PlatformComponentFactory.buildDatabasePlatformCollectionHolder(), platformSelectionHolder));
            this.setRenderer(new PlatformCellRenderer());
        }
    }
}

