/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.platformsplugin.ui.platform;

import java.util.Iterator;
import javax.swing.tree.TreePath;
import org.eclipse.persistence.tools.workbench.framework.action.AbstractFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.NewNameDialog;
import org.eclipse.persistence.tools.workbench.platformsmodel.DatabasePlatform;
import org.eclipse.persistence.tools.workbench.platformsmodel.DatabasePlatformRepository;
import org.eclipse.persistence.tools.workbench.platformsplugin.ui.platform.DatabasePlatformNode;
import org.eclipse.persistence.tools.workbench.utility.iterators.TransformationIterator;

final class RenameDatabasePlatformAction
extends AbstractFrameworkAction {
    public RenameDatabasePlatformAction(WorkbenchContext context) {
        super(context);
    }

    protected void initialize() {
        this.initializeTextAndMnemonic("RENAME_DATABASE_PLATFORM");
        this.initializeIcon("RENAME_DATABASE_PLATFORM");
        this.initializeToolTipText("RENAME_DATABASE_PLATFORM.TOOL_TIP");
    }

    protected void execute() {
        TreePath[] paths = this.navigatorSelectionModel().getSelectionPaths();
        NewNameDialog.Builder builder = this.buildNewNameDialogBuilder();
        ApplicationNode[] nodes = this.selectedNodes();
        int i = nodes.length;
        while (i-- > 0) {
            this.execute(((DatabasePlatformNode)nodes[i]).getDatabasePlatform(), builder);
        }
        this.navigatorSelectionModel().setSelectionPaths(paths);
    }

    private NewNameDialog.Builder buildNewNameDialogBuilder() {
        NewNameDialog.Builder builder = new NewNameDialog.Builder();
        builder.setTitle(this.resourceRepository().getString("RENAME_DATABASE_PLATFORM_DIALOG_TITLE"));
        builder.setTextFieldDescription(this.resourceRepository().getString("RENAME_DATABASE_PLATFORM_DIALOG_DESCRIPTION"));
        builder.setHelpTopicId("dialog.dbPlatformRename");
        return builder;
    }

    protected void execute(DatabasePlatform dbPlatform, NewNameDialog.Builder builder) {
        builder.setExistingNames(this.existingPlatformNames(dbPlatform.getRepository()));
        builder.setOriginalName(dbPlatform.getName());
        NewNameDialog dialog = builder.buildDialog(this.getWorkbenchContext());
        dialog.show();
        if (dialog.wasConfirmed()) {
            dbPlatform.setName(dialog.getNewName());
        }
    }

    private Iterator existingPlatformNames(DatabasePlatformRepository repository) {
        return new TransformationIterator(repository.platforms()){

            protected Object transform(Object next) {
                return ((DatabasePlatform)next).getName();
            }
        };
    }
}

