/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.model.adapter;

import java.util.List;
import org.eclipse.persistence.internal.sessions.factories.model.transport.RMITransportManagerConfig;
import org.eclipse.persistence.internal.sessions.factories.model.transport.TransportManagerConfig;
import org.eclipse.persistence.internal.sessions.factories.model.transport.discovery.DiscoveryConfig;
import org.eclipse.persistence.internal.sessions.factories.model.transport.naming.JNDINamingServiceConfig;
import org.eclipse.persistence.internal.sessions.factories.model.transport.naming.RMIRegistryNamingServiceConfig;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.DiscoveryAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.JNDINamingServiceAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.RMIRegistryNamingServiceAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SCAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.TransportManagerAdapter;

public class RMITransportManagerAdapter
extends TransportManagerAdapter {
    private volatile JNDINamingServiceAdapter namingService;
    public static final String JNDI_NAMING_SERVICE_PROPERTY = "jndiNamingService";
    private volatile DiscoveryAdapter discovery;
    public static final String DISCOVERY_PROPERTY = "discovery";
    private volatile RMIRegistryNamingServiceAdapter rmiRegistryNamingService;
    public static final String RMI_REGISTRY_NAMING_SERVICE_PROPERTY = "rmiRegistryNamingService";
    public static final String JNDI_ENCRYPTION_CLASS_PROPERTY = "encryptionClass";
    public static final String JNDI_PROPERTIES_COLLECTION = "properties";
    public static final String DISCOVER_MULTICAST_GROUP_ADDRESS_PROPERTY = "multicastGroupAddress";
    public static final String DISCOVER_MULTICAST_PORT_PROPERTY = "multicastPort";
    public static final String DISCOVER_ANNOUNCEMENT_DELAY_PROPERTY = "announcementDelay";
    public static final String DISCOVER_PACKET_TIME_TO_LIVE_PROPERTY = "packetTimeToLive";
    public volatile String namingServiceType;
    public static final String NAMING_SERVICE_TYPE_PROPERTY = "namingServiceType";
    public static final String SEND_MODE_PROPERTY = "sendMode";

    RMITransportManagerAdapter(SCAdapter parent, RMITransportManagerConfig scConfig) {
        super(parent, (TransportManagerConfig)scConfig);
    }

    protected RMITransportManagerAdapter(SCAdapter parent) {
        super(parent);
    }

    protected Object buildModel() {
        return new RMITransportManagerConfig();
    }

    private DiscoveryAdapter buildDiscovery() {
        return new DiscoveryAdapter(this);
    }

    private RMIRegistryNamingServiceAdapter buildRegistryNamingService() {
        return new RMIRegistryNamingServiceAdapter(this);
    }

    private final RMITransportManagerConfig manager() {
        return (RMITransportManagerConfig)this.getModel();
    }

    protected void initializeFromModel(Object scConfig) {
        super.initializeFromModel(scConfig);
        this.discovery = (DiscoveryAdapter)this.adapt(this.manager().getDiscoveryConfig());
        this.namingService = (JNDINamingServiceAdapter)this.adapt(this.manager().getJNDINamingServiceConfig());
        this.rmiRegistryNamingService = (RMIRegistryNamingServiceAdapter)this.adapt(this.manager().getRMIRegistryNamingServiceConfig());
        this.namingServiceType = this.namingService != null ? JNDI_NAMING_SERVICE_PROPERTY : RMI_REGISTRY_NAMING_SERVICE_PROPERTY;
    }

    protected void initialize(Object newConfig) {
        super.initialize(newConfig);
        this.setDiscovery(this.buildDiscovery());
        this.setJNDINamingService(this.buildJNDINamingService());
        this.namingServiceType = JNDI_NAMING_SERVICE_PROPERTY;
    }

    protected void initializeDefaults() {
        super.initializeDefaults();
        this.setMulticastGroupAddress("226.10.12.64");
        this.setMulticastPort(3121);
        this.setAnnouncementDelay(1000);
        this.setSynchronous("Asynchronous".equals("Asynchronous"));
        this.setPacketTimeToLive(2);
    }

    DiscoveryAdapter getDiscovery() {
        return this.discovery;
    }

    public JNDINamingServiceAdapter getJNDINamingService() {
        return this.namingService;
    }

    public RMIRegistryNamingServiceAdapter getRMIRegistryNamingService() {
        return this.rmiRegistryNamingService;
    }

    private void setDiscovery(DiscoveryAdapter discovery) {
        JNDINamingServiceAdapter old = this.namingService;
        this.discovery = discovery;
        this.manager().setDiscoveryConfig((DiscoveryConfig)discovery.getModel());
        this.firePropertyChanged(DISCOVERY_PROPERTY, old, (Object)discovery);
    }

    private void setJNDINamingService(JNDINamingServiceAdapter service) {
        JNDINamingServiceAdapter old = this.namingService;
        this.namingService = service;
        JNDINamingServiceConfig config = service != null ? (JNDINamingServiceConfig)service.getModel() : null;
        this.manager().setJNDINamingServiceConfig(config);
        this.firePropertyChanged(JNDI_NAMING_SERVICE_PROPERTY, old, service);
    }

    private void setRegistryNamingService(RMIRegistryNamingServiceAdapter service) {
        JNDINamingServiceAdapter old = this.namingService;
        this.rmiRegistryNamingService = service;
        if (service != null) {
            this.manager().setRMIRegistryNamingServiceConfig((RMIRegistryNamingServiceConfig)service.getModel());
        } else {
            this.manager().setRMIRegistryNamingServiceConfig(null);
        }
        this.firePropertyChanged(RMI_REGISTRY_NAMING_SERVICE_PROPERTY, old, (Object)service);
    }

    public String getMulticastGroupAddress() {
        return this.discovery.getMulticastGroupAddress();
    }

    public void setMulticastGroupAddress(String address) {
        String old = this.discovery.getMulticastGroupAddress();
        this.discovery.setMulticastGroupAddress(address);
        this.firePropertyChanged(DISCOVER_MULTICAST_GROUP_ADDRESS_PROPERTY, old, address);
    }

    public int getMulticastPort() {
        return this.discovery.getMulticastPort();
    }

    public void setMulticastPort(int value) {
        int old = this.discovery.getMulticastPort();
        this.discovery.setMulticastPort(value);
        this.firePropertyChanged(DISCOVER_MULTICAST_PORT_PROPERTY, old, value);
    }

    public int getPacketTimeToLive() {
        return this.discovery.getPacketTimeToLive();
    }

    public void setPacketTimeToLive(int value) {
        int old = this.discovery.getPacketTimeToLive();
        this.discovery.setPacketTimeToLive(value);
        this.firePropertyChanged(DISCOVER_PACKET_TIME_TO_LIVE_PROPERTY, old, value);
    }

    public int getAnnouncementDelay() {
        return this.discovery.getAnnouncementDelay();
    }

    public void setAnnouncementDelay(int value) {
        int old = this.discovery.getAnnouncementDelay();
        this.discovery.setAnnouncementDelay(value);
        this.firePropertyChanged(DISCOVER_ANNOUNCEMENT_DELAY_PROPERTY, old, value);
    }

    public String getNamingServiceType() {
        return this.namingServiceType;
    }

    public JNDINamingServiceAdapter setNamingServiceToJNDINamingService() {
        String old = this.getNamingServiceType();
        this.setJNDINamingService(this.buildJNDINamingService());
        this.setRegistryNamingService(null);
        this.namingServiceType = JNDI_NAMING_SERVICE_PROPERTY;
        this.firePropertyChanged(NAMING_SERVICE_TYPE_PROPERTY, old, this.namingServiceType);
        return this.getJNDINamingService();
    }

    public RMIRegistryNamingServiceAdapter setNamingServiceToRMIRegistryNamingService() {
        String old = this.getNamingServiceType();
        this.setJNDINamingService(null);
        this.setRegistryNamingService(this.buildRegistryNamingService());
        this.namingServiceType = RMI_REGISTRY_NAMING_SERVICE_PROPERTY;
        this.firePropertyChanged(NAMING_SERVICE_TYPE_PROPERTY, old, this.namingServiceType);
        return this.getRMIRegistryNamingService();
    }

    public String getEncryptionClass() {
        return this.namingService.getEncryptionClass();
    }

    public void setEncryptionClass(String name) {
        String old = this.namingService.getEncryptionClass();
        this.namingService.setEncryptionClass(name);
        this.firePropertyChanged(JNDI_ENCRYPTION_CLASS_PROPERTY, old, name);
    }

    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        if (this.getJNDINamingService() != null) {
            children.add(this.getJNDINamingService());
        }
        if (this.getRMIRegistryNamingService() != null) {
            children.add(this.getRMIRegistryNamingService());
        }
    }

    public boolean isSynchronous() {
        String value = this.manager().getSendMode();
        return value != null && value.equalsIgnoreCase("Synchronous");
    }

    public void setSynchronous(boolean synchronous) {
        boolean old = this.removeConnectionOnError();
        if (synchronous) {
            this.manager().setSendMode("Synchronous");
        } else {
            this.manager().setSendMode("Asynchronous");
        }
        this.firePropertyChanged(SEND_MODE_PROPERTY, old, synchronous);
    }
}

