/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.model.adapter;

import java.util.List;
import java.util.ListIterator;
import org.eclipse.persistence.internal.sessions.factories.model.event.SessionEventManagerConfig;
import org.eclipse.persistence.internal.sessions.factories.model.log.LogConfig;
import org.eclipse.persistence.internal.sessions.factories.model.platform.ServerPlatformConfig;
import org.eclipse.persistence.internal.sessions.factories.model.rcm.RemoteCommandManagerConfig;
import org.eclipse.persistence.internal.sessions.factories.model.session.SessionConfig;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.DatabaseSessionAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.DefaultSessionLogAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.JavaLogAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.LogAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.NoLogAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.Nominative;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.NullServerPlatformAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.RemoteCommandManagerAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SCAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.ServerLogAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.ServerPlatform;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.ServerPlatformAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SessionEventManagerAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.TransportManagerAdapter;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.TriStateBoolean;

public abstract class SessionAdapter
extends SCAdapter
implements Nominative {
    private volatile ServerPlatformAdapter serverPlatform;
    public static final String SERVER_PLATFORM_CONFIG_PROPERTY = "serverPlatform";
    public static final String PROFILER_PROPERTY = "profiler";
    public static final String EXCEPTION_HANDLER_CLASS_PROPERTY = "exceptionHandlerClass";
    public static final String SESSION_CUSTOMIZER_CLASS_PROPERTY = "sessionCustomizerClass";
    private volatile LogAdapter log;
    public static final String LOG_CONFIG_PROPERTY = "log";
    public static final String LOG_PROFILER_TOPLINK = "toplink";
    public static final String LOG_PROFILER_DMS = "dms";
    private volatile RemoteCommandManagerAdapter remoteCommandManager;
    public static final String REMOTE_COMMAND_MANAGER_CONFIG_PROPERTY = "remoteCommandManager";
    private volatile SessionEventManagerAdapter sessionEventManager;
    public static final String SESSION_EVENT_LISTENERS_CONFIGS_LIST = "sessionEventListeners";
    private volatile boolean managedByBroker;
    public static final String MANAGED_BY_BROKER = "managedByBroker";
    private boolean cacheSynchronizationManagerAllowed;
    private TriStateBoolean clusteringService;

    SessionAdapter(SCAdapter parent, SessionConfig scConfig) {
        super(parent, scConfig);
    }

    protected SessionAdapter(SCAdapter parent, String name) {
        super(parent);
        this.setName(name);
    }

    private SessionEventManagerAdapter buildSessionEventManager() {
        SessionEventManagerAdapter sessionEventManager = new SessionEventManagerAdapter(this);
        this.session().setSessionEventManagerConfig((SessionEventManagerConfig)sessionEventManager.getModel());
        return sessionEventManager;
    }

    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        if (this.getLog() != null) {
            children.add(this.getLog());
        }
        if (this.getRemoteCommandManager() != null) {
            children.add(this.getRemoteCommandManager());
        }
        if (this.getServerPlatform() != null) {
            children.add(this.getServerPlatform());
        }
    }

    protected void addProblemsTo(List branchProblems) {
        super.addProblemsTo(branchProblems);
        this.verifyDeprecatedFeatures(branchProblems);
    }

    protected void initialize(Object newConfig) {
        super.initialize(newConfig);
        this.sessionEventManager = this.buildSessionEventManager();
        this.clusteringService = TriStateBoolean.UNDEFINED;
        this.setDefaultLogging();
        this.managedByBroker = false;
    }

    protected void initializeFromModel(Object scConfig) {
        super.initializeFromModel(scConfig);
        LogAdapter adapter = (LogAdapter)this.adapt(this.session().getLogConfig());
        if (adapter == null) {
            this.setNoLogging();
        } else {
            this.log = adapter;
        }
        this.remoteCommandManager = (RemoteCommandManagerAdapter)this.adapt(this.session().getRemoteCommandManagerConfig());
        this.sessionEventManager = (SessionEventManagerAdapter)this.adapt(this.session().getSessionEventManagerConfig());
        if (this.sessionEventManager == null) {
            this.sessionEventManager = this.buildSessionEventManager();
        }
        if (this.session().getServerPlatformConfig() == null) {
            this.initializeServerPlatform(new ServerPlatform(ClassTools.shortNameForClassNamed((String)NullServerPlatformAdapter.instance().getServerClassName())));
        } else {
            this.serverPlatform = (ServerPlatformAdapter)this.adapt(this.session().getServerPlatformConfig());
        }
        this.clusteringService = this.remoteCommandManager != null ? TriStateBoolean.TRUE : TriStateBoolean.UNDEFINED;
        this.managedByBroker = false;
    }

    protected void postInitializationFromModel() {
        super.postInitializationFromModel();
        if (!this.configVersionIsPre10g() || this.serverPlatform.isCustom()) {
            // empty if block
        }
    }

    private void verifyDeprecatedFeatures(List branchProblems) {
        if (this.configVersionIsPre10g() && this.serverPlatform.isCustom()) {
            branchProblems.add(this.buildProblem("0813", this.getParent().displayString()));
        }
    }

    protected void initializeServerPlatform(ServerPlatform sp) {
        this.setServerPlatform(sp.buildAdapter(this));
    }

    public boolean isCacheSynchronizationManagerAllowed() {
        return this.cacheSynchronizationManagerAllowed;
    }

    public String getName() {
        return this.session().getName();
    }

    public void setName(String name) {
        String old = this.session().getName();
        this.session().setName(name);
        this.firePropertyChanged("name", old, name);
    }

    public String displayString() {
        return this.getName();
    }

    public boolean hasJTA() {
        SessionAdapter session = this.isManaged() ? ((DatabaseSessionAdapter)this).getBroker() : this;
        return session.getServerPlatform() == null ? false : session.getServerPlatform().getEnableJTA();
    }

    public boolean hasCacheSynchronizationManager() {
        return this.clusteringService == TriStateBoolean.FALSE;
    }

    public boolean hasNoClusteringService() {
        return this.clusteringService == TriStateBoolean.UNDEFINED;
    }

    public boolean hasRemoteCommandManager() {
        return this.clusteringService == TriStateBoolean.TRUE;
    }

    public boolean platformIsRdbms() {
        return false;
    }

    public boolean platformIsEis() {
        return false;
    }

    public boolean platformIsXml() {
        return false;
    }

    public boolean isManaged() {
        return this.managedByBroker;
    }

    public boolean isBroker() {
        return false;
    }

    public String getDataSourceName() {
        return "";
    }

    public RemoteCommandManagerAdapter getRemoteCommandManager() {
        return this.remoteCommandManager;
    }

    public RemoteCommandManagerAdapter setClusteringToRemoteCommandManager() {
        if (this.hasRemoteCommandManager()) {
            return this.remoteCommandManager;
        }
        this.clusteringService = TriStateBoolean.TRUE;
        this.setRemoteCommandManager(this.buildRemoteCommandManager());
        return this.remoteCommandManager;
    }

    public void setClusteringToNothing() {
        this.clusteringService = TriStateBoolean.UNDEFINED;
        this.setRemoteCommandManager(null);
    }

    private void setRemoteCommandManager(RemoteCommandManagerAdapter manager) {
        RemoteCommandManagerAdapter old = this.remoteCommandManager;
        this.remoteCommandManager = manager;
        if (manager == null) {
            this.session().setRemoteCommandManagerConfig(null);
        } else {
            this.session().setRemoteCommandManagerConfig((RemoteCommandManagerConfig)manager.getModel());
        }
        this.firePropertyChanged(REMOTE_COMMAND_MANAGER_CONFIG_PROPERTY, (Object)old, (Object)manager);
    }

    private RemoteCommandManagerAdapter buildRemoteCommandManager() {
        return new RemoteCommandManagerAdapter(this);
    }

    public TransportManagerAdapter getTransportManager() {
        return this.remoteCommandManager.getTransportManager();
    }

    public ServerPlatformAdapter setServerPlatform(ServerPlatform sp) {
        this.setServerPlatform(sp.buildAdapter(this));
        this.externalTransactionControllerClassChanged();
        return this.serverPlatform;
    }

    public LogAdapter getLog() {
        return this.log;
    }

    private LogAdapter setNoLogging() {
        this.setLog(new NoLogAdapter(this));
        return this.log;
    }

    public JavaLogAdapter setJavaLogging() {
        this.setLog(new JavaLogAdapter(this));
        return (JavaLogAdapter)this.log;
    }

    public ServerLogAdapter setServerLogging() {
        this.setLog(new ServerLogAdapter(this));
        return (ServerLogAdapter)this.log;
    }

    public DefaultSessionLogAdapter setDefaultLogging() {
        return this.setTopLinkLogging("standard output", "info");
    }

    public DefaultSessionLogAdapter setTopLinkLogging(String fileName, String logLevel) {
        this.setLog(new DefaultSessionLogAdapter(this, fileName, logLevel));
        return (DefaultSessionLogAdapter)this.log;
    }

    public ServerPlatformAdapter getServerPlatform() {
        return this.isManaged() ? ((DatabaseSessionAdapter)this).getBroker().getServerPlatform() : this.serverPlatform;
    }

    private void setServerPlatform(ServerPlatformAdapter platform) {
        ServerPlatformAdapter old = this.serverPlatform;
        this.serverPlatform = platform;
        this.session().setServerPlatformConfig((ServerPlatformConfig)platform.getModel());
        if (old != null && old.isCustom()) {
            this.externalTransactionControllerClassChanged();
        }
        this.firePropertyChanged(SERVER_PLATFORM_CONFIG_PROPERTY, (Object)old, (Object)platform);
    }

    private void setLog(LogAdapter log) {
        LogAdapter old = this.log;
        this.log = log;
        this.session().setLogConfig((LogConfig)log.getModel());
        this.firePropertyChanged(LOG_CONFIG_PROPERTY, (Object)old, (Object)log);
    }

    protected void setManaged(boolean managed) {
        boolean old = this.managedByBroker;
        this.managedByBroker = managed;
        this.firePropertyChanged(MANAGED_BY_BROKER, old, managed);
    }

    private final SessionConfig session() {
        return (SessionConfig)this.getModel();
    }

    public void toString(StringBuffer sb) {
        sb.append(this.getName());
    }

    public ListIterator sessionEventListenerConfigs() {
        return this.sessionEventManager.sessionEventListenerConfigs();
    }

    private List getSessionEventListenerConfigs() {
        return this.sessionEventManager.getSessionEventListenerConfigs();
    }

    public void addPropertyConfigNamed(String name) {
        int i = this.sessionEventManager.addSessionEventListenerConfigNamed(name);
        this.fireItemAdded(SESSION_EVENT_LISTENERS_CONFIGS_LIST, i, name);
    }

    public String removePropertyConfigNamed(String name) {
        String removedItem = null;
        int i = this.getSessionEventListenerConfigs().indexOf(name);
        if (i != -1 && (removedItem = this.sessionEventManager.removeSessionEventListenerConfigNamed(name)) != null) {
            this.fireItemRemoved(SESSION_EVENT_LISTENERS_CONFIGS_LIST, i, removedItem);
        }
        return removedItem;
    }

    private void removeAllPropertyConfigNamed() {
        List items = this.sessionEventManager.removeAllSessionEventListenerConfigNamed();
        if (items.size() > 0) {
            this.fireItemsRemoved(SESSION_EVENT_LISTENERS_CONFIGS_LIST, 0, items);
        }
    }

    public String getProfiler() {
        return this.session().getProfiler();
    }

    public void setProfiler(String name) {
        String old = this.session().getProfiler();
        this.session().setProfiler(name);
        this.firePropertyChanged(PROFILER_PROPERTY, old, name);
    }

    abstract void externalTransactionControllerClassChanged();

    public String getExceptionHandlerClass() {
        return this.session().getExceptionHandlerClass();
    }

    public void setExceptionHandlerClass(String name) {
        String old = this.session().getExceptionHandlerClass();
        this.session().setExceptionHandlerClass(name);
        this.firePropertyChanged(EXCEPTION_HANDLER_CLASS_PROPERTY, old, name);
    }

    public String getSessionCustomizerClass() {
        return this.session().getSessionCustomizerClass();
    }

    public void setSessionCustomizerClass(String name) {
        String old = this.session().getSessionCustomizerClass();
        this.session().setSessionCustomizerClass(name);
        this.firePropertyChanged(SESSION_CUSTOMIZER_CLASS_PROPERTY, old, name);
    }

    protected void initializeDefaults() {
        super.initializeDefaults();
        this.setDefaultLogging();
        if (this.getProfiler() != null) {
            this.setProfiler(null);
        }
        if (this.getExceptionHandlerClass() != null) {
            this.setExceptionHandlerClass(null);
        }
        if (this.getSessionCustomizerClass() != null) {
            this.setSessionCustomizerClass(null);
        }
        if (!this.hasNoClusteringService()) {
            this.setClusteringToNothing();
        }
        this.removeAllPropertyConfigNamed();
    }
}

