/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.model.adapter;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.persistence.internal.sessions.factories.model.session.SessionBrokerConfig;
import org.eclipse.persistence.internal.sessions.factories.model.session.SessionConfig;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.DatabaseSessionAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SCAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.ServerPlatform;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SessionAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.TopLinkSessionsAdapter;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;

public final class SessionBrokerAdapter
extends SessionAdapter {
    public static final String SESSIONS_COLLECTION = "sessions";

    SessionBrokerAdapter(SCAdapter parent, SessionBrokerConfig scConfig) {
        super(parent, (SessionConfig)scConfig);
    }

    protected SessionBrokerAdapter(SCAdapter parent, String name, ServerPlatform sp) {
        super(parent, name);
        this.initializeServerPlatform(sp);
    }

    protected Object buildModel() {
        return new SessionBrokerConfig();
    }

    private final SessionBrokerConfig sessionBroker() {
        return (SessionBrokerConfig)this.getModel();
    }

    private TopLinkSessionsAdapter topLinkSessions() {
        return (TopLinkSessionsAdapter)this.getParent();
    }

    public boolean isBroker() {
        return true;
    }

    public SessionAdapter sessionNamed(String name) {
        return this.topLinkSessions().managedSessionNamed(name);
    }

    public Iterator sessions() {
        return this.topLinkSessions().managedSessions(this);
    }

    public int sessionsSize() {
        return this.getSessionNameConfigs().size();
    }

    Iterator sessionNames() {
        return this.getSessionNameConfigs().iterator();
    }

    private Collection getSessionNameConfigs() {
        return this.sessionBroker().getSessionNames();
    }

    public DatabaseSessionAdapter manage(String name) {
        DatabaseSessionAdapter session = this.topLinkSessions().addManagedSessionNamed(name);
        session.setBroker(this);
        this.getSessionNameConfigs().add(name);
        this.fireItemAdded(SESSIONS_COLLECTION, session);
        return session;
    }

    void internalAddSessionNamed(String name) {
        DatabaseSessionAdapter session = this.topLinkSessions().addManagedSessionNamed(name);
        session.setBroker(this);
    }

    public DatabaseSessionAdapter unManage(String name) {
        DatabaseSessionAdapter session = this.topLinkSessions().removeManagedSessionNamed(name);
        session.setBroker(null);
        this.getSessionNameConfigs().remove(name);
        this.fireCollectionChanged(SESSIONS_COLLECTION);
        return session;
    }

    public Collection unManage(Collection sessions) {
        Collection removedSessions = this.topLinkSessions().removeManagedSessions(sessions);
        Iterator i = removedSessions.iterator();
        while (i.hasNext()) {
            ((DatabaseSessionAdapter)i.next()).setBroker(null);
        }
        Collection removedSessionsNames = this.topLinkSessions().getSessionsNames(removedSessions.iterator());
        this.getSessionNameConfigs().removeAll(removedSessionsNames);
        this.fireCollectionChanged(SESSIONS_COLLECTION);
        return removedSessions;
    }

    void externalTransactionControllerClassChanged() {
        Iterator iter = this.sessions();
        while (iter.hasNext()) {
            DatabaseSessionAdapter session = (DatabaseSessionAdapter)iter.next();
            session.externalTransactionControllerClassChanged();
        }
    }

    protected void setManaged(boolean managed) {
        throw new IllegalStateException();
    }

    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        CollectionTools.addAll((Collection)children, (Iterator)this.sessions());
    }

    protected void addProblemsTo(List branchProblems) {
        super.addProblemsTo(branchProblems);
        this.verifyProblemSessionCount(branchProblems);
    }

    private void verifyProblemSessionCount(List branchProblems) {
        if (this.sessionsSize() == 0) {
            branchProblems.add(this.buildProblem("0804", this.displayString()));
        }
    }

    void sessionRenamed(String oldName, String newName) {
        this.getSessionNameConfigs().remove(oldName);
        this.getSessionNameConfigs().add(newName);
    }
}

