/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.ui;

import java.io.File;
import org.eclipse.persistence.tools.workbench.framework.action.AbstractFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.scplugin.SCPlugin;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.TopLinkSessionsAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.meta.SCSessionsProperties;
import org.eclipse.persistence.tools.workbench.scplugin.ui.project.ProjectNode;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;

public class AddNewSessionsAction
extends AbstractFrameworkAction {
    private SCPlugin plugin;

    public AddNewSessionsAction(WorkbenchContext context, SCPlugin plugin) {
        super(context);
        this.plugin = plugin;
    }

    protected void initialize() {
        this.initializeText("NEW_SESSIONS_CONFIGURATION");
        this.initializeMnemonic("NEW_SESSIONS_CONFIGURATION");
        this.initializeIcon("NEW_SESSIONS_CONFIGURATION");
        this.initializeToolTipText("NEW_SESSIONS_CONFIGURATION.TOOL_TIP");
    }

    protected void execute() {
        this.navigatorSelectionModel().pushExpansionState();
        File sessionsFile = this.plugin.nextUntitledFile(this.getApplicationContext());
        ApplicationNode newProjectNode = this.buildTopLinkSessionsNode(sessionsFile);
        this.nodeManager().addProjectNode(newProjectNode);
        this.navigatorSelectionModel().setSelectedNode(newProjectNode);
        this.navigatorSelectionModel().popAndRestoreExpansionState();
    }

    private ApplicationNode buildTopLinkSessionsNode(File sessionsFile) {
        SCSessionsProperties properties = this.plugin.getSessionsProperties(this.getApplicationContext(), sessionsFile);
        TopLinkSessionsAdapter topLinkSessions = this.buildTopLinkSessions(properties);
        this.updateClasspath(topLinkSessions);
        return new ProjectNode(topLinkSessions, this.nodeManager().getRootNode(), this.plugin, this.getApplicationContext());
    }

    private TopLinkSessionsAdapter buildTopLinkSessions(SCSessionsProperties properties) {
        return new TopLinkSessionsAdapter(properties, this.preferences(), true);
    }

    private void updateClasspath(TopLinkSessionsAdapter topLinkSessions) {
        String classpath = this.preferences().get("default classpath", null);
        if (classpath != null && !"".equals(classpath)) {
            Object[] entries = classpath.split(System.getProperty("path.separator"));
            topLinkSessions.getClassRepository().addClasspathEntries(0, CollectionTools.list((Object[])entries));
        }
    }
}

