/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.ui.project;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.persistence.tools.workbench.framework.action.AbstractFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.app.AbstractApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.NullServerPlatformAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.ServerPlatform;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SessionAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SessionBrokerAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.TopLinkSessionsAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.ui.project.BrokerCreationDialog;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ReadOnlyCollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ListModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ObjectListSelectionModel;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public class AddNewBrokerAction
extends AbstractFrameworkAction {
    private final boolean selectNode;

    public AddNewBrokerAction(WorkbenchContext context) {
        this(context, true);
    }

    public AddNewBrokerAction(WorkbenchContext context, boolean selectNode) {
        super(context);
        this.selectNode = selectNode;
    }

    protected void initialize() {
        super.initialize();
        this.initializeText("ADD_BROKER");
        this.initializeMnemonic("ADD_BROKER");
        this.initializeIcon("ADD_BROKER");
        this.initializeToolTipText("ADD_BROKER.TOOL_TIP");
    }

    private ObjectListSelectionModel buildSelectionModel(CollectionValueModel itemHolder) {
        ListModelAdapter adapter = new ListModelAdapter(itemHolder);
        return new ObjectListSelectionModel(adapter);
    }

    private CollectionValueModel buildSessionCollectionHolder(TopLinkSessionsAdapter topLinkSessions) {
        Collection sessions = CollectionTools.collection((Iterator)topLinkSessions.databaseSessions());
        return new ReadOnlyCollectionValueModel(sessions);
    }

    private Collection buildSessionBrokerNames(TopLinkSessionsAdapter topLinkSessions) {
        return CollectionTools.collection((Iterator)topLinkSessions.sessionBrokerNames());
    }

    public void execute() {
        super.execute();
    }

    protected void execute(ApplicationNode selectedNode) {
        ServerPlatform sp;
        TopLinkSessionsAdapter topLinkSessions = (TopLinkSessionsAdapter)selectedNode.getValue();
        SimplePropertyValueModel stringHolder = new SimplePropertyValueModel();
        SimplePropertyValueModel serverPlatformHolder = new SimplePropertyValueModel();
        CollectionValueModel itemHolder = this.buildSessionCollectionHolder(topLinkSessions);
        ObjectListSelectionModel selectionModel = this.buildSelectionModel(itemHolder);
        Collection sessionBrokerNames = this.buildSessionBrokerNames(topLinkSessions);
        BrokerCreationDialog dialog = new BrokerCreationDialog(this.getWorkbenchContext(), itemHolder, selectionModel, stringHolder, serverPlatformHolder, sessionBrokerNames);
        dialog.show();
        if (dialog.wasCanceled()) {
            return;
        }
        this.navigatorSelectionModel().pushExpansionState();
        if (dialog.usesServerPlatform()) {
            sp = new ServerPlatform((String)serverPlatformHolder.getValue());
        } else {
            String serverClassName = NullServerPlatformAdapter.instance().getServerClassName();
            sp = new ServerPlatform(ClassTools.shortNameForClassNamed((String)serverClassName));
        }
        SessionBrokerAdapter newBroker = topLinkSessions.addSessionBrokerNamed((String)stringHolder.getValue(), sp);
        Iterator iter = CollectionTools.iterator((Object[])selectionModel.getSelectedValues());
        while (iter.hasNext()) {
            SessionAdapter sessionAdapter = (SessionAdapter)iter.next();
            newBroker.manage(sessionAdapter.getName());
        }
        this.navigatorSelectionModel().popAndRestoreExpansionState();
        if (this.selectNode) {
            ((AbstractApplicationNode)selectedNode.getProjectRoot()).selectDescendantNodeForValue((Node)newBroker, this.navigatorSelectionModel());
        }
    }
}

