/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.ui.project;

import org.eclipse.persistence.tools.workbench.framework.app.AbstractApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.context.ApplicationContext;
import org.eclipse.persistence.tools.workbench.scplugin.SCPlugin;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.DatabaseSessionAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SCAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.ServerSessionAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SessionAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.ui.SCApplicationNode;
import org.eclipse.persistence.tools.workbench.scplugin.ui.session.DatabaseSessionNode;
import org.eclipse.persistence.tools.workbench.scplugin.ui.session.ServerSessionNode;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ItemPropertyListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SortedListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.TransformationListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.TreeNodeValueModel;

public abstract class SessionsNode
extends SCApplicationNode {
    private ListValueModel childrenModel;

    public SessionsNode(SCAdapter scAdapter, TreeNodeValueModel parent, SCPlugin plugin, ApplicationContext context) {
        super(scAdapter, parent, plugin, context);
    }

    protected void initialize() {
        super.initialize();
        this.childrenModel = this.buildChildrenModel();
    }

    protected ListValueModel buildChildrenModel() {
        return new SortedListValueModelAdapter(this.buildDisplayStringAdapter());
    }

    protected ListValueModel buildDisplayStringAdapter() {
        return new ItemPropertyListValueModelAdapter(this.buildChildrenNodeWrapper(), "displayString");
    }

    protected ListValueModel buildChildrenNodeWrapper() {
        return new TransformationListValueModelAdapter(this.buildSessionsAspectAdapter()){

            protected Object transformItem(Object item) {
                return SessionsNode.this.buildChildNode((SessionAdapter)item);
            }
        };
    }

    protected abstract CollectionValueModel buildSessionsAspectAdapter();

    protected AbstractApplicationNode buildChildNode(SessionAdapter session) {
        DatabaseSessionNode node = null;
        if (session instanceof ServerSessionAdapter) {
            node = new ServerSessionNode((ServerSessionAdapter)session, (TreeNodeValueModel)this, (SCPlugin)this.getPlugin(), this.getApplicationContext());
        } else if (session instanceof DatabaseSessionAdapter) {
            node = new DatabaseSessionNode((DatabaseSessionAdapter)session, (TreeNodeValueModel)this, (SCPlugin)this.getPlugin(), this.getApplicationContext());
        } else {
            throw new IllegalArgumentException("Invalid Session");
        }
        return node;
    }

    public ListValueModel getChildrenModel() {
        return this.childrenModel;
    }
}

