/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.ui.session.login;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedSet;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.uitools.Spacer;
import org.eclipse.persistence.tools.workbench.scplugin.model.EisPlatformManager;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.EISLoginAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.ui.login.EisLoginPane;
import org.eclipse.persistence.tools.workbench.scplugin.ui.login.LoginExternalOptionsPane;
import org.eclipse.persistence.tools.workbench.scplugin.ui.session.login.AbstractLoginPropertiesPage;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ReadOnlyCollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SortedListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.TransformationPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ComboBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.SimpleListCellRenderer;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;

public class EisConnectionPropertiesPage
extends AbstractLoginPropertiesPage {
    public EisConnectionPropertiesPage(PropertyValueModel nodeHolder, WorkbenchContextHolder contextHolder) {
        super(nodeHolder, contextHolder);
    }

    private Comparator buildEisPlatformNameCompator() {
        return new Comparator(){

            public int compare(Object object1, Object object2) {
                String shortClassName1 = ((String)object1).replaceFirst("Platform", "");
                String shortClassName2 = ((String)object2).replaceFirst("Platform", "");
                return shortClassName1.compareTo(shortClassName2);
            }
        };
    }

    protected Component buildPage() {
        GridBagConstraints constraints = new GridBagConstraints();
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JLabel platformLabel = this.buildLabel("CONNECTION_EIS_PLATFORM_FIELD");
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)platformLabel, constraints);
        this.addAlignLeft(platformLabel);
        this.helpManager().addTopicID(platformLabel, "session.login.database.connection.platform");
        JComboBox platformComboBox = new JComboBox(this.buildPlatformComboAdapter());
        platformComboBox.setName("CONNECTION_EIS_PLATFORM_FIELD");
        platformComboBox.setRenderer(this.buildPlatformLabelDecorator());
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 5, 0, 0);
        panel.add(platformComboBox, constraints);
        platformLabel.setLabelFor(platformComboBox);
        this.helpManager().addTopicID(platformComboBox, "session.login.database.connection.platform");
        Spacer spacer = new Spacer();
        constraints.gridx = 2;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 5, 0, 0);
        panel.add((Component)spacer, constraints);
        this.addAlignRight(spacer);
        EisLoginPane loginPane = new EisLoginPane(this.getSelectionHolder(), this.getWorkbenchContextHolder());
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 3;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(5, 0, 0, 0);
        panel.add((Component)loginPane, constraints);
        this.addPaneForAlignment(loginPane);
        LoginExternalOptionsPane optionsPane = new LoginExternalOptionsPane(this.getSelectionHolder(), this.getApplicationContext());
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.gridwidth = 3;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 1.0;
        constraints.fill = 0;
        constraints.anchor = 23;
        constraints.insets = new Insets(5, 0, 0, 0);
        panel.add((Component)optionsPane, constraints);
        this.helpManager().addTopicID(optionsPane, "session.login.externalPool");
        return panel;
    }

    private CollectionValueModel buildPlatformCollectionHolder() {
        SortedSet platforms = CollectionTools.sortedSet((Iterator)EisPlatformManager.instance().platformShortNames());
        return new ReadOnlyCollectionValueModel(platforms);
    }

    private ComboBoxModel buildPlatformComboAdapter() {
        return new ComboBoxModelAdapter(this.buildPlatformListHolder(), this.buildPlatformHolder());
    }

    private PropertyValueModel buildPlatformHolder() {
        PropertyAspectAdapter adapter = new PropertyAspectAdapter(this.getSelectionHolder(), "platformClass"){

            protected Object getValueFromSubject() {
                EISLoginAdapter login = (EISLoginAdapter)this.subject;
                return login.getPlatformClass();
            }

            protected void setValueOnSubject(Object value) {
                EISLoginAdapter adapter = (EISLoginAdapter)this.subject;
                adapter.setPlatformClass((String)value);
            }
        };
        return new TransformationPropertyValueModel(adapter){

            protected Object reverseTransform(Object value) {
                if (value == null) {
                    return null;
                }
                return EisPlatformManager.instance().getRuntimePlatformClassNameForClass((String)value);
            }

            protected Object transform(Object value) {
                if (value == null) {
                    return null;
                }
                return ClassTools.shortNameForClassNamed((String)((String)value));
            }
        };
    }

    private ListCellRenderer buildPlatformLabelDecorator() {
        return new SimpleListCellRenderer(){

            protected String buildText(Object cellValue) {
                if (((String)cellValue).equals("AQPlatform")) {
                    return "Oracle AQ";
                }
                if (((String)cellValue).equals("JMSPlatform")) {
                    return "JMS";
                }
                if (((String)cellValue).equals("MQPlatform")) {
                    return "IBM MQSeries";
                }
                return "XML File";
            }
        };
    }

    private ListValueModel buildPlatformListHolder() {
        return new SortedListValueModelAdapter(this.buildPlatformCollectionHolder(), this.buildEisPlatformNameCompator());
    }
}

