/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.app;

import java.util.Iterator;
import java.util.List;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.TreeNodeValueModel;
import org.eclipse.persistence.tools.workbench.utility.AbstractModel;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.events.ChangeSupport;
import org.eclipse.persistence.tools.workbench.utility.events.StateChangeListener;
import org.eclipse.persistence.tools.workbench.utility.iterators.ChainIterator;

public abstract class AbstractTreeNodeValueModel
extends AbstractModel
implements TreeNodeValueModel {
    protected AbstractTreeNodeValueModel() {
    }

    protected ChangeSupport buildDefaultChangeSupport() {
        return super.buildDefaultChangeSupport();
    }

    public void addStateChangeListener(StateChangeListener listener) {
        if (this.hasNoStateChangeListeners()) {
            this.engageValue();
        }
        super.addStateChangeListener(listener);
    }

    protected abstract void engageValue();

    public void removeStateChangeListener(StateChangeListener listener) {
        super.removeStateChangeListener(listener);
        if (this.hasNoStateChangeListeners()) {
            this.disengageValue();
        }
    }

    protected abstract void disengageValue();

    public void setValue(Object value) {
        throw new UnsupportedOperationException();
    }

    public TreeNodeValueModel[] path() {
        List path = CollectionTools.reverseList((Iterator)this.backPath());
        return path.toArray(new TreeNodeValueModel[path.size()]);
    }

    protected Iterator backPath() {
        return new ChainIterator(this){

            protected Object nextLink(Object currentLink) {
                return ((TreeNodeValueModel)currentLink).getParent();
            }
        };
    }

    public TreeNodeValueModel getChild(int index) {
        return (TreeNodeValueModel)this.getChildrenModel().getItem(index);
    }

    public int childrenSize() {
        return this.getChildrenModel().size();
    }

    public int indexOfChild(TreeNodeValueModel child) {
        ListValueModel children = this.getChildrenModel();
        int size = children.size();
        for (int i = 0; i < size; ++i) {
            if (children.getItem(i) != child) continue;
            return i;
        }
        return -1;
    }

    public boolean isLeaf() {
        return this.getChildrenModel().size() == 0;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        AbstractTreeNodeValueModel other = (AbstractTreeNodeValueModel)o;
        return this.getValue().equals(other.getValue());
    }

    public int hashCode() {
        return this.getValue().hashCode();
    }

    public void toString(StringBuffer sb) {
        sb.append(this.getValue());
    }
}

