/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.app;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModelChangeSupport;
import org.eclipse.persistence.tools.workbench.utility.AbstractModel;
import org.eclipse.persistence.tools.workbench.utility.events.ChangeSupport;
import org.eclipse.persistence.tools.workbench.utility.iterators.ReadOnlyListIterator;

public class SimpleListValueModel
extends AbstractModel
implements ListValueModel {
    protected List value;

    public SimpleListValueModel(List value) {
        this.setValue(value);
    }

    public SimpleListValueModel() {
        this(new ArrayList());
    }

    protected ChangeSupport buildDefaultChangeSupport() {
        return new ValueModelChangeSupport(this);
    }

    public Object getValue() {
        return new ReadOnlyListIterator(this.value);
    }

    public void addItem(int index, Object item) {
        this.addItemToList(index, item, this.value, "value");
    }

    public void addItems(int index, List items) {
        this.addItemsToList(index, items, this.value, "value");
    }

    public Object removeItem(int index) {
        return this.removeItemFromList(index, this.value, "value");
    }

    public List removeItems(int index, int length) {
        return this.removeItemsFromList(index, length, this.value, "value");
    }

    public Object replaceItem(int index, Object item) {
        return this.setItemInList(index, item, this.value, "value");
    }

    public List replaceItems(int index, List items) {
        return this.setItemsInList(index, items, this.value, "value");
    }

    public Object getItem(int index) {
        return this.value.get(index);
    }

    public int size() {
        return this.value.size();
    }

    public void setValue(List value) {
        this.value = value == null ? new ArrayList() : value;
        this.fireListChanged("value");
    }

    public void addItem(Object item) {
        this.addItem(this.size(), item);
    }

    public int indexOfItem(Object item) {
        return this.value.indexOf(item);
    }

    public void removeItem(Object item) {
        this.removeItem(this.indexOfItem(item));
    }

    public void clear() {
        if (this.value.isEmpty()) {
            return;
        }
        ArrayList items = new ArrayList(this.value);
        this.value.clear();
        this.fireItemsRemoved("value", 0, items);
    }

    public void toString(StringBuffer sb) {
        sb.append(this.value);
    }
}

