/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.app.adapters;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import org.eclipse.persistence.tools.workbench.uitools.app.AspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.adapters.PreferencePropertyValueModel;
import org.eclipse.persistence.tools.workbench.utility.iterators.ArrayIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.TransformationIterator;

public class PreferencesCollectionValueModel
extends AspectAdapter
implements CollectionValueModel {
    protected Map preferences;
    protected PreferenceChangeListener preferenceChangeListener;

    public PreferencesCollectionValueModel(Preferences preferences) {
        super(preferences);
    }

    public PreferencesCollectionValueModel(ValueModel preferencesHolder) {
        super(preferencesHolder);
    }

    protected void initialize() {
        super.initialize();
        this.preferences = new HashMap();
        this.preferenceChangeListener = this.buildPreferenceChangeListener();
    }

    protected PreferenceChangeListener buildPreferenceChangeListener() {
        return new PreferenceChangeListener(){

            public void preferenceChange(PreferenceChangeEvent e) {
                PreferencesCollectionValueModel.this.preferenceChanged(e.getKey(), e.getNewValue());
            }

            public String toString() {
                return "preference change listener";
            }
        };
    }

    public synchronized Object getValue() {
        return this.preferences.values().iterator();
    }

    public void addItem(Object item) {
        throw new UnsupportedOperationException();
    }

    public void addItems(Collection items) {
        Iterator stream = items.iterator();
        while (stream.hasNext()) {
            this.addItem(stream.next());
        }
    }

    public void removeItem(Object item) {
        throw new UnsupportedOperationException();
    }

    public void removeItems(Collection items) {
        Iterator stream = items.iterator();
        while (stream.hasNext()) {
            this.removeItem(stream.next());
        }
    }

    public synchronized int size() {
        return this.preferences.size();
    }

    protected boolean hasListeners() {
        return this.hasAnyCollectionChangeListeners("value");
    }

    protected void fireAspectChange(Object oldValue, Object newValue) {
        this.fireCollectionChanged("value");
    }

    protected void engageNonNullSubject() {
        ((Preferences)this.subject).addPreferenceChangeListener(this.preferenceChangeListener);
        Iterator stream = this.preferenceModels();
        while (stream.hasNext()) {
            PreferencePropertyValueModel preferenceModel = (PreferencePropertyValueModel)stream.next();
            this.preferences.put(preferenceModel.getKey(), preferenceModel);
        }
    }

    protected void disengageNonNullSubject() {
        block2: {
            try {
                ((Preferences)this.subject).removePreferenceChangeListener(this.preferenceChangeListener);
            }
            catch (IllegalStateException ex) {
                if (ex.getMessage().equals("Node has been removed.")) break block2;
                throw ex;
            }
        }
        this.preferences.clear();
    }

    public void toString(StringBuffer sb) {
        sb.append(this.subject);
    }

    protected Iterator preferenceModels() {
        Object[] keys;
        try {
            keys = ((Preferences)this.subject).keys();
        }
        catch (BackingStoreException ex) {
            throw new RuntimeException(ex);
        }
        return new TransformationIterator((Iterator)new ArrayIterator(keys)){

            protected Object transform(Object next) {
                return PreferencesCollectionValueModel.this.buildPreferenceModel((String)next);
            }
        };
    }

    protected PreferencePropertyValueModel buildPreferenceModel(String key) {
        return new PreferencePropertyValueModel(this.subjectHolder, key);
    }

    protected synchronized void preferenceChanged(String key, String newValue) {
        if (newValue == null) {
            PreferencePropertyValueModel preferenceModel = (PreferencePropertyValueModel)this.preferences.remove(key);
            this.fireItemRemoved("value", preferenceModel);
        } else if (!this.preferences.containsKey(key)) {
            PreferencePropertyValueModel preferenceModel = this.buildPreferenceModel(key);
            this.preferences.put(key, preferenceModel);
            this.fireItemAdded("value", preferenceModel);
        }
    }
}

