/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.app.swing;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ComboBoxModel;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ListModelAdapter;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public class ComboBoxModelAdapter
extends ListModelAdapter
implements ComboBoxModel {
    protected PropertyValueModel selectionHolder;
    protected PropertyChangeListener selectionListener;

    public ComboBoxModelAdapter(ListValueModel listHolder, PropertyValueModel selectionHolder) {
        super(listHolder);
        if (selectionHolder == null) {
            throw new NullPointerException();
        }
        this.selectionHolder = selectionHolder;
    }

    public ComboBoxModelAdapter(CollectionValueModel collectionHolder, PropertyValueModel selectionHolder) {
        super(collectionHolder);
        if (selectionHolder == null) {
            throw new NullPointerException();
        }
        this.selectionHolder = selectionHolder;
    }

    protected void initialize() {
        super.initialize();
        this.selectionListener = this.buildSelectionListener();
    }

    protected PropertyChangeListener buildSelectionListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                ComboBoxModelAdapter.this.fireSelectionChanged();
            }

            public String toString() {
                return "selection listener";
            }
        };
    }

    public Object getSelectedItem() {
        return this.selectionHolder.getValue();
    }

    public void setSelectedItem(Object selectedItem) {
        this.selectionHolder.setValue(selectedItem);
    }

    protected void engageModel() {
        super.engageModel();
        this.selectionHolder.addPropertyChangeListener("value", this.selectionListener);
    }

    protected void disengageModel() {
        this.selectionHolder.removePropertyChangeListener("value", this.selectionListener);
        super.disengageModel();
    }

    protected void fireSelectionChanged() {
        this.fireContentsChanged(this, -1, -1);
    }

    public String toString() {
        return StringTools.buildToStringFor((Object)this, (Object)(this.selectionHolder + ":" + this.listHolder));
    }
}

