/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.app.swing;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Date;
import javax.swing.SpinnerDateModel;
import javax.swing.event.ChangeListener;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public class DateSpinnerModelAdapter
extends SpinnerDateModel {
    private Date defaultValue;
    private PropertyValueModel dateHolder;
    private PropertyChangeListener dateChangeListener;

    public DateSpinnerModelAdapter(PropertyValueModel dateHolder) {
        this(dateHolder, new Date());
    }

    public DateSpinnerModelAdapter(PropertyValueModel dateHolder, Date defaultValue) {
        this(dateHolder, null, null, 5, defaultValue);
    }

    public DateSpinnerModelAdapter(PropertyValueModel dateHolder, Comparable start, Comparable end, int calendarField) {
        this(dateHolder, start, end, calendarField, new Date());
    }

    public DateSpinnerModelAdapter(PropertyValueModel dateHolder, Comparable start, Comparable end, int calendarField, Date defaultValue) {
        super(dateHolder.getValue() == null ? defaultValue : (Date)dateHolder.getValue(), start, end, calendarField);
        this.dateHolder = dateHolder;
        this.dateChangeListener = this.buildDateChangeListener();
        this.defaultValue = defaultValue;
    }

    private PropertyChangeListener buildDateChangeListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                DateSpinnerModelAdapter.this.synchronize(e.getNewValue());
            }

            public String toString() {
                return "date listener";
            }
        };
    }

    public Object getValue() {
        if (this.getChangeListeners().length == 0) {
            super.setValue(this.spinnerValueOf(this.dateHolder.getValue()));
        }
        return super.getValue();
    }

    public void setValue(Object value) {
        super.setValue(value);
        this.dateHolder.setValue(value);
    }

    public void addChangeListener(ChangeListener listener) {
        if (this.getChangeListeners().length == 0) {
            this.dateHolder.addPropertyChangeListener("value", this.dateChangeListener);
            this.synchronize(this.dateHolder.getValue());
        }
        super.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        super.removeChangeListener(listener);
        if (this.getChangeListeners().length == 0) {
            this.dateHolder.removePropertyChangeListener("value", this.dateChangeListener);
        }
    }

    protected Date getDefaultValue() {
        return this.defaultValue;
    }

    protected Object spinnerValueOf(Object value) {
        return value == null ? this.getDefaultValue() : value;
    }

    void synchronize(Object value) {
        Object newValue = this.spinnerValueOf(value);
        if (!this.getValue().equals(newValue)) {
            this.setValue(newValue);
        }
    }

    public String toString() {
        return StringTools.buildToStringFor((Object)this, (Object)this.dateHolder);
    }
}

