/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.internal.jpql;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.persistence.jpa.internal.jpql.NumericTypeComparator;
import org.eclipse.persistence.jpa.internal.jpql.Resolver;
import org.eclipse.persistence.jpa.internal.jpql.ResolverVisitor;
import org.eclipse.persistence.jpa.jpql.TypeHelper;
import org.eclipse.persistence.jpa.jpql.spi.IType;
import org.eclipse.persistence.jpa.jpql.spi.ITypeDeclaration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class NumericResolver
extends Resolver {
    private final Collection<Resolver> resolvers;

    NumericResolver(Resolver parent, Collection<Resolver> typeResolvers) {
        super(parent);
        this.resolvers = typeResolvers;
    }

    NumericResolver(Resolver parent, Resolver resolver) {
        this(parent, Collections.singleton(resolver));
    }

    @Override
    public void accept(ResolverVisitor visitor) {
    }

    @Override
    IType buildType() {
        ArrayList<IType> types = new ArrayList<IType>(this.resolvers.size());
        TypeHelper helper = this.getTypeHelper();
        IType unresolvableType = helper.unknownType();
        for (Resolver typeResolver : this.resolvers) {
            IType type = typeResolver.getType();
            if (type == unresolvableType) continue;
            if (!helper.isNumericType(type)) {
                type = helper.objectType();
            }
            types.add(type);
        }
        if (types.isEmpty()) {
            return helper.unknownType();
        }
        Collections.sort(types, new NumericTypeComparator(helper));
        return (IType)types.get(0);
    }

    @Override
    ITypeDeclaration buildTypeDeclaration() {
        return this.getType().getTypeDeclaration();
    }
}

