/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.internal.jpql.parser;

import java.util.Collection;
import java.util.List;
import org.eclipse.persistence.jpa.internal.jpql.WordParser;
import org.eclipse.persistence.jpa.internal.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.DeleteClause;
import org.eclipse.persistence.jpa.internal.jpql.parser.Expression;
import org.eclipse.persistence.jpa.internal.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.internal.jpql.parser.FullyQualifyPathExpressionVisitor;
import org.eclipse.persistence.jpa.internal.jpql.parser.JPQLQueryBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.StringExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.WhereClause;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DeleteStatement
extends AbstractExpression {
    private DeleteClause deleteClause;
    private boolean hasSpace;
    private AbstractExpression whereClause;

    DeleteStatement(AbstractExpression parent) {
        super(parent);
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void acceptChildren(ExpressionVisitor visitor) {
        this.getDeleteClause().accept(visitor);
        this.getWhereClause().accept(visitor);
    }

    @Override
    void addChildrenTo(Collection<Expression> children) {
        children.add(this.getDeleteClause());
        children.add(this.getWhereClause());
    }

    DeleteClause addDeleteClause() {
        this.deleteClause = new DeleteClause(this);
        return this.deleteClause;
    }

    @Override
    void addOrderedChildrenTo(List<StringExpression> children) {
        children.add(this.deleteClause);
        if (this.hasSpace) {
            children.add(this.buildStringExpression(' '));
        }
        children.add(this.whereClause);
    }

    public DeleteClause getDeleteClause() {
        return this.deleteClause;
    }

    @Override
    public JPQLQueryBNF getQueryBNF() {
        return DeleteStatement.queryBNF("delete_statement");
    }

    public Expression getWhereClause() {
        if (this.whereClause == null) {
            this.whereClause = this.buildNullExpression();
        }
        return this.whereClause;
    }

    public boolean hasSpaceAfterDeleteClause() {
        return this.hasSpace;
    }

    public boolean hasWhereClause() {
        return this.whereClause != null && !this.whereClause.isNull();
    }

    @Override
    void parse(WordParser wordParser, boolean tolerant) {
        this.deleteClause = new DeleteClause(this);
        this.deleteClause.parse(wordParser, tolerant);
        boolean bl = this.hasSpace = wordParser.skipLeadingWhitespace() > 0;
        if (wordParser.startsWithIdentifier("WHERE")) {
            this.whereClause = new WhereClause(this);
            this.whereClause.parse(wordParser, tolerant);
        }
        this.accept(FullyQualifyPathExpressionVisitor.instance());
    }

    @Override
    void toParsedText(StringBuilder writer, boolean includeVirtual) {
        this.deleteClause.toParsedText(writer, includeVirtual);
        if (this.hasSpace) {
            writer.append(' ');
        }
        if (this.whereClause != null) {
            this.whereClause.toParsedText(writer, includeVirtual);
        }
    }
}

