/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.internal.jpql.parser;

import org.eclipse.persistence.jpa.internal.jpql.parser.AbstractExpressionVisitor;
import org.eclipse.persistence.jpa.internal.jpql.parser.AbstractPathExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.AbstractTraverseChildrenVisitor;
import org.eclipse.persistence.jpa.internal.jpql.parser.CollectionValuedPathExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.EntryExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.Expression;
import org.eclipse.persistence.jpa.internal.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.internal.jpql.parser.IdentificationVariable;
import org.eclipse.persistence.jpa.internal.jpql.parser.KeyExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.RangeVariableDeclaration;
import org.eclipse.persistence.jpa.internal.jpql.parser.SelectStatement;
import org.eclipse.persistence.jpa.internal.jpql.parser.SimpleSelectStatement;
import org.eclipse.persistence.jpa.internal.jpql.parser.StateFieldPathExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.ValueExpression;

final class FullyQualifyPathExpressionVisitor
extends AbstractTraverseChildrenVisitor {
    private String variableName;
    private GeneralIdentificationVariableVisitor visitor;
    private static final FullyQualifyPathExpressionVisitor INSTANCE = new FullyQualifyPathExpressionVisitor();

    FullyQualifyPathExpressionVisitor() {
    }

    static ExpressionVisitor instance() {
        return INSTANCE;
    }

    private GeneralIdentificationVariableVisitor generalIdentificationVariableVisitor() {
        if (this.visitor == null) {
            this.visitor = new GeneralIdentificationVariableVisitor();
        }
        return this.visitor;
    }

    private void qualifyPathExpression(AbstractPathExpression expression) {
        expression.setVirtualIdentificationVariable(this.variableName);
    }

    public void visit(CollectionValuedPathExpression expression) {
        if (this.variableName != null) {
            this.visitAbstractPathExpression(expression);
        }
    }

    public void visit(IdentificationVariable expression) {
        if (this.variableName != null && !expression.isVirtual() && !this.variableName.equalsIgnoreCase(expression.getText())) {
            expression.setVirtualIdentificationVariable(this.variableName);
        }
    }

    public void visit(RangeVariableDeclaration expression) {
        if (expression.hasIdentificationVariable()) {
            this.variableName = expression.getIdentificationVariable().toParsedText().toLowerCase();
        } else {
            this.variableName = expression.getAbstractSchemaName().toParsedText().toLowerCase();
            expression.setVirtualIdentificationVariable(this.variableName);
        }
    }

    public void visit(SelectStatement expression) {
    }

    public void visit(SimpleSelectStatement expression) {
    }

    public void visit(StateFieldPathExpression expression) {
        if (this.variableName != null) {
            this.visitAbstractPathExpression(expression);
        }
    }

    private void visitAbstractPathExpression(AbstractPathExpression expression) {
        if (!expression.hasIdentificationVariable()) {
            this.qualifyPathExpression(expression);
        } else if (!expression.startsWithDot()) {
            String variable;
            GeneralIdentificationVariableVisitor visitor = this.generalIdentificationVariableVisitor();
            expression.getIdentificationVariable().accept(visitor);
            if (visitor.expression == null && !this.variableName.equalsIgnoreCase(variable = expression.getIdentificationVariable().toParsedText())) {
                this.qualifyPathExpression(expression);
            }
        }
    }

    private class GeneralIdentificationVariableVisitor
    extends AbstractExpressionVisitor {
        private Expression expression;

        private GeneralIdentificationVariableVisitor() {
        }

        public void visit(EntryExpression expression) {
            this.expression = expression;
        }

        public void visit(KeyExpression expression) {
            this.expression = expression;
        }

        public void visit(ValueExpression expression) {
            this.expression = expression;
        }
    }
}

