/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.internal.jpql.parser;

import java.util.Collection;
import java.util.List;
import org.eclipse.persistence.jpa.internal.jpql.WordParser;
import org.eclipse.persistence.jpa.internal.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.Expression;
import org.eclipse.persistence.jpa.internal.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.internal.jpql.parser.JPQLQueryBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.StringExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NullComparisonExpression
extends AbstractExpression {
    private AbstractExpression expression;
    private boolean hasNot;

    NullComparisonExpression(AbstractExpression parent, AbstractExpression expression) {
        super(parent);
        this.updateExpression(expression);
    }

    NullComparisonExpression(AbstractExpression parent, String identifier, AbstractExpression expression) {
        super(parent, identifier);
        this.updateExpression(expression);
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void acceptChildren(ExpressionVisitor visitor) {
        this.getExpression().accept(visitor);
    }

    @Override
    void addChildrenTo(Collection<Expression> children) {
        children.add(this.getExpression());
    }

    @Override
    void addOrderedChildrenTo(List<StringExpression> children) {
        if (this.hasExpression()) {
            children.add(this.expression);
            children.add(this.buildStringExpression(' '));
        }
        children.add(this.buildStringExpression(this.getIdentifier()));
    }

    public Expression getExpression() {
        if (this.expression == null) {
            this.expression = this.buildNullExpression();
        }
        return this.expression;
    }

    public String getIdentifier() {
        return this.hasNot ? "IS NOT NULL" : "IS NULL";
    }

    @Override
    public JPQLQueryBNF getQueryBNF() {
        return NullComparisonExpression.queryBNF("null_comparison_expression");
    }

    public boolean hasExpression() {
        return this.expression != null && !this.expression.isNull();
    }

    public boolean hasNot() {
        return this.hasNot;
    }

    @Override
    void parse(WordParser wordParser, boolean tolerant) {
        String identifier = this.getText();
        if (identifier != null) {
            wordParser.moveForward(identifier);
            this.hasNot = identifier == "IS NOT NULL";
        } else {
            wordParser.moveForward("IS");
            wordParser.skipLeadingWhitespace();
            this.hasNot = wordParser.startsWithIdentifier("NOT");
            if (this.hasNot) {
                wordParser.moveForward("NOT");
                wordParser.skipLeadingWhitespace();
            }
            wordParser.moveForward("NULL");
        }
    }

    @Override
    void toParsedText(StringBuilder writer, boolean includeVirtual) {
        if (this.hasExpression()) {
            this.expression.toParsedText(writer, includeVirtual);
            writer.append(' ');
        }
        writer.append(this.getIdentifier().toString());
    }

    private void updateExpression(AbstractExpression expression) {
        if (expression != null) {
            this.expression = expression;
            this.expression.setParent(this);
        }
    }
}

