/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.descriptors;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.eclipse.persistence.annotations.BatchFetchType;
import org.eclipse.persistence.annotations.CacheKeyType;
import org.eclipse.persistence.annotations.IdValidation;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.DescriptorEvent;
import org.eclipse.persistence.descriptors.DescriptorEventManager;
import org.eclipse.persistence.descriptors.FetchGroupManager;
import org.eclipse.persistence.descriptors.changetracking.ChangeTracker;
import org.eclipse.persistence.descriptors.changetracking.ObjectChangePolicy;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.databaseaccess.DatabaseAccessor;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.databaseaccess.Platform;
import org.eclipse.persistence.internal.descriptors.DescriptorIterator;
import org.eclipse.persistence.internal.descriptors.OptimisticLockingPolicy;
import org.eclipse.persistence.internal.descriptors.PersistenceEntity;
import org.eclipse.persistence.internal.expressions.ObjectExpression;
import org.eclipse.persistence.internal.expressions.QueryKeyExpression;
import org.eclipse.persistence.internal.expressions.SQLSelectStatement;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.helper.InvalidObject;
import org.eclipse.persistence.internal.identitymaps.CacheId;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.indirection.ProxyIndirectionPolicy;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.queries.EntityFetchGroup;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.AggregateChangeRecord;
import org.eclipse.persistence.internal.sessions.AggregateObjectChangeSet;
import org.eclipse.persistence.internal.sessions.DirectToFieldChangeRecord;
import org.eclipse.persistence.internal.sessions.MergeManager;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.TransformationMappingChangeRecord;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.AggregateMapping;
import org.eclipse.persistence.mappings.AggregateObjectMapping;
import org.eclipse.persistence.mappings.ContainerMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.mappings.foundation.AbstractDirectMapping;
import org.eclipse.persistence.mappings.foundation.AbstractTransformationMapping;
import org.eclipse.persistence.mappings.querykeys.DirectQueryKey;
import org.eclipse.persistence.mappings.querykeys.QueryKey;
import org.eclipse.persistence.queries.DataReadQuery;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.FetchGroup;
import org.eclipse.persistence.queries.FetchGroupTracker;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.queries.ObjectLevelModifyQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.QueryByExamplePolicy;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.queries.WriteObjectQuery;
import org.eclipse.persistence.sessions.CopyGroup;
import org.eclipse.persistence.sessions.DatabaseRecord;
import org.eclipse.persistence.sessions.changesets.ChangeRecord;
import org.eclipse.persistence.sessions.remote.RemoteSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectBuilder
implements Cloneable,
Serializable {
    protected ClassDescriptor descriptor;
    protected Map<String, DatabaseMapping> mappingsByAttribute;
    protected Map<DatabaseField, DatabaseMapping> mappingsByField;
    protected Map<DatabaseField, List<DatabaseMapping>> readOnlyMappingsByField;
    protected Map<DatabaseField, DatabaseField> fieldsMap;
    protected List<DatabaseMapping> primaryKeyMappings;
    protected List<Class> primaryKeyClassifications;
    protected transient List<DatabaseMapping> nonPrimaryKeyMappings;
    protected transient Expression primaryKeyExpression;
    protected List<DatabaseMapping> joinedAttributes;
    protected List<DatabaseMapping> batchFetchedAttributes;
    protected boolean hasInBatchFetchedAttribute;
    protected List<DatabaseMapping> cloningMappings;
    protected List<DatabaseMapping> eagerMappings;
    protected List<DatabaseMapping> relationshipMappings;
    protected boolean isSimple;
    protected boolean hasWrapperPolicy;
    protected AbstractDirectMapping sequenceMapping;
    protected boolean mayHaveNullInPrimaryKey;
    protected String lockAttribute;

    public ObjectBuilder(ClassDescriptor descriptor) {
        this.descriptor = descriptor;
        this.initialize(descriptor);
    }

    protected void initialize(ClassDescriptor descriptor) {
        this.mappingsByField = new HashMap<DatabaseField, DatabaseMapping>(20);
        this.readOnlyMappingsByField = new HashMap<DatabaseField, List<DatabaseMapping>>(10);
        this.mappingsByAttribute = new HashMap<String, DatabaseMapping>(20);
        this.fieldsMap = new HashMap<DatabaseField, DatabaseField>(20);
        this.primaryKeyMappings = new ArrayList<DatabaseMapping>(5);
        this.nonPrimaryKeyMappings = new ArrayList<DatabaseMapping>(10);
        this.cloningMappings = new ArrayList<DatabaseMapping>(10);
        this.eagerMappings = new ArrayList<DatabaseMapping>(5);
        this.relationshipMappings = new ArrayList<DatabaseMapping>(5);
    }

    public AbstractRecord createRecord(AbstractSession session) {
        return new DatabaseRecord();
    }

    public AbstractRecord createRecord(int size, AbstractSession session) {
        return new DatabaseRecord(size);
    }

    protected AbstractRecord createRecordForPKExtraction(int size, AbstractSession session) {
        return this.createRecord(size, session);
    }

    public void addPrimaryKeyForNonDefaultTable(AbstractRecord databaseRow) {
        this.addPrimaryKeyForNonDefaultTable(databaseRow, null, null);
    }

    public void addPrimaryKeyForNonDefaultTable(AbstractRecord databaseRow, Object object, AbstractSession session) {
        if (!this.descriptor.hasMultipleTables()) {
            return;
        }
        Vector<DatabaseTable> tables = this.descriptor.getTables();
        int size = tables.size();
        for (int index = 1; index < size; ++index) {
            DatabaseTable table = (DatabaseTable)tables.get(index);
            Map<DatabaseField, DatabaseField> keyMapping = this.descriptor.getAdditionalTablePrimaryKeyFields().get(table);
            if (keyMapping == null) continue;
            Iterator<DatabaseField> primaryKeyFieldEnum = keyMapping.keySet().iterator();
            Iterator<DatabaseField> secondaryKeyFieldEnum = keyMapping.values().iterator();
            while (primaryKeyFieldEnum.hasNext()) {
                DatabaseField primaryKeyField = primaryKeyFieldEnum.next();
                DatabaseField secondaryKeyField = secondaryKeyFieldEnum.next();
                Object primaryValue = databaseRow.getIndicatingNoEntry(primaryKeyField);
                if (primaryValue == AbstractRecord.noEntry) {
                    if (object != null) {
                        DatabaseMapping mapping = this.getMappingForField(secondaryKeyField);
                        if (mapping == null) {
                            throw DescriptorException.missingMappingForField(secondaryKeyField, this.descriptor);
                        }
                        mapping.writeFromObjectIntoRow(object, databaseRow, session, DatabaseMapping.WriteType.UNDEFINED);
                    }
                    databaseRow.put(primaryKeyField, databaseRow.get(secondaryKeyField));
                    continue;
                }
                databaseRow.put(secondaryKeyField, primaryValue);
            }
        }
    }

    public void clearPrimaryKey(Object object) {
        if (object instanceof PersistenceEntity) {
            ((PersistenceEntity)object)._persistence_setId(null);
        }
    }

    public void assignReturnRow(Object object, AbstractSession writeSession, AbstractRecord row, ObjectChangeSet changeSet) throws DatabaseException {
        writeSession.log(1, "query", "assign_return_row", row);
        ReadObjectQuery query = new ReadObjectQuery();
        query.setSession(writeSession);
        HashSet handledMappings = null;
        int size = row.size();
        if (size > 1) {
            handledMappings = new HashSet(size);
        }
        Vector fields = row.getFields();
        for (int index = 0; index < size; ++index) {
            DatabaseField field = (DatabaseField)fields.get(index);
            this.assignReturnValueForField(object, query, row, field, handledMappings, changeSet);
        }
    }

    public void assignReturnValueForField(Object object, ReadObjectQuery query, AbstractRecord row, DatabaseField field, Collection handledMappings, ObjectChangeSet changeSet) {
        List<DatabaseMapping> readOnlyMappings;
        DatabaseMapping mapping = this.getMappingForField(field);
        if (mapping != null) {
            this.assignReturnValueToMapping(object, query, row, field, mapping, handledMappings, changeSet);
        }
        if ((readOnlyMappings = this.getReadOnlyMappingsForField(field)) != null) {
            int size = readOnlyMappings.size();
            for (int index = 0; index < size; ++index) {
                mapping = readOnlyMappings.get(index);
                this.assignReturnValueToMapping(object, query, row, field, mapping, handledMappings, changeSet);
            }
        }
    }

    protected void assignReturnValueToMapping(Object object, ReadObjectQuery query, AbstractRecord row, DatabaseField field, DatabaseMapping mapping, Collection handledMappings, ObjectChangeSet changeSet) {
        if (handledMappings != null && handledMappings.contains(mapping)) {
            return;
        }
        if (mapping.isDirectToFieldMapping()) {
            if (changeSet != null && (!changeSet.isNew() || query.getDescriptor() != null && query.getDescriptor().shouldUseFullChangeSetsForNewObjects())) {
                DirectToFieldChangeRecord changeRecord = (DirectToFieldChangeRecord)changeSet.getChangesForAttributeNamed(mapping.getAttributeName());
                Object oldAttributeValue = null;
                if (changeRecord == null) {
                    oldAttributeValue = mapping.getAttributeValueFromObject(object);
                }
                Object attributeValue = mapping.readFromRowIntoObject(row, null, object, null, query, query.getSession(), true);
                if (changeRecord == null) {
                    changeRecord = (DirectToFieldChangeRecord)((DirectToFieldMapping)mapping).internalBuildChangeRecord(attributeValue, oldAttributeValue, changeSet);
                    changeSet.addChange(changeRecord);
                } else {
                    changeRecord.setNewValue(attributeValue);
                }
            } else {
                mapping.readFromRowIntoObject(row, null, object, null, query, query.getSession(), true);
            }
        } else if (mapping.isAggregateObjectMapping()) {
            ((AggregateObjectMapping)mapping).readFromReturnRowIntoObject(row, object, query, handledMappings, changeSet);
        } else if (mapping.isTransformationMapping()) {
            ((AbstractTransformationMapping)mapping).readFromReturnRowIntoObject(row, object, query, handledMappings, changeSet);
        } else {
            query.getSession().log(1, "query", "field_for_unsupported_mapping_returned", field, this.descriptor);
        }
    }

    public Object assignSequenceNumber(Object object, AbstractSession writeSession) throws DatabaseException {
        return this.assignSequenceNumber(object, writeSession, null);
    }

    public Object assignSequenceNumber(WriteObjectQuery writeQuery) throws DatabaseException {
        return this.assignSequenceNumber(writeQuery.getObject(), writeQuery.getSession(), writeQuery);
    }

    protected Object assignSequenceNumber(Object object, AbstractSession writeSession, WriteObjectQuery writeQuery) throws DatabaseException {
        int index;
        DatabaseField sequenceNumberField = this.descriptor.getSequenceNumberField();
        Object existingValue = null;
        existingValue = this.sequenceMapping != null ? this.sequenceMapping.getAttributeValueFromObject(object) : this.getBaseValueForField(sequenceNumberField, object);
        if (!this.isPrimaryKeyComponentInvalid(existingValue, index = this.descriptor.getPrimaryKeyFields().indexOf(sequenceNumberField)) && !this.descriptor.getSequence().shouldAlwaysOverrideExistingValue()) {
            return null;
        }
        Object sequenceValue = writeSession.getSequencing().getNextValue(this.descriptor.getJavaClass());
        if (sequenceValue == null) {
            return null;
        }
        writeSession.log(1, "sequencing", "assign_sequence", sequenceValue, object);
        Object convertedSequenceValue = null;
        if (this.sequenceMapping != null) {
            convertedSequenceValue = this.sequenceMapping.getAttributeValue(sequenceValue, writeSession);
            this.sequenceMapping.setAttributeValueInObject(object, convertedSequenceValue);
        } else {
            AbstractRecord tempRow = this.createRecord(1, writeSession);
            tempRow.put(sequenceNumberField, sequenceValue);
            ReadObjectQuery query = new ReadObjectQuery();
            query.setSession(writeSession);
            DatabaseMapping mapping = this.getBaseMappingForField(sequenceNumberField);
            Object sequenceIntoObject = this.getParentObjectForField(sequenceNumberField, object);
            convertedSequenceValue = mapping.readFromRowIntoObject(tempRow, null, sequenceIntoObject, null, query, writeSession, true);
        }
        this.clearPrimaryKey(object);
        if (writeQuery != null) {
            Object primaryKey = this.extractPrimaryKeyFromObject(object, writeSession);
            writeQuery.setPrimaryKey(primaryKey);
            AbstractRecord modifyRow = writeQuery.getModifyRow();
            modifyRow.put(sequenceNumberField, sequenceValue);
            if (this.descriptor.hasMultipleTables()) {
                this.addPrimaryKeyForNonDefaultTable(modifyRow, object, writeSession);
            }
            if (writeSession.isUnitOfWork()) {
                ObjectChangeSet objectChangeSet = writeQuery.getObjectChangeSet();
                if (objectChangeSet == null && ((UnitOfWorkImpl)writeSession).getUnitOfWorkChangeSet() != null) {
                    objectChangeSet = (ObjectChangeSet)((UnitOfWorkImpl)writeSession).getUnitOfWorkChangeSet().getObjectChangeSetForClone(object);
                }
                if (objectChangeSet != null) {
                    if (writeQuery.getDescriptor().shouldUseFullChangeSetsForNewObjects()) {
                        if (this.sequenceMapping != null) {
                            String attributeName = this.sequenceMapping.getAttributeName();
                            DirectToFieldChangeRecord changeRecord = (DirectToFieldChangeRecord)objectChangeSet.getChangesForAttributeNamed(attributeName);
                            if (changeRecord == null) {
                                changeRecord = new DirectToFieldChangeRecord(objectChangeSet);
                                changeRecord.setAttribute(attributeName);
                                changeRecord.setMapping(this.sequenceMapping);
                                objectChangeSet.addChange(changeRecord);
                            }
                            changeRecord.setNewValue(convertedSequenceValue);
                        } else {
                            org.eclipse.persistence.internal.sessions.ChangeRecord changeRecord = this.getBaseChangeRecordForField(objectChangeSet, object, sequenceNumberField, writeSession);
                            if (changeRecord.getMapping().isDirectCollectionMapping()) {
                                ((DirectToFieldChangeRecord)changeRecord).setNewValue(convertedSequenceValue);
                            } else if (changeRecord.getMapping().isTransformationMapping()) {
                                ((TransformationMappingChangeRecord)changeRecord).getRecord().put(sequenceNumberField, sequenceValue);
                            }
                        }
                    }
                    objectChangeSet.setId(primaryKey);
                }
            }
        }
        return convertedSequenceValue;
    }

    public void buildAttributesIntoObject(Object domainObject, CacheKey cacheKey, AbstractRecord databaseRow, ObjectBuildingQuery query, JoinedAttributeManager joinManager, boolean forRefresh, AbstractSession targetSession) throws DatabaseException {
        DescriptorEventManager descriptorEventManager;
        Vector<DatabaseMapping> mappings = this.descriptor.getMappings();
        boolean readAllMappings = query.shouldReadAllMappings();
        boolean isTargetProtected = targetSession.isProtectedSession();
        int size = mappings.size();
        for (int index = 0; index < size; ++index) {
            DatabaseMapping mapping = (DatabaseMapping)mappings.get(index);
            if (!readAllMappings && !query.shouldReadMapping(mapping)) continue;
            mapping.readFromRowIntoObject(databaseRow, joinManager, domainObject, cacheKey, query, targetSession, isTargetProtected);
        }
        if (this.descriptor.hasEventManager() && (descriptorEventManager = this.descriptor.getDescriptorEventManager()).hasAnyEventListeners()) {
            DescriptorEvent event = new DescriptorEvent(domainObject);
            event.setQuery(query);
            event.setSession(query.getSession());
            event.setRecord(databaseRow);
            if (forRefresh) {
                event.setEventCode(9);
            } else {
                event.setEventCode(8);
            }
            descriptorEventManager.executeEvent(event);
        }
    }

    public Object buildBackupClone(Object clone, UnitOfWorkImpl unitOfWork) {
        ClassDescriptor descriptor = this.descriptor;
        Object backup = descriptor.getCopyPolicy().buildClone(clone, unitOfWork);
        List<DatabaseMapping> mappings = this.getCloningMappings();
        int size = mappings.size();
        if (descriptor.hasFetchGroupManager() && descriptor.getFetchGroupManager().isPartialObject(clone)) {
            FetchGroupManager fetchGroupManager = descriptor.getFetchGroupManager();
            for (int index = 0; index < size; ++index) {
                DatabaseMapping mapping = mappings.get(index);
                if (!fetchGroupManager.isAttributeFetched(clone, mapping.getAttributeName())) continue;
                mapping.buildBackupClone(clone, backup, unitOfWork);
            }
        } else {
            for (int index = 0; index < size; ++index) {
                mappings.get(index).buildBackupClone(clone, backup, unitOfWork);
            }
        }
        return backup;
    }

    public Expression buildDeleteExpression(DatabaseTable table, AbstractRecord row, boolean usesOptimisticLocking) {
        if (usesOptimisticLocking && this.descriptor.getTables().firstElement().equals(table)) {
            return this.descriptor.getOptimisticLockingPolicy().buildDeleteExpression(table, this.primaryKeyExpression, row);
        }
        return this.buildPrimaryKeyExpression(table);
    }

    public Expression buildExpressionFromExample(Object queryObject, QueryByExamplePolicy policy, Expression expressionBuilder, Map processedObjects, AbstractSession session) {
        if (processedObjects.containsKey(queryObject)) {
            return null;
        }
        processedObjects.put(queryObject, queryObject);
        Expression expression = null;
        Vector<DatabaseMapping> mappings = this.descriptor.getMappings();
        for (int index = 0; index < mappings.size(); ++index) {
            DatabaseMapping mapping = (DatabaseMapping)mappings.get(index);
            expression = expression == null ? mapping.buildExpression(queryObject, policy, expressionBuilder, processedObjects, session) : expression.and(mapping.buildExpression(queryObject, policy, expressionBuilder, processedObjects, session));
        }
        return expression;
    }

    public Object buildNewInstance() {
        return this.descriptor.getInstantiationPolicy().buildNewInstance();
    }

    public Object buildObject(ObjectLevelReadQuery query, AbstractRecord databaseRow) throws DatabaseException, QueryException {
        JoinedAttributeManager joinManager = null;
        if (query.hasJoining()) {
            joinManager = query.getJoinedAttributeManager();
        }
        return this.buildObject(query, databaseRow, joinManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object buildObject(ObjectBuildingQuery query, AbstractRecord databaseRow, JoinedAttributeManager joinManager) throws DatabaseException, QueryException {
        AbstractSession session = query.getSession();
        session.startOperationProfile("Timer:ObjectBuilding", query, Integer.MAX_VALUE);
        Object domainObject = null;
        try {
            Object primaryKey = this.extractPrimaryKeyFromRow(databaseRow, session);
            if (primaryKey == null && !query.hasPartialAttributeExpressions() && !this.descriptor.isAggregateCollectionDescriptor()) {
                if (query.shouldBuildNullForNullPk()) {
                    Object var7_7 = null;
                    return var7_7;
                }
                throw QueryException.nullPrimaryKeyInBuildingObject(query, databaseRow);
            }
            ClassDescriptor concreteDescriptor = this.descriptor;
            if (concreteDescriptor.hasInheritance() && concreteDescriptor.getInheritancePolicy().shouldReadSubclasses()) {
                Class classValue = concreteDescriptor.getInheritancePolicy().classFromRow(databaseRow, session);
                if ((concreteDescriptor = concreteDescriptor.getInheritancePolicy().getDescriptor(classValue)) == null && query.hasPartialAttributeExpressions()) {
                    concreteDescriptor = this.descriptor;
                }
                if (concreteDescriptor == null) {
                    throw QueryException.noDescriptorForClassFromInheritancePolicy(query, classValue);
                }
            }
            if (session.isUnitOfWork()) {
                domainObject = this.buildObjectInUnitOfWork(query, joinManager, databaseRow, (UnitOfWorkImpl)session, primaryKey, concreteDescriptor);
            } else {
                domainObject = this.buildObject(false, query, databaseRow, session, primaryKey, concreteDescriptor, joinManager);
                if (query.shouldCacheQueryResults()) {
                    query.cacheResult(domainObject);
                }
                if (query.shouldUseWrapperPolicy()) {
                    domainObject = concreteDescriptor.getObjectBuilder().wrapObject(domainObject, session);
                }
            }
        }
        finally {
            session.endOperationProfile("Timer:ObjectBuilding", query, Integer.MAX_VALUE);
        }
        return domainObject;
    }

    public void instantiateEagerMappings(Object object, AbstractSession session) {
        if (!this.eagerMappings.isEmpty()) {
            FetchGroup fetchGroup = null;
            FetchGroupManager fetchGroupManager = this.descriptor.getFetchGroupManager();
            if (fetchGroupManager != null) {
                fetchGroup = fetchGroupManager.getObjectFetchGroup(object);
            }
            int size = this.eagerMappings.size();
            for (int index = 0; index < size; ++index) {
                DatabaseMapping mapping = this.eagerMappings.get(index);
                if (fetchGroup != null && !fetchGroup.containsAttributeInternal(mapping.getAttributeName())) continue;
                mapping.instantiateAttribute(object, session);
            }
        }
    }

    protected Object buildObjectInUnitOfWork(ObjectBuildingQuery query, JoinedAttributeManager joinManager, AbstractRecord databaseRow, UnitOfWorkImpl unitOfWork, Object primaryKey, ClassDescriptor concreteDescriptor) throws DatabaseException, QueryException {
        if (!concreteDescriptor.shouldUseSessionCacheInUnitOfWorkEarlyTransaction() && (unitOfWork.hasCommitManager() && unitOfWork.getCommitManager().isActive() || unitOfWork.wasTransactionBegunPrematurely() || concreteDescriptor.shouldIsolateObjectsInUnitOfWork() || concreteDescriptor.shouldIsolateProtectedObjectsInUnitOfWork() || query.shouldStoreBypassCache()) && !unitOfWork.isClassReadOnly(concreteDescriptor.getJavaClass(), concreteDescriptor)) {
            return concreteDescriptor.getObjectBuilder().buildWorkingCopyCloneFromRow(query, joinManager, databaseRow, unitOfWork, primaryKey);
        }
        return this.buildWorkingCopyCloneNormally(query, databaseRow, unitOfWork, primaryKey, concreteDescriptor, joinManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object buildWorkingCopyCloneNormally(ObjectBuildingQuery query, AbstractRecord databaseRow, UnitOfWorkImpl unitOfWork, Object primaryKey, ClassDescriptor concreteDescriptor, JoinedAttributeManager joinManager) throws DatabaseException, QueryException {
        CacheKey unitOfWorkCacheKey = unitOfWork.getIdentityMapAccessorInstance().acquireLock(primaryKey, concreteDescriptor.getJavaClass(), concreteDescriptor);
        Object clone = unitOfWorkCacheKey.getObject();
        boolean found = clone != null;
        Object original = null;
        try {
            if (!found || query.shouldRefreshIdentityMapResult() || query.shouldCacheQueryResults() || query.shouldRetrieveBypassCache() || concreteDescriptor.hasFetchGroupManager() && concreteDescriptor.getFetchGroupManager().isPartialObject(clone)) {
                AbstractSession session = unitOfWork.getParentIdentityMapSession(query);
                query.setSession(session);
                if (session.isUnitOfWork()) {
                    original = this.buildObjectInUnitOfWork(query, joinManager, databaseRow, (UnitOfWorkImpl)session, primaryKey, concreteDescriptor);
                    if (unitOfWork.shouldCascadeCloneToJoinedRelationship()) {
                        Object object = query.registerIndividualResult(original, primaryKey, unitOfWork, joinManager, concreteDescriptor);
                        return object;
                    }
                    Object object = query.registerIndividualResult(original, primaryKey, unitOfWork, null, concreteDescriptor);
                    return object;
                }
                CacheKey parentCacheKey = (CacheKey)this.buildObject(true, query, databaseRow, session, primaryKey, concreteDescriptor, joinManager);
                original = parentCacheKey.getObject();
                if (query.shouldCacheQueryResults()) {
                    query.cacheResult(original);
                }
                if (unitOfWork.isClassReadOnly(original.getClass(), concreteDescriptor)) {
                    query.recordCloneForPessimisticLocking(original, unitOfWork);
                    Object object = original;
                    return object;
                }
                if (!query.isRegisteringResults()) {
                    Object object = original;
                    return object;
                }
                if (clone == null) {
                    clone = unitOfWork.cloneAndRegisterObject(original, parentCacheKey, unitOfWorkCacheKey, concreteDescriptor);
                }
                if (concreteDescriptor.hasFetchGroupManager() && concreteDescriptor.getFetchGroupManager().shouldWriteInto(original, clone)) {
                    concreteDescriptor.getFetchGroupManager().writePartialIntoClones(original, clone, unitOfWork);
                }
            }
            query.postRegisterIndividualResult(clone, original, primaryKey, unitOfWork, joinManager, concreteDescriptor);
        }
        finally {
            unitOfWorkCacheKey.release();
            query.setSession(unitOfWork);
        }
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object buildObject(boolean returnCacheKey, ObjectBuildingQuery query, AbstractRecord databaseRow, AbstractSession session, Object primaryKey, ClassDescriptor concreteDescriptor, JoinedAttributeManager joinManager) throws DatabaseException, QueryException {
        boolean isProtected = concreteDescriptor.isProtectedIsolation();
        if (isProtected && session.isIsolatedClientSession()) {
            return this.buildProtectedObject(returnCacheKey, query, databaseRow, session, primaryKey, concreteDescriptor, joinManager);
        }
        Object domainObject = null;
        CacheKey cacheKey = null;
        boolean cacheHit = true;
        try {
            if (!(!query.shouldMaintainCache() || query.shouldRetrieveBypassCache() && query.shouldStoreBypassCache())) {
                cacheKey = session.retrieveCacheKey(primaryKey, concreteDescriptor, joinManager, query.requiresDeferredLocks());
                domainObject = cacheKey.getObject();
            }
            if (domainObject == null || query.shouldRetrieveBypassCache()) {
                boolean domainWasMissing;
                cacheHit = false;
                boolean bl = domainWasMissing = domainObject == null;
                if (domainObject == null || query.shouldStoreBypassCache()) {
                    domainObject = query.isReadObjectQuery() && ((ReadObjectQuery)query).shouldLoadResultIntoSelectionObject() ? ((ReadObjectQuery)query).getSelectionObject() : concreteDescriptor.getObjectBuilder().buildNewInstance();
                }
                if (query.shouldMaintainCache() && !query.shouldStoreBypassCache()) {
                    if (domainWasMissing) {
                        cacheKey.setObject(domainObject);
                    }
                    this.copyQueryInfoToCacheKey(cacheKey, query, databaseRow, session, concreteDescriptor);
                } else if (returnCacheKey && (cacheKey == null || domainWasMissing && query.shouldRetrieveBypassCache())) {
                    cacheKey = new CacheKey(primaryKey);
                    cacheKey.setObject(domainObject);
                }
                concreteDescriptor.getObjectBuilder().buildAttributesIntoObject(domainObject, cacheKey, databaseRow, query, joinManager, false, session);
                if (isProtected && cacheKey != null) {
                    this.cacheForeignKeyValues(databaseRow, cacheKey, session);
                }
                if (query.shouldMaintainCache() && !query.shouldStoreBypassCache() && query.getEntityFetchGroup() != null && concreteDescriptor.hasFetchGroupManager()) {
                    query.getEntityFetchGroup().setOnEntity(domainObject, session);
                }
                if (domainObject instanceof PersistenceEntity) {
                    ((PersistenceEntity)domainObject)._persistence_setId(primaryKey);
                }
            } else {
                if (query.isReadObjectQuery() && ((ReadObjectQuery)query).shouldLoadResultIntoSelectionObject()) {
                    this.copyInto(domainObject, ((ReadObjectQuery)query).getSelectionObject());
                    domainObject = ((ReadObjectQuery)query).getSelectionObject();
                }
                boolean isInvalidated = concreteDescriptor.getCacheInvalidationPolicy().isInvalidated(cacheKey, query.getExecutionTime());
                if (cacheKey.getMutex().getActiveThread() == Thread.currentThread() && (query.shouldRefreshIdentityMapResult() || concreteDescriptor.shouldAlwaysRefreshCache() || isInvalidated) && cacheKey.getLastUpdatedQueryId() != query.getQueryId() && !cacheKey.getMutex().isLockedByMergeManager()) {
                    cacheHit = this.refreshObjectIfRequired(concreteDescriptor, cacheKey, cacheKey.getObject(), query, joinManager, databaseRow, session, false);
                } else if (concreteDescriptor.hasFetchGroupManager() && concreteDescriptor.getFetchGroupManager().isPartialObject(domainObject) && !concreteDescriptor.getFetchGroupManager().isObjectValidForFetchGroup(domainObject, query.getEntityFetchGroup())) {
                    cacheHit = false;
                    concreteDescriptor.getFetchGroupManager().unionEntityFetchGroupIntoObject(domainObject, query.getEntityFetchGroup(), session);
                    concreteDescriptor.getObjectBuilder().buildAttributesIntoObject(domainObject, cacheKey, databaseRow, query, joinManager, false, session);
                    if (cacheKey != null) {
                        this.cacheForeignKeyValues(databaseRow, cacheKey, session);
                    }
                } else if (joinManager != null && joinManager.hasJoinedAttributeExpressions()) {
                    this.loadJoinedAttributes(concreteDescriptor, domainObject, cacheKey, databaseRow, joinManager, query, false);
                } else if (query.isReadAllQuery() && ((ReadAllQuery)query).hasBatchReadAttributes()) {
                    this.loadBatchReadAttributes(concreteDescriptor, domainObject, cacheKey, databaseRow, query, joinManager, false);
                }
            }
        }
        finally {
            if (query.shouldMaintainCache() && cacheKey != null) {
                if (cacheKey.getObject() != null) {
                    cacheKey.updateAccess();
                }
                if (query.requiresDeferredLocks()) {
                    cacheKey.releaseDeferredLock();
                } else {
                    cacheKey.release();
                }
            }
        }
        if (!cacheHit) {
            concreteDescriptor.getObjectBuilder().instantiateEagerMappings(domainObject, session);
        }
        if (returnCacheKey) {
            return cacheKey;
        }
        return domainObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object buildProtectedObject(boolean returnCacheKey, ObjectBuildingQuery query, AbstractRecord databaseRow, AbstractSession session, Object primaryKey, ClassDescriptor concreteDescriptor, JoinedAttributeManager joinManager) throws DatabaseException, QueryException {
        Object cachedObject = null;
        Object protectedObject = null;
        CacheKey cacheKey = null;
        CacheKey sharedCacheKey = null;
        boolean cacheHit = true;
        try {
            if (!(!query.shouldMaintainCache() || query.shouldRetrieveBypassCache() && query.shouldStoreBypassCache())) {
                cacheKey = session.retrieveCacheKey(primaryKey, concreteDescriptor, joinManager, query.requiresDeferredLocks());
                protectedObject = cacheKey.getObject();
            }
            if (protectedObject == null || query.shouldRetrieveBypassCache()) {
                boolean domainWasMissing;
                cacheHit = false;
                boolean bl = domainWasMissing = protectedObject == null;
                if (protectedObject == null || query.shouldStoreBypassCache()) {
                    protectedObject = query.isReadObjectQuery() && ((ReadObjectQuery)query).shouldLoadResultIntoSelectionObject() ? ((ReadObjectQuery)query).getSelectionObject() : concreteDescriptor.getObjectBuilder().buildNewInstance();
                }
                if (query.shouldMaintainCache() && !query.shouldStoreBypassCache()) {
                    if (domainWasMissing) {
                        cacheKey.setObject(protectedObject);
                    }
                    this.copyQueryInfoToCacheKey(cacheKey, query, databaseRow, session, concreteDescriptor);
                } else if (returnCacheKey && (cacheKey == null || domainWasMissing && query.shouldRetrieveBypassCache())) {
                    cacheKey = new CacheKey(primaryKey);
                    cacheKey.setObject(protectedObject);
                }
                if (query.shouldMaintainCache() && !query.shouldStoreBypassCache() && (sharedCacheKey = session.getParent().retrieveCacheKey(primaryKey, concreteDescriptor, joinManager, query.requiresDeferredLocks())).getObject() == null) {
                    sharedCacheKey = (CacheKey)this.buildObject(true, query, databaseRow, session.getParent(), primaryKey, concreteDescriptor, joinManager);
                    cachedObject = sharedCacheKey.getObject();
                }
                concreteDescriptor.getObjectBuilder().buildAttributesIntoObject(protectedObject, sharedCacheKey, databaseRow, query, joinManager, false, session);
                if (query.shouldMaintainCache() && !query.shouldStoreBypassCache() && query.getEntityFetchGroup() != null && concreteDescriptor.hasFetchGroupManager()) {
                    query.getEntityFetchGroup().setOnEntity(protectedObject, session);
                }
                if (protectedObject instanceof PersistenceEntity) {
                    ((PersistenceEntity)protectedObject)._persistence_setId(primaryKey);
                }
            } else {
                if (query.isReadObjectQuery() && ((ReadObjectQuery)query).shouldLoadResultIntoSelectionObject()) {
                    this.copyInto(protectedObject, ((ReadObjectQuery)query).getSelectionObject());
                    protectedObject = ((ReadObjectQuery)query).getSelectionObject();
                }
                if ((cachedObject = (sharedCacheKey = session.getParent().retrieveCacheKey(primaryKey, concreteDescriptor, joinManager, query.requiresDeferredLocks())).getObject()) == null) {
                    sharedCacheKey = (CacheKey)this.buildObject(true, query, databaseRow, session.getParent(), primaryKey, concreteDescriptor, joinManager);
                    cachedObject = sharedCacheKey.getObject();
                }
                boolean isInvalidated = concreteDescriptor.getCacheInvalidationPolicy().isInvalidated(sharedCacheKey, query.getExecutionTime());
                if (sharedCacheKey.getMutex().getActiveThread() == Thread.currentThread() && (query.shouldRefreshIdentityMapResult() || concreteDescriptor.shouldAlwaysRefreshCache() || isInvalidated) && sharedCacheKey.getLastUpdatedQueryId() != query.getQueryId() && !sharedCacheKey.getMutex().isLockedByMergeManager()) {
                    cacheHit = this.refreshObjectIfRequired(concreteDescriptor, sharedCacheKey, cachedObject, query, joinManager, databaseRow, session.getParent(), true);
                    this.refreshObjectIfRequired(concreteDescriptor, sharedCacheKey, protectedObject, query, joinManager, databaseRow, session, true);
                } else if (concreteDescriptor.hasFetchGroupManager() && concreteDescriptor.getFetchGroupManager().isPartialObject(protectedObject) && !concreteDescriptor.getFetchGroupManager().isObjectValidForFetchGroup(protectedObject, query.getEntityFetchGroup())) {
                    cacheHit = false;
                    concreteDescriptor.getFetchGroupManager().unionEntityFetchGroupIntoObject(protectedObject, query.getEntityFetchGroup(), session);
                    concreteDescriptor.getObjectBuilder().buildAttributesIntoObject(protectedObject, sharedCacheKey, databaseRow, query, joinManager, false, session);
                } else if (joinManager != null && joinManager.hasJoinedAttributeExpressions()) {
                    this.loadJoinedAttributes(concreteDescriptor, cachedObject, sharedCacheKey, databaseRow, joinManager, query, false);
                    this.loadJoinedAttributes(concreteDescriptor, protectedObject, sharedCacheKey, databaseRow, joinManager, query, true);
                } else if (query.isReadAllQuery() && ((ReadAllQuery)query).hasBatchReadAttributes()) {
                    this.loadBatchReadAttributes(concreteDescriptor, cachedObject, sharedCacheKey, databaseRow, query, joinManager, false);
                    this.loadBatchReadAttributes(concreteDescriptor, protectedObject, sharedCacheKey, databaseRow, query, joinManager, true);
                }
            }
            Object var15_15 = null;
        }
        catch (Throwable throwable) {
            Object var15_16 = null;
            if (!query.shouldMaintainCache()) throw throwable;
            if (cacheKey != null) {
                if (cacheKey.getObject() != null) {
                    cacheKey.updateAccess();
                }
                if (query.requiresDeferredLocks()) {
                    cacheKey.releaseDeferredLock();
                } else {
                    cacheKey.release();
                }
            }
            if (sharedCacheKey == null) throw throwable;
            if (sharedCacheKey.getObject() != null) {
                sharedCacheKey.updateAccess();
            }
            if (query.requiresDeferredLocks()) {
                sharedCacheKey.releaseDeferredLock();
                throw throwable;
            }
            sharedCacheKey.release();
            throw throwable;
        }
        if (query.shouldMaintainCache()) {
            if (cacheKey != null) {
                if (cacheKey.getObject() != null) {
                    cacheKey.updateAccess();
                }
                if (query.requiresDeferredLocks()) {
                    cacheKey.releaseDeferredLock();
                } else {
                    cacheKey.release();
                }
            }
            if (sharedCacheKey != null) {
                if (sharedCacheKey.getObject() != null) {
                    sharedCacheKey.updateAccess();
                }
                if (query.requiresDeferredLocks()) {
                    sharedCacheKey.releaseDeferredLock();
                } else {
                    sharedCacheKey.release();
                }
            }
        }
        if (!cacheHit) {
            concreteDescriptor.getObjectBuilder().instantiateEagerMappings(protectedObject, session);
        }
        if (!returnCacheKey) return protectedObject;
        return cacheKey;
    }

    private void revertFetchGroupData(Object domainObject, ClassDescriptor concreteDescriptor, CacheKey cacheKey, ObjectBuildingQuery query, JoinedAttributeManager joinManager, AbstractRecord databaseRow, AbstractSession session, boolean targetIsProtected) {
        concreteDescriptor.getFetchGroupManager().reset(domainObject);
        concreteDescriptor.getFetchGroupManager().setObjectFetchGroup(domainObject, query.getEntityFetchGroup(), session);
        cacheKey.setReadTime(query.getExecutionTime());
        concreteDescriptor.getObjectBuilder().buildAttributesIntoObject(domainObject, cacheKey, databaseRow, query, joinManager, false, session);
        concreteDescriptor.getFetchGroupManager().setRefreshOnFetchGroupToObject(domainObject, query.shouldRefreshIdentityMapResult() || concreteDescriptor.shouldAlwaysRefreshCache());
        cacheKey.setLastUpdatedQueryId(query.getQueryId());
        if (concreteDescriptor.usesOptimisticLocking()) {
            OptimisticLockingPolicy policy = concreteDescriptor.getOptimisticLockingPolicy();
            cacheKey.setWriteLockValue(policy.getValueToPutInCache(databaseRow, session));
        }
    }

    public Object buildObjectsInto(ReadAllQuery query, List databaseRows, Object domainObjects) throws DatabaseException {
        int size = databaseRows.size();
        if (size > 0) {
            ContainerPolicy policy;
            AbstractSession session = query.getSession();
            JoinedAttributeManager joinManager = null;
            if (query.hasJoining()) {
                joinManager = query.getJoinedAttributeManager();
            }
            if ((policy = query.getContainerPolicy()).shouldAddAll()) {
                ArrayList<Object> domainObjectsIn = new ArrayList<Object>(size);
                ArrayList<AbstractRecord> databaseRowsIn = new ArrayList<AbstractRecord>(size);
                for (int index = 0; index < size; ++index) {
                    AbstractRecord databaseRow = (AbstractRecord)databaseRows.get(index);
                    if (databaseRow == null) continue;
                    domainObjectsIn.add(this.buildObject(query, databaseRow, joinManager));
                    databaseRowsIn.add(databaseRow);
                }
                policy.addAll(domainObjectsIn, domainObjects, session, databaseRowsIn, query, (CacheKey)null, true);
            } else {
                boolean quickAdd = domainObjects instanceof Collection && !this.hasWrapperPolicy;
                for (int index = 0; index < size; ++index) {
                    AbstractRecord databaseRow = (AbstractRecord)databaseRows.get(index);
                    if (databaseRow == null) continue;
                    Object domainObject = this.buildObject(query, databaseRow, joinManager);
                    if (quickAdd) {
                        ((Collection)domainObjects).add(domainObject);
                        continue;
                    }
                    policy.addInto(domainObject, domainObjects, session, databaseRow, query, (CacheKey)null, true);
                }
            }
        }
        return domainObjects;
    }

    public Expression buildPrimaryKeyExpression(DatabaseTable table) throws DescriptorException {
        if (this.descriptor.getTables().firstElement().equals(table)) {
            return this.getPrimaryKeyExpression();
        }
        Map<DatabaseField, DatabaseField> keyMapping = this.descriptor.getAdditionalTablePrimaryKeyFields().get(table);
        if (keyMapping == null) {
            throw DescriptorException.multipleTablePrimaryKeyNotSpecified(this.descriptor);
        }
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = null;
        for (DatabaseField field : keyMapping.values()) {
            expression = builder.getField(field).equal(builder.getParameter(field)).and(expression);
        }
        return expression;
    }

    public Expression buildPrimaryKeyExpressionFromKeys(Object primaryKey, AbstractSession session) {
        ExpressionBuilder builder = new ExpressionBuilder();
        List<DatabaseField> primaryKeyFields = this.descriptor.getPrimaryKeyFields();
        if (this.descriptor.getCacheKeyType() == CacheKeyType.ID_VALUE) {
            return ((Expression)builder).getField(primaryKeyFields.get(0)).equal(primaryKey);
        }
        Expression expression = null;
        int size = primaryKeyFields.size();
        Object[] primaryKeyValues = ((CacheId)primaryKey).getPrimaryKey();
        for (int index = 0; index < size; ++index) {
            Object value = primaryKeyValues[index];
            DatabaseField field = primaryKeyFields.get(index);
            if (value == null) continue;
            Expression subExpression = ((Expression)builder).getField(field).equal(value);
            expression = subExpression.and(expression);
        }
        return expression;
    }

    public Expression buildPrimaryKeyExpressionFromObject(Object domainObject, AbstractSession session) {
        return this.buildPrimaryKeyExpressionFromKeys(this.extractPrimaryKeyFromObject(domainObject, session), session);
    }

    public AbstractRecord buildRow(Object object, AbstractSession session, DatabaseMapping.WriteType writeType) {
        return this.buildRow(this.createRecord(session), object, session, writeType);
    }

    public AbstractRecord buildRow(AbstractRecord databaseRow, Object object, AbstractSession session, DatabaseMapping.WriteType writeType) {
        Vector<DatabaseMapping> mappings = this.descriptor.getMappings();
        int mappingsSize = mappings.size();
        for (int index = 0; index < mappingsSize; ++index) {
            DatabaseMapping mapping = (DatabaseMapping)mappings.get(index);
            mapping.writeFromObjectIntoRow(object, databaseRow, session, writeType);
        }
        if (this.descriptor.hasInheritance()) {
            this.descriptor.getInheritancePolicy().addClassIndicatorFieldToRow(databaseRow);
        }
        if (this.descriptor.hasMultipleTables() && !this.descriptor.isAggregateDescriptor()) {
            this.addPrimaryKeyForNonDefaultTable(databaseRow, object, session);
        }
        if (this.getDescriptor().hasMultitenantPolicy()) {
            this.getDescriptor().getMultitenantPolicy().addFieldsToRow(databaseRow, session);
        }
        return databaseRow;
    }

    public AbstractRecord buildRowForShallowInsert(Object object, AbstractSession session) {
        return this.buildRowForShallowInsert(this.createRecord(session), object, session);
    }

    public AbstractRecord buildRowForShallowInsert(AbstractRecord databaseRow, Object object, AbstractSession session) {
        Vector<DatabaseMapping> mappings = this.descriptor.getMappings();
        int mappingsSize = mappings.size();
        for (int index = 0; index < mappingsSize; ++index) {
            DatabaseMapping mapping = (DatabaseMapping)mappings.get(index);
            mapping.writeFromObjectIntoRowForShallowInsert(object, databaseRow, session);
        }
        if (this.descriptor.hasInheritance()) {
            this.descriptor.getInheritancePolicy().addClassIndicatorFieldToRow(databaseRow);
        }
        if (!this.descriptor.isAggregateDescriptor()) {
            this.addPrimaryKeyForNonDefaultTable(databaseRow, object, session);
        }
        if (this.getDescriptor().hasMultitenantPolicy()) {
            this.getDescriptor().getMultitenantPolicy().addFieldsToRow(databaseRow, session);
        }
        return databaseRow;
    }

    public AbstractRecord buildRowWithChangeSet(AbstractRecord databaseRow, ObjectChangeSet objectChangeSet, AbstractSession session, DatabaseMapping.WriteType writeType) {
        List<ChangeRecord> changes = objectChangeSet.getChanges();
        int size = changes.size();
        for (int index = 0; index < size; ++index) {
            org.eclipse.persistence.internal.sessions.ChangeRecord changeRecord = (org.eclipse.persistence.internal.sessions.ChangeRecord)changes.get(index);
            DatabaseMapping mapping = changeRecord.getMapping();
            mapping.writeFromObjectIntoRowWithChangeRecord(changeRecord, databaseRow, session, writeType);
        }
        if (this.descriptor.hasInheritance()) {
            this.descriptor.getInheritancePolicy().addClassIndicatorFieldToRow(databaseRow);
        }
        if (this.getDescriptor().hasMultitenantPolicy()) {
            this.getDescriptor().getMultitenantPolicy().addFieldsToRow(databaseRow, session);
        }
        return databaseRow;
    }

    public AbstractRecord buildRowForTranslation(Object object, AbstractSession session) {
        AbstractRecord databaseRow = this.createRecord(session);
        List<DatabaseMapping> primaryKeyMappings = this.getPrimaryKeyMappings();
        int size = primaryKeyMappings.size();
        for (int index = 0; index < size; ++index) {
            DatabaseMapping mapping = primaryKeyMappings.get(index);
            if (mapping == null) continue;
            mapping.writeFromObjectIntoRow(object, databaseRow, session, DatabaseMapping.WriteType.UNDEFINED);
        }
        if (this.descriptor.hasMultipleTables()) {
            this.addPrimaryKeyForNonDefaultTable(databaseRow, object, session);
        }
        return databaseRow;
    }

    public AbstractRecord buildRowForUpdate(WriteObjectQuery query) {
        AbstractRecord databaseRow = this.createRecord(query.getSession());
        return this.buildRowForUpdate(databaseRow, query);
    }

    public AbstractRecord buildRowForUpdate(AbstractRecord databaseRow, WriteObjectQuery query) {
        for (DatabaseMapping mapping : this.getNonPrimaryKeyMappings()) {
            mapping.writeFromObjectIntoRowForUpdate(query, databaseRow);
        }
        if (this.descriptor.hasInheritance() && this.descriptor.isAggregateDescriptor() && query.getObject() != null) {
            if (query.getBackupClone() == null) {
                this.descriptor.getInheritancePolicy().addClassIndicatorFieldToRow(databaseRow);
            } else if (!query.getObject().getClass().equals(query.getBackupClone().getClass())) {
                this.descriptor.getInheritancePolicy().addClassIndicatorFieldToRow(databaseRow);
            }
        }
        if (this.getDescriptor().hasMultitenantPolicy()) {
            this.getDescriptor().getMultitenantPolicy().addFieldsToRow(databaseRow, query.getExecutionSession());
        }
        return databaseRow;
    }

    public AbstractRecord buildRowForUpdateWithChangeSet(WriteObjectQuery query) {
        AbstractRecord databaseRow = this.createRecord(query.getSession());
        AbstractSession session = query.getSession();
        List<ChangeRecord> changes = query.getObjectChangeSet().getChanges();
        int size = changes.size();
        for (int index = 0; index < size; ++index) {
            org.eclipse.persistence.internal.sessions.ChangeRecord changeRecord = (org.eclipse.persistence.internal.sessions.ChangeRecord)changes.get(index);
            DatabaseMapping mapping = changeRecord.getMapping();
            mapping.writeFromObjectIntoRowWithChangeRecord(changeRecord, databaseRow, session, DatabaseMapping.WriteType.UPDATE);
        }
        return databaseRow;
    }

    public AbstractRecord buildRowForWhereClause(ObjectLevelModifyQuery query) {
        AbstractRecord databaseRow = this.createRecord(query.getSession());
        if (query.isUpdateObjectQuery()) {
            query.setShouldValidateUpdateCallCacheUse(true);
        }
        for (DatabaseMapping mapping : this.descriptor.getMappings()) {
            mapping.writeFromObjectIntoRowForWhereClause(query, databaseRow);
        }
        if (!this.descriptor.isAggregateDescriptor()) {
            this.addPrimaryKeyForNonDefaultTable(databaseRow);
        }
        return databaseRow;
    }

    public AbstractRecord writeIntoRowFromPrimaryKeyValues(AbstractRecord row, Object primaryKey, AbstractSession session, boolean convert) {
        List<DatabaseField> primaryKeyFields = this.descriptor.getPrimaryKeyFields();
        if (this.descriptor.getCacheKeyType() == CacheKeyType.ID_VALUE) {
            DatabaseField field = primaryKeyFields.get(0);
            Object value = primaryKey;
            value = session.getPlatform(this.descriptor.getJavaClass()).getConversionManager().convertObject(value, field.getType());
            row.put(field, value);
            return row;
        }
        int size = primaryKeyFields.size();
        Object[] primaryKeyValues = ((CacheId)primaryKey).getPrimaryKey();
        for (int index = 0; index < size; ++index) {
            DatabaseField field = primaryKeyFields.get(index);
            Object value = primaryKeyValues[index];
            value = session.getPlatform(this.descriptor.getJavaClass()).getConversionManager().convertObject(value, field.getType());
            row.put(field, value);
        }
        return row;
    }

    public AbstractRecord buildRowFromPrimaryKeyValues(Object key, AbstractSession session) {
        AbstractRecord databaseRow = this.createRecord(this.descriptor.getPrimaryKeyFields().size(), session);
        return this.writeIntoRowFromPrimaryKeyValues(databaseRow, key, session, true);
    }

    public AbstractRecord buildTemplateInsertRow(AbstractSession session) {
        AbstractRecord databaseRow = this.createRecord(session);
        this.buildTemplateInsertRow(session, databaseRow);
        return databaseRow;
    }

    public void buildTemplateInsertRow(AbstractSession session, AbstractRecord databaseRow) {
        for (DatabaseMapping mapping : this.descriptor.getMappings()) {
            mapping.writeInsertFieldsIntoRow(databaseRow, session);
        }
        if (this.descriptor.hasInheritance()) {
            this.descriptor.getInheritancePolicy().addClassIndicatorFieldToInsertRow(databaseRow);
        }
        if (!this.descriptor.isAggregateDescriptor()) {
            this.addPrimaryKeyForNonDefaultTable(databaseRow);
        }
        if (this.descriptor.usesOptimisticLocking()) {
            this.descriptor.getOptimisticLockingPolicy().addLockFieldsToUpdateRow(databaseRow, session);
        }
        if (this.getDescriptor().hasMultitenantPolicy()) {
            this.getDescriptor().getMultitenantPolicy().addFieldsToRow(databaseRow, session);
        }
        this.trimFieldsForInsert(session, databaseRow);
    }

    public void trimFieldsForInsert(AbstractSession session, AbstractRecord databaseRow) {
        ClassDescriptor descriptor = this.descriptor;
        if (descriptor.usesSequenceNumbers() && descriptor.getSequence().shouldAcquireValueAfterInsert()) {
            databaseRow.remove(descriptor.getSequenceNumberField());
        }
        if (descriptor.hasReturningPolicy()) {
            descriptor.getReturningPolicy().trimModifyRowForInsert(databaseRow);
        }
    }

    public AbstractRecord buildTemplateUpdateRow(AbstractSession session) {
        AbstractRecord databaseRow = this.createRecord(session);
        for (DatabaseMapping mapping : this.getNonPrimaryKeyMappings()) {
            mapping.writeUpdateFieldsIntoRow(databaseRow, session);
        }
        if (this.descriptor.usesOptimisticLocking()) {
            this.descriptor.getOptimisticLockingPolicy().addLockFieldsToUpdateRow(databaseRow, session);
        }
        return databaseRow;
    }

    public Expression buildUpdateExpression(DatabaseTable table, AbstractRecord transactionRow, AbstractRecord modifyRow) {
        Expression primaryKeyExpression = this.buildPrimaryKeyExpression(table);
        if (this.descriptor.usesOptimisticLocking()) {
            return this.descriptor.getOptimisticLockingPolicy().buildUpdateExpression(table, primaryKeyExpression, transactionRow, modifyRow);
        }
        return primaryKeyExpression;
    }

    public void buildPrimaryKeyAttributesIntoObject(Object original, AbstractRecord databaseRow, ObjectBuildingQuery query, AbstractSession session) throws DatabaseException, QueryException {
        List<DatabaseMapping> mappings = this.primaryKeyMappings;
        int mappingsSize = mappings.size();
        for (int i = 0; i < mappingsSize; ++i) {
            DatabaseMapping mapping = mappings.get(i);
            mapping.buildShallowOriginalFromRow(databaseRow, original, null, query, session);
        }
    }

    public void buildAttributesIntoShallowObject(Object original, AbstractRecord databaseRow, ObjectBuildingQuery query) throws DatabaseException, QueryException {
        AbstractSession executionSession = query.getSession().getExecutionSession(query);
        List<DatabaseMapping> pkMappings = this.getPrimaryKeyMappings();
        int mappingsSize = pkMappings.size();
        for (int i = 0; i < mappingsSize; ++i) {
            DatabaseMapping mapping = pkMappings.get(i);
            if (mapping.isDirectToFieldMapping()) continue;
            mapping.buildShallowOriginalFromRow(databaseRow, original, null, query, executionSession);
        }
        Vector<DatabaseMapping> mappings = this.descriptor.getMappings();
        mappingsSize = mappings.size();
        for (int i = 0; i < mappingsSize; ++i) {
            DatabaseMapping mapping = (DatabaseMapping)mappings.get(i);
            if (!mapping.isDirectToFieldMapping()) continue;
            mapping.buildShallowOriginalFromRow(databaseRow, original, null, query, executionSession);
        }
    }

    public void buildAttributesIntoWorkingCopyClone(Object clone, CacheKey sharedCacheKey, ObjectBuildingQuery query, JoinedAttributeManager joinManager, AbstractRecord databaseRow, UnitOfWorkImpl unitOfWork, boolean forRefresh) throws DatabaseException, QueryException {
        boolean readAllMappings = query.shouldReadAllMappings();
        Vector<DatabaseMapping> mappings = this.descriptor.getMappings();
        int size = mappings.size();
        for (int index = 0; index < size; ++index) {
            DatabaseMapping mapping = (DatabaseMapping)mappings.get(index);
            if (!readAllMappings && !query.shouldReadMapping(mapping)) continue;
            mapping.buildCloneFromRow(databaseRow, joinManager, clone, sharedCacheKey, query, unitOfWork, unitOfWork);
        }
        if (this.descriptor.getEventManager().hasAnyEventListeners()) {
            DescriptorEvent event = new DescriptorEvent(clone);
            event.setQuery(query);
            event.setSession(unitOfWork);
            event.setDescriptor(this.descriptor);
            event.setRecord(databaseRow);
            if (forRefresh) {
                event.setEventCode(9);
            } else {
                event.setEventCode(8);
                unitOfWork.deferEvent(event);
                event = new DescriptorEvent(clone);
                event.setQuery(query);
                event.setSession(unitOfWork);
                event.setDescriptor(this.descriptor);
                event.setRecord(databaseRow);
                event.setOriginalObject(clone);
                event.setEventCode(10);
            }
            unitOfWork.deferEvent(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object buildWorkingCopyCloneFromRow(ObjectBuildingQuery query, JoinedAttributeManager joinManager, AbstractRecord databaseRow, UnitOfWorkImpl unitOfWork, Object primaryKey) throws DatabaseException, QueryException {
        CacheKey originalCacheKey;
        boolean isIsolated;
        boolean isARefresh;
        boolean wasAClone;
        Object workingClone;
        CacheKey unitOfWorkCacheKey;
        ClassDescriptor descriptor;
        block18: {
            Object session;
            Object original;
            boolean wasAnOriginal;
            block17: {
                block16: {
                    descriptor = this.descriptor;
                    unitOfWorkCacheKey = unitOfWork.getIdentityMapAccessorInstance().getIdentityMapManager().acquireLock(primaryKey, descriptor.getJavaClass(), false, descriptor);
                    workingClone = unitOfWorkCacheKey.getObject();
                    try {
                        wasAClone = workingClone != null;
                        boolean bl = isARefresh = query.shouldRefreshIdentityMapResult() || query.isLockQuery() && (!wasAClone || !query.isClonePessimisticLocked(workingClone, unitOfWork));
                        if (wasAClone && descriptor.hasFetchGroupManager() && descriptor.getFetchGroupManager().isPartialObject(workingClone) && !descriptor.getFetchGroupManager().isObjectValidForFetchGroup(workingClone, query.getEntityFetchGroup())) {
                            isARefresh = true;
                        }
                        if (!wasAClone || isARefresh) break block16;
                        Object object = workingClone;
                        Object var19_13 = null;
                        unitOfWorkCacheKey.release();
                        return object;
                    }
                    catch (Throwable throwable) {
                        Object var19_17 = null;
                        unitOfWorkCacheKey.release();
                        throw throwable;
                    }
                }
                wasAnOriginal = false;
                isIsolated = descriptor.shouldIsolateObjectsInUnitOfWork() || descriptor.shouldIsolateObjectsInUnitOfWorkEarlyTransaction() && unitOfWork.wasTransactionBegunPrematurely();
                original = null;
                originalCacheKey = null;
                if (isARefresh || isIsolated || query.shouldRetrieveBypassCache() || unitOfWork.shouldReadFromDB() || unitOfWork.shouldForceReadFromDB(query, primaryKey) || (originalCacheKey = ((AbstractSession)(session = unitOfWork.getParentIdentityMapSession(query))).getIdentityMapAccessorInstance().getCacheKeyForObject(primaryKey, descriptor.getJavaClass(), descriptor, false)) == null) break block17;
                original = originalCacheKey.getObject();
                wasAnOriginal = original != null;
                boolean bl = isARefresh = wasAnOriginal && (descriptor.shouldAlwaysRefreshCache() || descriptor.getCacheInvalidationPolicy().isInvalidated(originalCacheKey, query.getExecutionTime()));
                if (!wasAnOriginal || isARefresh || !descriptor.isSharedIsolation() && descriptor.shouldIsolateProtectedObjectsInUnitOfWork()) break block17;
                Object object = unitOfWork.cloneAndRegisterObject(original, originalCacheKey, unitOfWorkCacheKey, descriptor);
                Object var19_14 = null;
                unitOfWorkCacheKey.release();
                return object;
            }
            if (!wasAClone) {
                if (wasAnOriginal && !query.shouldRetrieveBypassCache()) {
                    workingClone = this.instantiateWorkingCopyClone(original, unitOfWork);
                    unitOfWork.getCloneToOriginals().put(workingClone, original);
                } else {
                    workingClone = this.instantiateWorkingCopyCloneFromRow(databaseRow, query, primaryKey, unitOfWork);
                }
                unitOfWorkCacheKey.setObject(workingClone);
                unitOfWork.getCloneMapping().put(workingClone, workingClone);
            }
            if (!wasAClone || unitOfWorkCacheKey.getLastUpdatedQueryId() < query.getQueryId()) break block18;
            session = workingClone;
            Object var19_15 = null;
            unitOfWorkCacheKey.release();
            return session;
        }
        this.copyQueryInfoToCacheKey(unitOfWorkCacheKey, query, databaseRow, unitOfWork, descriptor);
        ObjectChangePolicy policy = descriptor.getObjectChangePolicy();
        if (!wasAClone) {
            policy.setChangeListener(workingClone, unitOfWork, descriptor);
        }
        policy.dissableEventProcessing(workingClone);
        FetchGroupManager fetchGroupManager = this.descriptor.getFetchGroupManager();
        if (isARefresh && fetchGroupManager != null) {
            fetchGroupManager.setObjectFetchGroup(workingClone, query.getExecutionFetchGroup(), unitOfWork);
        }
        if (descriptor.isProtectedIsolation() && !isIsolated && !query.shouldStoreBypassCache()) {
            originalCacheKey = (CacheKey)this.buildObject(true, query, databaseRow, unitOfWork.getParentIdentityMapSession(descriptor, false, true), primaryKey, descriptor, joinManager);
        }
        if (isARefresh) {
            originalCacheKey = null;
        }
        this.buildAttributesIntoWorkingCopyClone(workingClone, originalCacheKey, query, joinManager, databaseRow, unitOfWork, wasAClone);
        if (!isARefresh && fetchGroupManager != null) {
            fetchGroupManager.setObjectFetchGroup(workingClone, query.getExecutionFetchGroup(), unitOfWork);
        }
        Object backupClone = policy.buildBackupClone(workingClone, this, unitOfWork);
        if (wasAClone) {
            policy.clearChanges(workingClone, unitOfWork, descriptor, isARefresh);
        }
        policy.enableEventProcessing(workingClone);
        unitOfWork.getCloneMapping().put(workingClone, backupClone);
        query.recordCloneForPessimisticLocking(workingClone, unitOfWork);
        if (workingClone instanceof PersistenceEntity) {
            ((PersistenceEntity)workingClone)._persistence_setId(primaryKey);
        }
        Object var19_16 = null;
        unitOfWorkCacheKey.release();
        this.instantiateEagerMappings(workingClone, unitOfWork);
        return workingClone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object buildObjectFromResultSet(ObjectBuildingQuery query, JoinedAttributeManager joinManager, ResultSet resultSet, AbstractSession executionSession, DatabaseAccessor accessor, ResultSetMetaData metaData, DatabasePlatform platform) throws SQLException {
        Object object;
        CacheKey parentCacheKey;
        CacheKey cacheKey;
        boolean isolated;
        AbstractSession session;
        UnitOfWorkImpl unitOfWork;
        Object primaryKey;
        DatabaseMapping primaryKeyMapping;
        ClassDescriptor descriptor;
        block16: {
            descriptor = this.descriptor;
            primaryKeyMapping = this.primaryKeyMappings.get(0);
            primaryKey = primaryKeyMapping.valueFromResultSet(resultSet, query, executionSession, accessor, metaData, 1, platform);
            unitOfWork = null;
            session = executionSession;
            boolean bl = isolated = !descriptor.isSharedIsolation();
            if (session.isUnitOfWork()) {
                unitOfWork = (UnitOfWorkImpl)executionSession;
            }
            cacheKey = session.getIdentityMapAccessorInstance().getIdentityMapManager().acquireLock(primaryKey, descriptor.getJavaClass(), false, descriptor);
            parentCacheKey = null;
            object = cacheKey.getObject();
            if (object == null) break block16;
            Object object2 = object;
            Object var22_19 = null;
            cacheKey.release();
            if (parentCacheKey != null) {
                parentCacheKey.release();
            }
            return object2;
        }
        try {
            if (unitOfWork != null && !isolated) {
                session = unitOfWork.getParentIdentityMapSession(query);
                parentCacheKey = session.getIdentityMapAccessorInstance().getIdentityMapManager().acquireLock(primaryKey, descriptor.getJavaClass(), false, descriptor);
                object = parentCacheKey.getObject();
            }
            if (object == null) {
                object = this.buildNewInstance();
                if (unitOfWork == null) {
                    cacheKey.setObject(object);
                } else if (isolated) {
                    cacheKey.setObject(object);
                    unitOfWork.getCloneMapping().put(object, object);
                } else {
                    parentCacheKey.setObject(object);
                }
                primaryKeyMapping.setAttributeValueInObject(object, primaryKey);
                Vector<DatabaseMapping> mappings = descriptor.getMappings();
                int size = mappings.size();
                for (int index = 1; index < size; ++index) {
                    DatabaseMapping mapping = (DatabaseMapping)mappings.get(index);
                    mapping.readFromResultSetIntoObject(resultSet, object, query, session, accessor, metaData, index + 1, platform);
                }
                ((PersistenceEntity)object)._persistence_setId(primaryKey);
                if (unitOfWork != null && isolated) {
                    ObjectChangePolicy policy = descriptor.getObjectChangePolicy();
                    policy.setChangeListener(object, unitOfWork, descriptor);
                }
            }
            if (unitOfWork != null && !isolated) {
                Object clone = this.instantiateWorkingCopyClone(object, unitOfWork);
                ((PersistenceEntity)clone)._persistence_setId(cacheKey.getKey());
                unitOfWork.getCloneMapping().put(clone, clone);
                unitOfWork.getCloneToOriginals().put(clone, object);
                cacheKey.setObject(clone);
                ObjectChangePolicy policy = descriptor.getObjectChangePolicy();
                policy.setChangeListener(clone, unitOfWork, descriptor);
                object = clone;
            }
            Object var22_20 = null;
            cacheKey.release();
            if (parentCacheKey != null) {
                parentCacheKey.release();
            }
        }
        catch (Throwable throwable) {
            Object var22_21 = null;
            cacheKey.release();
            if (parentCacheKey != null) {
                parentCacheKey.release();
            }
            throw throwable;
        }
        return object;
    }

    public Object clone() {
        ObjectBuilder objectBuilder = null;
        try {
            objectBuilder = (ObjectBuilder)super.clone();
        }
        catch (CloneNotSupportedException exception) {
            throw new InternalError(exception.toString());
        }
        objectBuilder.setMappingsByAttribute(new HashMap<String, DatabaseMapping>(this.getMappingsByAttribute()));
        objectBuilder.setMappingsByField(new HashMap<DatabaseField, DatabaseMapping>(this.getMappingsByField()));
        objectBuilder.setFieldsMap(new HashMap<DatabaseField, DatabaseField>(this.getFieldsMap()));
        objectBuilder.setReadOnlyMappingsByField(new HashMap<DatabaseField, List<DatabaseMapping>>(this.getReadOnlyMappingsByField()));
        objectBuilder.setPrimaryKeyMappings(new ArrayList<DatabaseMapping>(this.getPrimaryKeyMappings()));
        objectBuilder.setNonPrimaryKeyMappings(new ArrayList<DatabaseMapping>(this.getNonPrimaryKeyMappings()));
        objectBuilder.cloningMappings = new ArrayList<DatabaseMapping>(this.cloningMappings);
        objectBuilder.eagerMappings = new ArrayList<DatabaseMapping>(this.eagerMappings);
        objectBuilder.relationshipMappings = new ArrayList<DatabaseMapping>(this.relationshipMappings);
        return objectBuilder;
    }

    public void cascadePerformRemove(Object object, UnitOfWorkImpl uow, Map visitedObjects) {
        if (!this.isSimple) {
            List<DatabaseMapping> mappings = this.relationshipMappings;
            for (int index = 0; index < mappings.size(); ++index) {
                DatabaseMapping mapping = mappings.get(index);
                mapping.cascadePerformRemoveIfRequired(object, uow, visitedObjects);
            }
        }
    }

    public void cascadePerformRemovePrivateOwnedObjectFromChangeSet(Object object, UnitOfWorkImpl uow, Map visitedObjects) {
        if (object != null && !this.isSimple) {
            for (DatabaseMapping mapping : this.relationshipMappings) {
                if (!mapping.isPrivateOwned()) continue;
                mapping.cascadePerformRemovePrivateOwnedObjectFromChangeSetIfRequired(object, uow, visitedObjects);
            }
        }
    }

    public void cacheForeignKeyValues(AbstractRecord databaseRecord, CacheKey cacheKey, AbstractSession session) {
        Set<DatabaseField> foreignKeys = this.descriptor.getForeignKeyValuesForCaching();
        if (foreignKeys.isEmpty()) {
            return;
        }
        DatabaseRecord cacheRecord = new DatabaseRecord(foreignKeys.size());
        for (DatabaseField field : foreignKeys) {
            cacheRecord.put(field, databaseRecord.get(field));
        }
        cacheKey.setProtectedForeignKeys(cacheRecord);
    }

    public void cacheForeignKeyValues(Object source, CacheKey cacheKey, ClassDescriptor descriptor, AbstractSession session) {
        Set<DatabaseField> foreignKeys = this.descriptor.getForeignKeyValuesForCaching();
        if (foreignKeys.isEmpty()) {
            return;
        }
        DatabaseRecord cacheRecord = new DatabaseRecord(foreignKeys.size());
        for (DatabaseField field : foreignKeys) {
            cacheRecord.put(field, this.extractValueFromObjectForField(source, field, session));
        }
        cacheKey.setProtectedForeignKeys(cacheRecord);
    }

    public void cascadeDiscoverAndPersistUnregisteredNewObjects(Object object, Map newObjects, Map unregisteredExistingObjects, Map visitedObjects, UnitOfWorkImpl uow, Set cascadeErrors) {
        block4: {
            if (this.isSimple) break block4;
            List<DatabaseMapping> mappings = this.relationshipMappings;
            int size = mappings.size();
            FetchGroupManager fetchGroupManager = this.descriptor.getFetchGroupManager();
            if (fetchGroupManager != null && fetchGroupManager.isPartialObject(object)) {
                for (int index = 0; index < size; ++index) {
                    DatabaseMapping mapping = mappings.get(index);
                    if (!fetchGroupManager.isAttributeFetched(object, mapping.getAttributeName())) continue;
                    mapping.cascadeDiscoverAndPersistUnregisteredNewObjects(object, newObjects, unregisteredExistingObjects, visitedObjects, uow, cascadeErrors);
                }
            } else {
                for (int index = 0; index < size; ++index) {
                    DatabaseMapping mapping = mappings.get(index);
                    mapping.cascadeDiscoverAndPersistUnregisteredNewObjects(object, newObjects, unregisteredExistingObjects, visitedObjects, uow, cascadeErrors);
                }
            }
        }
    }

    public void cascadeRegisterNewForCreate(Object object, UnitOfWorkImpl uow, Map visitedObjects) {
        if (!this.isSimple) {
            List<DatabaseMapping> mappings = this.relationshipMappings;
            int size = mappings.size();
            FetchGroupManager fetchGroupManager = this.descriptor.getFetchGroupManager();
            if (fetchGroupManager != null && fetchGroupManager.isPartialObject(object)) {
                for (int index = 0; index < size; ++index) {
                    DatabaseMapping mapping = mappings.get(index);
                    if (!fetchGroupManager.isAttributeFetched(object, mapping.getAttributeName())) continue;
                    mapping.cascadeRegisterNewIfRequired(object, uow, visitedObjects);
                }
            } else {
                for (int index = 0; index < size; ++index) {
                    DatabaseMapping mapping = mappings.get(index);
                    mapping.cascadeRegisterNewIfRequired(object, uow, visitedObjects);
                }
            }
        }
        if (this.descriptor.getPartitioningPolicy() != null) {
            this.descriptor.getPartitioningPolicy().partitionPersist(uow.getParent(), object, this.descriptor);
        }
    }

    public ObjectChangeSet compareForChange(Object clone, Object backUp, UnitOfWorkChangeSet changeSet, AbstractSession session) {
        return this.descriptor.getObjectChangePolicy().calculateChanges(clone, backUp, backUp == null, changeSet, (UnitOfWorkImpl)session, this.descriptor, true);
    }

    public boolean compareObjects(Object firstObject, Object secondObject, AbstractSession session) {
        Vector<DatabaseMapping> mappings = this.descriptor.getMappings();
        for (int index = 0; index < mappings.size(); ++index) {
            DatabaseMapping mapping = (DatabaseMapping)mappings.get(index);
            if (mapping.compareObjects(firstObject, secondObject, session)) continue;
            Object firstValue = mapping.getAttributeValueFromObject(firstObject);
            Object secondValue = mapping.getAttributeValueFromObject(secondObject);
            session.log(1, "query", "compare_failed", mapping, firstValue, secondValue);
            return false;
        }
        return true;
    }

    public void copyInto(Object source, Object target, boolean cloneOneToOneValueHolders) {
        Vector<DatabaseMapping> mappings = this.descriptor.getMappings();
        for (int index = 0; index < mappings.size(); ++index) {
            DatabaseMapping mapping = (DatabaseMapping)mappings.get(index);
            Object value = null;
            value = cloneOneToOneValueHolders && mapping.isForeignReferenceMapping() ? ((ForeignReferenceMapping)mapping).getAttributeValueWithClonedValueHolders(source) : mapping.getAttributeValueFromObject(source);
            mapping.setAttributeValueInObject(target, value);
        }
    }

    public void copyInto(Object source, Object target) {
        this.copyInto(source, target, false);
    }

    public Object copyObject(Object original, CopyGroup copyGroup) {
        Object copy = copyGroup.getCopies().get(original);
        if (copyGroup.shouldCascadeTree()) {
            FetchGroupManager fetchGroupManager = this.descriptor.getFetchGroupManager();
            if (fetchGroupManager != null) {
                Set<String> attributesToVisit;
                if (copyGroup.hasItems()) {
                    FetchGroup fetchGroup;
                    String name;
                    if (!copyGroup.shouldResetPrimaryKey()) {
                        for (DatabaseMapping mapping : this.primaryKeyMappings) {
                            name = mapping.getAttributeName();
                            if (copyGroup.containsAttributeInternal(name)) continue;
                            copyGroup.addAttribute(name);
                        }
                    } else {
                        for (DatabaseMapping mapping : this.primaryKeyMappings) {
                            if (!mapping.isForeignReferenceMapping() || copyGroup.containsAttributeInternal(name = mapping.getAttributeName())) continue;
                            copyGroup.addAttribute(name);
                        }
                    }
                    if (!copyGroup.shouldResetVersion() && this.lockAttribute != null && !copyGroup.containsAttributeInternal(this.lockAttribute)) {
                        copyGroup.addAttribute(this.lockAttribute);
                    }
                    if ((fetchGroup = fetchGroupManager.getObjectFetchGroup(original)) != null && !fetchGroup.getAttributeNames().containsAll(copyGroup.getAttributeNames())) {
                        fetchGroup.onUnfetchedAttribute((FetchGroupTracker)original, null);
                    }
                }
                EntityFetchGroup existingEntityFetchGroup = null;
                if (copy != null) {
                    Object[] copyArray = (Object[])copy;
                    copy = copyArray[0];
                    Set visitedCopyGroups = (Set)copyArray[1];
                    if (visitedCopyGroups.contains(copyGroup)) {
                        return copy;
                    }
                    visitedCopyGroups.add(copyGroup);
                    existingEntityFetchGroup = fetchGroupManager.getObjectEntityFetchGroup(copy);
                }
                EntityFetchGroup newEntityFetchGroup = null;
                Set<String> attributesToCopy = attributesToVisit = copyGroup.getAttributeNames();
                boolean shouldCopyAllAttributes = false;
                boolean shouldAssignNewEntityFetchGroup = false;
                if (copy != null && existingEntityFetchGroup == null) {
                    attributesToCopy = null;
                } else {
                    EntityFetchGroup copyGroupEntityFetchGroup = fetchGroupManager.getEntityFetchGroup(attributesToCopy);
                    if (copyGroupEntityFetchGroup == null) {
                        shouldCopyAllAttributes = true;
                    }
                    if (copy != null) {
                        if (copyGroupEntityFetchGroup != null) {
                            if (!copyGroup.shouldResetPrimaryKey() && !existingEntityFetchGroup.getAttributeNames().containsAll(attributesToCopy)) {
                                newEntityFetchGroup = fetchGroupManager.flatUnionFetchGroups(existingEntityFetchGroup, copyGroupEntityFetchGroup);
                                shouldAssignNewEntityFetchGroup = true;
                            }
                            attributesToCopy = new HashSet<String>(attributesToCopy);
                            attributesToCopy.removeAll(existingEntityFetchGroup.getAttributeNames());
                        }
                    } else {
                        copy = copyGroup.getSession().getDescriptor(original).getObjectBuilder().buildNewInstance();
                        HashSet<CopyGroup> visitedCopyGroups = new HashSet<CopyGroup>();
                        visitedCopyGroups.add(copyGroup);
                        copyGroup.getCopies().put(original, new Object[]{copy, visitedCopyGroups});
                        if (!copyGroup.shouldResetPrimaryKey()) {
                            newEntityFetchGroup = copyGroupEntityFetchGroup;
                            shouldAssignNewEntityFetchGroup = true;
                        }
                    }
                }
                if (shouldAssignNewEntityFetchGroup) {
                    fetchGroupManager.setObjectFetchGroup(copy, newEntityFetchGroup, null);
                }
                for (DatabaseMapping mapping : this.getDescriptor().getMappings()) {
                    boolean shouldVisit;
                    String name = mapping.getAttributeName();
                    boolean shouldCopy = shouldCopyAllAttributes || attributesToCopy != null && attributesToCopy.contains(name);
                    boolean bl = shouldVisit = attributesToVisit == null || attributesToVisit.contains(name);
                    if (!shouldCopy && !shouldVisit) continue;
                    boolean isVisiting = false;
                    CopyGroup mappingCopyGroup = copyGroup;
                    if (mapping.isForeignReferenceMapping()) {
                        ForeignReferenceMapping frMapping = (ForeignReferenceMapping)mapping;
                        ClassDescriptor referenceDescriptor = frMapping.getReferenceDescriptor();
                        if (referenceDescriptor != null) {
                            isVisiting = true;
                            mappingCopyGroup = copyGroup.getGroup(name);
                            if (mappingCopyGroup == null) {
                                FetchGroupManager referenceFetchGroupManager = referenceDescriptor.getFetchGroupManager();
                                if (referenceFetchGroupManager != null) {
                                    EntityFetchGroup nonReferenceEntityFetchGroup = referenceFetchGroupManager.getNonReferenceEntityFetchGroup(copyGroup.shouldResetPrimaryKey(), copyGroup.shouldResetVersion());
                                    if (nonReferenceEntityFetchGroup != null) {
                                        mappingCopyGroup = nonReferenceEntityFetchGroup.toCopyGroup();
                                    } else {
                                        mappingCopyGroup = new CopyGroup();
                                        mappingCopyGroup.shouldCascadeTree();
                                    }
                                } else {
                                    mappingCopyGroup = new CopyGroup();
                                    mappingCopyGroup.dontCascade();
                                    isVisiting = false;
                                }
                                mappingCopyGroup.setCopies(copyGroup.getCopies());
                                mappingCopyGroup.setShouldResetPrimaryKey(copyGroup.shouldResetPrimaryKey());
                                mappingCopyGroup.setShouldResetVersion(copyGroup.shouldResetVersion());
                            }
                            mappingCopyGroup.setSession(copyGroup.getSession());
                        }
                    } else if (mapping.isAggregateObjectMapping()) {
                        mappingCopyGroup = new CopyGroup();
                    }
                    if (!shouldCopy && !isVisiting) continue;
                    mapping.buildCopy(copy, original, mappingCopyGroup);
                }
            }
        } else {
            if (copy != null) {
                return copy;
            }
            copy = this.instantiateClone(original, copyGroup.getSession());
            copyGroup.getCopies().put(original, copy);
            List<DatabaseMapping> mappings = this.getCloningMappings();
            int size = mappings.size();
            for (int index = 0; index < size; ++index) {
                mappings.get(index).buildCopy(copy, original, copyGroup);
            }
            if (copyGroup.shouldResetPrimaryKey() && !this.descriptor.isDescriptorTypeAggregate()) {
                int index;
                boolean hasOneToOne = false;
                List<DatabaseMapping> primaryKeyMappings = this.getPrimaryKeyMappings();
                size = primaryKeyMappings.size();
                for (index = 0; index < size; ++index) {
                    if (!primaryKeyMappings.get(index).isOneToOneMapping()) continue;
                    hasOneToOne = true;
                }
                if (!hasOneToOne) {
                    for (index = 0; index < size; ++index) {
                        DatabaseMapping mapping = primaryKeyMappings.get(index);
                        if (mapping.isDirectToFieldMapping()) {
                            Object nullValue = ((AbstractDirectMapping)mapping).getAttributeValue(null, copyGroup.getSession());
                            mapping.setAttributeValueInObject(copy, nullValue);
                            continue;
                        }
                        if (!mapping.isTransformationMapping()) continue;
                        mapping.setAttributeValueInObject(copy, null);
                    }
                }
            }
            if (this.descriptor.getEventManager().hasAnyEventListeners()) {
                DescriptorEvent event = new DescriptorEvent(copy);
                event.setSession(copyGroup.getSession());
                event.setOriginalObject(original);
                event.setEventCode(10);
                this.descriptor.getEventManager().executeEvent(event);
            }
        }
        return copy;
    }

    public ObjectChangeSet createObjectChangeSet(Object clone, UnitOfWorkChangeSet uowChangeSet, AbstractSession session) {
        boolean isNew = ((UnitOfWorkImpl)session).isObjectNew(clone);
        return this.createObjectChangeSet(clone, uowChangeSet, isNew, session);
    }

    public ObjectChangeSet createObjectChangeSet(Object clone, UnitOfWorkChangeSet uowChangeSet, boolean isNew, AbstractSession session) {
        return this.createObjectChangeSet(clone, uowChangeSet, isNew, false, session);
    }

    public ObjectChangeSet createObjectChangeSet(Object clone, UnitOfWorkChangeSet uowChangeSet, boolean isNew, boolean assignPrimaryKeyIfExisting, AbstractSession session) {
        Object primaryKey;
        ObjectChangeSet changes = (ObjectChangeSet)uowChangeSet.getObjectChangeSetForClone(clone);
        if (changes == null) {
            changes = this.descriptor.isAggregateDescriptor() ? new AggregateObjectChangeSet(new CacheId(new Object[0]), this.descriptor, clone, uowChangeSet, isNew) : new ObjectChangeSet(this.extractPrimaryKeyFromObject(clone, session, true), this.descriptor, clone, uowChangeSet, isNew);
            changes.setIsAggregate(this.descriptor.isDescriptorTypeAggregate());
            uowChangeSet.addObjectChangeSetForIdentity(changes, clone);
        } else if (assignPrimaryKeyIfExisting && !changes.isAggregate() && (primaryKey = this.extractPrimaryKeyFromObject(clone, session, true)) != null) {
            changes.setId(primaryKey);
        }
        return changes;
    }

    public void createPrimaryKeyExpression(AbstractSession session) {
        Expression expression = null;
        ExpressionBuilder builder = new ExpressionBuilder();
        List<DatabaseField> primaryKeyFields = this.descriptor.getPrimaryKeyFields();
        if (null != primaryKeyFields) {
            for (int index = 0; index < primaryKeyFields.size(); ++index) {
                DatabaseField primaryKeyField = primaryKeyFields.get(index);
                Expression subExp1 = ((Expression)builder).getField(primaryKeyField);
                Expression subExp2 = builder.getParameter(primaryKeyField);
                Expression subExpression = subExp1.equal(subExp2);
                expression = expression == null ? subExpression : expression.and(subExpression);
            }
        }
        this.setPrimaryKeyExpression(expression);
    }

    public Object extractPrimaryKeyFromExpression(boolean requiresExactMatch, Expression expression, AbstractRecord translationRow, AbstractSession session) {
        AbstractRecord primaryKeyRow = this.createRecord(this.getPrimaryKeyMappings().size(), session);
        expression.getBuilder().setSession(session.getRootSession(null));
        boolean isValid = expression.extractPrimaryKeyValues(requiresExactMatch, this.descriptor, primaryKeyRow, translationRow);
        if (requiresExactMatch && !isValid) {
            return null;
        }
        if (primaryKeyRow.size() != this.descriptor.getPrimaryKeyFields().size()) {
            return null;
        }
        Object primaryKey = this.extractPrimaryKeyFromRow(primaryKeyRow, session);
        if (primaryKey == null && isValid) {
            return InvalidObject.instance;
        }
        return primaryKey;
    }

    public boolean isPrimaryKeyExpression(boolean requiresExactMatch, Expression expression, AbstractSession session) {
        expression.getBuilder().setSession(session.getRootSession(null));
        HashSet<DatabaseField> fields = new HashSet<DatabaseField>(this.descriptor.getPrimaryKeyFields().size());
        boolean isValid = expression.extractPrimaryKeyFields(requiresExactMatch, this.descriptor, fields);
        if (requiresExactMatch && !isValid) {
            return false;
        }
        return fields.size() == this.descriptor.getPrimaryKeyFields().size();
    }

    public Object extractPrimaryKeyFromObject(Object domainObject, AbstractSession session) {
        return this.extractPrimaryKeyFromObject(domainObject, session, false);
    }

    public Object extractPrimaryKeyFromObject(Object domainObject, AbstractSession session, boolean shouldReturnNullIfNull) {
        Object primaryKey;
        boolean isPersistenceEntity;
        boolean bl = isPersistenceEntity = domainObject instanceof PersistenceEntity && !this.isXMLObjectBuilder();
        if (isPersistenceEntity && (primaryKey = ((PersistenceEntity)domainObject)._persistence_getId()) != null) {
            return primaryKey;
        }
        ClassDescriptor descriptor = this.descriptor;
        boolean isNull = false;
        if (descriptor.hasInheritance() && domainObject.getClass() != descriptor.getJavaClass() && !domainObject.getClass().getSuperclass().equals(descriptor.getJavaClass())) {
            return session.getDescriptor(domainObject).getObjectBuilder().extractPrimaryKeyFromObject(domainObject, session, shouldReturnNullIfNull);
        }
        CacheKeyType cacheKeyType = descriptor.getCacheKeyType();
        List<DatabaseField> primaryKeyFields = descriptor.getPrimaryKeyFields();
        Object[] primaryKeyValues = null;
        if (cacheKeyType != CacheKeyType.ID_VALUE) {
            primaryKeyValues = new Object[primaryKeyFields.size()];
        }
        List<DatabaseMapping> mappings = this.getPrimaryKeyMappings();
        int size = mappings.size();
        if (descriptor.hasSimplePrimaryKey()) {
            for (int index = 0; index < size; ++index) {
                AbstractDirectMapping mapping = (AbstractDirectMapping)mappings.get(index);
                Object keyValue = mapping.valueFromObject(domainObject, primaryKeyFields.get(index), session);
                if (this.isPrimaryKeyComponentInvalid(keyValue, index)) {
                    if (shouldReturnNullIfNull) {
                        return null;
                    }
                    isNull = true;
                }
                if (cacheKeyType == CacheKeyType.ID_VALUE) {
                    if (isPersistenceEntity && !isNull) {
                        ((PersistenceEntity)domainObject)._persistence_setId(keyValue);
                    }
                    return keyValue;
                }
                primaryKeyValues[index] = keyValue;
            }
        } else {
            AbstractRecord databaseRow = this.createRecordForPKExtraction(size, session);
            for (int index = 0; index < size; ++index) {
                DatabaseMapping mapping = mappings.get(index);
                if (mapping == null) continue;
                mapping.writeFromObjectIntoRow(domainObject, databaseRow, session, DatabaseMapping.WriteType.UNDEFINED);
            }
            List<Class> primaryKeyClassifications = this.getPrimaryKeyClassifications();
            Platform platform = session.getPlatform(domainObject.getClass());
            for (int index = 0; index < size; ++index) {
                Class classification = primaryKeyClassifications.get(index);
                Object value = databaseRow.get(primaryKeyFields.get(index));
                if (this.isPrimaryKeyComponentInvalid(value, index)) {
                    if (shouldReturnNullIfNull) {
                        return null;
                    }
                    isNull = true;
                }
                value = platform.convertObject(value, classification);
                if (cacheKeyType == CacheKeyType.ID_VALUE) {
                    if (isPersistenceEntity && !isNull) {
                        ((PersistenceEntity)domainObject)._persistence_setId(value);
                    }
                    return value;
                }
                primaryKeyValues[index] = value;
            }
        }
        CacheId id = new CacheId(primaryKeyValues);
        if (isPersistenceEntity && !isNull) {
            ((PersistenceEntity)domainObject)._persistence_setId(id);
        }
        return id;
    }

    public Object extractPrimaryKeyFromRow(AbstractRecord databaseRow, AbstractSession session) {
        List<DatabaseField> primaryKeyFields = this.descriptor.getPrimaryKeyFields();
        if (null == primaryKeyFields) {
            return null;
        }
        List<Class> primaryKeyClassifications = this.getPrimaryKeyClassifications();
        int size = primaryKeyFields.size();
        Object[] primaryKeyValues = null;
        CacheKeyType cacheKeyType = this.descriptor.getCacheKeyType();
        if (cacheKeyType != CacheKeyType.ID_VALUE) {
            primaryKeyValues = new Object[size];
        }
        int numberOfNulls = 0;
        for (int index = 0; index < size; ++index) {
            DatabaseField field = primaryKeyFields.get(index);
            Class classification = primaryKeyClassifications.get(index);
            Object value = databaseRow.get(field);
            if (value != null) {
                if (value.getClass() != classification) {
                    value = session.getPlatform(this.descriptor.getJavaClass()).convertObject(value, classification);
                }
                if (cacheKeyType == CacheKeyType.ID_VALUE) {
                    return value;
                }
                primaryKeyValues[index] = value;
                continue;
            }
            if (this.mayHaveNullInPrimaryKey) {
                if (++numberOfNulls < size) {
                    primaryKeyValues[index] = null;
                    continue;
                }
                return null;
            }
            return null;
        }
        return new CacheId(primaryKeyValues);
    }

    public AbstractRecord extractPrimaryKeyRowFromExpression(Expression expression, AbstractRecord translationRow, AbstractSession session) {
        AbstractRecord primaryKeyRow = this.createRecord(this.getPrimaryKeyMappings().size(), session);
        expression.getBuilder().setSession(session.getRootSession(null));
        boolean isValid = expression.extractPrimaryKeyValues(true, this.descriptor, primaryKeyRow, translationRow);
        if (!isValid) {
            return null;
        }
        if (primaryKeyRow.size() != this.descriptor.getPrimaryKeyFields().size()) {
            return null;
        }
        return primaryKeyRow;
    }

    public AbstractRecord extractPrimaryKeyRowFromObject(Object domainObject, AbstractSession session) {
        AbstractRecord databaseRow = this.createRecord(this.getPrimaryKeyMappings().size(), session);
        for (int index = 0; index < this.getPrimaryKeyMappings().size(); ++index) {
            this.getPrimaryKeyMappings().get(index).writeFromObjectIntoRow(domainObject, databaseRow, session, DatabaseMapping.WriteType.UNDEFINED);
        }
        if (this.descriptor.hasSimplePrimaryKey()) {
            return databaseRow;
        }
        AbstractRecord primaryKeyRow = this.createRecord(this.getPrimaryKeyMappings().size(), session);
        List<DatabaseField> primaryKeyFields = this.descriptor.getPrimaryKeyFields();
        for (int index = 0; index < primaryKeyFields.size(); ++index) {
            Class classification = this.getPrimaryKeyClassifications().get(index);
            DatabaseField field = primaryKeyFields.get(index);
            Object value = databaseRow.get(field);
            primaryKeyRow.put(field, session.getPlatform(domainObject.getClass()).convertObject(value, classification));
        }
        return primaryKeyRow;
    }

    public Object extractValueFromObjectForField(Object domainObject, DatabaseField field, AbstractSession session) throws DescriptorException {
        ClassDescriptor descriptor = null;
        if (this.descriptor.hasInheritance() && domainObject.getClass() != this.descriptor.getJavaClass() && (descriptor = session.getDescriptor(domainObject)).getJavaClass() != this.descriptor.getJavaClass()) {
            if (descriptor.isAggregateCollectionDescriptor()) {
                descriptor = this.descriptor.getInheritancePolicy().getDescriptor(descriptor.getJavaClass());
            }
            return descriptor.getObjectBuilder().extractValueFromObjectForField(domainObject, field, session);
        }
        DatabaseMapping mapping = this.getMappingForField(field);
        if (mapping == null) {
            throw DescriptorException.missingMappingForField(field, this.descriptor);
        }
        return mapping.valueFromObject(domainObject, field, session);
    }

    public void fixObjectReferences(Object object, Map objectDescriptors, Map processedObjects, ObjectLevelReadQuery query, RemoteSession session) {
        if (!this.isSimple) {
            List<DatabaseMapping> mappings = this.relationshipMappings;
            for (int index = 0; index < mappings.size(); ++index) {
                mappings.get(index).fixObjectReferences(object, objectDescriptors, processedObjects, query, session);
            }
        }
    }

    public org.eclipse.persistence.internal.sessions.ChangeRecord getBaseChangeRecordForField(ObjectChangeSet objectChangeSet, Object object, DatabaseField databaseField, AbstractSession session) {
        org.eclipse.persistence.internal.sessions.ChangeRecord changeRecord;
        String attributeName;
        DatabaseMapping mapping = this.getMappingForField(databaseField);
        while (mapping.isAggregateObjectMapping()) {
            ObjectChangeSet aggregateChangeSet;
            attributeName = mapping.getAttributeName();
            Object aggregate = mapping.getAttributeValueFromObject(object);
            ClassDescriptor referenceDescriptor = ((AggregateObjectMapping)mapping).getReferenceDescriptor();
            AggregateChangeRecord aggregateChangeRecord = (AggregateChangeRecord)objectChangeSet.getChangesForAttributeNamed(attributeName);
            if (aggregateChangeRecord == null) {
                aggregateChangeRecord = new AggregateChangeRecord(objectChangeSet);
                aggregateChangeRecord.setAttribute(attributeName);
                aggregateChangeRecord.setMapping(mapping);
                objectChangeSet.addChange(aggregateChangeRecord);
            }
            if ((aggregateChangeSet = (ObjectChangeSet)aggregateChangeRecord.getChangedObject()) == null) {
                aggregateChangeSet = referenceDescriptor.getObjectBuilder().createObjectChangeSet(aggregate, (UnitOfWorkChangeSet)objectChangeSet.getUOWChangeSet(), session);
                aggregateChangeRecord.setChangedObject(aggregateChangeSet);
            }
            mapping = referenceDescriptor.getObjectBuilder().getMappingForField(databaseField);
            objectChangeSet = aggregateChangeSet;
            object = aggregate;
        }
        attributeName = mapping.getAttributeName();
        if (mapping.isDirectToFieldMapping()) {
            changeRecord = (DirectToFieldChangeRecord)objectChangeSet.getChangesForAttributeNamed(attributeName);
            if (changeRecord == null) {
                changeRecord = new DirectToFieldChangeRecord(objectChangeSet);
                changeRecord.setAttribute(attributeName);
                changeRecord.setMapping(mapping);
                objectChangeSet.addChange(changeRecord);
            }
            return changeRecord;
        }
        if (mapping.isTransformationMapping()) {
            changeRecord = (TransformationMappingChangeRecord)objectChangeSet.getChangesForAttributeNamed(attributeName);
            if (changeRecord == null) {
                changeRecord = new TransformationMappingChangeRecord(objectChangeSet);
                changeRecord.setAttribute(attributeName);
                changeRecord.setMapping(mapping);
                objectChangeSet.addChange(changeRecord);
            }
            return changeRecord;
        }
        session.log(1, "query", "field_for_unsupported_mapping_returned", databaseField, this.getDescriptor());
        return null;
    }

    public DatabaseMapping getBaseMappingForField(DatabaseField databaseField) {
        DatabaseMapping mapping = this.getMappingForField(databaseField);
        while (mapping.isAggregateObjectMapping()) {
            mapping = ((AggregateObjectMapping)mapping).getReferenceDescriptor().getObjectBuilder().getMappingForField(databaseField);
        }
        return mapping;
    }

    public Object getBaseValueForField(DatabaseField databaseField, Object domainObject) {
        Object valueIntoObject = domainObject;
        DatabaseMapping mapping = this.getMappingForField(databaseField);
        while (mapping.isAggregateObjectMapping()) {
            valueIntoObject = mapping.getAttributeValueFromObject(valueIntoObject);
            mapping = ((AggregateMapping)mapping).getReferenceDescriptor().getObjectBuilder().getMappingForField(databaseField);
        }
        return mapping.getAttributeValueFromObject(valueIntoObject);
    }

    public ClassDescriptor getDescriptor() {
        return this.descriptor;
    }

    public Class getFieldClassification(DatabaseField fieldToClassify) throws DescriptorException {
        DatabaseMapping mapping = this.getMappingForField(fieldToClassify);
        if (mapping == null) {
            return null;
        }
        return mapping.getFieldClassification(fieldToClassify);
    }

    public DatabaseField getFieldForQueryKeyName(String name) {
        QueryKey key = this.descriptor.getQueryKeyNamed(name);
        if (key == null) {
            DatabaseMapping mapping = this.getMappingForAttributeName(name);
            if (mapping == null) {
                return null;
            }
            if (mapping.getFields().isEmpty()) {
                return null;
            }
            return mapping.getFields().get(0);
        }
        if (key.isDirectQueryKey()) {
            return ((DirectQueryKey)key).getField();
        }
        return null;
    }

    public Map<DatabaseField, DatabaseField> getFieldsMap() {
        return this.fieldsMap;
    }

    protected void setFieldsMap(Map fieldsMap) {
        this.fieldsMap = fieldsMap;
    }

    public List<DatabaseMapping> getCloningMappings() {
        return this.cloningMappings;
    }

    public boolean isSimple() {
        return this.isSimple;
    }

    public List<DatabaseMapping> getRelationshipMappings() {
        return this.relationshipMappings;
    }

    public List<DatabaseMapping> getEagerMappings() {
        return this.eagerMappings;
    }

    public List<DatabaseMapping> getJoinedAttributes() {
        return this.joinedAttributes;
    }

    public List<DatabaseMapping> getBatchFetchedAttributes() {
        return this.batchFetchedAttributes;
    }

    public AbstractDirectMapping getSequenceMapping() {
        return this.sequenceMapping;
    }

    public void setSequenceMapping(AbstractDirectMapping sequenceMapping) {
        this.sequenceMapping = sequenceMapping;
    }

    public boolean hasJoinedAttributes() {
        return this.joinedAttributes != null;
    }

    public boolean hasBatchFetchedAttributes() {
        return this.batchFetchedAttributes != null;
    }

    public boolean hasInBatchFetchedAttribute() {
        return this.hasInBatchFetchedAttribute;
    }

    public void setHasInBatchFetchedAttribute(boolean hasInBatchFetchedAttribute) {
        this.hasInBatchFetchedAttribute = hasInBatchFetchedAttribute;
    }

    public DatabaseMapping getMappingForAttributeName(String name) {
        return this.getMappingsByAttribute().get(name);
    }

    public DatabaseMapping getMappingForField(DatabaseField field) {
        return this.getMappingsByField().get(field);
    }

    public List<DatabaseMapping> getReadOnlyMappingsForField(DatabaseField field) {
        return this.getReadOnlyMappingsByField().get(field);
    }

    protected Map<String, DatabaseMapping> getMappingsByAttribute() {
        return this.mappingsByAttribute;
    }

    public Map<DatabaseField, DatabaseMapping> getMappingsByField() {
        return this.mappingsByField;
    }

    public Map<DatabaseField, List<DatabaseMapping>> getReadOnlyMappingsByField() {
        return this.readOnlyMappingsByField;
    }

    protected List<DatabaseMapping> getNonPrimaryKeyMappings() {
        return this.nonPrimaryKeyMappings;
    }

    public Object getParentObjectForField(DatabaseField databaseField, Object domainObject) {
        Object valueIntoObject = domainObject;
        DatabaseMapping mapping = this.getMappingForField(databaseField);
        while (mapping.isAggregateObjectMapping()) {
            valueIntoObject = mapping.getAttributeValueFromObject(valueIntoObject);
            mapping = ((AggregateMapping)mapping).getReferenceDescriptor().getObjectBuilder().getMappingForField(databaseField);
        }
        return valueIntoObject;
    }

    public List<Class> getPrimaryKeyClassifications() {
        if (this.primaryKeyClassifications == null) {
            List<DatabaseField> primaryKeyFields = this.descriptor.getPrimaryKeyFields();
            if (null == primaryKeyFields) {
                return Collections.emptyList();
            }
            ArrayList<Class> classifications = new ArrayList<Class>(primaryKeyFields.size());
            for (int index = 0; index < primaryKeyFields.size(); ++index) {
                if (this.getPrimaryKeyMappings().size() < index + 1) {
                    classifications.add(null);
                    continue;
                }
                DatabaseMapping mapping = this.getPrimaryKeyMappings().get(index);
                DatabaseField field = primaryKeyFields.get(index);
                if (mapping != null) {
                    classifications.add(Helper.getObjectClass(mapping.getFieldClassification(field)));
                    continue;
                }
                classifications.add(null);
            }
            this.primaryKeyClassifications = classifications;
        }
        return this.primaryKeyClassifications;
    }

    public Expression getPrimaryKeyExpression() {
        return this.primaryKeyExpression;
    }

    public List<DatabaseMapping> getPrimaryKeyMappings() {
        return this.primaryKeyMappings;
    }

    public DatabaseField getTargetFieldForQueryKeyName(String queryKeyName) {
        DatabaseMapping mapping = this.getMappingForAttributeName(queryKeyName);
        if (mapping != null && mapping.isDirectToFieldMapping()) {
            return ((AbstractDirectMapping)mapping).getField();
        }
        QueryKey queryKey = this.descriptor.getQueryKeyNamed(queryKeyName);
        if (queryKey != null && queryKey.isDirectQueryKey()) {
            return ((DirectQueryKey)queryKey).getField();
        }
        return null;
    }

    public void initialize(AbstractSession session) throws DescriptorException {
        DatabaseMapping lockMapping;
        DatabaseField lockField;
        DatabaseMapping sequenceMapping;
        this.getMappingsByField().clear();
        this.getReadOnlyMappingsByField().clear();
        this.getMappingsByAttribute().clear();
        this.getCloningMappings().clear();
        this.getEagerMappings().clear();
        this.getRelationshipMappings().clear();
        Enumeration<DatabaseMapping> mappings = this.descriptor.getMappings().elements();
        while (mappings.hasMoreElements()) {
            DatabaseMapping mapping = mappings.nextElement();
            if (!mapping.isWriteOnly()) {
                this.getMappingsByAttribute().put(mapping.getAttributeName(), mapping);
            }
            if (mapping.isCloningRequired()) {
                this.getCloningMappings().add(mapping);
            }
            if (mapping.isForeignReferenceMapping() && ((ForeignReferenceMapping)mapping).usesIndirection() && !mapping.isLazy()) {
                this.getEagerMappings().add(mapping);
            }
            if (mapping.getReferenceDescriptor() != null && mapping.isCollectionMapping() && this.getDescriptor() == mapping.getDescriptor()) {
                ((ContainerMapping)((Object)mapping)).getContainerPolicy().processAdditionalWritableMapKeyFields(session);
            }
            if (!mapping.isDirectToFieldMapping()) {
                this.getRelationshipMappings().add(mapping);
            }
            for (DatabaseField field : mapping.getFields()) {
                if (mapping.isReadOnly()) {
                    List<DatabaseMapping> readOnlyMappings = this.getReadOnlyMappingsByField().get(field);
                    if (readOnlyMappings == null) {
                        readOnlyMappings = new ArrayList<DatabaseMapping>();
                        this.getReadOnlyMappingsByField().put(field, readOnlyMappings);
                    }
                    readOnlyMappings.add(mapping);
                    continue;
                }
                if (mapping.isAggregateObjectMapping()) {
                    ObjectBuilder aggregateObjectBuilder = ((AggregateObjectMapping)mapping).getReferenceDescriptor().getObjectBuilder();
                    DatabaseMapping aggregatedFieldMapping = aggregateObjectBuilder.getMappingForField(field);
                    if (aggregatedFieldMapping == null) {
                        List<DatabaseMapping> readOnlyMappings = this.getReadOnlyMappingsByField().get(field);
                        if (readOnlyMappings == null) {
                            readOnlyMappings = new ArrayList<DatabaseMapping>();
                            this.getReadOnlyMappingsByField().put(field, readOnlyMappings);
                        }
                        readOnlyMappings.add(mapping);
                        continue;
                    }
                    this.getMappingsByField().put(field, mapping);
                    continue;
                }
                if (this.getMappingsByField().containsKey(field) || mapping.getDescriptor().getAdditionalWritableMapKeyFields().contains(field)) {
                    session.getIntegrityChecker().handleError(DescriptorException.multipleWriteMappingsForField(field.toString(), mapping));
                    continue;
                }
                this.getMappingsByField().put(field, mapping);
            }
        }
        this.isSimple = this.getRelationshipMappings().isEmpty();
        this.initializePrimaryKey(session);
        this.initializeJoinedAttributes();
        this.initializeBatchFetchedAttributes();
        if (this.descriptor.usesSequenceNumbers() && (sequenceMapping = this.getMappingForField(this.descriptor.getSequenceNumberField())) != null && sequenceMapping.isDirectToFieldMapping()) {
            this.setSequenceMapping((AbstractDirectMapping)sequenceMapping);
        }
        if (this.descriptor.usesOptimisticLocking() && (lockField = this.descriptor.getOptimisticLockingPolicy().getWriteLockField()) != null && (lockMapping = this.getDescriptor().getObjectBuilder().getMappingForField(lockField)) != null) {
            this.lockAttribute = lockMapping.getAttributeName();
        }
    }

    public boolean isPrimaryKeyComponentInvalid(Object keyValue, int index) {
        IdValidation idValidation = index < 0 ? this.descriptor.getIdValidation() : this.descriptor.getPrimaryKeyIdValidations().get(index);
        if (idValidation == IdValidation.ZERO) {
            return keyValue == null || Helper.isEquivalentToNull(keyValue);
        }
        if (idValidation == IdValidation.NULL) {
            return keyValue == null;
        }
        if (idValidation == IdValidation.NEGATIVE) {
            return keyValue == null || Helper.isNumberNegativeOrZero(keyValue);
        }
        return false;
    }

    public void recordPrivateOwnedRemovals(Object object, UnitOfWorkImpl uow, boolean initialPass) {
        if (!this.descriptor.isDescriptorTypeAggregate()) {
            if (!initialPass && uow.getDeletedObjects().containsKey(object)) {
                return;
            }
            uow.getDeletedObjects().put(object, object);
        }
        if (this.descriptor.hasMappingsPostCalculateChanges()) {
            for (DatabaseMapping mapping : this.descriptor.getMappingsPostCalculateChanges()) {
                mapping.recordPrivateOwnedRemovals(object, uow);
            }
        }
    }

    public void postInitialize(AbstractSession session) throws DescriptorException {
        this.hasWrapperPolicy = this.descriptor.hasWrapperPolicy() || session.getProject().hasProxyIndirection();
    }

    public void initializeJoinedAttributes() {
        ArrayList<DatabaseMapping> joinedAttributes = null;
        Vector<DatabaseMapping> mappings = this.descriptor.getMappings();
        for (int i = 0; i < mappings.size(); ++i) {
            DatabaseMapping mapping = (DatabaseMapping)mappings.get(i);
            if (!mapping.isForeignReferenceMapping() || !((ForeignReferenceMapping)mapping).isJoinFetched()) continue;
            if (joinedAttributes == null) {
                joinedAttributes = new ArrayList<DatabaseMapping>();
            }
            joinedAttributes.add(mapping);
        }
        this.joinedAttributes = joinedAttributes;
    }

    public void initializeBatchFetchedAttributes() {
        ArrayList<DatabaseMapping> batchedAttributes = null;
        for (DatabaseMapping mapping : this.descriptor.getMappings()) {
            if (mapping.isForeignReferenceMapping() && ((ForeignReferenceMapping)mapping).shouldUseBatchReading()) {
                if (batchedAttributes == null) {
                    batchedAttributes = new ArrayList<DatabaseMapping>();
                }
                batchedAttributes.add(mapping);
                if (((ForeignReferenceMapping)mapping).getBatchFetchType() != BatchFetchType.IN) continue;
                this.hasInBatchFetchedAttribute = true;
                continue;
            }
            if (!mapping.isAggregateObjectMapping() || !mapping.getReferenceDescriptor().getObjectBuilder().hasInBatchFetchedAttribute()) continue;
            this.hasInBatchFetchedAttribute = true;
        }
        this.batchFetchedAttributes = batchedAttributes;
        if (this.hasInBatchFetchedAttribute && this.descriptor.hasInheritance()) {
            ClassDescriptor parent = this.descriptor.getInheritancePolicy().getParentDescriptor();
            while (parent != null) {
                parent.getObjectBuilder().setHasInBatchFetchedAttribute(true);
                parent = parent.getInheritancePolicy().getParentDescriptor();
            }
        }
    }

    protected void copyQueryInfoToCacheKey(CacheKey cacheKey, ObjectBuildingQuery query, AbstractRecord databaseRow, AbstractSession session, ClassDescriptor concreteDescriptor) {
        cacheKey.setLastUpdatedQueryId(query.getQueryId());
        if (concreteDescriptor.usesOptimisticLocking()) {
            OptimisticLockingPolicy policy = concreteDescriptor.getOptimisticLockingPolicy();
            Object cacheValue = policy.getValueToPutInCache(databaseRow, session);
            cacheKey.setWriteLockValue(cacheValue);
        }
        cacheKey.setReadTime(query.getExecutionTime());
    }

    public void initializePrimaryKey(AbstractSession session) throws DescriptorException {
        DatabaseMapping mapping;
        List<DatabaseField> primaryKeyFields = this.descriptor.getPrimaryKeyFields();
        if ((null == primaryKeyFields || primaryKeyFields.isEmpty()) && this.getDescriptor().isAggregateCollectionDescriptor()) {
            DatabaseTable defaultTable = this.getDescriptor().getDefaultTable();
            for (DatabaseField field : this.getDescriptor().getFields()) {
                if (!field.getTable().equals(defaultTable) || !this.getMappingsByField().containsKey(field)) continue;
                primaryKeyFields.add(field);
            }
            List<DatabaseField> additionalFields = this.descriptor.getAdditionalAggregateCollectionKeyFields();
            for (int i = 0; i < additionalFields.size(); ++i) {
                DatabaseField additionalField = additionalFields.get(i);
                if (primaryKeyFields.contains(additionalField)) continue;
                primaryKeyFields.add(additionalField);
            }
        }
        this.createPrimaryKeyExpression(session);
        if (null != this.primaryKeyMappings) {
            this.primaryKeyMappings.clear();
        }
        if (null != this.nonPrimaryKeyMappings) {
            this.nonPrimaryKeyMappings.clear();
        }
        for (DatabaseField field : this.getMappingsByField().keySet()) {
            if (null != primaryKeyFields && primaryKeyFields.contains(field)) continue;
            mapping = this.getMappingForField(field);
            if (this.nonPrimaryKeyMappings == null || this.getNonPrimaryKeyMappings().contains(mapping)) continue;
            this.getNonPrimaryKeyMappings().add(mapping);
        }
        if (null != primaryKeyFields) {
            for (int index = 0; index < primaryKeyFields.size(); ++index) {
                DatabaseField primaryKeyField = primaryKeyFields.get(index);
                mapping = this.getMappingForField(primaryKeyField);
                if (mapping == null) {
                    if (this.descriptor.isDescriptorTypeAggregate()) {
                        this.mayHaveNullInPrimaryKey = true;
                    } else {
                        throw DescriptorException.noMappingForPrimaryKey(primaryKeyField, this.descriptor);
                    }
                }
                this.getPrimaryKeyMappings().add(mapping);
                if (mapping != null) {
                    mapping.setIsPrimaryKeyMapping(true);
                }
                if (!this.descriptor.hasMultipleTables() || mapping == null) continue;
                for (Map<DatabaseField, DatabaseField> keyMapping : this.descriptor.getAdditionalTablePrimaryKeyFields().values()) {
                    DatabaseField secondaryField = keyMapping.get(primaryKeyField);
                    if (secondaryField == null) continue;
                    this.getMappingsByField().put(secondaryField, mapping);
                    if (!mapping.isAggregateObjectMapping()) continue;
                    ((AggregateObjectMapping)mapping).addPrimaryKeyJoinField(primaryKeyField, secondaryField);
                }
            }
        }
        boolean hasSimplePrimaryKey = true;
        if (null != this.primaryKeyMappings) {
            for (int index = 0; index < this.getPrimaryKeyMappings().size(); ++index) {
                mapping = this.getPrimaryKeyMappings().get(index);
                if (mapping != null && mapping.isDirectToFieldMapping()) continue;
                hasSimplePrimaryKey = false;
                break;
            }
        }
        this.descriptor.setHasSimplePrimaryKey(hasSimplePrimaryKey);
        boolean wasIdValidationSet = true;
        if (this.descriptor.getIdValidation() == null) {
            wasIdValidationSet = false;
            List<DatabaseField> descriptorPrimaryKeyFields = this.descriptor.getPrimaryKeyFields();
            if (descriptorPrimaryKeyFields != null && descriptorPrimaryKeyFields.size() > 1) {
                this.descriptor.setIdValidation(IdValidation.NULL);
            } else {
                this.descriptor.setIdValidation(IdValidation.ZERO);
            }
        }
        if (this.descriptor.getPrimaryKeyFields() != null && this.descriptor.getPrimaryKeyIdValidations() == null) {
            this.descriptor.setPrimaryKeyIdValidations(new ArrayList<IdValidation>(this.descriptor.getPrimaryKeyFields().size()));
            for (DatabaseField field : this.descriptor.getPrimaryKeyFields()) {
                if (!wasIdValidationSet && this.descriptor.usesSequenceNumbers() && field.equals(this.descriptor.getSequenceNumberField())) {
                    this.descriptor.getPrimaryKeyIdValidations().add(IdValidation.ZERO);
                    continue;
                }
                this.descriptor.getPrimaryKeyIdValidations().add(this.descriptor.getIdValidation());
            }
        }
    }

    public Object instantiateClone(Object domainObject, AbstractSession session) {
        Object clone = this.descriptor.getCopyPolicy().buildClone(domainObject, session);
        if (clone instanceof ChangeTracker) {
            ((ChangeTracker)clone)._persistence_setPropertyChangeListener(null);
        }
        if (clone instanceof FetchGroupTracker) {
            ((FetchGroupTracker)clone)._persistence_setFetchGroup(null);
            ((FetchGroupTracker)clone)._persistence_setSession(null);
        }
        this.clearPrimaryKey(clone);
        return clone;
    }

    public Object instantiateWorkingCopyClone(Object domainObject, AbstractSession session) {
        return this.descriptor.getCopyPolicy().buildWorkingCopyClone(domainObject, session);
    }

    public Object instantiateWorkingCopyCloneFromRow(AbstractRecord row, ObjectBuildingQuery query, Object primaryKey, UnitOfWorkImpl unitOfWork) {
        return this.descriptor.getCopyPolicy().buildWorkingCopyCloneFromRow(row, query, primaryKey, unitOfWork);
    }

    public boolean isPrimaryKeyMapping(DatabaseMapping mapping) {
        return this.getPrimaryKeyMappings().contains(mapping);
    }

    public void iterate(DescriptorIterator iterator) {
        List<DatabaseMapping> mappings;
        if (iterator.shouldIterateOnPrimitives()) {
            mappings = this.descriptor.getMappings();
        } else {
            if (this.isSimple) {
                return;
            }
            mappings = this.relationshipMappings;
        }
        int mappingsSize = mappings.size();
        for (int index = 0; index < mappingsSize; ++index) {
            mappings.get(index).iterate(iterator);
        }
    }

    public void mergeChangesIntoObject(Object target, ObjectChangeSet changeSet, Object source, MergeManager mergeManager, AbstractSession targetSession) {
        this.mergeChangesIntoObject(target, changeSet, source, mergeManager, targetSession, false, false);
    }

    public void mergeChangesIntoObject(Object target, ObjectChangeSet changeSet, Object source, MergeManager mergeManager, AbstractSession targetSession, boolean isTargetCloneOfOriginal, boolean shouldMergeFetchGroup) {
        if (source != null && changeSet.isNew() && !this.descriptor.shouldUseFullChangeSetsForNewObjects()) {
            this.mergeIntoObject(target, true, source, mergeManager, targetSession, false, isTargetCloneOfOriginal, shouldMergeFetchGroup);
        } else {
            List<ChangeRecord> changes = changeSet.getChanges();
            int size = changes.size();
            for (int index = 0; index < size; ++index) {
                org.eclipse.persistence.internal.sessions.ChangeRecord record = (org.eclipse.persistence.internal.sessions.ChangeRecord)changes.get(index);
                DatabaseMapping mapping = this.getMappingForAttributeName(record.getAttribute());
                mapping.mergeChangesIntoObject(target, record, source, mergeManager, targetSession);
            }
        }
        if (this.descriptor.getEventManager().hasAnyEventListeners()) {
            DescriptorEvent event = new DescriptorEvent(target);
            event.setSession(mergeManager.getSession());
            event.setOriginalObject(source);
            event.setChangeSet(changeSet);
            event.setEventCode(11);
            this.descriptor.getEventManager().executeEvent(event);
        }
    }

    public void mergeIntoObject(Object target, boolean isUnInitialized, Object source, MergeManager mergeManager, AbstractSession targetSession) {
        this.mergeIntoObject(target, isUnInitialized, source, mergeManager, targetSession, false, false, false);
    }

    public void mergeIntoObject(Object target, boolean isUnInitialized, Object source, MergeManager mergeManager, AbstractSession targetSession, boolean cascadeOnly, boolean isTargetCloneOfOriginal, boolean shouldMergeFetchGroup) {
        FetchGroup sourceFetchGroup = null;
        FetchGroup targetFetchGroup = null;
        if (this.descriptor.hasFetchGroupManager()) {
            sourceFetchGroup = this.descriptor.getFetchGroupManager().getObjectFetchGroup(source);
            targetFetchGroup = this.descriptor.getFetchGroupManager().getObjectFetchGroup(target);
            if (targetFetchGroup != null) {
                if (!targetFetchGroup.isSupersetOf(sourceFetchGroup)) {
                    targetFetchGroup.onUnfetchedAttribute((FetchGroupTracker)target, null);
                }
            } else if (shouldMergeFetchGroup && sourceFetchGroup != null) {
                this.descriptor.getFetchGroupManager().setObjectFetchGroup(target, sourceFetchGroup, targetSession);
            }
        }
        Vector<DatabaseMapping> mappings = this.descriptor.getMappings();
        for (int index = 0; index < mappings.size(); ++index) {
            DatabaseMapping mapping = (DatabaseMapping)mappings.get(index);
            if (!(!cascadeOnly && !isTargetCloneOfOriginal || cascadeOnly && mapping.isForeignReferenceMapping()) && (!isTargetCloneOfOriginal || !mapping.isCloningRequired()) || sourceFetchGroup != null && !sourceFetchGroup.containsAttributeInternal(mapping.getAttributeName())) continue;
            mapping.mergeIntoObject(target, isUnInitialized, source, mergeManager, targetSession);
        }
        if (this.descriptor.getEventManager().hasAnyEventListeners()) {
            DescriptorEvent event = new DescriptorEvent(target);
            event.setSession(mergeManager.getSession());
            event.setOriginalObject(source);
            event.setEventCode(11);
            this.descriptor.getEventManager().executeEvent(event);
        }
    }

    public void populateAttributesForClone(Object original, CacheKey cacheKey, Object clone, AbstractSession cloningSession) {
        List<DatabaseMapping> mappings = this.getCloningMappings();
        int size = mappings.size();
        if (this.descriptor.hasFetchGroupManager() && this.descriptor.getFetchGroupManager().isPartialObject(original)) {
            FetchGroupManager fetchGroupManager = this.descriptor.getFetchGroupManager();
            for (int index = 0; index < size; ++index) {
                DatabaseMapping mapping = mappings.get(index);
                if (!fetchGroupManager.isAttributeFetched(original, mapping.getAttributeName())) continue;
                mapping.buildClone(original, cacheKey, clone, cloningSession);
            }
        } else {
            for (int index = 0; index < size; ++index) {
                mappings.get(index).buildClone(original, cacheKey, clone, cloningSession);
            }
        }
        if (this.descriptor.getEventManager().hasAnyEventListeners()) {
            DescriptorEvent event = new DescriptorEvent(clone);
            event.setSession(cloningSession);
            event.setOriginalObject(original);
            event.setDescriptor(this.descriptor);
            event.setEventCode(10);
            cloningSession.deferEvent(event);
        }
    }

    protected void loadBatchReadAttributes(ClassDescriptor concreteDescriptor, Object sourceObject, CacheKey cacheKey, AbstractRecord databaseRow, ObjectBuildingQuery query, JoinedAttributeManager joinManager, boolean isTargetProtected) {
        List<Expression> batchExpressions = ((ReadAllQuery)query).getBatchReadAttributeExpressions();
        int size = batchExpressions.size();
        for (int index = 0; index < size; ++index) {
            QueryKeyExpression queryKeyExpression = (QueryKeyExpression)batchExpressions.get(index);
            if (!queryKeyExpression.getBaseExpression().isExpressionBuilder()) continue;
            DatabaseMapping mapping = this.getMappingForAttributeName(queryKeyExpression.getName());
            if (mapping == null) {
                throw ValidationException.missingMappingForAttribute(concreteDescriptor, queryKeyExpression.getName(), this.toString());
            }
            Object attributeValue = mapping.getAttributeValueFromObject(sourceObject);
            if (attributeValue == null || !mapping.isForeignReferenceMapping() || !((ForeignReferenceMapping)mapping).usesIndirection() || ((ForeignReferenceMapping)mapping).getIndirectionPolicy().objectIsInstantiated(attributeValue)) continue;
            mapping.readFromRowIntoObject(databaseRow, joinManager, sourceObject, cacheKey, query, query.getExecutionSession(), isTargetProtected);
        }
    }

    protected void loadJoinedAttributes(ClassDescriptor concreteDescriptor, Object sourceObject, CacheKey cacheKey, AbstractRecord databaseRow, JoinedAttributeManager joinManager, ObjectBuildingQuery query, boolean isTargetProtected) {
        List<Expression> joinExpressions = joinManager.getJoinedAttributeExpressions();
        int size = joinExpressions.size();
        for (int index = 0; index < size; ++index) {
            QueryKeyExpression queryKeyExpression = (QueryKeyExpression)joinExpressions.get(index);
            QueryKeyExpression baseExpression = (QueryKeyExpression)joinManager.getJoinedAttributes().get(index);
            DatabaseMapping mapping = joinManager.getJoinedAttributeMappings().get(index);
            if (queryKeyExpression != baseExpression) continue;
            Object intermediateValue = joinManager.getValueFromObjectForExpression(query.getExecutionSession(), sourceObject, (ObjectExpression)baseExpression.getBaseExpression());
            if (mapping == null) {
                throw ValidationException.missingMappingForAttribute(concreteDescriptor, queryKeyExpression.getName(), this.toString());
            }
            Object attributeValue = mapping.getAttributeValueFromObject(intermediateValue);
            if (attributeValue == null || !mapping.isForeignReferenceMapping() || !((ForeignReferenceMapping)mapping).usesIndirection() || ((ForeignReferenceMapping)mapping).getIndirectionPolicy().objectIsInstantiated(attributeValue)) continue;
            mapping.readFromRowIntoObject(databaseRow, joinManager, intermediateValue, cacheKey, query, query.getExecutionSession(), isTargetProtected);
        }
    }

    protected boolean refreshObjectIfRequired(ClassDescriptor concreteDescriptor, CacheKey cacheKey, Object domainObject, ObjectBuildingQuery query, JoinedAttributeManager joinManager, AbstractRecord databaseRow, AbstractSession session, boolean targetIsProtected) {
        boolean cacheHit = true;
        if (concreteDescriptor.hasFetchGroupManager() && concreteDescriptor.getFetchGroupManager().isPartialObject(domainObject)) {
            cacheHit = false;
            this.revertFetchGroupData(domainObject, concreteDescriptor, cacheKey, query, joinManager, databaseRow, session, targetIsProtected);
        } else {
            boolean refreshRequired = true;
            if (concreteDescriptor.usesOptimisticLocking()) {
                OptimisticLockingPolicy policy = concreteDescriptor.getOptimisticLockingPolicy();
                Object cacheValue = policy.getValueToPutInCache(databaseRow, session);
                if (concreteDescriptor.shouldOnlyRefreshCacheIfNewerVersion() && !(refreshRequired = policy.isNewerVersion(databaseRow, domainObject, cacheKey.getKey(), session))) {
                    cacheKey.setReadTime(query.getExecutionTime());
                }
                if (refreshRequired) {
                    cacheKey.setWriteLockValue(cacheValue);
                }
            }
            if (refreshRequired) {
                cacheHit = false;
                cacheKey.setLastUpdatedQueryId(query.getQueryId());
                cacheKey.setReadTime(query.getExecutionTime());
                concreteDescriptor.getObjectBuilder().buildAttributesIntoObject(domainObject, cacheKey, databaseRow, query, joinManager, true, session);
            }
        }
        return cacheHit;
    }

    public void rehashFieldDependancies(AbstractSession session) {
        this.setMappingsByField(Helper.rehashMap(this.getMappingsByField()));
        this.setReadOnlyMappingsByField(Helper.rehashMap(this.getReadOnlyMappingsByField()));
        this.setFieldsMap(Helper.rehashMap(this.getFieldsMap()));
        this.setPrimaryKeyMappings(new ArrayList<DatabaseMapping>(2));
        this.setNonPrimaryKeyMappings(new ArrayList<DatabaseMapping>(2));
        this.initializePrimaryKey(session);
    }

    public void setDescriptor(ClassDescriptor aDescriptor) {
        this.descriptor = aDescriptor;
    }

    protected void setMappingsByAttribute(Map<String, DatabaseMapping> theAttributeMappings) {
        this.mappingsByAttribute = theAttributeMappings;
    }

    public void setMappingsByField(Map<DatabaseField, DatabaseMapping> theFieldMappings) {
        this.mappingsByField = theFieldMappings;
    }

    public void setReadOnlyMappingsByField(Map<DatabaseField, List<DatabaseMapping>> theReadOnlyFieldMappings) {
        this.readOnlyMappingsByField = theReadOnlyFieldMappings;
    }

    protected void setNonPrimaryKeyMappings(List<DatabaseMapping> theNonPrimaryKeyMappings) {
        this.nonPrimaryKeyMappings = theNonPrimaryKeyMappings;
    }

    public void setPrimaryKeyClassifications(List<Class> primaryKeyClassifications) {
        this.primaryKeyClassifications = primaryKeyClassifications;
    }

    public void setPrimaryKeyExpression(Expression criteria) {
        this.primaryKeyExpression = criteria;
    }

    protected void setPrimaryKeyMappings(List<DatabaseMapping> thePrimaryKeyMappings) {
        this.primaryKeyMappings = thePrimaryKeyMappings;
    }

    public String toString() {
        return Helper.getShortClassName(this.getClass()) + "(" + this.descriptor.toString() + ")";
    }

    public Object unwrapObject(Object proxy, AbstractSession session) {
        ClassDescriptor descriptor;
        if (!this.hasWrapperPolicy) {
            return proxy;
        }
        if (proxy == null) {
            return null;
        }
        if (!this.descriptor.hasWrapperPolicy() || this.descriptor.getJavaClass() == proxy.getClass() || !this.descriptor.getWrapperPolicy().isWrapped(proxy)) {
            if (session.getProject().hasProxyIndirection()) {
                return ProxyIndirectionPolicy.getValueFromProxy(proxy);
            }
            return proxy;
        }
        if (this.descriptor.hasInheritance() && this.descriptor.getInheritancePolicy().hasChildren() && (descriptor = session.getDescriptor(proxy)) != this.descriptor) {
            return descriptor.getObjectBuilder().unwrapObject(proxy, session);
        }
        return this.descriptor.getWrapperPolicy().unwrapObject(proxy, session);
    }

    public void validate(AbstractSession session) throws DescriptorException {
        if (this.descriptor.usesSequenceNumbers() && this.getMappingForField(this.descriptor.getSequenceNumberField()) == null) {
            throw DescriptorException.mappingForSequenceNumberField(this.descriptor);
        }
    }

    public boolean verifyDelete(Object object, AbstractSession session) {
        AbstractRecord translationRow = this.buildRowForTranslation(object, session);
        if (this.descriptor.getQueryManager().getReadObjectQuery() != null && this.descriptor.getQueryManager().getReadObjectQuery().isCallQuery()) {
            Object result = session.readObject(object);
            if (result != null) {
                return false;
            }
        } else {
            Enumeration<DatabaseTable> tables = this.descriptor.getTables().elements();
            while (tables.hasMoreElements()) {
                DatabaseTable table = tables.nextElement();
                SQLSelectStatement sqlStatement = new SQLSelectStatement();
                sqlStatement.addTable(table);
                if (table == this.descriptor.getTables().firstElement()) {
                    sqlStatement.setWhereClause((Expression)this.getPrimaryKeyExpression().clone());
                } else {
                    sqlStatement.setWhereClause(this.buildPrimaryKeyExpression(table));
                }
                DatabaseField all = new DatabaseField("*");
                all.setTable(table);
                sqlStatement.addField(all);
                sqlStatement.normalize(session, null);
                DataReadQuery dataReadQuery = new DataReadQuery();
                dataReadQuery.setSQLStatement(sqlStatement);
                dataReadQuery.setSessionName(this.descriptor.getSessionName());
                List queryResults = (List)session.executeQuery((DatabaseQuery)dataReadQuery, translationRow);
                if (queryResults.isEmpty()) continue;
                return false;
            }
        }
        Enumeration<DatabaseMapping> mappings = this.descriptor.getMappings().elements();
        while (mappings.hasMoreElements()) {
            DatabaseMapping mapping = mappings.nextElement();
            if (mapping.verifyDelete(object, session)) continue;
            return false;
        }
        return true;
    }

    public boolean hasWrapperPolicy() {
        return this.hasWrapperPolicy;
    }

    public void setHasWrapperPolicy(boolean hasWrapperPolicy) {
        this.hasWrapperPolicy = hasWrapperPolicy;
    }

    public Object wrapObject(Object implementation, AbstractSession session) {
        ClassDescriptor descriptor;
        if (!this.hasWrapperPolicy) {
            return implementation;
        }
        if (implementation == null) {
            return null;
        }
        if (!this.descriptor.hasWrapperPolicy() || this.descriptor.getWrapperPolicy().isWrapped(implementation)) {
            return implementation;
        }
        if (this.descriptor.hasInheritance() && this.descriptor.getInheritancePolicy().hasChildren() && implementation.getClass() != this.descriptor.getJavaClass() && (descriptor = session.getDescriptor(implementation)) != this.descriptor) {
            return descriptor.getObjectBuilder().wrapObject(implementation, session);
        }
        return this.descriptor.getWrapperPolicy().wrapObject(implementation, session);
    }

    public boolean isXMLObjectBuilder() {
        return false;
    }

    public String getLockAttribute() {
        return this.lockAttribute;
    }
}

