/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.identitymaps;

import java.util.Iterator;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.identitymaps.FullIdentityMap;
import org.eclipse.persistence.internal.identitymaps.WeakCacheKey;

public class WeakIdentityMap
extends FullIdentityMap {
    protected volatile int cleanupCount = 0;
    protected volatile int cleanupSize;

    public WeakIdentityMap(int size, ClassDescriptor descriptor) {
        super(size, descriptor);
        this.cleanupSize = size;
    }

    public WeakIdentityMap(int size, ClassDescriptor descriptor, boolean isolated) {
        this(size, descriptor);
        this.isIsolated = isolated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanupDeadCacheKeys() {
        Iterator<CacheKey> iterator = this.getCacheKeys().values().iterator();
        while (iterator.hasNext()) {
            Object var4_3;
            CacheKey key = iterator.next();
            if (key.getObject() != null || !key.acquireIfUnownedNoWait()) continue;
            try {
                if (key.getObject() == null) {
                    iterator.remove();
                }
                var4_3 = null;
                key.release();
            }
            catch (Throwable throwable) {
                var4_3 = null;
                key.release();
                throw throwable;
            }
        }
    }

    public CacheKey createCacheKey(Object primaryKey, Object object, Object writeLockValue, long readTime) {
        return new WeakCacheKey(primaryKey, object, writeLockValue, readTime, this.isIsolated);
    }

    protected CacheKey putCacheKeyIfAbsent(CacheKey searchKey) {
        CacheKey cacheKey = super.putCacheKeyIfAbsent(searchKey);
        if (cacheKey == null) {
            this.checkCleanup();
        }
        return cacheKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkCleanup() {
        if (this.cleanupCount > this.cleanupSize) {
            WeakIdentityMap weakIdentityMap = this;
            synchronized (weakIdentityMap) {
                if (this.cleanupCount > this.cleanupSize) {
                    this.cleanupDeadCacheKeys();
                    this.cleanupCount = 0;
                    int size = this.getSize();
                    if (size > this.cleanupSize) {
                        this.cleanupSize = size;
                    }
                }
            }
        }
        ++this.cleanupCount;
    }
}

