/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database.oracle.plsql;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.internal.databaseaccess.DatasourceCall;
import org.eclipse.persistence.internal.helper.ComplexDatabaseType;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseType;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.platform.database.DatabasePlatform;
import org.eclipse.persistence.platform.database.oracle.plsql.OraclePLSQLType;
import org.eclipse.persistence.platform.database.oracle.plsql.PLSQLStoredProcedureCall;
import org.eclipse.persistence.platform.database.oracle.plsql.PLSQLargument;
import org.eclipse.persistence.queries.StoredProcedureCall;
import org.eclipse.persistence.sessions.DatabaseRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PLSQLrecord
extends ComplexDatabaseType
implements OraclePLSQLType,
Cloneable {
    protected List<PLSQLargument> fields = new ArrayList<PLSQLargument>();

    @Override
    public PLSQLrecord clone() {
        PLSQLrecord clone = (PLSQLrecord)super.clone();
        clone.fields = new ArrayList<PLSQLargument>(this.fields.size());
        for (PLSQLargument f : this.fields) {
            clone.fields.add(f.clone());
        }
        return clone;
    }

    @Override
    public boolean isRecord() {
        return true;
    }

    public List<PLSQLargument> getFields() {
        return this.fields;
    }

    @Override
    public int getSqlCode() {
        if (this.hasCompatibleType()) {
            return 2002;
        }
        return 1111;
    }

    public void addField(PLSQLargument field) {
        this.fields.add(field);
    }

    public void addField(String fieldName, DatabaseType databaseType) {
        this.fields.add(new PLSQLargument(fieldName, -1, DatasourceCall.IN, databaseType));
    }

    public void addField(String fieldName, DatabaseType databaseType, int precision, int scale) {
        this.fields.add(new PLSQLargument(fieldName, -1, DatasourceCall.IN, databaseType, precision, scale));
    }

    public void addField(String fieldName, DatabaseType databaseType, int length) {
        this.fields.add(new PLSQLargument(fieldName, -1, DatasourceCall.IN, databaseType, length));
    }

    @Override
    public int computeInIndex(PLSQLargument inArg, int newIndex, ListIterator<PLSQLargument> iterator) {
        if (this.hasCompatibleType()) {
            return super.computeInIndex(inArg, newIndex, iterator);
        }
        iterator.remove();
        inArg.inIndex = newIndex;
        for (PLSQLargument argument : this.fields) {
            argument.inIndex = newIndex++;
            iterator.add(argument);
        }
        return newIndex;
    }

    @Override
    public int computeOutIndex(PLSQLargument outArg, int newIndex, ListIterator<PLSQLargument> iterator) {
        if (this.hasCompatibleType()) {
            return super.computeOutIndex(outArg, newIndex, iterator);
        }
        iterator.remove();
        outArg.outIndex = newIndex;
        for (PLSQLargument argument : this.fields) {
            argument.outIndex = newIndex++;
            argument.direction = DatasourceCall.OUT;
            iterator.add(argument);
        }
        return newIndex;
    }

    @Override
    public void buildInDeclare(StringBuilder sb, PLSQLargument inArg) {
        if (this.hasCompatibleType()) {
            super.buildInDeclare(sb, inArg);
        } else {
            if (this.getTypeName() == null || this.getTypeName().equals("")) {
                throw QueryException.typeNameNotSet(this);
            }
            sb.append("  ");
            sb.append(DatabaseType.DatabaseTypeHelper.databaseTypeHelper.buildTarget(inArg));
            sb.append(" ");
            sb.append(this.getTypeName());
            sb.append(";\n");
        }
    }

    @Override
    public void buildOutDeclare(StringBuilder sb, PLSQLargument outArg) {
        if (this.hasCompatibleType()) {
            super.buildOutDeclare(sb, outArg);
        } else {
            if (this.getTypeName() == null || this.getTypeName().equals("")) {
                throw QueryException.typeNameNotSet(this);
            }
            sb.append("  ");
            sb.append(DatabaseType.DatabaseTypeHelper.databaseTypeHelper.buildTarget(outArg));
            sb.append(" ");
            sb.append(this.getTypeName());
            sb.append(";\n");
        }
    }

    @Override
    public void buildBeginBlock(StringBuilder sb, PLSQLargument arg, PLSQLStoredProcedureCall call) {
        if (this.hasCompatibleType()) {
            super.buildBeginBlock(sb, arg, call);
        } else {
            String target = DatabaseType.DatabaseTypeHelper.databaseTypeHelper.buildTarget(arg);
            if (arg.direction == DatasourceCall.IN | arg.direction == DatasourceCall.INOUT) {
                for (PLSQLargument f : this.fields) {
                    sb.append("  ");
                    sb.append(target);
                    sb.append('.');
                    sb.append(f.name);
                    sb.append(" := ");
                    sb.append(":");
                    sb.append(f.inIndex);
                    sb.append(";\n");
                }
            }
        }
    }

    @Override
    public void buildOutAssignment(StringBuilder sb, PLSQLargument outArg, PLSQLStoredProcedureCall call) {
        if (this.hasCompatibleType()) {
            super.buildOutAssignment(sb, outArg, call);
        } else {
            String target = DatabaseType.DatabaseTypeHelper.databaseTypeHelper.buildTarget(outArg);
            for (PLSQLargument f : this.fields) {
                sb.append("  ");
                sb.append(":");
                sb.append(f.outIndex);
                sb.append(" := ");
                sb.append(target);
                sb.append('.');
                sb.append(f.name);
                sb.append(";\n");
            }
        }
    }

    @Override
    public void translate(PLSQLargument arg, AbstractRecord translationRow, AbstractRecord copyOfTranslationRow, List<DatabaseField> copyOfTranslationFields, List<DatabaseField> translationRowFields, List translationRowValues, StoredProcedureCall call) {
        if (this.hasCompatibleType()) {
            super.translate(arg, translationRow, copyOfTranslationRow, copyOfTranslationFields, translationRowFields, translationRowValues, call);
        } else {
            for (PLSQLargument argument : this.fields) {
                DatabaseType.DatabaseTypeHelper.databaseTypeHelper.translate(argument, translationRow, copyOfTranslationRow, copyOfTranslationFields, translationRowFields, translationRowValues, call);
            }
        }
    }

    @Override
    public void buildOutputRow(PLSQLargument outArg, AbstractRecord outputRow, DatabaseRecord newOutputRow, List<DatabaseField> outputRowFields, List outputRowValues) {
        if (this.hasCompatibleType()) {
            super.buildOutputRow(outArg, outputRow, newOutputRow, outputRowFields, outputRowValues);
        } else {
            for (PLSQLargument field : this.fields) {
                DatabaseType.DatabaseTypeHelper.databaseTypeHelper.buildOutputRow(field, outputRow, newOutputRow, outputRowFields, outputRowValues);
            }
        }
    }

    @Override
    public void logParameter(StringBuilder sb, Integer direction, PLSQLargument arg, AbstractRecord translationRow, DatabasePlatform platform) {
        if (this.hasCompatibleType()) {
            super.logParameter(sb, direction, arg, translationRow, platform);
        } else {
            Iterator<PLSQLargument> iterator = this.fields.iterator();
            while (iterator.hasNext()) {
                PLSQLargument argument = iterator.next();
                argument.databaseType.logParameter(sb, direction, argument, translationRow, platform);
                if (!iterator.hasNext()) continue;
                sb.append(", ");
            }
        }
    }
}

